C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
      SUBROUTINE MCTVF(LX,X,FILTER_TYPE,TDEL,BAND,DB,LFMAX,FREQ,F,
     1                 BUF3,BUF4,LF,Y,MXNT,lb,ZF,ZW,npow,first,amp)
C     A CONFIDENTIAL AMOCO SUBROUTINE                                   
C             FORTRAN BY KEN PEACOCK  8-24-83.                          
C     CTVF APPLIES THE HILBERT TRANSFORM HIGHCUT FILTER TO THE INPUT    
C     DATA.  INPUT PARAMETERS CONSIST OF THE FREQUENCY ARRAY AND ROLLOFF
C     BAND.  THIS VERSION USES THE EMPIRICAL EQUATIONS OF REPORT F83-E- 
C     10.                                                               
C     INPUTS ARE...                                                     
C        LX, LENGTH OF X ARRAY.                                         
C        X, THE INPUT ARRAY.                                            
C        FILTER_TYPE, TYPE OF WEIGHTING, 1 = ROSS, 2 = BESSEL.                
C        TDEL, SAMPLE INCREMENT, IN SECONDS, NOTE THAT THE HIGHEST      
C             FREQUENCY PERMITTED IN THE INPUT IS 1/2 NYQUIST.  THAT IS 
C             THE DATA MUST NOT HAVE FREQUENCY CONTENT IN THE UPPER HALF
C             RANGE.                                                    
C        BAND, ROLLOFF INTERVAL, IN HERTZ.                              
C        first, NEW FILTER CODE, 1= NEW FILTER.                         
C        DB, MINIMUM REJECTION FOR THE REJECT BAND.                     
C        LFMAX, MAXIMUM LENGTH FOR HILBERT OPERATOR, IN SAMPLES.        
C     INPUT/BUFFER IS...                                                
C        FREQ, LX-LENGTH INSTANTANEOUS FREQUENCY ARRAY, SUBSEQUENTLY    
C             USED AS BUFFER.                                           
C     BUFFERS ARE...                                                    
C        F, LFMAX-LENGTH BUFFER.                                        
C        BUF2, LX-LENGTH BUFFER.                                        
C        BUF3, LX+LFMAX-1 LENGTH BUFFER.                                
C        BUF4, LX+LFMAX-1 LENGTH BUFFER.                                
C     OUTPUTS ARE...                                                    
C        LF, LENGTH OF HILBERT OPERATOR.                                
C             IF LF = LFMAX, THE FILTER WILL NOT MEET CRITERIA.  IF THIS
C             IS NOT ACCEPTABLE, UP LFMAX, LOWER DB, OR INCREASE BAND.  
C        Y, THE LX-LENGTH OUTPUT SIGNAL.                                
C     PROGRAMMED FOR THE IBM 370/158 COMPUTER.                          
C     VERSION AS OF 8-24-83.                                            
C                                                                       
#include <f77/lhdrsz.h>

c declare variables passed from calling routine

      integer lx, filter_type, lfmax, lf, mxnt, lb, npow

      real tdel, band, db, amp

      DIMENSION X(MXNT),Y(MXNT)
      DIMENSION BUF3(MXNT+LFMAX-1),BUF4(MXNT+LFMAX-1)
C
      DIMENSION F(*),FREQ(MXNT,4)                                       
      real      work(2*SZLNHD)
      complex   ZW (2*SZLNHD)
      integer   ordfft
      logical   first
C_______________________________________________________________________
C     BUFFER A IS FOR INTD                                              
C_______________________________________________________________________
      DIMENSION A(31)                                                   
C
      IF( first ) THEN
C_______________________________________________________________________
         filter_type = 1
C        INITIALIZE
C_______________________________________________________________________
         FACT = 2.*3.1415927                                            
         CALL INTD(LX,FREQ(1,1),1,TDEL,3.,31,A,FREQ(1,2))               
         DO 77 I=1,LX                                                   
          FREQ(I,2) = FREQ(I,2)*FACT                                    
77       CONTINUE
         EX = -1.1440+.0048880*DB**1.768                                
         IF(FILTER_TYPE.EQ.2)EX = -8.4948+2.0913*DB**.470                     
         IF(EX.LT.0.)EX = 0.                                            
         LF = (-.22527+.010129*DB**1.552)/(BAND*TDEL)                   
         IF(FILTER_TYPE.EQ.2) LF = (-.63196+.080371*DB**.973)/
     :        (BAND*TDEL)     
         LF = LF/2*2+1                                                  
         IF(LF.GT.LFMAX) LF= LFMAX                                      
         CALL HILC(LF,FILTER_TYPE,TDEL,EX,F)                                  
         DO 5 I=1,LX                                                    
          FREQ(I,1) = COS(FREQ(I,2))                                    
          FREQ(I,2) = SIN(FREQ(I,2))                                    
5        CONTINUE
C_______________________________________________________________________
C        SCALE FREQ(I,1) AND FREQ(I,2) BY TDEL FOR POSTFILTERING.
C_______________________________________________________________________
         DO 50 I=1,LX                                                   
          FREQ(I,3) = FREQ(I,1)*TDEL                                    
50       CONTINUE
         DO 55 I=1,LX                                                   
          FREQ(I,4) = FREQ(I,2)*TDEL                                    
55       CONTINUE

         ly = lx + lf - 1
         nu = ordfft (ly)
         npow = 2 ** nu

      ENDIF

          do  i = 1, lx
              y    (i) = x (i)
              work (i) = freq(i,1) * x (i)
              x    (i) = freq(i,2) * x (i)
          enddo

          call foldf (f,zf,lf,work,zw,lx,buf3,ly,npow,first,amp)
          call foldf (f,zf,lf,   x,zw,lx,buf4,ly,npow,first,amp)

C_______________________________________________________________________
C     LOOP 5000 IS TWO MATRIX VECTOR MULTIPLIES.
C_______________________________________________________________________
       JFACT = LF/2
       eno = 0.
       DO 4 I=1,LX
        J = I+JFACT
        xI =  -FREQ(I,4)*BUF3(J)
     1        +FREQ(I,3)*BUF4(J)
        x(i) = XI
4      CONTINUE

      RETURN
      END
