C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c routine sctvf [continuous time variant filtering]
c
c     Changes:
c
c     August 6/98: fixed call to mctvf where filter_type was passed
c                  to subroutine as the numeric entry 2 and then 
c                  reassigned [not good].  Invented the variable filter_type
c                  which when equal to 2 implies Bessel and when equal to 
c                  unity implies Ross weighting
c
c                  Added UnitSc logic to replace > 32 stuff.  Declared a lot
c                  of undeclared variables
c
c     Garossino
c
#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      PARAMETER (MXNT=2*SZLNHD, MXTR=SZSPRD/4) 

      PARAMETER (LFMAX=501, MXBUF=MXNT+LFMAX+1,MXPT=10)

      INTEGER   ITR (2*SZLNHD)
      INTEGER   ARGIS,obytes
      INTEGER   iz(MXNT)
      integer filter_type
      integer StaCor, ifmt_StaCor, l_StaCor, ln_StaCor
    
      REAL      xtr(MXNT), work(MXNT+SZSPRD)
      REAL      tabl1(MXNT), tabl2(MXNT), zz(4*MXNT)
      real UnitSc
    
      COMPLEX   ZG(MXNT)
      COMPLEX   ZB(MXNT)

      CHARACTER NTAP*255, OTAP*255, VTIME*255, NAME*5

      LOGICAL   INVAR, verbos, locut, heap, mind, pmute
      LOGICAL   first, interp

c  dynamic memory allocation

      real       x, y, buf3, buf4

      pointer    (wkadrx, x(1))
      pointer    (wkadry, y(1))
      pointer    (wkadb3, buf3(1))
      pointer    (wkadb4, buf4(1))


      DIMENSION FREQ(MXNT,4)                                            
      DIMENSION F(MXNT)                                                
      DIMENSION G(MXNT), BUF(MXNT)                                     
      DIMENSION TIM(MXPT), FR(MXPT)                                      

      DATA NAME/'SCTVF'/
      DATA first/.true./
 
c  get online help if requested

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 ) then
         call help ()
         stop
      endif

c  open printout file

#include <f77/open.h>

C_______________________________________________________________________
C     READ CARD IMAGE INPUT CONTROL CARDS.
C     DB.........REJECTION LEVEL FOR  FILTER IN DB.                     
C     BAND.......ROLLOFF INTERVAL FOR TIME VARIANT FILTER IN HZ.        
C     NPT........NUMBER OF CONTROL POINTS IN HIGH CUT                   
C                FREQUENCY FUNCTION. IF (NPT .EQ. 1) THE FILTER IS
C                SET TO BE INVARIANT.
C     IMODE......FILTER MODE:                                           
C                  1 = HIGHCUT
C                  2 = LOW CUT
C     F1,F2......INVARIANT LOW CUT FILTER POINTS                        
C     F3,F4......INVARIANT HIGH CUT FILTER POINTS (INVARIANT MODE ONLY) 
C     TIM,FR.....TIME FREQUENCY PAIRS FOR TIME VARIANT HIGH CUT FILTER.
C                FR(I) DEFINES THE DB ROLL OVER POINT AT TIME TIM(I)
C                THERE WILL BE NPT OF THESE.
C_______________________________________________________________________
c
c
c   get command line parameters

      call cmdln (ntap,otap,db,band,npt,f1,f2,f3,f4,
     &     vtime,idec,invar,locut,verbos,mind,idelay,
     &     lhf,wt,prew,pmute,interp)
c
c - abort upon finding any unrecognized arguments
c
      call xtrarg(name,LER,.FALSE.,.FALSE.)
      call xtrarg(name,LERR,.FALSE.,.TRUE.)


c  open I/O 

      call getln ( luin, ntap, 'r', 0 )
      call getln ( luout, otap, 'w', 1 )


      IF(invar) THEN
         WRITE(LERR,*) ' FIXED (INVARIANT) FILTER OPTION SELECTED'
      ELSE
         WRITE(LERR,*) ' TIME VARIANT FILTER OPTION SELECTED'
      ENDIF

c  pick up time freq pairs from file vtime

      if(.not. invar) then
         if (vtime .eq. ' ') then
            write(LERR,*)'Time variant option requires file of'
            write(LERR,*)'time frequency pairs'
            write(LERR,*)'You will need to build this file and'
            write(LERR,*)'rerun the command line with the correct'
            write(LERR,*)'file name and the correct no. of pairs'
            write(LER,*)'Time variant option requires file of'
            write(LER,*)'time frequency pairs'
            write(LER,*)'You will need to build this file and'
            write(LER,*)'rerun the command line with the correct'
            write(LER,*)'file name and the correct no. of pairs'
            call exit (101)
         endif

         if (npt .eq. 1) npt = mxpt

         open(LUN,file=vtime,status = 'OLD')

         do 50 j=1,npt
            read(LUN,*,end=51) tim(j),fr(j)
 50      continue

         go to 52
 51      continue
         npt = j - 1
 52      continue
         
         IF(NPT .GT. MXPT) THEN
            WRITE(LER,*) ' ERROR IN SCTVF.'
            WRITE(LER,*) ' NO. OF TIME POINTS NPT =',NPT
            WRITE(LER,*) ' EXCEEDS MAXIMUM   MXPT =',MXPT
            call exit (100)
         ENDIF
         if (npt .eq. 1) then
            write(LERR,*)'sctvf:   *** FATAL ERROR ***'
            write(LERR,*)'Must have at least 2 time-frequency pairs'
            write(LERR,*)'Edit time-freq files and re-run'
            write(LER,*)'sctvf:   *** FATAL ERROR ***'
            write(LER,*)'Must have at least 2 time-frequency pairs'
            write(LER,*)'Edit time-freq files and re-run'
            call exit (666)
         endif
         write(LERR,*)' '
         do  j = 1, npt
             write(LERR,*)'time frequency pairs'
             write(LERR,*)'time= ',tim(j),' freq= ',fr(j)
         enddo
         write(LERR,*)' '
      endif

C  READ LINE HEADER

      lbytes=0
      CALL RTAPE (LUIN,ITR,LBYTES)
      if(lbytes .eq. 0) then
         write(LERR,*)'SCTVF: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         call exit (102)
      endif

c  save key header values
#include <f77/saveh.h>

      call saver(itr, 'UnitSc', UnitSc, LINHED)

c check header for units scaling.  Using UnitSc, remember
c that UnitSc default is milliseconds [i.e. 0.001] and UnitSc
c is a floating point variable.  A UnitSc entry of 1.0 would
c mean units are in seconds.  A UnitSc entry of 0 indicates that
c the unit was not defined.  In this case milliseconds are 
c assumed and loaded to the header for further processing.

      if ( UnitSc .eq. 0.0 ) then
         write(LERR,*)'********************************************'
         write(LERR,*)'WARNING: sample unit scaler in LH = ',UnitSc
         write(LERR,*)'         will set to .001 (millisec default)'
         write(LERR,*)'********************************************'
         UnitSc = 0.001
         call savew ( itr, 'UnitSc', UnitSc, LINHED)
      endif

      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      CALL HLHprt (ITR,LBYTES,NAME,5,LERR)

c  verbos printout

      dt  = nsi * UnitSc
      fnq = .5/dt
      idelay = idelay/nsi
      if (idelay .eq. 0) idelay = 1

      WRITE(LERR,*)' VALUES READ FROM LINE HEADER'
      write(LERR,*)' # samples/trace   =  ',nsamp
      write(LERR,*)' sample interval   =  ',nsi
      write(LERR,*)' traces/recod      =  ',ntrc
      write(LERR,*)' records/line      =  ',nrec
      write(LERR,*)' format of data    =  ',iform
      write(LERR,*)' f1 = ',f1
      write(LERR,*)' f2 = ',f2
      write(LERR,*)' f3 = ',f3
      write(LERR,*)' f4 = ',f4
      write(LERR,*)' db = ',db
      write(LERR,*)' band = ',band
      if(invar) then
         write(LERR,*)'Time - Frequency pairs'
         do 55 j=1,npt
            write(LERR,*)tim(j),fr(j)
 55      continue
      endif
      write(LERR,*)' Decimation factor =  ',idec

      nsampw = nsamp + .2 * nsamp

c---------------------------------------------------------
c
c - modified to prevent possible loss of last sample - j.m.w. - 12/16/94
c
c     msamp = nsamp/idec
      msamp = (nsamp+idec-1)/idec

      TDEL = nsi * UnitSc

      si  = nsi
      nsi = nsi*idec
      nsampo = nsampw

      IF (.not. INVAR) THEN

         if ( interp ) then
            TDEL = .5 * TDEL
            DT   = .5 * DT
            fnq  = 2 * fnq
            so   = .5 * si
            nsampo = 2 * nsampw
         else
            so = si
            nsampo = nsampw
         endif

         fnyqm = 1.0 / ( 2.0 * dt )

c         if (so .le. 32.) then
c            fnyqm = 500. / so
c         else
c            fnyqm = 500000. / so
c         endif

         if (f3 .eq. 0. .and. f4 .eq. 0.) then
            fnyq1 = 0.8 * fnyqm
            fnyq2 = 0.9 * fnyqm
         else
            if (f3*f4 .eq. 0.) then
               write(LERR,*)'Must set both f3 & f4 on cmd line'
               write(LERR,*)'Re-run'
               call exit (105)
            endif
            fnyq1 = f3
            fnyq2 = f4
         endif

         if (.not.interp) then
            do  j = 1, npt
               if (fr(j) .gt. .50*fnyqm) fr(j) = .50*fnyqm
            enddo
         endif

      ELSE

         if(f4 .eq. 0.) f4 = .9*fnq
         if(f3 .eq. 0.) f3 = f4 - band
         write(LERR,*) ' F3 = ',f3
         write(LERR,*) ' F4 = ',f4

      ENDIF

c---------------------------------------------------------
c  adjust line header, hist. line header & write header

      call savew( itr, 'NumSmp', msamp , LINHED)
      call savew( itr, 'SmpInt',  nsi  , LINHED)
      obytes = SZTRHD + SZSMPD * msamp
      call savhlh ( itr, lbytes, lbyout )

c   write header

      call wrtape(luout,itr,lbyout)

      if(idec .gt. 1) then
         if(f4 .gt. .9*fnq) then
           write(LERR,*)'Upper frequency, f4, must less than .9 Nyquist, 
     1           nyquist= ',fnq
           write(LERR,*)'Adjust this parameter and rerun job'
           call exit (106)
        endif
      endif

      if ( interp ) then
         do  j = 1, nsampw
            tabl1(j) = float( j - 1 ) * si
         enddo
   
         do  j = 1, nsampo
            tabl2(j) = float( j - 1 ) * so
         enddo
      endif

C_______________________________________________________________________
C     READ IN RECORDS AND INITIALIZE SOME FILTER PARAMETERS
C_______________________________________________________________________

      lx  = nsampw
      ntr = ntrc
      IF(LX .GT. MXNT) THEN
         WRITE(LERR,*) ' ERROR IN SCTVF.'
         WRITE(LERR,*) ' NO. OF SAMPLES LX =',LX,' EXCEEDS MXNT',MXNT
         call exit (107)
      ENDIF
 
      IF(.NOT. INVAR) THEN
         f3 = fnyq1
         f4 = fnyq2
         call cona (npt,fr,tim,tdel,lx,freq)
         write(LERR,*) ' F3 = ',f3
         write(LERR,*) ' F4 = ',f4
      ENDIF

C_______________________________________________________________________
C     ECHO INPUT.
c_______________________________________________________________________

      CALL FILTI(LFMAX,2,TDEL,db,F1,F2,F3,F4,BUF,LG,G)
      ISH = LG/2

c------------
c  min delay?

      if(mind .and. invar) then

         write(LERR,*)' '
         idelay = 1
         write(LERR,*)'Computing minumum delay response version of'
         write(LERR,*)'Ormsby filter:  using prewhitening= ',prew
         call maxmgv (G, 1, gmax, indx, LG)
         call vsdiv  (G, 1, gmax, G, 1, LG)

         call vclr (work, 1, MXNT)
         call vclr (xtr , 1, MXNT)
         xtr(1) = 1.0
         call vclr (buf , 1, LFMAX)
         
         call shape1(LG,G,  LG, xtr, LG, buf, ase, work, prew)
         write(LERR,*)'Inverse to Ormsby: squared error= ',ase
         call vclr (work, 1, MXNT)
         call vclr (xtr , 1, MXNT)
         xtr(1) = 1.0
         call shape1(LG, buf,  LG, xtr, LG, G, ase, work(idelay), prew)
         write(LERR,*)(g(i),i=1,lg)
         sgn = g(1)/abs(g(1))
         write(LERR,*)'Double inverse: squared error= ',ase
         ISH = 1
         call maxmgv (G, 1, gmax1, indx, LG)
         gmax2 = sgn * gmax / gmax1
         call vsmul  (G, 1, gmax2, G, 1, LG)
         write(LERR,*)'filter scale factors= ',gmax,gmax1,gmax2

         write(LERR,*)' '

      endif

      ens = 2.

c---------------------------------------------------
c  malloc only space we're going to use
      heap  = .true.

      itemx =  nsampo
      itemy = (nsampo + lfmax)
      itemi = ITRWRD

      write(LERR,*)'itemx= ',itemx,' itemy= ',itemy

      if (.not. INVAR .OR. locut) then
         item3 = 4 * (nsampo + lfmax - 1)
         write(LERR,*)'item3= ',item3
      endif

      if (errcd .ne. 0.) heap = .false.
      call galloc (wkadrx, itemx*SZSMPD, errcd, abort)
      if (errcd .ne. 0.) heap = .false.
      call galloc (wkadry, itemy*SZSMPD, errcd, abort)
      if (errcd .ne. 0.) heap = .false.
      if (.not. INVAR .OR. locut) then
          call galloc (wkadb3, item3*SZSMPD, errcd, abort)
          if (errcd .ne. 0.) heap = .false.
      endif
      if (.not. INVAR) then
          call galloc (wkadb4, item3*SZSMPD, errcd, abort)
          if (errcd .ne. 0.) heap = .false.
      endif
      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemx*SZSMPD,'  bytes'
         write(LERR,*) itemy*SZSMPD,'  bytes'
         if (.not. INVAR) then
             write(LERR,*) item3*SZSMPD,'  bytes'
         endif
         if (.not. INVAR .OR. locut) then
             write(LERR,*) item3*SZSMPD,'  bytes'
         endif
         write(LERR,*) 2*item3*SZSMPD,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemx*SZSMPD,'  bytes'
         write(LERR,*) itemy*SZSMPD,'  bytes'
         if (.not. INVAR) then
             write(LERR,*) item3*SZSMPD,'  bytes'
         endif
         if (.not. INVAR .OR. locut) then
             write(LERR,*) item3*SZSMPD,'  bytes'
         endif
         write(LERR,*)' '
      endif


      icinit = 1

      DO 100 jj = 1,nrec

         DO 99 KK = 1,ntrc

            nbytes=0
            call rtape(luin,itr,nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif

            do  i = 1, nsampw
               xtr (i) = 0.
            enddo

            call vmov (itr(ITHWP1), 1, xtr, 1, nsamp)
            call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1           StaCor, TRACEHEADER)

            IF (StaCor .ne. 30000) THEN

               xdot = 0.
               do  ii = 1, nsamp
                  xdot = xdot + xtr (ii) * xtr (ii)
               enddo
               IF (xdot .lt. 1.e-30) THEN
                  call vclr (x, 1, nsamp)
                  go to 998
               ENDIF

c  detect mute
               if (pmute)
     1              call detmut (xtr, muteskk, nsamp)

c-----------------------------------------------------------------
c                 filter section
c
c---------------------------------------------------
c     time invariant filter

               IF(INVAR) THEN

c     time invariant filter

                  IF (INVAR .AND. locut) THEN
                     do  ii = 1, nsamp
                        buf3 (ii) = xtr (ii)
                     enddo
                  ENDIF
                  
                  call fold  (LG, G, nsampw, xtr, LO, Y)
         
                  do  ii = 1, nsampw
                     x (ii) = tdel * y (ii + ish)
                  enddo

c---------------------------------------------------
c     time variant filter

               ELSE

                  if ( interp ) then
                     call fcuint (tabl1, xtr, nsampw, tabl2, x, nsampo,
     1                    iz, zz, icinit)
                  else
                     do  i = 1, nsamp
                        x (i) = xtr (i)
                     enddo
                  endif

                  filter_type = 2

                  CALL MCTVF (nsampo,X,filter_type,TDEL,BAND,DB,LFMAX,
     :                 FREQ,F,BUF3,BUF4,LF,Y,nsampo,lg,ZG,ZB,npow,first,
     :                 ens)

                  if ( interp ) then
                     i2 = 0
                     do  ii = 1, nsampo, 2
                        i2 = i2 + 1
                        x (i2) = x (ii)
                     enddo
                     icinit = 0
                  endif

               ENDIF

c-----------------------------------------------------------------
 
               IF (.not.INVAR .AND. locut) THEN
                  
                  do  ii = 1, nsamp
                     x (ii) = y (ii) - x (ii)
                  enddo

               ELSEIF  (INVAR .AND. locut) THEN

                  do  ii = 1, nsamp
                     x (ii) = buf3 (ii) - x (ii)
                  enddo
                  
               ENDIF

C     do output

               if (pmute)
     1              call resmut (x, muteskk, nsamp)
               if(StaCor .ne. 30000 .and. idec .gt. 1) then
                  call decim(x,work,nsamp,idec)
               endif
            ELSE
               call vclr (x, 1, msamp)
            ENDIF

 998        continue

            call vmov (x, 1, itr(ITHWP1), 1, msamp)
            call wrtape(luout,itr,obytes)


 99      CONTINUE

         if(verbos) then
            WRITE(LERR,*)'PROCESSED RECORD  ',jj
         endif

 100  CONTINUE

 999  continue
      call lbclos(luin)
      call lbclos(luout)
      stop
      END
c 
c   decimation routine
      subroutine decim(x,work,n,ndec)
      dimension x(*),work(*)
c
c   decimation by outputting every ndec th point
c
      j=0
      do 100 i=1,n,ndec
         j = j+1
         work(j) = x(i)
  100 continue
      do 200 i=1,n/ndec
         x(i) = work(i)
  200 continue
      return
      end

c----------------------------------------
c  online help section
c----------------------------------------
      subroutine  help
#include <f77/iounit.h>

        write(LER,*)'Here are the Command Line Parameters for CTVF'
        write(LER,*)'       -- time (in)variant filter'
        write(LER,*)' '
        write(LER,*)'Input.......................................(def)'
        write(LER,*)'-N{} -- replace {} with input data set name(stdin)'
        write(LER,*)'-O{} -- output data set name (stdout)'
        write(LER,*)'-db{} - rejection level for filter in db (40)'
        write(LER,*)'-r{} -- roll off interval for T-V filter in Hz(10)'
        write(LER,*)'        If np=1 filter in invariant, else enter...'
        write(LER,*)'-v{} -- name of file containing time-freq pairs'
        write(LER,*)'        Note: do not exceed 1/2 Nyquist'
        write(LER,*)'-f1{} - first lo-cut freq (hz)      (def=2)'
        write(LER,*)'-f2{} - second lo-cut               (def=5)'
        write(LER,*)'-f3{} - first hi-cut           (def=.9Nyq - band)'
        write(LER,*)'-f4{} - second hi-cut          (def=.9Nyq)'
        write(LER,*)'-d{}  - decimation factor                   ( 1 )'
        write(LER,*)'-s{}  - filter delay (ms)      (1/2 filter length)'
        write(LER,*)'-wt{} - ross weighting for hilbert filter   (1.0)'
        write(LER,*)'-ln{} - length (samps) hilbert filter       (63)'
        write(LER,*)'-lo   - for time variant: compute low cut response'
        write(LER,*)'      - for time invariant: compute band reject'
        write(LER,*)'-T    - if present filter is time variant'
        write(LER,*)'-M    - if present filter is minimum delay'
        write(LER,*)'-R    - if present preserve early mute'
        write(LER,*)'-I    - for T-V option: interpolate data to next'
        write(LER,*)'        lowest s.i. (can sometimes reduce noise)'
        write(LER,*)'-V    - if present give verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'      sctvf -N{} -O{} -db{} -r{} -f1{} -f2{}'
        write(LER,*)'            -f3{} -f4{} -v{} -wt{} -ln{}'
        write(LER,*)'             [-T -M -lo -R -I -V]'
        write(LER,*)' '

      return
      end


c-----
c     get command arguments
c
c     ntap  - C*255  input file name
c     otap  - C*255  output file name
c    vtime  - C*255  time-freq file name
c      db   - R      rejection of filter
c    band   - R      roll off interval
c     npt   - I      no. control points
c f1,2,3,4  - R      corner frqs
c    idec   - I      decimation factor
c   idelay  - I      force filter delay
c    lhf    - I      length of hilbert filter
c     wt    - R      ross weight for hilbert filter
c    invar  - L      invariant flag
c     mind  - L      minimum delay filter
c    locut  - L      lo-cut flag
c    verbos - L      verbose output or not
c-----
      subroutine cmdln (ntap,otap,db,band,npt,f1,f2,f3,f4,
     &                vtime,idec,invar,locut,verbos,mind,idelay,
     &                lhf,wt,prew,pmute,interp)
#include <f77/iounit.h>
      character  ntap*(*), otap*(*), vtime*(*)
      integer    argis,npt,idec,idelay,lhf
      real       f1,f2,f3,f4,db,band,wt,prew
      logical    invar,locut,verbos,mind,pmute,interp

         call argstr('-N',ntap,' ',' ')
         call argstr('-O',otap,' ',' ')
         call argstr('-v',vtime,' ',' ')
         call argr4('-db',db,40.,40.)
         call argr4('-r',band,10.,10.)
         call argi4('-np',npt,1,1)
         call argr4('-f1',f1,2.,2.)
         call argr4('-f2',f2,5.,5.)
         call argr4('-f3',f3,0.,0.)
         call argr4('-f4',f4,0.,0.)
         call argi4('-d',idec,1,1)
         call argr4('-p',prew,.5,.5)
         call argi4('-s',idelay,0,0)
         call argi4('-ln',lhf,63,63)
         call argr4('-wt',wt,1.0,1.0)

         prew = prew / 100.
         invar = .true.
         if (invar) then
            mind = (argis('-M') .gt. 0)
         else
            mind = .false.
         endif
         if (argis('-T') .gt. 0) then
            invar = .false.
         endif
         interp = (argis('-I') .gt. 0)
         pmute  = (argis('-R') .gt. 0)
         locut  = (argis('-lo') .gt. 0)
         if (locut .AND. .not.invar) then
            write(LERR,*)' '
            write(LERR,*)'SCTVF: time varying lo-cut option no longer'
            write(LERR,*)'supported. Use tvfilt for all T-V filtering.'
            write(LER ,*)' '
            write(LER ,*)'SCTVF: time varying lo-cut option no longer'
            write(LER ,*)'supported. Use tvfilt for all T-V filtering.'
            stop
         endif
         verbos = (argis('-V') .gt. 0)
         if(verbos) write(LERR,*)' Program SCTVF Begins'
         write(LERR,*)' '

      return
      end
