C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C
C -------------------------------------------------------------------
C (from  Numerical Recipes in FORTRAN)
C
      SUBROUTINE MEMCOF(DATA,N,M,PM,COF,WK1,WK2,WKM)                            
      DIMENSION DATA(N),COF(M),WK1(N),WK2(N),WKM(M)                             
      P=0.                                                                      
      DO 11 J=1,N                                                               
        P=P+DATA(J)**2                                                          
11    CONTINUE                                                                  
      PM=P/N                                                                    
      WK1(1)=DATA(1)                                                            
      WK2(N-1)=DATA(N)                                                          
      DO 12 J=2,N-1                                                             
        WK1(J)=DATA(J)                                                          
        WK2(J-1)=DATA(J)                                                        
12    CONTINUE                                                                  
      DO 17 K=1,M                                                               
        PNEUM=0.                                                                
        DENOM=0.                                                                
        DO 13 J=1,N-K                                                           
          PNEUM=PNEUM+WK1(J)*WK2(J)                                             
          DENOM=DENOM+WK1(J)**2+WK2(J)**2                                       
13      CONTINUE                                                                
        COF(K)=2.*PNEUM/DENOM                                                   
        PM=PM*(1.-COF(K)**2)                                                    
        IF(K.NE.1)THEN                                                          
          DO 14 I=1,K-1                                                         
            COF(I)=WKM(I)-COF(K)*WKM(K-I)                                       
14        CONTINUE                                                              
        ENDIF                                                                   
        IF(K.EQ.M)RETURN                                                        
        DO 15 I=1,K                                                             
          WKM(I)=COF(I)                                                         
15      CONTINUE                                                                
        DO 16 J=1,N-K-1                                                         
          WK1(J)=WK1(J)-WKM(K)*WK2(J)                                           
          WK2(J)=WK2(J+1)-WKM(K)*WK1(J+1)                                       
16      CONTINUE                                                                
17    CONTINUE                                                                  
c     PAUSE 'never get here'
      write(LER,*) 'never got here'
      END                                                                       
C
C ----------------------------------------------------------------
      FUNCTION EVLMEM(FDT,COF,M,PM)                                             
      DIMENSION COF(M)                                                          
      REAL*8 WR,WI,WPR,WPI,WTEMP,THETA                                          
      THETA=6.28318530717959D0*FDT                                              
      WPR=DCOS(THETA)                                                           
      WPI=DSIN(THETA)                                                           
      WR=1.D0                                                                   
      WI=0.D0                                                                   
      SUMR=1.                                                                   
      SUMI=0.                                                                   
      DO 11 I=1,M                                                               
        WTEMP=WR                                                                
        WR=WR*WPR-WI*WPI                                                        
        WI=WI*WPR+WTEMP*WPI                                                     
        SUMR=SUMR-COF(I)*SNGL(WR)                                               
        SUMI=SUMI-COF(I)*SNGL(WI)                                               
11    CONTINUE                                                                  
      EVLMEM=PM/(SUMR**2+SUMI**2)                                               
      RETURN                                                                    
      END                                                                       
C
