/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* $Id: geoetypes.h,v 1.1.1.1 2000/10/11 19:53:18 rob Exp $ */
/* $Name:  $ */
/*
 * $Log: geoetypes.h,v $
 * Revision 1.1.1.1  2000/10/11 19:53:18  rob
 * Import GeoEnergy specific definitions
 *
 *
 */
/*-------------------------------------------------------------------*/

/* geoetypes.h
 * platform-specific numeric BIFs.
 */
#ifndef GEOETYPES_H_INC_
#define GEOETYPES_H_INC_


#ifdef PPCMACOS
#include <MacTypes.h>
#   define uint32    UInt32
#   define int32     SInt32
#   define uint16    UInt16
#   define int16     SInt16
#   define uint8     UInt8
#   define int8      SInt8
#   define bool      int
#endif

#ifdef WIN32
#   define uint32    unsigned int 
#   define int32     int
#   define uint16    unsigned short int
#   define int16     short int
#   define uint8     unsigned char
#   define int8      char
#   define bool      int
#endif

#ifdef __sun
#   include <malloc.h>
#   define uint32    unsigned int
#   define int32     int
#   define uint16    unsigned short int
#   define int16     short int
#   define uint8     unsigned char
#   define int8      char
#   define bool      int
#endif

#ifdef __mips
#   include <inttypes.h>
#   define uint32    uint32_t
#   define int32     int32_t
#   define uint16    uint16_t
#   define int16     int16_t
#   define uint8     uint8_t
#   define int8      int8_t
#   define bool      int
#endif

#ifdef __linux__
#   define uint32    unsigned int 
#   define int32     int
#   define uint16    unsigned short int
#   define int16     short int
#   define uint8     unsigned char
#   define int8      char
#   define bool      int
#endif

#ifdef __FreeBSD__
#   define uint32    unsigned int 
#   define int32     int
#   define uint16    unsigned short int
#   define int16     short int
#   define uint8     unsigned char
#   define int8      char
#   define bool      int
#endif

#endif /*GEOETYPES_H_INC_*/
