C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c     program module seltrc
c
c**********************************************************************c
c
c seltrc reads seismic trace data from an input file,
c based on a trace key and value and whether it is gt, lt, or eq
c and writes the output to stdout
c
c
c**********************************************************************c
c
c     declare variables
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer     itr  ( SZLNHD )
      integer     itr0 ( SZLNHD )
      integer     lhed ( SZLNHD )
      integer     lhed0( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, luout,val
      integer     luin , lbytes, nbytes,lbyout,lbyte
      integer     irs,ire,ns,ne
#include <f77/pid.h>
      character   ntap * 256, otap * 256, name*6, itwd*6
      logical     query, lt, eq, gt, le, ge, neq, verbos, live, rec
      integer     argis

      equivalence ( itr (  1), lhed (1) )
      equivalence ( itr0(  1), lhed0(1) )
      data lbytes / 0 /, nbytes / 0 /, name/'SELTRC'/, live/.true./
      data itr0/SZLNHD*0/

c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif

C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>

C**********************************************************************C
C     read command line parameters
C**********************************************************************C

      call gcmdln(ntap,otap,ns,ne,irs,ire,itwd, lt, eq, gt,val,
     1                  le,ge,neq,verbos,live,rec,npad)
c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin ,  ntap,'r', 0)
      call getln(luout , otap,'w', 1)
c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape   ( luin, itr, lbyte)
      if(lbyte .eq. 0) then
         write(LER,*)'seltrc: no header read from unit ',luin
         write(LER,*)'FATAL'
         stop
      endif
      CALL HLHprt    ( ITR , LBYTE, name, 6,          LERR)

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      call savelu(itwd,ifmt_itwd,l_itwd,ln_itwd,TRACEHEADER)
c-----
c     ensure that command line values are compatible with data set
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
      jtr = ne - ns + 1
      if (npad .eq. 0) npad = jtr
      nrecc = ire - irs + 1

         write(LERR,*)' Values read from input data set lineheader'
         write(LERR,*)' # of Samples/Trace =  ',nsamp
         write(LERR,*)' Sample Interval    =  ',nsi
         write(LERR,*)' Traces per Record  =  ',ntrc
         write(LERR,*)' Records per Line   =  ',nrec
         write(LERR,*)' Format of Data     =  ',iform
         write(LERR,*)' Trace velue key    =  ',itwd
         write(LERR,*)' Trace value        =  ',val
         if (rec) then
         write(LERR,*)' Operation done record-by-record'
         write(LERR,*)' Pad output records to ',npad,' traces'
         endif
         write(LERR,*)' Pass traces with values =  ',eq
         write(LERR,*)' Pass traces with values != ',neq
         write(LERR,*)' Pass traces with values >  ',gt
         write(LERR,*)' Pass traces with values >= ',ge
         write(LERR,*)' Pass traces with values <  ',lt
         write(LERR,*)' Pass traces with values <= ',le

      call savhlh(itr, lbyte, lbyout)
C**********************************************************************C
C     write out modified line header
C**********************************************************************C
      if (rec) then
         call savew(itr, 'NumTrc', jtr  , LINHED)
         call savew(itr, 'NumRec', nrecc, LINHED)
      endif
      call wrtape(luout, itr, lbyout)


c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)

c-----
c     spin through the data looking for header value
c-----
      ir = 0
      ic = 0
      DO  1000  JJ = irs, ire

c----------------
c  skip to start
c  of record
            call trcskp(jj,1,ns-1,luin,ntrc,itr)
c----------------
            call savew2(lhed0,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                  JJ     , TRACEHEADER)
            call savew2(lhed0,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                  30000  , TRACEHEADER)

            ir = ir + 1
            if (rec) ic = 0

            do  1001  KK = ns, ne

                  nbytes = 0
                  call rtape ( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif

                  call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        istatic, TRACEHEADER)

                 if (.not. live) istatic = 0
                 IF (istatic .ne. 30000) THEN

                  call saver2(lhed,ifmt_itwd,l_itwd, ln_itwd,
     1                        nval   , TRACEHEADER)

                  if(lt) then
                     if (nval .lt. val) then
                        call wrtape (luout, itr, nbytes)
                        ic = ic + 1
                     endif
                  elseif (le) then
                     if (nval .le. val) then
                        call wrtape (luout, itr, nbytes)
                        ic = ic + 1
                     endif
                  elseif (eq) then
                     if (nval .eq. val) then
                        call wrtape (luout, itr, nbytes)
                        ic = ic + 1
                     endif
                  elseif (ge) then
                     if (nval .ge. val) then
                        call wrtape (luout, itr, nbytes)
                        ic = ic + 1
                     endif
                  elseif (gt) then
                     if (nval .gt. val) then
                        call wrtape (luout, itr, nbytes)
                        ic = ic + 1
                     endif
                  elseif (neq) then
                     if (nval .ne. val) then
                        call wrtape (luout, itr, nbytes)
                        ic = ic + 1
                     endif
                  endif

c                 call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
c    1                        ic     , TRACEHEADER)

                 ENDIF

 1001           continue

                IF (rec) THEN

                   if (ic .lt. jtr) then

                      do  kk = ic+1, jtr

                          call savew2(lhed0,ifmt_TrcNum,l_TrcNum,
     1                                ln_TrcNum,  KK  , TRACEHEADER)
                          call wrtape (luout, itr0, nbytes)
                      enddo
                   endif
                ENDIF

c----------------
c  skip to end of
c  current record
            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
c----------------

 1000       CONTINUE
c-----
c     close data files
c-----
  999 continue
      write(LERR,*)' '
      write(LERR,*)'seltrc finished having read ',ir,' records and'
      write(LERR,*)'written ',ic,' total traces'
      write(LERR,*)' '
      call lbclos ( luin )
      call lbclos ( luout)
      end

      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
      write(LER,*)
     :'execute seltrc by typing seltrc and a list of program parameters'
      write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
      write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
      write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)       : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)       : output data file name'
        write(LER,*)
        write(LER,*)
     :' -T[itwd]     (none)             : trace header mnemonic'
        write(LER,*)
     :' -ns[ns]      (default = first)  : start trace number'
        write(LER,*)
     :' -ne[ne]      (default = last)   : end trace number'
        write(LER,*)
     :' -rs[irs]      (default = first) : start record number'
        write(LER,*)
     :' -ne[ire]      (default = last)  : end record number'
        write(LER,*)
     :' -v[val]       (default = none)  : key value'
        write(LER,*)
     :' -lt  :  if present pass traces with value < val'
        write(LER,*)
     :' -le  :  if present pass traces with value < or = to val'
        write(LER,*)
     :' -eq  :  if present pass traces with value = to val (def)'
        write(LER,*)
     :' -ge  :  if present pass traces with value > or = val'
        write(LER,*)
     :' -gt  :  if present pass traces with value > val'
        write(LER,*)
     :' -neq :  if present pass traces with value not equal to val'
        write(LER,*)
     :' -R   :  if present process record-by-record'
        write(LER,*)
     :' -pad[npad] (def=ne-ns+1)        : for -R pad output recs'
        write(LER,*)
     :' -L   :  if present process live traces only'
         write(LER,*)
     :'usage:   seltrc -N[ntap] -T[] -v[] [-lt -le -eq -ge -gt -neq]'
         write(LER,*)
     :' -ns[ns] -ne[ne] -rs[irs] -re[ire] [-R -pad[]]  -V'
         write(LER,*)
     :'***************************************************************'
      return
      end

      subroutine gcmdln(ntap,otap,ns,ne,irs,ire,itwd,lt,eq,gt,val,
     1                  le,ge,neq,verbos,live,rec,npad)
c-----
c     get command arguments
c
c     ntap  - c*100     input file name
c     otap  - c*100     output file name
c     ns    - i*4 starting trace index
c     ne    - i*4 ending trace index
c      rs   - i*4 starting record index
c      re   - i*4 ending record index
c     val   - i*4 trace header value tested against
c     itwd  - c*6 trace header mnemonic word to test against
c     gt          - L   pass traces with values less than val
c     eq          - L   pass traces with values equal val
c     gt          - L   pass traces with values greater than val
c     live        - L   live traces only
c     verbos      - L   verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*), itwd*6
      integer     ns, ne, irs, ire, val, npad
      integer     argis
      logical     lt, eq, gt, le, ge, neq, verbos, live, rec

            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr ( '-T', itwd , '      ','      ' )
            call argi4 ( '-v', val , 666666  ,666666 )
            call argi4 ( '-pad', npad , 0 , 0 )
            gt  = (argis('-gt') .gt. 0)
            ge  = (argis('-ge') .gt. 0)
            lt  = (argis('-lt') .gt. 0)
            le  = (argis('-le') .gt. 0)
            neq = (argis('-neq') .gt. 0)
            eq  = (argis('-eq') .gt. 0)
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            live   = (argis('-L') .eq. 0)
            rec    = (argis('-R') .gt. 0)
            verbos = (argis('-V') .gt. 0)

            if (itwd .eq. ' ') then
               write(LERR,*)'Must enter trace header mnemonic -- FATAL'
               stop 911
            endif
            if (val .eq. -666666) then
               write(LERR,*) 'Must enter a value on cmd line -- FATAL'
               stop 666
            endif
            if (.not.lt .and. .not.gt .and. .not.le .and. .not.ge
     1          .and. .not.neq)
     2           eq = .true.


      return
      end


