C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c   subroutine to do running n - point average smoothing
c
      subroutine nave( n, nord, y )
c
c   n   - I     number of points in input vector
c  nord - I     order of the smoother
c   y   - R     input vector (and output vector)
c  work - R     working space
c
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      integer    y(*)
      real       work(2*SZSMPM)
      integer    n, nord, nhaf, nhaf1
      real       xd, sum

      if (nord .le. 1) return

      if( mod(nord,2) .eq. 0) then
          nord = nord + 1
          write(LERR,*)'Order must be odd:'
          write(LERR,*)'it has been changed to ',nord
      endif
      if (nord .ge. n) then
         write(LERR,*)'Order of smoother = length of window'
         nord = nord - 2
         write(LERR,*)'Order changed to ',nord
      endif


      nhaf = nord/2
      nhaf1 = nhaf + 1
      sum = 0.

      do  1  ii = 1, nhaf
          sum = sum + y(ii)
1     continue
      xd = float(nhaf)
      i = 0

c---------------------------------
c  roll into full average window
      do  2  ii = nhaf1, nord

          i = i+1
          xd = xd + 1.
          sum = sum + y(ii)
          work(i) = sum/xd

2     continue
c---------------------------------

c---------------------------------
c  go thru data with full window
      do  3  i = nhaf1+1, n-nhaf

          sum = sum - y(i-nhaf1) + y(i+nhaf)
          work(i) = sum/xd

3     continue
c---------------------------------

c---------------------------------
c  roll off data
      ii = i
      do  5  iend = i, n

          xd = xd - 1.
          sum = sum - y(ii)
          work(iend) = sum/xd
          ii = ii + 1

5     continue
c---------------------------------

c---------------------
c  output vector
      do  10  i = 1, n
          y(i) = work(i)
10    continue
c---------------------

      return
      end
