C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c shape reads seismic trace data from an input file,
c for a selected wavelet in a record calculates the shaping filter
c for all other traces in the record, applies the filter to these traces, &
c writes the results to an output file
c
c changes
c
c Nov96 added who_cares flag for Gary Ruckgaber to allow zero traces
c       in model dataset.........this could be a temp situation as he
c       is testing it now.
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters

#include <f77/iounit.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
      integer     itr ( SZLNHD ), mtr ( SZLNHD )
      integer     lhed( SZLNHD )
      integer     head( SZLNHD )
      integer     mhed( SZLNHD )
      real        mead( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     RecNum, ifmt_RecNum, ln_RecNum, l_RecNum
      integer     TrcNum, ifmt_TrcNum, ln_TrcNum, l_TrcNum
      integer     StaCor, ifmt_StaCor, ln_StaCor, l_StaCor
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     nrecrd,ntrace, ist,ied,iwin
      integer     itimes(SZLNHD), mst, mend, mwin

c------
c  static memory allocation
c     real        bigar1(SZSPRD*SZSMPM)
c------
c  dynamic memory allocation for big arrays, eg whole records
      integer     ithdr
      pointer     (wkithdr, ithdr(1))
      real        bigar1
      pointer     (wkadr1, bigar1(1))
c------

c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
      real        tri ( SZLNHD ), trid( SZLNHD ), taper( SZLNHD )
      character   ntap * 256, otap * 256, name*6, modl * 256
      logical     verbos, heap1, filt, job, dbg, first, stk
      logical     pipem, who_cares
      integer     argis, pipe
 
      equivalence ( itr(  1), lhed(1), head(1) )
      equivalence ( mtr(  1), mhed(1), mead(1) )

      data lbytes / 0 /, nbytes / 0 /, name/'SHAPE2'/, first/.true./
      data pipe/3/
 
c-----
c     read program parameters from command line card image file
c-----

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0  )then
         call help()
         stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln( ntap, otap, modl, ntrace, ist, ied, prew, pct, lfilt,
     :     nrecrd, stk, job, filt, verbos, dbg, mst, mend, vel, 
     :     who_cares )

c-----
c     get logical unit numbers for input and output of seismic data
c     0 = default stdin
c     1 = default stdout
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

      if (modl .ne. ' ') then
          call getln(lumod, modl, 'r',-1)
          pipem = .false.
      else
          write(LERR,*)'shape2 assumed to be running inside IKP'
          call sisfdfit (lumod, pipe)
          if (lumod .gt. 0) pipem = .true.
      endif
      if (lumod .lt. 0) then
         write(LERR,*)'shape2 error: model file not accessible'
         write(LERR,*)'Check existence of this file & try again'
         go to 999
      else
         write(LERR,*)'input unit = ',luin
         write(LERR,*)'output unit= ',luout
         write(LERR,*)'model unit = ',lumod
      endif


c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'SHAPE: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif

c------
c     to get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c
c     see saver/w manual pages
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      call hlhprt (itr, lbytes, name, 6, LERR)

c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary

      dt = real (nsi) * unitsc

c--------
c     default times
c--------
      ist = ist/nsi
      ied = ied/nsi
      if (ist .le. 0) ist = 1
      if (ied .le. 0) ied = nsamp
      iwin = ied - ist + 1
      ist0 = ist
      veldt = vel * dt
      lfilt = lfilt/nsi
      if (lfilt .eq. 0) lfilt = iwin/2

c-----
c     build cosine taper
c-----
      call costap (taper, iwin, pct)


c-----
c     get model data
c     set model window times
c-----
         call rtape  ( lumod, mtr, mbytes)
         if(mbytes .eq. 0) then
            write(LER,*)'SHAPE: no header read from unit ',lumod
            write(LER,*)' model data set -- FATAL'
            stop
         endif
         call saver(mtr, 'NumSmp', msamp, LINHED)
         call saver(mtr, 'SmpInt', msi  , LINHED)
         call saver(mtr, 'NumTrc', mtrc , LINHED)
         call saver(mtr, 'NumRec', mrec , LINHED)
         call saver(mtr, 'Format', mform, LINHED)

         mst  = mst/nsi
         mend = mend/nsi
         if(mst  .le. 0) mst = 1
         if(mend .le. 0) mend = msamp
         mwin = mend - mst + 1

         if (mrec .eq. 1 .AND. .not. job) then
            write(LERR,*)'Warning: model data set has only 1 record'
            write(LERR,*)'and you have not specified the single model'
            write(LERR,*)'trace option.  Will set this option and use'
            write(LERR,*)'only the 1 record available'
         endif

c---------------------------------------------------
c  malloc only space we're going to use
      heap1 = .true.

c--------------------------
c  note: these don't
c  have to be the same size

      itemi = ntrc * ITRWRD * SZSMPD
      item1 = ntrc * nsamp
      heap1 = .true.

c  note also SZSMPD is the 
c  size of an item in bytes
c--------------------------

      call galloc (wkithdr, itemi * SZSMPD, errcd1, abort1)
      if (errcd1 .ne. 0.) heap1 = .false.

      call galloc (wkadr1,  item1 * SZSMPD, errcd1, abort1)
      if (errcd1 .ne. 0.) heap1 = .false.

      if (.not. heap1) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) item1*SZSMPD,'  bytes'
         write(LERR,*) itemi*SZSMPD,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) item1*SZSMPD,'  bytes'
         write(LERR,*) itemi*SZSMPD,'  bytes'
         write(LERR,*)' '
      endif
c---------------------------------------------------


c----------------------
c  number output bytes
      nsampo = nsamp
      if (filt) then
         nsampo = lfilt
         call savew(itr, 'NumSmp', nsampo, LINHED)
      endif
      obytes = SZTRHD + nsampo * SZSMPD
c----------------------
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout                 )

c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
            call verbal(nsamp, nsi, ntrc, nrec, iform,filt,job,nrecrd,
     1                  stk,lfilt,iwin,prew,ntrace,ist,ied,ntap,otap,
     2                  modl,mrec,mtrc,msamp,mst,mend,mwin,vel)

c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
c-----

c-----
c     process desired trace records
c-----

      do 1000 jj = 1, nrec

c debug
c         if ( jj .eq. 258 ) then
c            write(ler,*)'made it'
c         endif
c debug
 
 
            ic = 0
            do 1001  kk = 1, ntrc

                  nbytes = 0
                  call rtape( luin, itr, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c------
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif

c------
c     for trace header values you can use the I*2 vector
c     rather than saver/savew (which you can use)
c     this is faster in general than saver/w
c------

                  call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        StaCor, TRACEHEADER)
                  call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum, TRACEHEADER)
                  call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        TrcNum, TRACEHEADER)
                  call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                        idist , TRACEHEADER)
                  dist   = iabs(idist)

                  if (StaCor .eq. 30000) then
                     call vclr (tri,1,nsamp)
                     dist = 0.
                  endif

c----------------------
c  pack data into array
                  ic = ic + 1
                  istrc = (ic-1) * nsamp
                  ishdr = (ic-1) * ITRWRD
                  call vmov (lhed,1, ithdr(ishdr+1),1,ITRWRD)
                  call vmov (lhed(ITHWP1), 1, tri, 1, nsamp)
                  call vmov (tri,1, bigar1(istrc+1),1,nsamp)

                  itimes(ic) = ist0 + dist/veldt

1001        continue


c----------------------
c  select design trc

            if (.not. job) then
                nr = JJ
                first = .true.
            else
                if (JJ .eq. 1)
     1          call unitrs(1, nrecrd-1,lumod,mtrc,mtr,pipem)
                nr = nrecrd
            endif
                     call model (bigar1,trid,ithdr,nsamp,ntrc,
     1                           mrec, mtrc, msamp,mst,mend,mwin,
     2                           job,stk,ntrace,JJ,dbg,first,pipem,
     3                           lumod,mhed,mtr,nr,
     4                           l_StaCor,l_RecNum,l_TrcNum, who_cares)

c-----------------------
c  here's the meat...
c  compute shaping filter

                     call shaper (ntrc,nsamp,itimes,iwin,prew,mwin,
     1                            lfilt,taper,trid, bigar1,filt,
     2                            verbos,JJ)

c-----------------------

c---------------------
c  extract traces from
c  output array and
c  write output data

            do 1002 kk = 1, ntrc

                  istrc = (kk-1) * nsamp
                  ishdr = (kk-1) * ITRWRD
                  call vmov (bigar1(istrc+1),1,lhed(ITHWP1),1,nsampo)
                  call vmov (ithdr(ishdr+1),1,lhed,1,ITRWRD)

                  call wrtape (luout, itr, obytes)


 1002             continue
 
            if(verbos)write(LERR,*)'ri ',recnum,'  processed'
 
 1000       continue

c-----
c     close data files
c-----
  999 continue

      call lbclos ( luin )
      call lbclos ( luout )
      if (lumod .gt. 0)
     1call lbclos ( lumod )

            write(LERR,*)'end of shape2, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'shape2 takes a model trace and input traces and computes a'
        write(LER,*)
     :'least squares filter to shape the input to the model'
        write(LER,*)
     :'see manual pages for details ( online by typing uman shape2 )'
        write(LER,*)' '
        write(LER,*)
     :'execute shape2 by typing shape and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)         : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)         : output data file name'
        write(LER,*)
     :' -M [modl]    (default = none)     : model data file name'
        write(LER,*)
     :' -n[nt]       (default = first)    : model trace in each record'
        write(LER,*)
     :' -r[rt]       (default = first)    : model record (-M[] option)'
        write(LER,*)
     :' -s[ist]      (default = last)     : start design window (ms)'
        write(LER,*)
     :' -e[ied]      (default = first)    : end design window (ms)'
        write(LER,*)
     :' -v[vel]      (default = flat)     : desgn wndw velocity (f,m/s)'
        write(LER,*)
     :' -ms[mst]     (default = last)     : start model trc window (ms)'
        write(LER,*)
     :' -me[mend]    (default = first)    : end model trc window (ms)'
        write(LER,*)
     :' -l[lfilt]    (default = 1/2 wind) : length of filter (ms)'
        write(LER,*)
     :' -p[prew]     (default = .01%)     : % prewhitening'
        write(LER,*)
     :' -t[pct]      (default = 0)        : % window taper'
        write(LER,*) ' '
        write(LER,*)
     :' -S   model trace is result of stacking the gather, else it is'
        write(LER,*)
     :'      one trace from a gather'
        write(LER,*)
     :' -J   include on command line if using one model trace/line'
        write(LER,*)
     :'      else model is recomputed for each gather'
        write(LER,*)
     :' -F   include on command line if outputting filter only; else'
        write(LER,*)
     :'      we output filtered data. Filter can be applied with cross'
        write(LER,*)
        write(LER,*)
     :' -zero   include on command line if you suspect dead traces in'
        write(LER,*)
     :'      the model dataset.  Otherwise program will abort if a dead'
        write(LER,*)
     :'      model trace is encountered.'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   shape2 -N[ntap] -O[otap] -r[] -n[] -s[] -e[] -v[]'
        write(LER,*)
     :'                -ms[] -me[] -p[] -t[] -l[] [-S -J -F -V -zero]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,modl,ntrace,ist,ied,prew,pct,lfilt,
     1     nrecrd,stk,job,filt,verbos,dbg,mst,mend,vel, who_cares )
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     modl  - C*100    optional model trace file name
c   ntrace  - I*4      design trace
c    ist    - I*4      starting design window
c    ied    - I*4      ending design window
c   lfilt   - I*4      length of filter
c    prew   - R*4      % prewhitening
c    pct    - R*4      % length taper
c     filt    L        output filter, else output filtered data
c     verbos  L        verbose output or not
c   who_cares L   flag to allow the user to not care if a model trace
c                 is full of hard zeroes.
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*), modl*(*)
      integer     ntrace, ist, ied, lfilt, nrecrd
      real        prew, pct
      logical     verbos, filt, job, dbg, stk, who_cares
      integer     argis
 
c-------
c     see manual pages on the argument handler routines
c     for the meanings of these functions
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-M', modl, ' ', ' ' )
            call argi4 ( '-n', ntrace, 0, 0)
            call argi4 ( '-r', nrecrd, 0, 0)
            call argi4 ( '-s', ist , 0, 0)
            call argi4 ( '-e', ied , 0, 0)
            call argi4 ( '-ms', mst , 0, 0)
            call argi4 ( '-me', mend , 0, 0)
            call argi4 ( '-l', lfilt , 0, 0)
            call argr4 ( '-p', prew , .1, .1)
            call argr4 ( '-t', pct , 0., 0.)
            call argr4 ( '-v', vel , 999999., 999999.)

            stk    =   (argis('-S') .gt. 0)
            job    =   (argis('-J') .gt. 0)
            filt   =   (argis('-F') .gt. 0)
            verbos =   (argis('-V') .gt. 0)
            who_cares = ( argis('-zero') .gt. 0)

            dbg    =   verbos

            if (.not. job .AND. nrecrd .eq. 0) then
               nrecrd = 1
            endif

            if (ntrace .eq. 0 .and. stk) then
               write(LERR,*)'No design trace given -- FATAL'
               stop
            endif
            prew = prew * .01
 
      return
      end
 
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,filt,job,nrecrd,
     1                  stk,lfilt,iwin,prew,ntrace,ist,ied,ntap,otap,
     2                  modl,mrec,mtrc,msamp,mst,mend,mwin,vel)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c   ntrace  - I*4      design trace
c    ist    - I*4      starting design window
c    ied    - I*4      ending design window
c    iwin   - I*4      length of design window in points
c   lfilt   - I*4      length of filter
c    prew   - R*4      % prewhitening
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>

      integer     nsamp, nsi, ntrc, nrec, ntrace, ist, ied, lfilt
      integer     nrecrd
      character   ntap*(*), otap*(*), modl*(*)
      real        prew
      logical     filt, job, stk
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace       =  ', nsamp
            write(LERR,*) ' data sample interval     =  ', nsi
            write(LERR,*) ' data traces per record   =  ', ntrc
            write(LERR,*) ' data records per line    =  ', nrec
            write(LERR,*) ' data format of data      =  ', iform
            write(LERR,*) ' design trace             =  ', ntrace
            write(LERR,*) ' design record            =  ', nrecrd
            write(LERR,*) ' start data window        =  ', ist,' pts'
            write(LERR,*) ' end data window          =  ', ied,' pts'
            write(LERR,*) ' data window velocity     =  ', vel
            write(LERR,*) ' model sample/trace       =  ', msamp
            write(LERR,*) ' model traces per record  =  ', mtrc
            write(LERR,*) ' model records per line   =  ', mrec
            write(LERR,*) ' start model window       =  ', mst,' pts'
            write(LERR,*) ' end model window         =  ', mend,' pts'
            write(LERR,*) ' model window length      =  ', mwin,' pts'
            write(LERR,*) ' length of window         =  ',iwin,' pts'
            write(LERR,*) ' length of filter         =  ',lfilt,' pts'
            write(LERR,*) ' % prewhitening           =  ', 100.*prew
            write(LERR,*) ' output filter only       =  ', filt
            write(LERR,*) ' job constant model trc   =  ', job
            write(LERR,*) ' trace model result of stk=  ', stk
            write(LERR,*) ' input data set name      =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*) ' model data set name=  ', modl
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
 
