C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Shot_Average ( Record_WorkSpace, Headers, nsamp, ntrc, 
     :     ist, iend, Record, Shots, num_shots, skip_traces, 
     :     denominator, add_back_percentage, ifmt_ShtWrd, l_ShtWrd, 
     :     ln_ShtWrd, ntrc_cable, automode, threshold, lags,
     :     nrec, nshaved, shaved, nkicks, min_threshold, max_threshold,
     :     thresholds, detected, ramp, nopower )

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c the assumptions made in this routine are that
c a. Record_WorkSpace() contains three adjacent shots
c b. Headers() contains the headers for those shots 
c c. A 1:1 trace correspondance exists between the two arrays
c d. ist and iend contain the start and end samples to be operated on
c e. Record() will contain the averaged shot to be output
c f. if no averaging to be done Record() will still contain the output record

c decare variables passed from calling routine

      integer nsamp, ntrc, nrec, ist, iend, ntrc_cable, lags
      integer num_shots, skip_traces, nshaved, nkicks
      integer ifmt_ShtWrd, l_ShtWrd, ln_ShtWrd
      integer Headers(ITRWRD,3*ntrc), Shots(num_shots), shaved(nrec)
      integer detected(nrec)

      real add_back_percentage, denominator, threshold
      real min_threshold, max_threshold
      real Record_WorkSpace(nsamp,3*ntrc), Record(nsamp,ntrc)
      real thresholds(nrec)

      logical automode, ramp, nopower

c declare local variables

      integer i, ShtWrd

      logical present, searching

c initialize variables

      present = .false.
      searching = .true.

c determine if any action is required for this shot, first get the shot number
c for the central record then check to see if it is in the shots[] array.

      i = ntrc

      do while (searching)
         i = i + 1

         if ( i .gt. (2*ntrc) ) then
            if ( .not. automode ) then
               write(LERR,*)' '
               write(LERR,*)' Zero shot index found in shot averaging'
               write(LERR,*)' routine.  Looks like no data associated '
               write(LERR,*)' with chosen trace header mnemonic.  Check'
               write(LERR,*)' that data is indexed appropriately and'
               write(LERR,*)' resubmit.'
               write(LERR,*)'FATAL'
               write(LERR,*)' '
               write(LER,*)'SHAVE:'
               write(LER,*)' Zero shot index found in shot averaging'
               write(LER,*)' routine.  Looks like no data associated '
               write(LER,*)' with chosen trace header mnemonic.  Check'
               write(LER,*)' that data is indexed appropriately and'
               write(LER,*)' resubmit.'
               write(LER,*)'FATAL'
               stop
            else
               searching = .false.
            endif
         endif

         call saver2 ( Headers(1,i), ifmt_ShtWrd, l_ShtWrd, 
     :        ln_ShtWrd, ShtWrd, TRACEHEADER )
         if ( ShtWrd .ne. 0 ) searching = .false.
      enddo

      if ( .not. automode ) then

c look in attached headerpickfile for shot data
         call CheckShot ( Shots, num_shots, ShtWrd, present )

      else

c use covariance algorithm for autodetect of anomalous energy on the
c central record

         call AutoDetect ( Record_WorkSpace, ntrc, nsamp, ist, iend, 
     :        ShtWrd, threshold, present, lags, nkicks, min_threshold, 
     :        max_threshold, nrec, thresholds, detected, nopower )
      
      endif

c load output Record() buffer with middle record

      call vmov ( Record_WorkSpace(1,ntrc+1), 1, Record(1,1), 1, 
     :     ntrc*nsamp )

c if anomalous energy is present then replace the central record using
c information from adjacent records.

      if ( present ) then

c keep a record of shots averaged for printout on completion

         nshaved = nshaved + 1
         shaved(nshaved) = ShtWrd

c do nothing for the non-common traces on the front of the record, non-common
c in a Fresnel sense.  The three adjacent shot records illuminate nearly the
c same subsurface.  We will be excluding traces that don't fall in this 
c category

         do i = 1, skip_traces
            do j = ist, iend

               if ( ramp ) then
                  if ( j .le. (ist+9) ) then
                     Record(j,i) = Record(j,i) - 
     :                    (j-ist+1)/10. * Record(j,i)
                  elseif ( j .gt. (iend - 9) .and. iend .ne. nsamp) then
                     Record(j,i) = Record(j,i) - 
     :                    (iend - j )/10. * Record(j,i)
                  else
                     Record(j,i) = 0.0
                  endif
               else
                  Record(j,i) = 0.0
               endif
            enddo
         enddo

c average the traces over the common portion of the record with a user defined
c add_back_percentage of the original data and normalize

         do i = skip_traces + 1 , ntrc - skip_traces
      
c if we are at the end of a cable within a shot record then we must perform the
c same Fresnel consideration trace skips as at the beginning and end of the
c record.  We will emulate this by just killing the data.
      
            if ( i .lt. ( ntrc_cable - skip_traces ) .or. 
     :           i .gt. ( ntrc_cable + skip_traces ) ) then

               do j = ist, iend
                  if ( ramp ) then
                     if ( j .le. (ist+9) ) then
                        Record(j,i) = ( (Record_WorkSpace(j,i) +
     :                       Record_WorkSpace(j,2*ntrc+i)) * 
     :                       (j-ist+1)/10. + 
     :                       Record_WorkSpace(j,ntrc+i)) 
     :                       / (1. + (j-ist+1)/10. * 1.75)
                     elseif ( j .gt. (iend - 9) .and. iend .ne. nsamp ) 
     :                       then
                        Record(j,i) = ( (Record_WorkSpace(j,i) +
     :                       Record_WorkSpace(j,2*ntrc+i)) * 
     :                       (iend - j )/10. + 
     :                       Record_WorkSpace(j,ntrc+i)) 
     :                       / ( 1 + (iend - j )/10. * 1.75)
                     else
                        Record(j,i) = ( Record_WorkSpace(j,i) + 
     :                       Record_WorkSpace(j,2*ntrc+i) + 
     :                       add_back_percentage * 
     :                       Record_WorkSpace(j,ntrc+i)) 
     :                       / denominator
                     endif
                  else
                     Record(j,i) = ( Record_WorkSpace(j,i) + 
     :                    Record_WorkSpace(j,2*ntrc+i) + 
     :                    add_back_percentage * 
     :                    Record_WorkSpace(j,ntrc+i)) 
     :                    / denominator
                  endif
               enddo
            else
               do j = ist, iend
                  if ( ramp ) then
                     if ( j .le. (ist+9) ) then
                        Record(j,i) = Record(j,i) - 
     :                       (j-ist+1)/10. * Record(j,i)
                     elseif ( j .gt. (iend - 9) .and. iend .ne. nsamp ) 
     :                       then
                        Record(j,i) = Record(j,i) - 
     :                       (iend - j )/10. * Record(j,i)
                     else
                        Record(j,i) = 0.0
                     endif
                  else
                     Record(j,i) = 0.0
                  endif
               enddo
            endif
         enddo

c do nothing for the non-common traces on the back of the record

         do i = ntrc - skip_traces, ntrc
            do j = ist, iend
               if ( ramp ) then
                  if ( j .le. (ist+9) ) then
                     Record(j,i) = Record(j,i) - 
     :                    (j-ist+1)/10. * Record(j,i)
                  elseif ( j .gt. (iend - 9) .and. iend .ne. nsamp ) 
     :                    then
                     Record(j,i) = Record(j,i) - 
     :                    (iend - j )/10. * Record(j,i)
                  else
                     Record(j,i) = 0.0
                  endif
               else
                  Record(j,i) = 0.0
               endif
            enddo
         enddo
      endif

      return
      end
