C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln ( ntap, otap, shottap, avtap, irs, ire, ist, 
     :     iend, name, add_back_percentage, c_ShtWrd, shot_interval,
     :     group_interval, ntrc_cable, threshold, lags, mute, nopower )

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer irs, ire, ist, iend, lags

      real add_back_percentage, shot_interval, group_interval
      real threshold

      character ntap*(*), otap*(*), shottap*(*), name*(*)
      character c_ShtWrd*6, avtap*(*)

      logical mute, nopower

c declare local variables

      integer argis

c parse command line

      call argr4 ( '-amp', add_back_percentage, 0., 0. )
      add_back_percentage = 0.01 * add_back_percentage

      call argi4 ( '-cable', ntrc_cable, 160, 160 )

      call argi4 ( '-e', iend, 0, 0 )

      call argr4 ( '-gi', group_interval, 12.5, 12.5 )

      call argstr ( '-hw', c_ShtWrd, 'RecNum', 'RecNum' ) 

      call argi4 ( '-lag', lags, 100, 100 )

      mute = ( argis('-mute') .gt. 0 )

      call argstr ( '-N', ntap, ' ', ' ' ) 

      call argstr ( '-O', otap, ' ', ' ' ) 

      nopower = ( argis('-nopower') .gt. 0 )

      call argi4 ( '-re', ire, 0, 0 )
      call argi4 ( '-rs', irs, 0, 0 )

      call argstr ( '-S', avtap, ' ', ' ' ) 
      call argr4 ( '-si', shot_interval, 25., 25. )
      call argi4 ( '-s', ist, 1, 1 )

      call argr4 ( '-thresh', threshold, 0.1, 0.1 )

      call argstr ( '-X', shottap, ' ', ' ' ) 

c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

           
      return
      end

      
