C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( ntap, otap, shottap, avtap, nsamp, nsi, ntrc, 
     :     nrec, iform, ist, iend, irs, ire, Shots, num_shots, nopower, 
     :     shot_interval, group_interval, skip_traces, c_ShtWrd, 
     :     add_back_percentage, ntrc_cable, threshold, lags, mute )

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer nsamp, ntrc, iform, ist, iend, irs, ire, nsi
      integer num_shots, skip_traces, ntrc_cable
      integer Shots(num_shots), lags

      real shot_interval, group_interval, add_back_percentage
      real threshold

      character  ntap*(*), otap*(*), shottap*(*), c_ShtWrd*6
      character avtap*(*)

      logical mute, nopower

c declare local variables

      integer length

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      length = lenth(ntap)
      if (length .gt. 0) then
        write(LERR,*) ' input data set name   =  ', ntap(1:length)
      else
        write(LERR,*) ' input data set        =  stdin'
      endif
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      length = lenth(otap)
      if (length .gt. 0) then
        write(LERR,*) ' output data set name    = ', otap(1:length)
      else
        write(LERR,*) ' output data set         = stdout'
      endif
      write(LERR,*) ' start record            = ', irs 
      write(LERR,*) ' end record              = ', ire 
      write(LERR,*) ' processing sample start = ', ist
      write(LERR,*) ' processing sample end   = ', iend
      write(LERR,*) ' add back percentage     = ', add_back_percentage
      write(LERR,*) ' shot interval           = ', shot_interval
      write(LERR,*) ' group interval          = ', group_interval
      write(LERR,*) ' number traces per cable = ', ntrc_cable
      write(LERR,*) ' number of noncommon traces = ', skip_traces
      write(LERR,*) ' correlation lags        = ', lags
      if ( mute ) write(LERR,*)' surgical mute detect requested'
      if ( avtap .ne. ' ' ) then
         length = lenth(avtap)
         write(LERR,*)' Statistics file name = ',avtap(1:length)
      endif
      if ( shottap .ne. ' ' ) then
         length = lenth(shottap)
         write(LERR,*) ' xsd headerfile name     = ', shottap(1:length)
         write(LERR,*) ' xsd headerfile mnemonic = ', c_ShtWrd
      else
         write(LERR,*) ' in autodetect mode    '
         write(LERR,*) ' autodetect threshold = ', threshold
         write(LERR,*) ' trace header shot mnemonic = ', c_ShtWrd
      endif
      write(LERR,*)' '

      if ( shottap .ne. ' ' ) then
         write(LERR,*) ' '
         write(LERR,*) ' Shots to be Editted '
         write(LERR,*) ' -------------------'
         write(LERR,*) ' '
         write(LERR,*) c_ShtWrd
         write(LERR,*) '------ '
         write(LERR,*) ' '
         do i = 1, num_shots
            write(LERR,*)Shots(i)
         enddo
         write(LERR,*) ' '
         write(LERR,*)'========================================== '
         write(LERR,*)' '
      else
         write(LERR,*)' '
         write(LERR,*)' Auto Detect Mode '
         write(LERR,*)' '
         if ( .not. nopower ) then
            write(LERR,*)' '
            write(LERR,*)' using power of input records'
            write(LERR,*)' '
         endif
         write(LERR,*)'========================================== '
         write(LERR,*)' '
         write(LERR,*) ' '
         write(LERR,*) ' Covariance Statistics '
         write(LERR,*) ' ---------------------'
         write(LERR,*) ' '
      endif 

      return
      end


