C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c sis_xy reads seismic trace data from an input file,
c performs minimum entropy deconvolution and
c writes the results to an output file
c
c
c**********************************************************************c
c 
c Changes:
c
c May 1, 2001:  added UnitSc capability to ensure correct time listing
c               in ascii output.  Also fixed up dynamic memory allocation.
c Garossino
c
c     declare variables
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>
 
      integer     itr( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , lbytes, nbytes, luout, luo, obytes
      integer     irs,ire,ns,ne
      integer     recnum, trcnum, static, ncomp, rdel, tdel
      integer     npts ( SZLNHD )
      integer     argis, luval
      integer     length, lenth

      real        tri ( SZLNHD ), dels, nullval, UnitSc
      real        X ( SZLNHD )

      real        work, Y

      pointer     (wkadry, Y(2))
      pointer     (wkadrw, work(2))

      character   ntap * 255, otap * 255, name*6, card*80
      character   dg1*1, dg2*1

      logical     verbos, blnk, heap, mbs, rev
      logical     stream, w_col
 
      data lbytes / 0 /
      data nbytes / 0 /
      data name/'SIS_XY'/
 
      
c-----
c     read program parameters from command line card image file
c-----
      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis( '-h' ) .gt. 0 .or. 
     :     argis( '-help' ) .gt. 0) then
         call help()
         stop
      endif
 
c-----
c     open printout files
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,ist,iend,ns,ne,irs,ire,blnk,verbos,
     1            dels,ncomp,idec,rdel,tdel,mbs,rev,otap,nullval,
     2            stream,nsampi,ntrci,nreci,w_col,wvel)

c******
c  if reverse then we read a file of X-Y values and build output
c  seismic traces
c******
      IF (rev) THEN

        if (ntap(1:) .eq. ' ') then
            write(LERR,*)' '
            write(LERR,*)'Opening input stream for X-Y data. The'
            write(LERR,*)'number of samples per trace must be the'
            write(LERR,*)'same'
            write(LERR,*)' '
        else
            luval = 29
            open(unit=luval, file = ntap, status='old', iostat=ierr)
 
            if(ierr .ne. 0) then
               write(LERR,*)'SIS_XY: Could not open X-Y input file'
               write(LERR,*)'       Check existence/permissions'
               write(LERR,*)'FATAL'
               write(LER ,*)'SIS_XY: Could not open X-Y input file'
               write(LER ,*)'       Check existence/permissions'
               write(LER ,*)'FATAL'
               stop
            endif
        endif
c-----
c     get logical unit numbers for input and output
c-----
      call getln(luout , otap,'w', 1)
c-----
c     read line header of input
c     save certain parameters
c-----

        if (.not. stream) then

           rewind luval
           j = 1
           i = 0
           DO  while (1 .eq. 1)
                   read (luval, '(a80)', end=50) card
                   nc = lenth (card)
                   i = i + 1
                   if (nc .le. 1) then
                      npts (j) = i-1
                      j = j + 1
                      i = 0
                   endif
           ENDDO

           write(LERR,*)' '
           write(LERR,*)'FATAL ERROR in sis_xy -R'
	   length = lenth(ntap)
	   if (length .gt. 0) then
             write(LERR,*)'Did not hit end of file on input - ',
     1     	'check file ',ntap(1:length)
	   else
             write(LERR,*)'Did not hit end of file on input - ',
     1     	'check stdin '
	   endif
           write(LER ,*)' '
           write(LER ,*)'FATAL ERROR in sis_xy -R'
	   if (length .gt. 0) then
             write(LER,*)'Did not hit end of file on input - ',
     1     	'check file ',ntap(1:length)
	   else
             write(LER,*)'Did not hit end of file on input - ',
     1     	'check stdin '
	   endif
           stop 666

50         continue

           if (i .eq. 0) then
                 j = j - 1
           else
              npts (j) = i
           endif
           nfunc = j
           rewind luval

           call imax (nfunc, npts, maxpts)
           call imax (nfunc, npts, minpts)

           if (minpts .ne. maxpts) then
              write(LERR,*)'sis_xy fatal error:'
              write(LERR,*)'Unequal length X-Y functions'
              write(LERR,*)'Found ',nfunc,' functions:'
              do  j = 1, nfunc
                  write(LERR,*)'function ',j,' has ',npts(j),' pts'
              enddo
              write(LERR,*)'Must be all equal length'
           endif

           write(LERR,*)' '
           write(LERR,*)'Number of functions read  = ',nfunc
           write(LERR,*)'Number of points/function = ',maxpts
           write(LERR,*)' '

           minx  = X (1)
           maxx  = X (maxpts)
           intx  = X (2) - X (1)
           if (intx .eq. 0) intx = 1
           if (nreci .eq. 1 .AND. ntrci .eq. 1) then
              ntrci = nfunc
           else
              nfunc = nreci * ntrci
           endif

        else

           luval = LIN
           maxpts = nsampi
           minx  = X (1)
           maxx  = X (maxpts)
           intx  = X (2) - X (1)
           if (intx .eq. 0) intx = 1
           nfunc = ntrci * nreci

        endif

        heap = .true.
        item =  maxpts * SZSMPD
        call galloc (wkadry, item, errcd, abort)
        if (errcd .ne. 0.) heap = .false.
        if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) item,'  bytes'
         write(LER ,*)' '
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) item,'  bytes'
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) item,'  bytes'
      endif

      nsamp = maxpts

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      call savew (itr, 'NumRec', nreci , LINHED)
      call savew (itr, 'Format',  3    , LINHED)
      call savew (itr, 'NumTrc', ntrci , LINHED)
      call savew (itr, 'SmpInt',  1    , LINHED)
      call savew (itr, 'NumSmp', nsamp , LINHED)
      call savew (itr, 'MxShDp', maxx  , LINHED)
      call savew (itr, 'MnShDp', minx  , LINHED)
      call savew (itr, 'IntInc', intx  , LINHED)
      dg1 = 'S'
      dg2 = 'X'
      call savew (itr, 'DgTrk1', dg1   , LINHED)
      call savew (itr, 'DgTrk2', dg2   , LINHED)

      obytes = SZTRHD + SZSMPD*nsamp
      lbytes = HSTOFF
      nbyt = 2 * SZHFWD
      call savew ( itr, 'HlhEnt',  0   , LINHED)
      call savew ( itr, 'HlhByt', nbyt , LINHED)
      call savhlh( itr, lbytes, lbyout )
      CALL WRTAPE ( LUOUT, ITR, LBYOUT                 )

c******
c  otherwise we read seismic traces and output X-Y values
c******
      ELSE

c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape   ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LER,*)'SIS_XY: no header read from unit ',luin
         write(LER,*)'FATAL'
         stop
      endif

      if (otap(1:1) .eq. ' ') then
         luo = LOT
      else
        luo = 29
        open (unit=luo, file=otap, status='unknown', iostat=ierr)

        if(ierr .ne. 0) then
           write(LERR,*)'SIS_XY: Could not open X-Y output file'
           write(LERR,*)'       Check existence/permissions'
           write(LERR,*)'FATAL'
           write(LER ,*)'SIS_XY: Could not open X-Y output file'
           write(LER ,*)'       Check existence/permissions'
           write(LER ,*)'FATAL'
           stop
        endif
      endif


c------
c     save certain parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

 
      call saver (itr, 'NumSmp', nsamp, LINHED)
      call saver (itr, 'SmpInt', nsi  , LINHED)
      call saver (itr, 'NumTrc', ntrc , LINHED)
      call saver (itr, 'NumRec', nrec , LINHED)
      call saver (itr, 'Format', iform, LINHED)
      call saver (itr, 'MxShDp', maxx  , LINHED)
      call saver (itr, 'MnShDp', minx  , LINHED)
      call saver (itr, 'IntInc', intx  , LINHED)
      call saver (itr, 'DgTrk1', dg1   , LINHED)
      call saver (itr, 'DgTrk2', dg2   , LINHED)
      call saver (itr, 'UnitSc', UnitSc   , LINHED)

      if ( UnitSc .eq. 0.0 ) UnitSc = 0.001

      if (dels .eq. 0.0) then
          dels = float(nsi)
      endif

      call saver(itr, 'TmSlIn', idels, LINHED)
      if (mbs) dels = float(idels) / 1000.
      nsi = dels
      si  = dels

      if (dg1 .eq. 'S' .AND. dg2 .eq. 'X') then
         nsi = intx
         ns0 = minx
         ist = 1
         iend = nsamp
         nout = nsamp
      else
         ns0  = 0
         ist  = nint (float(ist)/si)
         iend = nint (float(iend)/si)
         if (ist  .lt. 1) ist = 1
         if (iend .lt. 1) iend = nsamp
         if (iend .gt. nsamp) iend = nsamp
         nout = iend - ist + 1
      endif
c-----
c     ensure that command line values are compatible with data set
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

      ntr = ne - ns + 1

      if (ncomp .gt. ntr) then
         write(LERR,*)'WARNING:'
         write(LERR,*)'Number of columns to output = ',ncomp,' is'
         write(LERR,*)'greater then number of traces selected from'
         write(LERR,*)'each record= ',ntr,' Will set # cols= ',ntr
         ncomp = ntr
      endif


      ENDIF
c******

c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  ist,iend,ntap,dels,idec,rdel,tdel)

      heap = .true.
 
      if (ncomp .gt. 1) then
         items = ntr * nout * SZSMPD
      else
         items = SZSMPD
      endif
 
      call galloc (wkadrw, items, errcd, abort)
 
      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) items,'  bytes'
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) items,'  bytes'
      endif


c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do decon, write to output file
c-----

c******
      IF (rev ) THEN

         call savew2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1               1      , TRACEHEADER)

         DO  j = 1, nfunc

             i = 0
             call vclr (Y, 1, maxpts)

             do  while (1.eq.1)
 
                 read (luval, '(a80)', end=65) card
                 lc = lenth(card)
                 go to 66
 
65               continue
                 lc = 0
 
66               continue

                 if ( lc .gt. 1 ) then
                    call fsscnf ( card, '%f %f', Xi, Yi )
                    i = i + 1
                    if (abs(nullval-Yi) .lt. 1.e-30) then
                       Y(i) = 0.
                    else
                       Y(i) = Yi
                    endif

                 else

                    call vmov (Y, 1, itr(ITHWP1), 1, maxpts)
                    call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                          j      , TRACEHEADER)
                    call wrtape (luout, itr, obytes)

                    go to 70

                 endif
             enddo

70           continue

         ENDDO
c******
      ELSE

c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)
c-----
c     process desired trace records
c-----
      iflag = 0
      do  1000  jj = irs, ire, rdel
 
c----------------------
c  skip to start trace
            call trcskp(jj,1,ns-1,luin,ntrc,itr)
c----------------------
 
            do  1001  kk = ns, ne, tdel
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif

                  call vmov (itr(ITHWP1), 1, tri, 1, nsamp)

                  call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum , TRACEHEADER)
                  call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum , TRACEHEADER)
                  call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                        idist  , TRACEHEADER)
                  call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        static , TRACEHEADER)
                  dist = idist


                  IF (ncomp .eq. 1) THEN
c--------------------
c  create time ampl
c  axis using format
                     if (w_col) then
                        do  i = 1, iend
                            if ((tri(i)-wvel) .gt. 1.e-10) then
                                ist = i - 1
                                go to 201
                            endif
                        enddo
201                     continue
                        do  i = ist, iend, idec
                            t = ns0 + dels * float(i-1)
                            write(luo,101) t,tri(i)
                        enddo
                     else
                        do  i = ist, iend, idec
                            t = ns0 + dels * float(i-1)
                            write(luo,101) t,tri(i)
                        enddo
                     endif
101                  format(f15.5,5x,e15.8)
c--------------------
c-------------------
c  output null line
                     if (.not.blnk)
     1               write(luo,102)
102                  format()
c-------------------

                  ELSE

c--------------------
c  fill up array of output
c  trc values
                     istrc = (kk-1) * nout
                     call vmov (tri(ist), 1, work(istrc+1), 1, nout)
c--------------------

                  ENDIF

                  if(verbos)write(LERR,*)'ri ',recnum,' trace ',trcnum
c----------------------
c  skip to next trace
                  if (tdel .gt. 1 .and. (kk+tdel) .le. ntrc) then
                      call trcskp(jj,kk+1,kk+tdel-1,luin,ntrc,itr)
                  endif
                  ic = kk
c----------------------
 1001             continue

                  IF (ncomp .gt. 1) THEN
c--------------------
c  create time ampl
c  axis using format
                     nel = nout * ntr
                     do  105  i = 1, nout
                              t = ns0 + dels * float(i-1)
                              write(luo,*) t,
     1                        (work(i+(j-1)*nout), j = 1, ncomp)
105                  continue
c--------------------
                  ENDIF
 
c----------------------
c  skip to end of record
            if (tdel .gt. 1 .and. (ic+1) .lt. ntrc) then
               call trcskp(jj,ic+1,ntrc,luin,ntrc,itr)
            endif
c  skip to next record
            if (rdel .gt. 1)
     1      call recskp(jj+1,jj+rdel-1,luin,ntrc,itr)
c----------------------
 
 1000       continue

      ENDIF
c******

c-----
c     close data files
c-----
      if (rev) then
         call lbclos ( luout )
         close (luval)
      else
         call lbclos ( luin )
         close (luo)
      endif
      write(LERR,*)'processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LER,*)'sis_xy: Normal Termination'
      stop

 999  continue
      if (rev) then
         call lbclos ( luout )
         close (luval)
      else
         call lbclos ( luin )
         close (luo)
      endif
      write(LERR,*)'end of sis_xy, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LER,*)'sis_xy: Abnormal Termination'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*)
     :'execute sis_xy by typing sis_xy and a list of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :'                  Forward Mode:'
        write(LER,*)
     :' -N [ntap]    (stdin)              : input data file name'
        write(LER,*)
     :' -O [otap]    (stdout)             : output X-Y file name'
        write(LER,*)
     :' -s[ist] (default = 0 ms)          :  start time (ms)'
        write(LER,*)
     :' -e[iend] (default = end of trace) :  end time (ms)'
        write(LER,*)
     :' -i[idec] (default = 1)            :  sample increment'
        write(LER,*)
     :' -b[ncomp]    (default = 1)        : # trcs/column output'
        write(LER,*)
     :' -ns[ns]      (default = first)    : start trace number'
        write(LER,*)
     :' -ne[ne]      (default = last)     : end trace number'
        write(LER,*)
     :' -T0[tdel]      (default = 1)      : trace increment'
        write(LER,*)
     :' -rs[irs]      (default = first)   : start record number'
        write(LER,*)
     :' -re[ire]      (default = last)    : end record number'
        write(LER,*)
     :' -R0[rdel]      (default = 1)      : record increment'
        write(LER,*)
     :' -f[dels]   (default = input s.i.) : sample interval override'
        write(LER,*)
     :' -w[wvel]   (def = do nothing)     : discard this water velocity'
        write(LER,*)
     :' -B    output no blank space between traces: xygraph will overplo
     :t traces'
        write(LER,*)
     :' -M    use MBS depth interval line header word for output s.i.'
          write(LER,*)
     :'usage:   sis_xy -N[] -O[] -s[] -e[] -i[] -ns[] -ne[] -T0[]'
          write(LER,*)
     :'                 -rs[] -re[] -R0[] -f[] -b[] [-w[] -M -B -V]'
         write(LER,*)
        write(LER,*)' '
        write(LER,*)
     :'                Reverse Mode:'
        write(LER,*)' '
        write(LER,*)
        write(LER,*)
     :' -N [ntap]    (stdin)              : input X-Y file name'
        write(LER,*)
     :' -O [otap]    (stdout)             : output data file name'
        write(LER,*)
     :' -nv[nulval]  (default = 0.0 )     : null value to trigger zero'
        write(LER,*)
     :' -R    reverse: take X-Y data and output traces'
        write(LER,*)
     :' -nsamp[nsamp] (def = none)        : number of samples/trace'
        write(LER,*)
     :' -ntrc[ntrc]   (def = 1)           : number of traces/record'
        write(LER,*)
     :' -nrec[nrec]   (def = 1)           : number of records'
          write(LER,*)
     :'usage:   sis_xy -N[] -O[] -nv[] [-R -nsamp[] -V]'
        write(LER,*)
     :'***************************************************************'

      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,ist,iend,ns,ne,irs,ire,blnk,verbos,
     1           dels,ncomp,idec,rdel,tdel,mbs,rev,otap,nullval,
     2           stream,nsampi,ntrci,nreci,w_col,wvel)
c-----
c     get command arguments
c
c     ntap  - c*120     input file name
c     ist   - i*4  start design window
c     iend  - i*4  end design window
c     ns    - i*4 starting trace index
c     ne    - i*4 ending trace index
c     irs   - i*4 starting record index
c     ire   - r*4 ending record index
c     fac   - i*4 scale factor
c     ncomp - i*4 number columns traces
c     blnk        - l   blank space y/n
c     verbos      - l   verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      real        dels, nullval, wvel
      integer     ns, ne, irs, ire, ist, iend, ncomp, rdel, tdel
      logical     verbos, blnk, mbs, rev, stream, w_col
      integer     argis
 
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )

            rev    = (argis('-R') .gt. 0)
            call argr4 ( '-w', wvel, 0.0, 0.0)
            w_col = .false.
            if (wvel .ne. 0.0) w_col = .true.
            call argi4 ( '-nsamp', nsampi ,   0  ,  0    )
            call argi4 ( '-nrec', nreci ,   1  ,  1    )
            call argi4 ( '-ntrc', ntrci ,   1  ,  1    )
            stream = .false.
            if (rev .AND. (ntap(1:1) .eq. ' ') ) then
               stream = .true.
               if (nsampi .eq. 0) then
                  write(LERR,*)' '
                  write(LERR,*)'FATAL ERROR in sis_xy:'
                  write(LERR,*)'For input streamed X-Y data must enter'
                  write(LERR,*)'number of samples per trace -nsamp[]'
                  write(LER ,*)' '
                  write(LER ,*)'FATAL ERROR in sis_xy:'
                  write(LER ,*)'For input streamed X-Y data must enter'
                  write(LER ,*)'number of samples per trace -nsamp[]'
                  stop 666
               endif
            endif

            call argi4 ( '-s', ist ,   1  ,  1    )
            call argi4 ( '-e', iend,   0  ,  0    )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-T0', tdel ,   1  ,  1    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argi4 ( '-R0', rdel ,   1  ,  1    )
            call argi4 ( '-b', ncomp ,   1  ,  1    )
            call argi4 ( '-i', idec ,   1  ,  1    )
            call argr4 ( '-f', dels ,   0.0  ,  0.0    )
            call argr4 ( '-nv', nullval ,   0.  ,  0.    )
            tdel = iabs (tdel)
            rdel = iabs (rdel)
            mbs    = (argis('-M') .gt. 0)
            blnk   = (argis('-B') .gt. 0)
            verbos = (argis('-V') .gt. 0)
 
      return
      end
 
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1            ist,iend,ntap,dels,idec,rdel,tdel)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     ist   - i*4  start design window
c     iend  - i*4  end design window
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ntap  - C*120     input file name
c     fac   - i*4 scale factor
c-----
#include <f77/iounit.h>
      integer * 4 nsamp, nsi, ntrc, nrec, rdel, tdel
      character ntap*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' design start time  =  ', ist
            write(LERR,*) ' design end time    =  ', iend
            write(LERR,*) ' input data set name =  ', ntap
            if (dels .ne. 0.0)
     1      write(LERR,*) ' output s.i.         =  ', dels
            write(LERR,*) ' output sample increment= ',idec
            write(LERR,*) ' output record increment= ',rdel
            write(LERR,*) ' output trace increment = ',tdel
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
