C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c Program Skill
c Amplitude Editting 

c changes: 

c Aug30_96:  fixed first sample replacement.  Previously would not
c            handle first sample if bad.  Currently will zero out 
c            first sample if bad....Garossino
c
c
c Jun_97:    added logic to interpolate sample values for absolute
c            value amplitudes less than a user input threshold.
c            previously only zeroed those values out.  (JEV)
c
c**********************************************************************c
c
c     declare variables
c
#include     <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare standard USP variables
 
      integer     itr ( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs, ire, ns, ne
      integer     argis

      real        tri ( SZLNHD )

      character   ntap * 512, otap * 512, name*5

      logical     verbos
c declare program specific variables

      integer     Adjacent, Lastil
      integer     recnum, trcnum

      logical     minSearch, notrp, alldead

c initialize variables
 
      data lbytes / 0 /
      data nbytes / 0 /
      data name/'SKILL'/
      data minSearch/.false./
 
c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout files

#include <f77/open.h>

c parse  command line
 
      call gcmdln(ntap,otap,lus,ns,ne,irs,ire,
     1     amax,amin,ikill,verbos,
     2     tbegin, tend, dbegin, dend, notrp,
     3     vel, alldead	)

c get logical unit numbers for input and output

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c read line header of input save certain parameters

      call rtape   ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'STORE: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      
      call hlhprt (itr, lbytes, name, 5, LERR)

c ensure that command line values are compatible with data set

      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
c modify line header to reflect actual number of traces output

      nrecc=ire - irs+1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr=ne-ns+1
      call savew(itr, 'NumTrc', jtr  , LINHED)
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout )

c compute start and end samples for application

      if ( tend .eq. 0.) tend = float( (nsamp -1) * nsi )
      istart = 1 + int( 0.5 + (tbegin / float( nsi ) ) )
      iend =   1 + int( 0.5 + (tend / float( nsi ) ) )
      if ( istart .lt. 1) istart = 1
      if ( iend .gt. nsamp) iend = nsamp

	itime_begin = istart

      if ( istart .ge. iend ) then
         write(lerr,*) 'Fatal Error -- Abort'
         write(lerr,*) 'Start time must be greater than end time'
         stop
      endif

c      if ( dbegin .ge. dend ) then
c made this .gt. so that users could work on a given offset without
c getting a fatal error
c
c Garossino

      if ( dbegin .gt. dend ) then
         write(lerr,*) 'Fatal Error -- Abort'
         write(lerr,*)
     1        'Start distance must be greater than end distance'
         stop
      endif
	

	
c output of all pertinent information before processing begins

      call verbal(nsamp, nsi, ntrc, nrec, iform,
     1     ntap,otap,amax,amin,ikill,
     2     tbegin, tend, dbegin, dend,
     3     vel, alldead)

c figure out design window times

      dt = float(nsi)/1000.

      if ( amin .ne. -1.e-30 ) minSearch = .true.

c process records

      do 1000 jj = 1, nrec

c process traces

         do 1001 kk = 1, ntrc

            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif
            call vmov (itr(ITHWP1), 1, tri, 1, nsamp)

            call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                  recnum , TRACEHEADER)
            call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                  trcnum , TRACEHEADER)
            call saver2(itr,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                  ili    , TRACEHEADER)
            call saver2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                  idi    , TRACEHEADER)
            call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                  idist  , TRACEHEADER)
            dist = idist
            call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                  istatic, TRACEHEADER)

        
            IF ( istatic .ne. 30000 ) THEN

               IF ( (dist .gt. dbegin) .and. (dist .le. dend) ) THEN

                  if ( minSearch ) then
                     if ( abs ( tri(1) ) .le. abs(amin) ) tri(1) = 0.
                  else
                     if ( abs ( tri(1) ) .ge. abs(amax) ) tri(1) = 0.
                  endif

                  igsamp = istart
                  igflag = 1
                  ncnt = 0   

                  ihsamp = istart
                  ihflag = 1

c loop over samples
c set the consecutive bad sample variables

c change the start time if vel not equal 999999

	if (vel .ne. 999999.) then
	istart = itime_begin + (((abs(dist)/int(vel))*1000)/nsi)
	endif
               
                  Adjacent = 0
                  Lastil = istart + 1

                  do 150 il = istart + 1, iend

                     IF (notrp) THEN

                        if ( abs( tri(il) ) .ge. abs( amax ) ) then
                             tri(il) = 0.
                             ncnt = ncnt + 1
                        endif
                        if ( minSearch ) then
                           if ( abs(tri(il) ) .le. abs(amin) ) then
                                tri(il) = 0.
                           endif
                        endif

                     ELSEIF (alldead) THEN


                        if ( abs( tri(il) ) .ge. abs( amax ) ) then
                             call vclr (tri, 1, nsamp)
                             call savew2(itr,ifmt_StaCor,l_StaCor,
     1                                   ln_StaCor, 30000, TRACEHEADER)
                             go to 602
                        endif
                        if ( minSearch ) then
                           if ( abs(tri(il) ) .le. abs(amin) ) then
                             call vclr (tri, 1, nsamp)
                             call savew2(itr,ifmt_StaCor,l_StaCor,
     1                                   ln_StaCor, 30000, TRACEHEADER)
                             go to 602
                           endif
                        endif

                     ELSE

                     if ( abs( tri(il) ) .ge. abs( amax ) ) then 
                        ncnt = ncnt + 1
                        igflag = 0
                     else
                        if (igflag .eq. 0) then
                           sl=(tri(il)-tri(igsamp))/(float(il-igsamp))
                           do 250 jl = igsamp, il
                              tri(jl) = sl * (jl - igsamp) + tri(igsamp)
 250                       continue
                           igsamp = il
                           igflag = 1
                        else
                           igsamp = il
                        endif
                     endif
c
c added logic to interpolate sample values 
c

                     if ( minSearch ) then
                        if ( abs(tri(il) ) .le. abs(amin) ) then
                           if ( ( il - Lastil ) .eq. 1 ) then 
                              Adjacent = Adjacent + 1
                              if ( Adjacent .ge. ikill ) goto 400
                              Lastil = il
                           else
                              Lastil = il
                              Adjacent = 0
                           endif
                          ihflag = 0
                        else
                        if (ihflag .eq. 0) then
                           sl=(tri(il)-tri(ihsamp))/(float(il-ihsamp))
                           do 300 jl = ihsamp, il
                              tri(jl) = sl * (jl - ihsamp) + tri(ihsamp)
 300                       continue
                           ihsamp = il
                           ihflag = 1
                        else
                           ihsamp = il
                        endif

                        endif

                     endif

                     ENDIF

 150              continue

c interpolate last sample if necessary

                  IF (notrp) GO TO 501

                  if ( igflag .eq. 0) then
                     sl = ( 0. - tri(igsamp) )/(float(iend-igsamp))
                     do 350 jl = igsamp, iend
                        tri(jl) = sl * (jl - igsamp) + tri(igsamp)
 350                 continue
                  endif

                  if ( ihflag .eq. 0) then
                     sl = ( 0. - tri(ihsamp) )/(float(iend-ihsamp))
                     do 425 jl = ihsamp, iend
                        tri(jl) = sl * (jl - ihsamp) + tri(ihsamp)
 425                 continue
                  endif

 400              if( (verbos) .and. (ncnt .ne. 0 .or. 
     :                 Adjacent .ge. ikill ) ) then
                     write(LERR,*)'ri/li ',recnum,ili,
     :                    '     trace/di ',trcnum,idi,
     :                    ' # Bad -amp samples ',ncnt,
     :                    ' # Bad -min samples', Adjacent
                  endif

c kill trace if number of bad samples eceeds ikill

501         CONTINUE
            if (ikill .eq. 0) go to 502

                  if (ncnt .ge. ikill .or. Adjacent .ge.
     : ikill ) then
	
c fixed by jmg 12 Feb 1996 it was doing the comments below
c now it actually writes the value in
c
                     call savew2(itr,ifmt_StaCor,l_StaCor,
     :		 ln_StaCor,
     1           30000  , TRACEHEADER)
c
c                     call saver2(itr,ifmt_StaCor,l_StaCor,
c     :		 ln_StaCor,
c     1           30000  , TRACEHEADER)
                     do 450 il = 1,nsamp
                        tri(il) = 0.
 450                 continue
                     if (verbos .and. (ncnt .ne. 0 ) ) then
           write(LERR,*) recnum,trcnum,'   Rec/Trace is now deceased'
                     endif
                  endif

               ENDIF
            ENDIF

502         CONTINUE

602         CONTINUE
            if (verbos .AND. alldead .AND. (Adjacent .eq. 0) ) then
                write(LERR,*) recnum,trcnum,'   Rec/Trc is now deceased'
            endif

            call vmov (tri, 1, itr(ITHWP1), 1, nsamp)
            call wrtape( luout, itr, nbytes)

 1001    continue
 
 1000 continue

c-----
c     close data files
c-----

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )

      write(LERR,*)'end of prgm, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
      WRITE(LER,*)
     :'***************************************************************'
      WRITE(LER,*)
     :'PROGRAM MODULE SKILL  --  AMPLITUDE EDITTING'
      WRITE(LER,*)
      WRITE(LER,*)
     :'Program SKILL removes high amplitude values from seismic data.'
      WRITE(LER,*)
     :'Absolute value amplitudes, exceeding  a user input threshold'
      WRITE(LER,*)
     :'within a time and offset designated application window'
      WRITE(LER,*)
     :'are replaced with with a new amplitude, linearly interpoloated'
      WRITE(LER,*)
     :'from the nearest acceptable sample amplitudes. Additionally,'
      WRITE(LER,*)
     :'if the number of unacceptable samples is greater than a user'
      WRITE(LER,*)
     :'input tolerance, the trace is flagged dead (halfword 125 =30000)'
      WRITE(LER,*)
     :'and all sample values are set to zero.'
      WRITE(LER,*)
      WRITE(LER,*)
     :'Execute SKILL  by typing "skill" followed by program parameters.'
      WRITE(LER,*)
     :'Note that each parameter is proceeded by -A where "A" is '
      WRITE(LER,*)
     :'a character(s) corresponding to some parameter.'	
      WRITE(LER,*)
     :'..............................................................'
      WRITE(LER,*)
      WRITE(LER,*)
     :'INPUT PARAMETERS and (DEFAULT VALUES)'
      WRITE(LER,*)
      WRITE(LER,*)
     :' -N [ntap]      (no default) : input data file name'
        WRITE(LER,*)
     :' -O [otap]      (no default) : output data file name'
        WRITE(LER,*) 
     :' -amp [amax]    (0)          : max. amplitude threshhold'
        WRITE(LER,*) 
     :' -min [amax]    (0)          : min amplitude threshhold'
      WRITE(LER,*)
     :' -kill [srcsft] (0)          : max. number of bad samples'
      WRITE(LER,*)
     :'                               per trace. '
        WRITE(LER,*) 
     :' -ts [tbegin]   (0)          : application start time'
        WRITE(LER,*) 
     :' -te [tend]     (last samp)  : application end time'
        WRITE(LER,*) 
     :' -v0 [vel]      (999999.)    : start velocity '
        WRITE(LER,*) 
     :' -ds [dstart]   (min dist    : minimum distance for application'
        WRITE(LER,*) 
     :' -de [dstart]   (max dist)   : maximum distance for application'
      WRITE(LER,*)
     :' -Z [verbos]    ( no )       : if present leave bad samples zeroe
     :d out (no interpolation)'
      WRITE(LER,*)
     :' -A             ( no )       : kill entire trace if single occurr
     :ence'
      WRITE(LER,*)
     :' -V [verbos]    ( no )       : print additional info'
      WRITE(LER,*)
      WRITE(LER,*)
     :' EXAMPLE'
      WRITE(LER,*)
     :' skill -N/home/data/ntap -O/home/data/otap -amp198734. -kill95'
      WRITE(LER,*)
      WRITE(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,lus,ns,ne,irs,ire,
     1                  amax,amin,ikill,verbos,
     2                  tbegin, tend, dbegin, dend, notrp,
     3			vel, alldead)
c-----
c     get command arguments
c
c     ntap  - c*100     input file name
c     otap  - c*100     output file name
c     vel   - r*4  design velocity
c     ns    - i*4 starting trace index
c     ne    - i*4 ending trace index
c     irs   - i*4 starting record index
c     ire   - i*4 ending record index
c     verbos      - l   verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      integer     ns, ne, irs, ire
      real        amax, amin, vel
      logical     verbos, notrp, alldead
      integer     argis
 
            call argr4( '-amp', amax, 1.e30, 1.e30 )
            call argr4( '-de', dend, 1000000., 1000000. )
            call argr4( '-ds', dbegin, -1000000., -1000000. )
            call argr4 ( '-kill', akill ,  0  , 0    )
            call argr4( '-min', amin, -1.e-30, -1.e-30 )
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argr4( '-te', tend, 0., 0. )
            call argr4( '-ts', tbegin, 0., 0. )
            call argr4( '-v0', vel, 999999., 999999. )
            alldead = (argis('-A') .gt. 0)
            verbos = (argis('-V') .gt. 0)
            notrp  = (argis('-Z') .gt. 0)
            ikill = int( akill )
            if (alldead) notrp = .false.
c
      lus=LUN
      return
      end
c
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  ntap,otap,amax,amin,ikill,
     2                  tbegin, tend, dbegin, dend,
     3                  vel, alldead)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     vel   - r*4  design velocity
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ntap  - C*120     input file name
c     otap  - C*120     output file name
c-----
#include <f77/iounit.h>
      integer   nsamp, nsi, ntrc, nrec
      character ntap*(*), otap*(*)
      logical   alldead
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace    =  ', nsamp
            write(LERR,*) ' sample interval       =  ', nsi
            write(LERR,*) ' traces per record     =  ', ntrc
            write(LERR,*) ' records per line      =  ', nrec
            write(LERR,*) ' format of data        =  ', iform
            write(LERR,*) 
            write(LERR,*) ' input data set name   =  ', ntap
            write(LERR,*) ' output data set name  =  ', otap
  
            write(LERR,*)' program control parameters '
            write(LERR,*) ' Min. Application Time =  ', tbegin
            write(LERR,*) ' Max. Application Time =  ', tend
            write(LERR,*) ' Min. Appl. Distance   =  ', dbegin
            write(LERR,*) ' Max. Appl. Distance   =  ', dend
            write(LERR,*) ' Max. Amp. Threshold   =  ', amax
            write(LERR,*) ' Min. Amp. Threshold   =  ', amin
            write(LERR,*) ' Velocity              =  ', vel
            write(LERR,*) ' Sample count Threshold  =  ', ikill
            if (alldead)
     1      write(LERR,*) ' Kill any trace with single ampl violation'
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
