C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine decon(x,ns,iws,iwe,lopp,pred,pw,y,ierr)
*     real x(*),y(*),decop(1501),peo(3001),twork(8194)
      real x(*),y(*),decop(1501),peo(3001)
      real acorr(6000),right(1501),work(8194),fwork(8194)
      real xavg, xknt,pw,offset,xmul
      integer pred,ipass,lop,lopp,lwind,iwe,iws,lacorr
      integer lclr,j,i,lwork,lxform,ns,ierr
      integer ioff,nzro,iflg,ltot,lt,lt1,nf
      data ipass/0/
      ipass=ipass+1
C +-------------------------------------------------------+
C |                                                       |
C | PARAMETERS ARE:                                       |
C |    x   - Data to be processed                         |
C |   NS   - NUMBER SAMPLES TO READ                       |
C |   IWS  - WINDOW START FOR DECON DESIGN (SAMPLES)      |
C |   IWE  - WINDOW END FOR DECON DESIGN   (SAMPLES)      |
C |   LOP  - OPERATOR LENGTH (SAMPLES)                    |
C |   PRED - PREDICTION LENGTH (SAMPLES OR ZERO CROSSINGS |
C |   PW  -  PREWHITENING                                 |
C |                                                       |
C +-------------------------------------------------------+
      LOP=LOPP
      LWIND=IWE-IWS+1
      LACORR=LOP*2+50
C     LACORR=MAX0(LWIND,LACORR)
      LCLR=NS+LOP
      IF(LACORR.GT.LWIND)LACORR=LWIND
C +----------------------------------------------------+
C | COMPUTE AND REMOVE THE AVERAGE                     |
C +----------------------------------------------------+
      xavg=0.
      j=iws
      do i=1,lwind
        if(x(j).ne.0.0)then
         xavg = xavg+x(j)
         xknt = xknt+1.
        endif
        j=j+1
      end do
      if(xknt.ne.0.0)then
         xavg = xavg/xknt
      else
         xavg = 0.
      end if
      do i=lwind,4096
        work(i)=0.
      end do
      is = iws-1
      do i=1,lwind
        work(i)=x(is+i)-xavg
      end do
C +----------------------------------------------------+
C | DO THE AUTOCORRELATION IN THE TIME DOMAIN          |
C +----------------------------------------------------+
C10/20/88
      LWORK=2*LWIND
      LXFORM=64
 1010 CONTINUE
      LXFORM=LXFORM+LXFORM
      IF(LXFORM.LT.LWORK)GO TO 1010
      CALL VCLR(ACORR,1,3000)
      CALL VCLR(WORK(LWIND+1),1,LXFORM-LWIND)
      CALL ACORF(WORK,ACORR,LACORR,LXFORM)
      ACORR(1)=ACORR(1)*(1.+PW)
C +----------------------------------------------------+
C | BUILD THE DECON OPERATOR                           |
C +----------------------------------------------------+
      IF(PRED.GE.0)THEN
         IF(PRED.LT.1)PRED=1
         IOFF=PRED
      ELSE
         NZRO=IABS(PRED)
         IF(NZRO.GE.10)NZRO=1
C +------------------------------------------------------------+
C | NZCROS LOOKS FOR NZRO-TH CROSSING, RETURNING IN IOFF THE   |
C | INDEX COUNT OF THE LAST SAMPLE BEFORE THE NZRO-TH          |
C | CROSSING.  NF IS THE NUMBER OF ZERO CROSSING FOUND         |
C | UP TO AND INCLUDING THE NZRO-TH CROSSING.                  |
C +------------------------------------------------------------+
         CALL NZCROS(ACORR,1,NZRO,IOFF,NF,LACORR)
         IF(NF.LT.NZRO)THEN
            IERR=200
            CALL VMOV(X,1,Y,1,NS)
            RETURN
         ENDIF
         IF(PRED.LE.-10)THEN
          XMUL=PRED
          XMUL=ABS(XMUL)/10.
          OFFSET=IOFF
          IOFF=OFFSET*XMUL
         ENDIF
      ENDIF
        CALL VCLR(RIGHT,1,LOP)
      IF(IOFF.LE.1)THEN
        RIGHT(1)=1.
      ELSE
        CALL VMOV(ACORR(IOFF+1),1,RIGHT,1,LOP)
      ENDIF
      IF(PRED.EQ.1)THEN
         IFLG=0
         CALL WIENER(LOP,ACORR,RIGHT,DECOP,PEO,IFLG,IERR)
         if(IERR.ne.0)return
         CALL VMOV(PEO(1),1,DECOP,1,LOP)
         IOFF=0
      ELSE
         IFLG=1
         CALL WIENER(LOP,ACORR,RIGHT,DECOP,PEO,IFLG,IERR)
         if(IERR.ne.0)return
      ENDIF
      IF(IERR.NE.0)RETURN
C +----------------------------------------------------+
C | CREATE PROPER PEO FOR GIVEN PREDICTION DISTANCE    |
C +----------------------------------------------------+
      CALL VCLR(WORK,1,3000)
      CALL VMOV(DECOP(1),1,WORK(IOFF+1),1,LOP)
      LOP=LOP+IOFF
      IF(PRED.NE.1)CALL VMUL(WORK(1),1,-1.0,0,WORK(1),1,LOP)
      WORK(1)=1.
      CALL VMOV(WORK,1,PEO,1,3000)
C +----------------------------------------------------+
C | CONVOLVE THE FILTER WITH DATA                      |
C +----------------------------------------------------+
         LTOT=LOP+NS
         LT=256
 3950    LT=LT+LT
         IF(LT.LT.LTOT)GO TO 3950
         LT1=LT/2+1
         CALL VCLR(WORK,1,8194)
         CALL VCLR(FWORK,1,8194)
*        CALL VMOV(X,1,WORK(lop-1),1,NS)
*        CALL VMOV(PEO(lop),-1,FWORK,1,LOP)
*        CALL RFFTF(WORK,TWORK,LT)
*        CALL VMOV(TWORK,1,WORK,1,LT)
*        CALL RFFTF(FWORK,TWORK,LT)
*        CALL VMOV(TWORK,1,FWORK,1,LT)
*        CALL RFFTSC(WORK,LT,3,0)
*        CALL RFFTSC(FWORK,LT,3,-1)
*        CALL CVMUL(WORK,2,FWORK,2,WORK,2,LT1,1)
*        CALL RFFTSC(WORK,LT,-3,0)
*        CALL RFFTI(WORK,TWORK,LT)
*        CALL VMOV(TWORK,1,Y,1,NS)
         call vmov(x,1,work(lop),1,ns)
         call conv(work,1,peo(lop),-1,y,1,ns,lop,1)
      CONTINUE
      RETURN
      END
