C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine hilbertx(x,lx,y,ierr)
#include <localsys.h>
      real x(*), y(*), work(1)
      POINTER (pw, work)
      integer lx

      n2 = 32
      lx2=lx+lx
      do while(n2.lt.lx2)
       n2=n2+n2
      end do
      n3 = n2/2+1
      n4=n3+n3
#ifndef CRAYSYSTEM
      iget = n4*4
#else
      iget = n4*8
#endif
      ierr = 0
      iabort = 0
      call galloc(pw,iget,ierr,iabort)
      if(ierr.ne.0)return
      do i=lx,n4
       work(i)=0.
      end do
      do i=1,lx
       work(i)=x(i)
      end do
      call rfft(work,n2,1)
      call rfftsc(work,n2,0,1)
      j=1
      do i=2,n3-1
        j=j+2
        h1 = work(j)
        h2 = work(j+1)
        work(j)=-h2
        work(j+1)=h1
      end do
      work(1)=0.
      work(2)=0.
      call rfft(work,n2,-1)
      do i=1,lx
       y(i)=work(i)
      end do
      call gfree(pw)
      return
      end
