C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine taupf(x,lx,nx,tp,np,temp,live,xoff,sr,y,arho,decon)
      real x(*),tp(*),temp(*),live(*),xoff(*),y(*)
      real shft,sr
      integer np,jp,kdx,i,j,lx,nx,ld,ierr
      logical arho,decon
      do jp = 1,np
        kdx=(jp-1)*lx
        do i=1,lx
         y(kdx+i)=0.
         live(i)=0.
        end do
C +==================================+
* |  Compute and apply current shift |
C +==================================+
        do j = 1,nx
         do i=1,lx
          temp(i)=0.
         end do
         ld=(j-1)*lx
         shft = abs(xoff(j))*tp(jp)
C +--------------------------------------------+
C |   For each trace compute the shift and sum |
C |   the shifted trace into the sum buffer.   |
C +--------------------------------------------+
         if(abs(shft).le.lx-2)then
          if(shft.eq.0.0)then
            do i=1,lx
              temp(i)=x(ld+i)
            end do
          else
            call statapp(x(ld+1),lx,temp,shft)
          endif
         endif
         do i=1,lx
           y(kdx+i)=y(kdx+i)+temp(i)
           live(i)=live(i)+1.
         end do
        end do
        do i=1,lx
          y(kdx+i)=y(kdx+i)/live(i)
        end do
        if(arho.and..not.decon)then
         call rho(y(kdx+1),lx,temp,sr,ierr)
         call vmov(temp,1,y(kdx+1),1,lx)
        endif
      end do
      return
      end
      subroutine taupr(x,lx,nx,tp,np,temp,live,xoff,sr,y,arho,decon)
      real x(*),tp(*),temp(*),y(*),live(*),xoff(*),sr
      real shft
      integer lx,nx,i,j,jp,ld,kdx,np
      logical arho,decon
      do  j = 1,nx
        kdx=(j-1)*lx
        do i=1,lx
         y(kdx+i)=0.
         live(i)=0.
        end do
C +==============================================+
C |   For each input trace compute the shift and |
C |   sum the shifted trace into the sum buffer  |
C +==============================================+
        do jp = 1,np
         do i=1,lx
          temp(i)=0.
         end do
         ld  = (jp-1)*lx
         shft = tp(jp)*abs(xoff(j))
         shft = -shft
         if(abs(shft).le.lx-2)then
          if(shft.eq.0)then
           do i=1,lx
            temp(i)=x(ld+i)
           end do
          else
           call statapp(x(ld+1),lx,temp,shft)
          endif
         endif
         do i=1,lx
          y(kdx+i)=y(kdx+i)+temp(i)
          live(i)=live(i)+1.
         end do
        end do
C   +===============================+
C   | Normalize the stack for the   |
C   | number of live samples summed |
C   +===============================+
        do i=1,lx
         y(kdx+i)=y(kdx+i)/live(i)
        end do
        if(arho.and.decon)then
         call rho(y(kdx+1),lx,temp,sr,ierr)
         call vmov(temp,1,y(kdx+1),1,lx)
        endif
      end do
      return
      end
