C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ExtractFcn ( xaxis, tri, nsamp, X, Y, N )
      
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      integer nsamp, N

      real tri(*), X(*), Y(*)

      real yp1, ypn, y2(2*SZLNHD)

c local variables

      integer islpsw, ierr

      real sigma, temp(2*SZLNHD), curv2

      external function curv2

c initialize data

      yp1 = 1.e+31
      ypn = 1.e+31

c set spline routine to calculate end slopes internally
      islpsw = 3
c set spline routine to use cubic spline
      sigma = 0.0

      call vclr(y2,1,2*SZLNHD)

c set up cubic spline 2nd derivatives

c      call spline ( xaxis, tri, nsamp, yp1, ypn, y2)
      call curv1 (nsamp, xaxis, tri, yp1, ypn, islpsw, y2, temp, 
     :     sigma, ierr)

c extract smoothed function at original x locations

      do i = 1, N

c         call splint ( xaxis, tri, y2, nsamp, X(i), Y(i) )
         Y(i) = curv2( X(i), nsamp, xaxis, tri, y2, sigma )

      enddo

      return
      end
         
