C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine UniformFcn ( X, Y, N, nsi, xaxis, tri, nsamp )

c converts a non-uniform sampling to uniform using cubic spline
c interpolation

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      integer nsi, nsamp, N

      real tri(*), X(*), Y(*)
      real Xmin, Xmax, yp1, ypn, y2(2*SZLNHD), xaxis(*)

c local variables

      integer islpsw, ierr

      real sigma, temp(2*SZLNHD)

c if N < 5 then bail as not enough points to fit spline

      if ( N .lt. 5 ) then
         write(LERR,*)' SMOOTH: not enough points to fit spline'
         write(LERR,*)' FATAL'
         stop
      endif


c check for duplicate X values and get rid of them

      ic = 1
      y2 (1) = X (1)
      do ii = 2, N
         if (X(ii) .ne. X(ii-1)) then
             ic = ic + 1
             y2 (ic) = X (ii)
             tri (ic) = Y (ii)
         endif
      enddo
      N = ic
      call vmov (y2, 1, X, 1, N)
      call vmov (tri, 1, Y, 1, N)

c initialize data

      Xmin = 1.e30
      Xmax = 1.e-30
      yp1 = 1.e+31
      ypn = 1.e+31
      islpsw = 3
      sigma = 0.0
      call vclr(y2,1,2*SZLNHD)

c determine nsamp

      do i = 1, N
         if ( X(i) .lt. Xmin ) Xmin = X(i)
         if ( X(i) .gt. Xmax ) Xmax = X(i)
      enddo

      nsamp = nint( ( Xmax - Xmin ) / float(nsi) )

c      set up cubic spline 2nd derivatives
 
c      call spline ( X, Y, N, yp1, ypn, y2)
      call curv1 (nsamp, X, Y, yp1, ypn, islpsw, y2, temp, 
     :     sigma, ierr)

c build cubic spline interpolated output series from Xmin to Xmax in
c steps of nsi for nsamp samples

      do i = 1, nsamp
 
         ThisSample = Xmin + float(nsi * (i-1))
c         call splint ( X, Y, y2, N, ThisSample, ThisValue )
         ThisValue = curv2( ThisSample, N, X, Y, y2, sigma )

         xaxis(i) = ThisSample
         tri(i) = ThisValue
 
      enddo

      return
      end
         
         

      
