C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( nsamp, nsi, ntrc, nrec, iform, ntap, otap, 
     :     flatfile, TwoFlag, SmoothOrder, xgraph, ReadOrder  )

c
c     verbose output of processing parameters
c

#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec, SmoothOrder
      integer     lentap, leotap

      character   ntap*(*), otap*(*), ReadOrder*2 

      logical flatfile, TwoFlag, xgraph
 
      IF ( .not. flatfile .and. .not. TwoFlag ) then 
      write(LERR,*)' '
      write(LERR,*)' line header values after default check '
      write(LERR,*) ' # of samples/trace   =  ', nsamp
      write(LERR,*) ' sample interval      =  ', nsi
      write(LERR,*) ' traces per record    =  ', ntrc
      write(LERR,*) ' records per line     =  ', nrec
      write(LERR,*) ' format of data       =  ', iform
      ELSEIF(flatfile)then
      write(LERR,*) 'Using velin Flat File Input' 
      write(LERR,*) ' sample interval      =  ', nsi
      ELSEIF(TwoFlag)then
      write(LERR,*) 'Using x,y Flat File Input' 
      write(LERR,*) ' sample interval      =  ', nsi
      ELSEIF(xgraph)then
      write(LERR,*) 'Using xgraph File Input' 
      write(LERR,*) ' sample interval      =  ', nsi
      ENDIF

      if ( ReadOrder .eq. 'yx' ) then
         write(LERR,*)' read order is [y,x]'
      else
         write(LERR,*)' read order is [x,y]'
      endif

      lentap = lenth(ntap)
      if (lentap .gt. 0) then
        write(LERR,*) ' input data set name  =  ', ntap(1:lentap)
      else
        write(LERR,*) ' input data set       =  stdin'
      endif
      leotap = lenth(otap)
      if (lentap .gt. 0) then
        write(LERR,*) ' output data set name =  ', otap(1:leotap)
      else
        write(LERR,*) ' output data set      =  stdout'
      endif
      write(LERR,*) ' smoothing factor     =  ', SmoothOrder
      write(LERR,*)' '
 
      return
      end
