C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln(ntap,otap,ns,ne,irs,ire,tm,vm,iwin,mindis,
     1     maxdis, ist, iend, verbos,tmul,dmul,exponent,hyp,pcent,
     :     signed )

      implicit none

#include <f77/iounit.h>

      integer    argis, ns,ne,irs,ire,iwin,mindis, maxdis
      integer    ist, iend

      real       tm,vm,tmul,dmul,exponent,pcent

      character  ntap*(*), otap*(*)

      logical    verbos, hyp, signed

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c      ns   - I      start trace
c      ne   - I      stop end trace
c     irs   - I      start record
c     ire   - I      stop end record
c   mindis  - I      minimum distance to mute
c     tm    - R      mute start time
c     vm    - R      mute velocity
c    restore- L      restore previous mute/bdmute
c    verbos - L      verbose output or not
c-----

      call argr4('-dmul',dmul,1.0,1.0)

      call argr4('-exp',exponent,2.0,2.0)

      hyp     = (argis('-H') .gt. 0)

      call argi4  ('-xmin',mindis,0,0)
      call argi4  ('-xmax',maxdis,100000,100000)

      call argi4  ('-ns',ns,0,0)
      call argi4  ('-ne',ne,0,0)
      call argstr ('-N', ntap, ' ', ' ' )

      call argstr ('-O', otap, ' ', ' ' )

 
      call argi4  ('-re',ire,0,0)
      call argi4  ('-rs',irs,0,0)

      signed  = (argis('-signed') .gt. 0)

      call argr4  ( '-taper', pcent, 25.0, 25.0 )
      call argi4  ( '-tmax', iend, 0, 0 )
      call argi4  ( '-tmin', ist, 0, 0 )

      call argr4('-tmul',tmul,1.0,1.0)
      call argr4 ('-t0', tm,0.0,0.0)

      call argr4 ('-v',vm,100000.0,100000.0)

      call argi4 ('-win',iwin,48,48)

      verbos  = (argis('-V') .gt. 0)

      return
      end
