C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  --------------------------------- smute ----------------------------
C
C smute reads seismic trace data from an input file,
C applies a user-specified mute window
C writes the results to an output file

c get system dependant variable definitions

      implicit none

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare standard usp variables

      integer     itr ( SZLNHD )
      integer     luin, nbytes, lbytes, lbyout, luout
      integer     nsamp, nsi, ntrc, nrec, iform, ist, iend
      integer     argis, jerr
      integer     irs, ire, ns, ne

      real        tri ( SZLNHD )

      character   name*5, ntap*255, otap*255

      logical     verbos

c declare program specific variables

      integer dstsgn, istatic
      integer itime, iwin, mindis, maxdis, time_units
      integer ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer ifmt_RecNum, l_RecNum, ln_RecNum
      integer ifmt_SrcLoc, l_SrcLoc, ln_SrcLoc
      integer ifmt_RecInd, l_RecInd, ln_RecInd
      integer ifmt_DphInd, l_DphInd, ln_DphInd
      integer ifmt_DstSgn, l_DstSgn, ln_DstSgn
      integer ifmt_DstUsg, l_DstUsg, ln_DstUsg
      integer ifmt_StaCor, l_StaCor, ln_StaCor
      integer minsamp, maxsamp, iwin2, iwin21, itaper, i
      integer j, k, irec


      real  wts ( SZLNHD )
      real  samp, dist, dists, tm, vm, tmul, dmul, exponent
      real  pcent, distmin, distmax, si, pi, arg, tf

      character freq_flag*2

      logical hyp, signed

c initialize variables

      data name/'SMUTE'/
      data  nbytes/0/
      data  lbytes/0/

c---------------------------------
c  get online help if necessary
c---------------------------------

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 ) then
          call help ()
          stop
      endif

c---------------------------------
c  open printout file
c---------------------------------
#include <f77/open.h>

C**********************************************************************C
C     read in command line parameters
C**********************************************************************C

      call cmdln( ntap, otap, ns, ne, irs, ire, tm, vm, iwin, mindis, 
     :     maxdis, ist, iend, verbos, tmul, dmul, exponent, hyp, pcent,
     :     signed )

c open input and output datasets

      call getln ( luin, ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )

c read input line header

      lbytes = 0
      call rtape (luin, itr, lbytes )
      if(lbytes .eq. 0) then
         write(LERR,*)'SMUTE: no header read on ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         write(LER,*)'SMUTE: no header read on ',ntap
         write(LER,*)'       Check existence of file & rerun'
         write(LER,*)'FATAL'
         stop
      endif

      call hlhprt( itr , lbytes, name, 5, LERR)

c read global line header parameters

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

      call saver ( itr, 'DgTrkS' , freq_flag, LINHED )
      call saver ( itr, 'T_Unit', time_units, LINHED ) 

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      if ( signed ) then
         distmin = dmul * float(mindis)
         distmax = dmul * float(maxdis)
      else
         distmin =  dmul * float(iabs (mindis) )
         distmax =  dmul * float(iabs (maxdis) )
      endif

      SI    =  tmul * float ( NSI )
      tm    =  tmul * tm
      minsamp = ist / nsi
      maxsamp = iend / nsi

      if ( minsamp .le. 0 ) minsamp = 1
      if ( maxsamp .ge. nsamp .or. maxsamp .le. 0 ) maxsamp = nsamp

c handle microseconds

      if ( time_units .eq. 0 ) then
         samp = real (nsi) /1000.
         tm   = 0.001 * tm
         tf   = 0.001
      elseif ( time_units .eq. 1 ) then
         samp = real (nsi) /1000000.
         tm   = 0.000001 * tm
         tf   = 0.000001
      else
         write(LERR,*)' a time units flag of ', time_units
         write(LERR,*)' is not handled by this routine'
         write(LERR,*)' FATAL'
         stop
      endif

c----
c   generate window cosine taper
c----

      samp  = tmul * samp
      iwin  = ( iwin / NSI ) + 1

c make sure length of window is odd

      if (mod(iwin,2) .eq. 0) iwin = iwin + 1

      if (iwin .lt. 5) then
         write(LERR,*)'FATAL ERROR in smute:'
         write(LERR,*)'Window too short; must be at least ',nsi*5
         write(LERR,*)'ms long'
         write(LER,*)'SMUTE: Window too short; must be at least ',nsi*5
         write(LER,*)'       ms long'
         write(LER,*)'FATAL'
         goto 999
      endif

      iwin2 = iwin / 2
      iwin21 = iwin2 + 1
      itaper = nint ( .01 * pcent * float(iwin) )
      itime  = iwin - itaper

      pi = 4. * atan(1.0)
      call vclr (wts, 1, iwin)
      do  i = 1, itaper
          arg = float(i) * pi / float(itaper)
          wts (itime + i) = 1. - 0.5 * (1. + cos(arg) )
          wts (itaper - i + 1) = 1. - 0.5 * (1. + cos(arg) )
      enddo

      if (verbos) write(LERR,*)' '
      if (verbos)       write(LERR,*)'Weights:'
      do i = 1, iwin
         wts (i) = wts (i) ** exponent
         if (verbos) write(LERR,*)i,'  ',wts(i)
      enddo
      if (verbos) write(LERR,*)' '
 
c verify command line entries with dataset boundaries
         
      call cmdchk ( ns,ne,irs,ire,ntrc,nrec )

c verbos printout

      call verbal( ntap, nsamp, nsi, ntrc, nrec, iform, otap, irs, ire,
     :      ns, ne, tmul, dmul, tm, vm, mindis, iwin, exponent, hyp, 
     :      pcent, maxdis, ist, iend, signed )

c modify header as needed

         call savhlh ( itr, lbytes, lbyout )
         call wrtape(luout, itr, lbyout)

c MAIN PROCESSING LOOP:  read trace, do mute, write trace

      DO j = 1, nrec

         DO k = 1, ntrc

            nbytes = 0
            call rtape(luin,itr,nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature End of file on input:'
               write(LERR,*)'  rec= ',j,'  trace= ',k
               go to 999
            endif
            call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
            
            call saver2(itr,ifmt_RecNum,l_RecNum,ln_RecNum,irec,
     :           TRACEHEADER)
            call saver2(itr,ifmt_DstSgn,l_DstSgn,ln_DstSgn,dstsgn, 
     :           TRACEHEADER)
            call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,istatic,
     :           TRACEHEADER)
            
c     mute only selected trcs & recs

            IF (J .ge. IRS .AND. J .le. IRE) THEN
               
               IF (K .ge. NS .AND. K .le. NE) THEN

                  dists = dmul * float( dstsgn )
                  
                  dist  = abs ( dists )
                  
c do mute from scratch

                  if ( signed ) then

                     if (istatic .ne. 30000 .AND. 
     :                    dists .ge. distmin .AND. 
     :                    dists .le. distmax ) then
                     
                        if ( freq_flag .eq. 'fk' ) then
                              
c when muting time-frequency data don't touch the phase

                           call muteaa ( nsamp/2, tm, vm, dist, SAMP,
     :                          hyp, tri, iwin, minsamp, maxsamp, wts)
                        
                        else
                        
                           call muteaa ( nsamp, tm, vm, dist, SAMP,
     :                          hyp, tri, iwin, minsamp, maxsamp, wts)
                        
                        endif
                     endif

                  else
                     
                     if (istatic .ne. 30000 .AND. 
     :                    dist .ge. distmin .AND. 
     :                    dist .le. distmax ) then
                     
                        if ( freq_flag .eq. 'fk' ) then
                              
c when muting time-frequency data don't touch the phase

                           call muteaa ( nsamp/2, tm, vm, dist, SAMP,
     :                          hyp, tri, iwin, minsamp, maxsamp, wts)
                        
                        else
                        
                           call muteaa ( nsamp, tm, vm, dist, SAMP,
     :                          hyp, tri, iwin, minsamp, maxsamp, wts)
                        
                        endif
                     endif
                  endif
                  
               ENDIF
               
            ENDIF
            
            call vmov   (tri, 1, itr(ITHWP1), 1, nsamp)
            CALL WRTAPE ( LUOUT, ITR, NBYTES )
            
         ENDDO
      ENDDO
      
      call lbclos(luin)
      call lbclos(luout)
      write(LERR,*)' Normal Termination'
      write(LER,*)' smute: Normal Termination'
      stop

 999  continue

      call lbclos(luin)
      call lbclos(luout)
      write(LERR,*)' Abnormal Termination'
      write(LER,*)' smute: Abnormal Termination'
      stop
      end
