C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal (ntap, nsamp, nsi, ntrc, nrec, iform, otap, irs,
     :       ire, ns, ne, tmul, dmul, tm, vm, mindis, iwin, p, hyp,
     :       pcent, maxdis, ist, iend, signed )

      implicit none

#include <f77/iounit.h>

c declare variables passed from calling routine      

      integer   nsamp, nsi, ntrc, nrec, irs, ire, ns, ne, iform
      integer   mindis, maxdis, iwin, ist, iend

      real      tm, vm, p, pcent, tmul, dmul

      character ntap*(*), otap*(*)

      logical   hyp, signed

      write(LERR,*)' '
      write(LERR,*)'    Input Data Parameters '
      write(LERR,*)' '
      write(LERR,*)' Input Data Set Name:  ',ntap
      write(LERR,*)' Samples / Trace    =  ',nsamp
      write(LERR,*)' Sample Interval    =  ',nsi
      write(LERR,*)' Traces / Record    =  ',ntrc
      write(LERR,*)' Records / Line     =  ',nrec
      write(LERR,*)' Format of Data     =  ',iform

      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters'
      write(LERR,*)' '
      write(LERR,*)' Output Data Set Name:               ',otap
      write(LERR,*)' First record to process             =  ',irs
      write(LERR,*)' Last record to process              =  ',ire
      write(LERR,*)' Starting trace number               =  ',ns
      write(LERR,*)' Ending   trace number               =  ',ne
      write(LERR,*)' Minimum time to mute                =  ',ist
      write(LERR,*)' Maximum time to mute                =  ',iend
      write(LERR,*)' Mute time in sec at zero offset     =  ',tm
      write(LERR,*)' Mute velocity                       =  ',vm
      write(LERR,*)' nramp (samples)                     = ',iwin
      if ( signed ) then
         write(LERR,*)' Using signed trace distance '
      else
         write(LERR,*)' Using absolute value of signed trace distance '
      endif
      write(LERR,*)' minimum distance to mute (ft/m)     = ',mindis
      write(LERR,*)' maximum distance to mute (ft/m)     = ',maxdis
      write(LERR,*)' distance multiplier                 = ', dmul
      write(LERR,*)' time multiplier                     = ', tmul
      write(LERR,*)' % window to cosine taper            = ', pcent
      write(LERR,*)' window exponent                     = ', p
      if (hyp) then
      write(LERR,*)' mute line follows hyperbola'
      else
      write(LERR,*)' mute line follows line'
      endif

      return
      end

