      SUBROUTINE DOIT1(NS,TA,N2,SUM,IOPT,WORK1,WORK2,WORK3)
C ******************************************************************** C
C *                                                                  * C
C *   PROGRAM  - DOIT1                                               * C
C *   LANGUAGE - FORTRAN IV                                          * C
C *   AUTHOR   - RICHARD CRIDER                                      * C
C *   DATE WRITTEN - AUGUST,1982                                     * C
C *                                                                  * C
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C *                                                                  * C
C *   ABSTRACT -                                                     * C
C *      THIS ROUTINE BUILDS AP CHAINS FOR FORWARD AND INVERSE       * C
C *      FOURIER TRANSFORM.                                          * C
C *                                                                  * C
C *   USAGE -                                                        * C
C *   CALL DOIT1(NS,TA,N2,SUM,IOPT,work arrays)                      * C
C *                                                                  * C
C *      NS - NUMBER OF POINTS TO BE TRANSFORMED.                    * C
C *      TA - DATA TO BE TRANSFORMED.                                * C
C *      N2 - LENGTH OF THE TRANSFORM.                               * C
C *     SUM - SUMMING ARRAY.                                         * C
C *     IPR - LOGICAL UNIT FOR PRINTER.                              * C
C *    IOPT - AVERAGING FLAG:                                        * C
C *           0 = GEOMETRIC  1 = ARITHMETIC                          * C
C *    work arrays = work1,work2,work3                               * C
C *                                                                  * C
C ******************************************************************** C
      DIMENSION TA(1),SUM(1)
      REAL WORK1(8204), WORK2(8204), WORK3(8204)
C
      LERR = 37
      N3=N2/2+1
      N4=N2+2
      SMULT=.5
C ******************************************************************** C
C *                                                                  * C
C *   DO FORWARD TRANSFORM AND SUMMING ON TA DATA                    * C
C *                                                                  * C
C -------------------------------------------------------------------* C
C
C -------------------------------------------------------------------* C
C *   DO THE TRANSFORM AND SCALE BY 1/2N.                            * C
C -------------------------------------------------------------------* C
      CALL VCLR(WORK2,1,N4)
      CALL VMOV(TA,1,WORK2,1,NS)
      CALL RFFTF(WORK2,WORK1,N2)
      IFLG = 3
      ISCL = 1
      CALL RFFTSC(WORK1,N2,IFLG,ISCL)
C -------------------------------------------------------------------* C
C *   COMPUTE AND SUM THE SPECTRUM.                                  * C
C *   SQUARE THE REAL AND IMAGINARY TERMS OF THE TRANSFORM.          * C
C *   GET THE SUM OF THE SQUARES OF THE REAL AND IMAGINARY TERMS.    * C
C -------------------------------------------------------------------* C
      CALL CVABS(WORK1,2,WORK2,1,N3)
	  if(iopt.ne.1)then
		call vlogz(work2,1,0.0,work1,1,n3)
		call vadd(work1,1,sum,1,sum,1,n3)
	  else
        CALL VADD(WORK2,1,SUM,1,SUM,1,N3)
	  endif
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       DOIT2                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  Compute the operator from the averaged sprectrum          *
C  ENTRY POINTS:                                                       *
C      DOIT2  (N2,SUM,IOPT,XN,OPRATR,WORK1,WORK2,WORK3)                *
C  ARGUMENTS:                                                          *
C      N2      INTEGER  INPUT          - transform length              *
C      SUM     REAL     INPUT   (1)    - summing buffer                *
C      IOPT    INTEGER  INPUT          - geometric or arithmetic       *
C                                        mean option (0 or 1)          *
C      XN      REAL     INPUT*         - scaler for sum = 1/ntraces.   *
C      OPRATR  REAL     OUTPUT  (8204) - computed balancing operator   *
C      WORK1   REAL             (8204) - work buffer                   *
C      WORK2   REAL             (8204) - work buffer                   *
C      WORK3   REAL             (8204) - work buffer                   *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 90/08/06  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/08/31  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VCLR   -                                                        *
C      VSMUL  -                                                        *
C      VEXP   -                                                        *
C      RFFTSC -                                                        *
C      RFFTI  -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE DOIT2(N2,SUM,IOPT,XN,OPRATR,WORK1,WORK2,WORK3)
#include <f77/iounit.h>
      REAL SUM(1),OPRATR(8204)
      REAL WORK1(8204), WORK2(8204), WORK3(8204)
C
      N3=N2/2+1
      N4=N2+2
C -------------------------------------------------------------------* C
C *   CLEAR THE SPACE TO BE USED FOR DATA STORAGE AND TRANSFORM,     * C
C *   PACK THE DATA, AND DO INVERSE TRANSFORM WITH NO SCALING.       * C
C -------------------------------------------------------------------* C
      CALL VCLR(WORK1,1,N4)
      CALL VSMUL(SUM,1,XN,WORK1,2,N3)
      IF(IOPT.NE.1)CALL VEXP(WORK1,2,WORK1,2,N3)
      IFLG = -3
      ISCL = 0
C * Pack the data for inverse transform
      CALL RFFTSC(WORK1,N2,IFLG,ISCL)
C * Inverse transform into opratr.
      call vclr(opratr,1,n2)
      CALL RFFTI(WORK1,OPRATR,N2)
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       DOIT3                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  Perform the balancing operation.                          *
C  ENTRY POINTS:                                                       *
C      DOIT3  (NS,TA,N2,OPRATR,WORK1,WORK2,WORK3)                      *
C  ARGUMENTS:                                                          *
C      NS      INTEGER  input          - Trace length (samples)        *
C      TA      REAL     input   (1)    - Input data (windowed)         *
C                       output           Balanced data                 *
C      N2      INTEGER  input          - Transform length              *
C      OPRATR  REAL     input   (1)    - Balancing operator.           *
C      WORK1   REAL             (8204) - Work buffer                   *
C      WORK2   REAL             (8204) - Work buffer                   *
C      WORK3   REAL             (8204) - Work buffer                   *
C      IDECON  INTEGER  input          - Deconvolution option          *
C                                        0 = NO  1 = YES               *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 90/08/06  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/08/31  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VCLR   -                                                        *
C      VMOV   -                                                        *
C      RFFTF  -                                                        *
C      RFFTSC -                                                        *
C      CVABS  -                                                        *
C      VDIVZ  -                                                        *
C      CVMUL  -                                                        *
C      RFFTI  -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE DOIT3(NS,TA,N2,OPRATR,WORK1,WORK2,WORK3, idecon)
      DIMENSION TA(1),OPRATR(1)
      REAL WORK1(8204), WORK2(8204), WORK3(8204),work4(8204)
C
      N3=N2/2+1
      N4=N2+2
      N2D = N2 * 2
      N3D = N2D/2+1
      N4D = N2D + 2
      N2H = N2 / 2
      scalr = 1./(float(N2D))
C  Clear area to transform the operator.
      CALL VCLR(WORK1,1,N2D)
C
C             SEPERATE THE OPERATOR IN THE 2X TRANSFORM AREA
C
      CALL VMOV(OPRATR,1,WORK1,1,N3)
      CALL VMOV(OPRATR(N2),-1,WORK1(N2D),-1,N2H)
C
C             TRANSFORM THE OPERATOR and scale by 1/4N
C
      CALL RFFTF(WORK1,WORK2,N2D)
      IFLG = 3
*     ISCL = -1
      ISCL = 0
      CALL RFFTSC(WORK2,N2D,IFLG,ISCL)
	  call cvabs(work2,2,work4,1,n3d)
C
C              TRANSFORM THE TRACE
C
	  call vclr(work1,1,n2d)
	  call vmov(ta,1,work1,1,ns)
      CALL RFFTF(WORK1,work3,N2D)
      IFLG = 3
*     ISCL = 0
      ISCL = -1
      CALL RFFTSC(WORK3,N2D,IFLG,ISCL)
      CALL CVABS(WORK3,2,WORK1,1,N3D)
C
C      WORK2 now contains the transform of the operator
C      WORK4 now contains the amp spectrum of the operator
C      WORK3 contains the transform of the data
C      WORK1 contains the amplitude spectrum of the data
C
C           DIVIDE THE TRACE AMPLITUDE INTO THE TRACE TRANSFORM
C           if not doing decon.
C          MULTIPLY THE OPERATOR AND THE TRACE TRANSFORM
C          if not doing decon. Otherwise, divide trace  
C          by the operator.
C
	  if(idecon.ne.1)then
         CALL VDIVZ(WORK3(1),2,WORK1,1,0.0,WORK3(1),2,N3D)
         CALL VDIVZ(WORK3(2),2,WORK1,1,0.0,WORK3(2),2,N3D)
        call cvmul(work3,2,work2,2,work3,2,n3d,1)
      else
        call vdivz(work3(1),2,work4,1,0.0,work3(1),2,n3d)
        call vdivz(work3(2),2,work4,1,0.0,work3(2),2,n3d)
      endif
C
      call vmul(work3,1,scalr,0,work3,1,N4D)
      IFLG = -3
      ISCL = 0
      CALL RFFTSC(WORK3,N2D,IFLG,ISCL)
      call rffti(work3,work1,n2D)
      call vmov(work1,1,ta,1,ns)
      RETURN
      END
