/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
static char *help_text[] = {
"                   Color Editor For On-Screen Display\n",
"\nAbstract\n",
"The color editor for on-screen display is a user friendly tool for modifying the color palette used to associate colors with amplitudes. Facility is provided for gray scale as well as color scale design, with simple \"slider bar\" customizing of scales.  Facility is also provided for saving/loading of color palettes and conversion of color palettes to 2COLR cards for use in program PLTR.\n",
"\nInput and Output\n",
"\nInput\n",
"\nThe input to the color editor is any previously saved color scale.  The previously used (and saved) scale is loaded automatically when the scale has been saved as a color palette. When no palette has been previously saved, the tool provides a default scale which can be easily customized.  The color scale input may be either a color palette or 2COLR cards from a PLTR card file.\n",
"\nOutput:\n",
"\nThe output from the color editor is the customized color scale. The color palette may be saved as either a color palette or as 2COLR cards for a PLTR card file.\n",
"\nPROGRAM EXPLANATION:\n",
"\nParameter Description\n",
"\nParameter entry for the color editor is performed through a mixture of button selections, slider bar, and text entry. A complete description of the parameters is included in the Operations section below.\n",
"\nOperations\n",
"\nThe color editor is a user-friendly interface for the association of colors with amplitudes for on-screen display.  The color editor provides for:\n",
"\n (1). Simplified customizing of color or gray scales,\n",
"\n (2). Conversion of RGB (screen) color codes to YMC (hardcopy device) color codes, with creation of 2COLR cards for PLTR application.\n",
"\n (3). Conversion of YMC (hardcopy device) color codes from 2COLR cards to RGB color codes for on-screen display.\n",
"\n (4). Saving and loading of color palettes (RGB scales), with their associated amplitudes and contrast/brightness settings.\n",
"\nThe various buttons and sliders are described in the Color Editor Panel discussion below.\n",
"\nColor Editor Panel\n",
"\nThe Color Editor panel appears when the option to change color scale is invoked in the display program. The panel consists of:\n",
"\n 1. The color scale, with its associated amplitudes, on the extreme lefthand side.\n",
"\n 2. Buttons for the selection of file options (load/save PLTR cards, load/save/delete color palettes) in the upper left portion of the panel.\n",
"\n 3. Buttons for the selection of file options (load/save/delete color palettes) in the upper left portion of the panel.\n",
"\n 4. Buttons for color operations (reseting sliders, selecting a gray scale, interpolating colors, and changing minimum/maximum amplitude limits) in the upper central portion of the panel.\n",
"\n 5. Contrast and brightness slider controls in the upper right portion of the panel.\n",
"\n 6. Control toggle buttons (toggles)for color cell manipulation in the central portion of the panel.\n",
"\n 7. RGB (red, green, blue) and brightness/darkness slider controls for varying the \"working color\", in the lower portion of the panel.\n",
"\n 8. Editting termination buttons at the extreme lower portion of the panel.\n",
"\nDescription of each of these items may be found in the topics discussed below.  The color scale, file option buttons and the color operations buttons are described.\n",
"\nColor Scale\n",
"\n The color scale associating colors and amplitudes is found on the extreme left side of the color editor panel.  This scale can contain up to 40 color buttons (cells), with amplitudes associated with each color in either a linear or logarithmic (dB) manner relative to the user-defined minimum/maximum amplitude.  When the color editor is invoked initially, a default color scale with 28 cells is created.  This default scale can easily be customized for the current application.\n",
"\nAdding cells\n",
"\nCells can be added at any point by selecting the \"Insert Working Color above\" toggle and selecting the cell in the scale above  which additional cells are to be added.  Associated amplitudes are automatically adjusted to account for the added cells, and the new cells are assigned a white color.\n",
"\nDeleting cells\n",
"\nCells may be deleted from the scale by selecting the \"Delete\" toggle and selecting the cells to be deleted. The associated amplitudes are automatically adjusted to account for the deleted cells. Colors are not changed for remaining cells.\n",
"\nReplacing/Initiating colors\n",
"\nColors may be placed in a cell to initiate a new cell or to replace the color in an existing cell by using the mouse cursor to move the red, green, and/or blue sliders until the desired color appears in the \"working color\" bar near the bottom of the panel, selecting the \"Replace with Working Color\" toggle, and selecting the cell in which the color is to be placed.\n",
"\nModifying / Interpolating colors\n",
"\nExisting colors in single cells may also be modified by selecting the \"Copy to Working Color\" toggle, selecting the cell containing the color to be modified (the \"working color\" bar changes to the selected color), and following the procedure for replacing color cells given above.  The color in a series of cells may be modified at once by interpolating between two or more existing colors.  To accomplish this,\n",
"\n  - select the \"Set Interpolation Breakpoints\" toggle,\n",
"\n  - select two or more cells to interpolate between (an \"*\" will appear in the selected cells), and\n",
"\n  - select the \"Interpolate Colors\" button near the top of the panel.\n",
"\nThe color in all cells between the selected cells will be adjusted for linear interpolation between the selected colors.  CAUTION: Only the selected cells are used in the  interpolation and the color for cells between selected cells are ignored.\n",
"\nModifying amplitudes\n",
"\nAmplitudes associated with the colors in the scale may be modified by selecting the \"Change Limits\" button near the top of the panel and selecting the appropriate options from the panel which is displayed.  See Changing Limits below for full description.\n",
"\nContrast/Brightness adjustment\n",
"\nContrast between and the brightness of the colors in the color scale may be varied by using the mouse cursor to move the contrast or brightness sliders until the desired contrast/brightness is obtained.\n",
"\nPLTR Cards\n",
"\nThe color editor will load/save 2COLR cards from/for PLTR application.  This is accomplished by converting the YMC color codes on the 2COLR cards to/from RGB color codes.  If 2COLR cards are loaded, the color scale is changed to reflect this input scale.  NOTE:  The conversion from RGB to YMC color codes assumes that your hardcopy device has the proper inks (Yellow, Magenta, and Cyan) and makes no attempt to compensate for improper inks.\n",
"If your hardcopy device has Yellow, Red(in place of Magenta), and Blue(in place of Cyan) ink installed, your hardcopy and screen colors WILL NOT MATCH (for example, your output will be considerably darker than what you see on the screen).  Contact your local systems personnel if you have problems.\n",
"\nLoad PLTR Cards\n",
"\nTo load PLTR cards, ensure that you have a file containing ONLY 2COLR cards.  Select the \"Load\" button beneath the PLTR label to cause a file selection box to appear. Find the desired file in the list of files appearing and activate the \"OK\" button at the bottom of the selection box.\n",
"\nSave PLTR Cards\n",
"\nTo save PLTR cards, select the \"Save\" button beneath the PLTR label, select or enter the appropriate file name in the list of files appearing the the file selection box, and activate the \"OK\" button at the bottom of the file selection box.\n",
"\nPalettes\n",
"\nOnce a color scale has been established, it can be saved and later loaded for on-screen application.  When one or more color palettes have been saved, the color editor \"remembers\" which one you used last (and for which program you used it) and loads it as the default the next time the color editor is used.  This is accomplished by saving two (reasonably small) files in your home directory.  The two files are .colorpalette and.colorpalette_defs.\n",
"The palettes contain color, amplitude, and brightness/contrast information for a color scale.\n",
"\nLoad Palette\n",
"\nTo load an existing palette to replace the current one, select the \"Load\" button beneath the \"Palettes\" label and select the appropriate palette name from the list of palettes appearing.  The selected palette is loaded and replaces the current color scale when the \"OK\" button at the bottom of the selection panel is activated.\n",
"\nSave Palette\n",
"\nTo save a palette into the palette file, select the \"Save\" button beneath the \"Palettes\" label, enter the requested description (palette name), and activate  the \"OK\" button at the bottom of the description box.  You may have more than one palette with the same description, so if you enter a name matching a previously exisiting name, the existing palette is NOT overwritten.  To eliminate a previously existing palette, use the Delete option described below.\n",
"\nDelete Palette\n",
"\nAlthough color palettes are not very large, disk space is typically quite limited, so you'll want to \"clean up\" your palettes.  To do this, select the \"Delete\" button beneath the \"Palettes\" label.  A file selection box containing the names(descriptions) of existing palettes will appear.  Select the palette to be deleted and activate the \"OK\" button at the bottom of the file selection box.\n",
"\nReset slider\n",
"\nThe contrast and brightness sliders in the upper right portion of the panel can be used to adjust the colors in a color scale.  However, the color interpolation procedure does not recognize these settings. Use the \"Reset Slider\" button to reset the contrast/brightness sliders to 0 before interpolation or after adjustment.\n",
"\nGray Scale\n",
"\nA gray scale may be used for display in the place of a color scale.  A gray scale could be created by placing the white color in the top cell, black in the bottom, and interpolating between.  A default gray scale may be loaded by selecting the \"Gray Scale\" button.\n",
"\nInterpolate Colors\n",
"\nLinear interpolation may be used to modify the colors in a series of color scale cells.  To use this option, select the \"Set Interpolation Breakpoints\" toggle in the middle of the panel, select the cells at the end oif the range to be interpolated.  Then select the \"Interpolate Colors\" button near the top of the panel.\n",
"\nChange Limits\n",
"\nThe amplitudes associated with the colors in a color scale and the increment between are are determined by the minimum/maximum amplitude and interpolation limits you supply.  To modify these values, select the \"Change Limits\" button and enter/select the appropriate options in the Color Contour Options panel which appears.  From this panel, you may select linear or logarithmic (dB) variation in amplitudes and supply the minimum and maximum amplitudes to be associated with a color scale.\n"};
