C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln ( ntap, dX, dY, dT, Xmax, Xmin, Ymax, Ymin, Tmax,   
     :     X0, Y0, T0, Azimuth, Dip, MaxModelRadius, otap, Velocity, 
     :     Amplitude, Plane, Cone, Hyperboloid, verbos )

#include <f77/iounit.h>

      integer argis, dT, Tmax

      real    dX, dY, Xmax, Xmin, Ymax, Ymin, X0, Y0
      real    Azimuth, Dip, MaxModelRadius, Velocity, Amplitude

      character otap*(*), ntap*(*)
      
      logical   verbos, Plane, Cone, Hyperboloid
      
      call argr4 ( '-amp', Amplitude, 1.0, 1.0 )
      call argr4 ( '-azim', Azimuth, 0.0, 0.0 )

      Cone = (argis('-C') .gt. 0)

      call argr4 ( '-dip', Dip, 0.0, 0.0 )
      call argi4 ( '-dt', dT, 2, 2 )
      call argr4 ( '-dx', dX, 25.0, 25.0 )
      call argr4 ( '-dy', dy, 25.0, 25.0 )

      Hyperboloid = (argis('-H') .gt. 0)

      call argstr( '-N', ntap, ' ', ' ' )
      call argstr( '-O', otap, ' ', ' ' )

      Plane = (argis('-P') .gt. 0)

      call argr4 ( '-rmax', MaxModelRadius, 1000.0, 1000.0 )

      call argi4 ( '-tmax', Tmax, 2000, 2000 )
      call argr4 ( '-t0', T0, 0.0, 0.0 )

      verbos =   (argis('-V') .gt. 0)
      call argr4 ( '-v', Velocity, 10000.0, 10000.0 )

      call argr4 ( '-xmax', Xmax, 1250.0, 1250.0 )
      call argr4 ( '-xmin', Xmin, -1250.0, -1250.0 )
      call argr4 ( '-x0', X0, 0.0, 0.0 )

      call argr4 ( '-ymax', Ymax, 1250.0, 1250.0 )
      call argr4 ( '-ymin', Ymin, -1250.0, -1250.0 )
      call argr4 ( '-y0', Y0, 0.0, 0.0 )

      return
      end
