C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  UnMerge  n  Data Sets
C
C**********************************************************************C
C
C splits READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C and splits it into n output data sets depending on flags set in header
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, savhlh, saver, savew
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>

      INTEGER     ITR  ( SZLNHD )
      INTEGER     LHED ( SZLNHD ),luout(1000)
      integer     lhed0( SZLNHD )
      REAL        HEAD ( SZLNHD ), TRI ( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN, LBYTES, NBYTES,obytes, nreco(1000)
      INTEGER     ntrco(1000), nsampt(1000), obytet(1000)
      INTEGER     ntrcdo(1000)
      integer     argis, pipes(1000), npipes, pipcnt, pmax
      integer	  liveknt,holdtrc
      CHARACTER   NAME * 5, ntap * 256, ftap * 256
#include <f77/pid.h>

      integer     hold
      pointer     (wkhold, hold(1))

      character   otap(1000) * 256
      character   prgm * 3
      logical     verbos,mpx,query,nblk,oneblk,split,wye,rotary
      logical     partition,heap,roll,rottrc,cycle,IKP,troll
      logical     trace,no_orig
C
      EQUIVALENCE ( ITR(  1), LHED(1), HEAD(1) )
      DATA NAME     /'SPLITR'/
      DATA  LBYTES / 0 /, NBYTES / 0 /
      DATA  obytes / 0 /
      data verbos/.false./,nblk/.false./,oneblk/.false./,mpx/.false./
      data split/.false./,rotary/.false./
      data npipes / 0 /
      data ntrco/1000*0/, nreco/1000*0/,ntrcdo/1000*0/
      data lhed0/SZLNHD*0/
      data prgm/'SPT'/

C**********************************************************************C
C     get help if necessary
C**********************************************************************C
      query = (argis('-?') .gt. 0)
      if(query) then
        call help()
        stop 0
      endif

      IKP = .false.
      if (in_ikp() .eq. 1) then
         IKP = .true.
      endif
C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>

C     get command line arguments
C**********************************************************************C
      call cmdln(ntap,otap,nu,ntr,nblk,oneblk,split,verbos,wye,
     1           rotary,mpx,pmax,partition,nroll,roll,
     2		       troll,mx,trace,ftap,no_orig)

C**********************************************************************C
      pipes(1) = 1
      luout(1) = 1
      do  i = 2, pmax
          pipes(i) = i + 1
      enddo

C**********************************************************************C
C     open i/o logical units
C**********************************************************************C
      call getln(luin,ntap,'r',0)
 
      IF (nu .ne. 0) THEN
         do 5 i=1,nu
            call getln(luout(i),otap(i),'w',pipes(i))

c           if(luout(i) .eq. 1) then
c              write(LERR,*)'Output data set ',otap(i),
c    1                       ' cannot be a pipe'
c              write(LERR,*)'check command line & rerun'
c              stop 100
c           endif
5        continue
      ELSE
         write(LERR,*)'splitr: pmax= ',pmax
         nu = pipcnt (pipes,pmax)
c
c - if pmax was unlimited, the printout file also got counted
c
	 if (pmax .eq. 1000) nu = nu - 1
         write(LERR,*)'Number of pipes found= ',nu
         write(LERR,*)'socket numbers:'
         write(LERR,*)(pipes(i),i=1,nu)
         if (nu .gt. 1000) then
           write(LERR,*)'Cannot have more then 1000 outputs'
           write(LERR,*)'You have  ',nu,'  outputs'
           stop 100
         endif

         do 2 i = 1, nu
	    if (pipes(i) .eq. 1) then
	      luout(i) = 1
	    else
              call sisfdfit (luout(i), pipes(i))
	    endif
2        continue
      ENDIF

      write(LERR,*)' '
      write(LERR,*)'Number output data set streams= ',nu
      do  3  i = 1, nu
            write(LERR,*)'luout',i,' =  ',luout(i),' pipe= ',pipes(i)
3     continue
 
C**********************************************************************C
C     read input header & save critical values
C**********************************************************************C
      lbytes=0
      CALL RTAPE  ( LUIN, ITR, LBYTES                  )
      if(lbytes .eq. 0) then
         write(LERR,*)'SPLITR: no header read on unit ',luin
         write(LERR,*)'FATAL'
         stop 100
      endif

c----
c     save certain parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header

#include <f77/saveh.h>

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      call savelu('SGRNum',ifmt_SGRNum,l_SGRNum,ln_SGRNum,TRACEHEADER)


      if (.not. no_orig) then
         call savew( itr, 'OrNREC', nrec  , LINHED)
         call savew( itr, 'OrNTRC', ntrc  , LINHED)
         write(LERR,*)'Saving OrNREC =  ',nrec
         write(LERR,*)'Saving OrNTRC =  ',ntrc
      endif

      CALL HLHprt ( ITR , LBYTES, NAME, 5, LERR        )

c---------------------------------------------------------------------
c    IF split not true
c---------------------------------------------------------------------
      write(LERR,*)' '
      write(LERR,*)'rotary,rottrc,mpx,trace,wye,split,partition,roll= ',
     1              rotary,rottrc,mpx,trace,wye,split,partition,roll
      write(LERR,*)' '
      IF (.not.split .AND. .not.roll .AND. .not. troll) THEN

c+++++++++++++
c do simple
c wye:
c      input data set will be duped into given output streams
c      each stream will have same # recs as input; each rec
c      will have same # trcs/rec

       if (wye) then

          ntrcc = ntrc
          nrr   = nrec
          do  91  i = 1, nu
              nreco(i) = nrec
              ntrco(i) = ntrc
91        continue

          write(LERR,*)'SPLITS:  simple wye function - '
          write(LERR,*)'input will be duplicated in each output'
          write(LERR,*)'number output records in each stream:'
          write(LERR,*)(nreco(i),i=1,nu)
          write(LERR,*)'number output traces in each stream:'
          write(LERR,*)(ntrco(i),i=1,nu)


c+++++++++++++
c do rotary record option:
c      input recs will be sent in turn to next output unit
c      sequentially like a distributor cap.  each output
c      stream will have approx nrec/nu records each of ntrc
c      traces

       elseif (rotary .and. .not. mpx) then

          nrr   = nrec / nu
          ntrcc = ntrc
          iu = 1
          nrect = 0
          cycle = .false.
          do  31  i = 1, nrec
              nreco(iu) = nreco(iu) + nroll
              nrect     = nrect + nroll
              if (nrect .gt. nrec) then
                  if (.not.cycle .AND. iu .lt. nu) then
c                     if (IKP) then
c                        write(LERR,*)'# recs/block is too large.'
c                        write(LERR,*)'# recs/block is too large.'
                      do  iiu = iu+1, nu
                          call lbclos ( luout(iiu) )
                      enddo
                      nu = iu
                      left = nrect - nrec
                      nreco(iu) = nreco(iu) - left
                      go to 33
                  elseif (cycle) then
                      left = nrect - nrec
                      nreco(iu) = nreco(iu) - left
                      go to 33
                  endif
              endif
              iu = iu + 1
              if (iu .gt. nu) then
                  iu = 1
                  cycle = .true.
              endif
31        continue

33        continue

          do  32  i = 1, nu
              ntrco(i) = ntrc
32        continue

          call savew( itr, 'ReSpFm', nroll  , LINHED)

          write(LERR,*)'SPLITS:  rotary function - '
          write(LERR,*)'each input record will be sent to an output'
          write(LERR,*)'file in succession.'
          write(LERR,*)'number output records in each stream:'
          write(LERR,*)(nreco(i),i=1,nu)
          write(LERR,*)'number output traces in each stream:'
          write(LERR,*)(ntrco(i),i=1,nu)


c+++++++++++++
c do rotary trace option:
c      input trcs will be sent in turn to next output unit
c      sequentially like a distributor cap.  each output
c      stream will have approx nint(ntrc*nrec/nu) records each of nu
c      traces

       elseif (rotary .and. mpx) then

          if (trace) then

             do  i = 1, nu
                 ntrco (i) = ntrc
             enddo
             do  i = 1, nu
                 nreco (i) = nrec
             enddo

             iu = 1
             do  i = 1, nu
                 nsampt (i) = 0
             enddo
             do  i = 1, nsamp
                 nsampt (iu) = nsampt (iu) + 1
                 iu = iu + 1
                 if (iu .gt. nu) iu = 1
             enddo
             do  i = 1, nu
                 obytet (i) = SZTRHD + nsampt (i) * SZSMPD
             enddo
        
             write(LERR,*)'SPLITS:  rotary function - '
             write(LERR,*)'each input trace will be sent to an output'
             write(LERR,*)'will be split into ',nu,' segments.'
             write(LERR,*)'number of samples in each stream:'
             write(LERR,*)(nsampt(i),i=1,nu)
             write(LERR,*)'number of bytes/trc in each stream:'
             write(LERR,*)(obytet(i),i=1,nu)
             write(LERR,*)'number output records in each stream:'
             write(LERR,*)(nreco(i),i=1,nu)
             write(LERR,*)'number output traces in each stream:'
             write(LERR,*)(ntrco(i),i=1,nu)

          else

             xrr   = float(nrec * ntrc) / float(nu)
             nro   = nint (xrr)
             write(LERR,*)nrec,ntrc,xrr,nro
             do  35  i = 1, nu
                 ntrco(i) = 1
35           continue
             iu = 1
             do  36  i = 1, nrec*ntrc
                 nreco(iu) = nreco(iu) + 1
                 iu = iu + 1
                 if (iu .gt. nu) iu = 1
36           continue
             nrr   = nrec

             write(LERR,*)'SPLITS:  rotary function - '
             write(LERR,*)'each input trace will be sent to an output'
             write(LERR,*)'file in succession.'
             write(LERR,*)'number output records in each stream:'
             write(LERR,*)(nreco(i),i=1,nu)
             write(LERR,*)'number output traces in each stream:'
             write(LERR,*)(ntrco(i),i=1,nu)

          endif


      elseif (partition) then

          write(LERR,*)'SPLITR: partition data set'
          nrecu = nrec / nu
          left  = nrec - nu * nrecu
          do  i = 1, nu
              nreco (i) = nrecu
          enddo
          if (left .ne. 0) then
             icnt = 0
             do  i = 1, nu
                 icnt = icnt + 1
                 if (icnt .le. left) then
                     nreco(i) = nreco(i) + 1
                 endif
             enddo
          endif
          write(LERR,*)'computed partitions are:'
          do  i = 1, nu
              ntrco(i) = ntrc
              write(LERR,*)'Output data set ',i,' has ',nreco(i),
     1                     ' records'
          enddo
          write(LERR,*)'computed partitions are:'

      elseif (.not. rotary .AND. .not. mpx) then

c++++++++++++
c undo a prior
c mergn:
c       this requires that certain line hdr words
c       from a previous mergn be present & correct

c*check in with headers & do unmerg based on info that merg put there**********
        call saver( itr, 'RATFld',  iflag  , LINHED)
        call saver( itr, 'RATTrc',  nuu    , LINHED)
        if (nuu .eq. 0) then
           write(LERR,*)' '
           write(LERR,*)'WARNING:'
           write(LERR,*)'Could not find velid ntuple entry in RATTrc'
           write(LERR,*)'mnemonic of line header. # output units set'
           write(LERR,*)'to number defined by user =  ',nu
           nuu = nu
           write(LERR,*)' '
        endif

        if(iabs(iflag) .gt. 2 .or. iabs(nuu) .gt. 10) then
           write(LERR,*)'Header info wrong for output of MERGN -- FATAL'
           stop 100
        endif

        if(nuu .gt. nu) then
           write(LERR,*)'Not enough output data sets named: input header 
     &  says ',           nuu
           stop 100
        endif

        if(nuu .lt. nu) then
           write(LERR,*)'Too many output data sets named: input header s
     &ays  ',              nuu
           stop 100
        endif

c    multiplex option: put ntuple # in 1/2 wd 70 & flag in wd 69
        if(iflag .ne. 1 .and. iflag .ne. 2) then
           ntrcc = ntrc/nu
           nrr   = nrec
           mpx   = .true.
          do  42  i = 1, nu
              nreco(i) = nrr
42        continue
          iu = 1
          do  43  i = 1, ntrc
              ntrco(iu) = ntrco(iu) + 1
              iu = iu + 1
              if (iu .gt. nu) iu = 1
43        continue
           write(LERR,*)'SPLITS:  undoing a mergn multiplex data set'
           write(LERR,*)'number output records in each stream:'
           write(LERR,*)(nreco(i),i=1,nu)
           write(LERR,*)'number output traces in each stream:'
           write(LERR,*)(ntrco(i),i=1,nu)
        endif

c  separate blocks back-to-back
        if(iflag .eq. 1) then
          ntrcc = ntrc
c         nrr   = nrec/nu
          nblk  = .true.
          iu = 1
          do  46  i = 1, nrec
              nreco(iu) =  nreco(iu) + 1
              iu = iu + 1
              if (iu .gt. nu) iu = 1
46        continue
          do  47  i = 1, nu
              ntrco(i) = ntrc
47        continue
          nrr = nreco(1)
          write(LERR,*)'SPLITS:  undoing a mergn with recs back-to-back'
           write(LERR,*)'number output records in each stream:'
           write(LERR,*)(nreco(i),i=1,nu)
           write(LERR,*)'number output traces in each stream:'
           write(LERR,*)(ntrco(i),i=1,nu)
        endif

c  input blocks put into 1 super block
        if(iflag .eq. 2) then
          ntrcc  = ntrc/nu
          nrr    = nrec
          oneblk = .true.
          do  48  i = 1, nu
              nreco(i) = nrr
48        continue
          iu = 1
          do  49  i = 1, ntrc
              ntrco(iu) = ntrco(iu) + 1
              iu = iu + 1
              if (iu .gt. nu) iu = 1
49        continue
          write(LERR,*)'SPLITS:  undoing a mergn with recs packed into'
          write(LERR,*)'        super records'
           write(LERR,*)'number output records in each stream:'
           write(LERR,*)(nreco(i),i=1,nu)
           write(LERR,*)'number output traces in each stream:'
           write(LERR,*)(ntrco(i),i=1,nu)
        endif


       endif

      
c-------
             heap = .true.
             items = SZSMPD
             call galloc (wkhold, items,  errcdi, aborti)
             if (errcdi .ne. 0.) heap = .false.
             if (.not. heap) then
                write(LERR,*)' '
                write(LERR,*)'Unable to allocate workspace:'
                write(LERR,*) items,'  bytes'
                write(LER ,*)'Unable to allocate workspace:'
                write(LER ,*) items,'  bytes'
                write(LERR,*)' '
                go to 999
             else
                write(LERR,*)' '
                write(LERR,*)'Allocating workspace:'
                write(LERR,*) items,'  bytes'
                write(LERR,*)' '
             endif

c---------------------------------------------------------------------
c    ELSE if split true
c---------------------------------------------------------------------
      ELSEIF (split .AND. .not.roll) THEN

         if(mod(ntrc,ntr) .ne. 0) then
           write(LERR,*)'No. split traces/rec does not go into input tr/
     &rec evenly'
           stop 100
         endif
         nuu = ntrc/ntr
         if(nuu .ne. nu) then
           write(LERR,*)'No. output data sets not eq no. of splits of ',
     &                    ntr,' tr/rec'
           stop 100
         endif
         nrr   = nrec
         ntrcc = ntr
         write(LERR,*)'SPLITS:  doing a split of the input data into'
         write(LERR,*) nrr,' records and ', ntrc,'  traces/rec'

       do  51  i = 1, nu
           nreco(i) = nrr
           ntrco(i) = ntrcc
51     continue
           write(LERR,*)'number output records in each stream:'
           write(LERR,*)(nreco(i),i=1,nu)
           write(LERR,*)'number output traces in each stream:'
           write(LERR,*)(ntrco(i),i=1,nu)

             heap = .true.
             items = SZSMPD
             call galloc (wkhold, items,  errcdi, aborti)
             if (errcdi .ne. 0.) heap = .false.
             if (.not. heap) then
                write(LERR,*)' '
                write(LERR,*)'Unable to allocate workspace:'
                write(LERR,*) items,'  bytes'
                write(LER ,*)'Unable to allocate workspace:'
                write(LER ,*) items,'  bytes'
                write(LERR,*)' '
                go to 999
             else
                write(LERR,*)' '
                write(LERR,*)'Allocating workspace:'
                write(LERR,*) items,'  bytes'
                write(LERR,*)' '
             endif

      ELSEIF (.not.split .AND. roll) THEN

             heap = .true.
             items = (nroll * ntrc * (nsamp + ITRWRD)) * SZSMPD
             call galloc (wkhold, items,  errcdi, aborti)
             if (errcdi .ne. 0.) heap = .false.
             if (.not. heap) then
                write(LERR,*)' '
                write(LERR,*)'Unable to allocate workspace:'
                write(LERR,*) items,'  bytes'
                write(LER ,*)'Unable to allocate workspace:'
                write(LER ,*) items,'  bytes'
                write(LERR,*)' '
                go to 999
             else
                write(LERR,*)' '
                write(LERR,*)'Allocating workspace:'
                write(LERR,*) items,'  bytes'
                write(LERR,*)' '
             endif

             nrolls = nroll / 2
             if (mod(nroll,2) .ne. 0) then
                nrolle = nrolls
             else
                nrolle = nrolls - 1
             endif
             nrtot = nrec * nroll
             nrr   = nrtot / nu
             ntrcc = ntrc
             iu = 1
             do  i = 1, nrec
                 nreco(iu) = nreco(iu) + 1
                 iu = iu + 1
                 if (iu .gt. nu) iu = 1
             enddo
             do  i = 1, nu
                 nreco(i) = nroll * nreco(i)
             enddo
             do  i = 1, nu
               ntrco(i) = ntrc
             enddo
             write(LER ,*)' '
             write(LER ,*)'SPLITS: partition option'
             write(LER ,*)'Number recs in add-1-drop1 operation ',nroll
             write(LER ,*)'Number of recs/pipe= ',(nreco(ii),ii=1,nu)
             write(LER ,*)'Number of trcs/rec = ',(ntrco(ii),ii=1,nu)
             write(LER ,*)' '

             call savew( itr, 'ReSpFm', nroll  , LINHED)

c
c - padded set of traces partitioned among output datasets
c
      ELSE IF ((.not. split) .and. troll) then
c
c - at most, we need mx traces to hold, the extra 10 samples is safeguard
c
             heap = .true.
             items = (2 * mx * ((nsamp+10) + ITRWRD)) * SZSMPD
             call galloc (wkhold, items,  errcdi, aborti)
             if (errcdi .ne. 0.) heap = .false.
             if (.not. heap) then
                write(LERR,*)' '
                write(LERR,*)'Unable to allocate workspace:'
                write(LERR,*) items,'  bytes'
                write(LER ,*)'Unable to allocate workspace:'
                write(LER ,*) items,'  bytes'
                write(LERR,*)' '
                go to 999
             else
                write(LERR,*)' '
                write(LERR,*)'Allocating workspace:'
                write(LERR,*) items,'  bytes'
                write(LERR,*)' '
             endif

c - this is the max no. of non-overlapped traces per pipe
c
c	     liveknt = (ntrc - ((nu - 1) * mx) + (nu-1)) / nu
	     liveknt = (ntrc + nu - 1) / nu
c
c - iu represents live traces already spoken for
c
             do  i = 1, nu
		nreco(i) = nrec
                ntrco(i) = liveknt + 2 * mx
		if (i .eq. 1) then
             	   ntrcdo(i) = mx
                   iu = liveknt + mx
		else if (i .ne. nu) then
             	   ntrcdo(i) = 0
                   iu = iu + liveknt
		else 
c            	   ntrcdo(i) = mx + (liveknt - ntrc + iu)
           	   ntrcdo(i) = liveknt - (ntrc - iu)
		   if (ntrcdo(i) .gt. mx) then
		     ntrco(i) = ntrco(i) - ntrcdo(i) + mx
           	     ntrcdo(i) = mx
		   endif
		endif
             enddo

             write(LER ,*)' '
             write(LER ,*)'SPLITS: trace partition option'
             write(LER ,*)'Number of trcs/pipe= ',
     1			(ntrco(ii),ii=1,nu)
c    1			liveknt + 2 * mx
             write(LER ,*)'Number of live trcs/rec = ',
     1			(ntrco(ii)-ntrcdo(ii),ii=1,nu)
             write(LER ,*)'Number of padded dead trcs/rec = ',
     1			(ntrcdo(ii),ii=1,nu)
             write(LER ,*)' '
  	     call savew(itr,'Nx_Pad', mx, LINHED)

      ENDIF

      nwd = nsamp + ITRWRD
      write(LERR,*)' '
c---------------------------------------------------------------------
c    END of split/no split decision
c---------------------------------------------------------------------

c---------------------------------------------------------------------
c    alter line header
c---------------------------------------------------------------------
      if(nsamp .gt. SZLNHD) nsamp=SZLNHD
      nsampo = nsamp
      call savhlh(itr, lbytes, lbyout)
 
c---------------------------------------------------------------------
c    verbos out if desired
c---------------------------------------------------------------------
      write(LERR,*)' '
c     if( verbos ) then
         write(LERR,*)
         write(LERR,*)' Values read from input data set line header'
         write(LERR,*)
         write(LERR,*) ' # of Samples/Trace =  ', nsamp
         write(LERR,*) ' Sample Interval    =  ', nsi  
         do 9 i=1,nu
           write(LERR,*) ' Traces per Record  =  ', ntrco(i),' OTAP= ',
     1                   otap(i)
           write(LERR,*)'   Records= ',nreco(i)
    9    continue
        if(mpx) write(LERR,*)' Multiplex option: ntuples input found'
        if(nblk) write(LERR,*)' Input blocks were placed back-to-back'
        if(oneblk)write(LERR,*)' Input blocks were put in 1 super block'
        if(split)write(LERR,*)' Force split of input data set into equal 
     & chunks'
        if(wye)write(LERR,*)' Simple wye function: duplicate input data'
        if(rotary)write(LERR,*)' Rotary function: send successive input 
     1records to each output stream'
        write(LERR,*)' New samples/trace= ',nsampo
        write(LERR,*)' Records per Line   =  ', nrr 
        write(LERR,*)' Format of Data     =  ', iform
c     endif
      write(LERR,*)' '

c---------------------------------------------------------------------
c    write out headers for each output data set
c---------------------------------------------------------------------
      call savew ( itr, 'OACUsr', prgm, LINHED)

      do 11  i = 1, nu
         if (trace) 
     1   call savew( itr, 'NumSmp', nsampt(i) , LINHED)
         call savew( itr, 'NumTrc', ntrco(i)  , LINHED)
         call savew( itr, 'NumRec', nreco(i)  , LINHED)
         CALL WRTAPE ( LUOUT(i), ITR, LBYOUT                 )
   11 continue

C**********************************************************************C
C     READ TRACES,  WRITE TO OUTPUT FILE
C**********************************************************************C


c---------------------------------------------------------------------
c     IF mpx (multiplex) is true
c---------------------------------------------------------------------
      IF(mpx .and. .not. trace) then

      iu=0
      DO 100 JJ = 1, NRR
         DO 99 KK = 1, ntrc
           iu = iu + 1
           nbytes = 0
           CALL RTAPE  ( LUIN , ITR, NBYTES         )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif

           if(verbos) then
             call saver2(lhed, ifmt_RecNum,l_RecNum,ln_RecNum, irec,
     1                   TRACEHEADER)
             call saver2(lhed, ifmt_TrcNum,l_TrcNum,ln_TrcNum, itrc,
     1                   TRACEHEADER)
             write(LERR,*)'LUIN= ',luin,' Rec= ',irec,' Trace= ',
     &                   itrc
           endif
c---------------------------------------------------------------------
c  put ntuple # in header & write out data
c---------------------------------------------------------------------
c            call savew( itr, 'SGRNum',  1   , TRCHED)

             call wrtape(luout(iu),itr,nbytes)

           if(verbos) then
             call saver2(lhed, ifmt_RecNum,l_RecNum,ln_RecNum, irec,
     1                   TRACEHEADER)
             call saver2(lhed, ifmt_TrcNum,l_TrcNum,ln_TrcNum, itrc,
     1                   TRACEHEADER)
              write(LERR,*)'LUOUT= ',luout(iu),' Rec= ',irec,
     &                    ' Trace= ',itrc
           endif

           if(iu .eq. nu) iu=0
   99    continue
  100 continue

c---------------------------------------------------------------------
c     ELSE we output portions of the input trace to each successive
c          output
c---------------------------------------------------------------------
      ELSEIF (mpx .and. trace) THEN

      DO 700 JJ = 1, NREC
         DO 799 KK = 1, NTRC

           nbytes = 0
           CALL RTAPE  ( LUIN , ITR, NBYTES         )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif
               call vmov  (lhed(ITHWP1), 1, tri, 1, nsamp)
 
           if(verbos) then
             call saver2(lhed, ifmt_RecNum,l_RecNum,ln_RecNum, irec,
     1                   TRACEHEADER)
             call saver2(lhed, ifmt_TrcNum,l_TrcNum,ln_TrcNum, itrc,
     1                   TRACEHEADER)
             write(LERR,*)'LUIN= ',luin,' Rec= ',irec,' Trace= ',
     &                   itrc
           endif
c---------------------------------------------------------------------
c  put ntuple # in header & write out data
c---------------------------------------------------------------------
c            call savew( itr, 'SGRNum',  1   , TRCHED)

             is = 1
             do  iu = 1, nu
 
                 call vmov  (tri(is), 1, lhed(ITHWP1), 1, nsampt(iu))
                 
                 call wrtape(luout(iu),itr,obytet(iu))

                 is = is + nsampt (iu)
 
               if(verbos) then
                 call saver2(lhed, ifmt_RecNum,l_RecNum,ln_RecNum, irec,
     1                       TRACEHEADER)
                 call saver2(lhed, ifmt_TrcNum,l_TrcNum,ln_TrcNum, itrc,
     1                       TRACEHEADER)
                  write(LERR,*)'LUOUT= ',luout(iu),' Rec= ',irec,
     &                        ' Trace= ',itrc, nsampt(iu),obytet(iu)
               endif

             enddo
 

  799    continue
  700 continue

c---------------------------------------------------------------------
c     ELSE we have a simple "Y" function with the input sent to
c          to multiple outputs
c---------------------------------------------------------------------
      ELSEIF(wye) THEN

      DO 300 JJ = 1, NRR
      DO 255 KK = 1, NTRCC
         CALL RTAPE  ( LUIN , ITR, NBYTES         )
              if(nbytes .eq. 0) then
                 write(LERR,*)'End of file on input:'
                 write(LERR,*)'  rec= ',jj,'  trace= ',kk,
     1                         'component= ',iu
                 go to 999
              endif

         do  299 iu = 1, nu
             call wrtape(luout(iu),itr,nbytes)
299      continue

255   CONTINUE
300   CONTINUE

c---------------------------------------------------------------------
c     ELSE we have a rotary function with each input record sent to
c          to multiple outputs
c---------------------------------------------------------------------
      ELSEIF(rotary) THEN

      iu = 1
      DO 400 JJ = 1, nrec
          DO 375 LL = 1, nroll
            DO 355 KK = 1, ntrc
               CALL RTAPE  ( LUIN , ITR, NBYTES         )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk,
     1                         'component= ',iu
                  go to 999
               endif

               call wrtape(luout(iu),itr,nbytes)

355         CONTINUE
375       CONTINUE
            iu = iu + 1
            if (iu .gt. nu) iu = 1
400   CONTINUE
c---------------------------------------------------------------------
c     ELSE nblk or oneblk are true
c---------------------------------------------------------------------
c     ELSEIF( .not. wye .and. .not. rotary .and. .not. partition) THEN
      ELSEIF( split ) THEN

      DO 200 JJ = 1, NRR
      do 155 iu=1,nu
         DO  199 KK = 1, ntrco(iu)
           nbytes = 0
           CALL RTAPE  ( LUIN , ITR, NBYTES         )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk,
     1                         'component= ',iu
                  go to 999
               endif
           if(verbos) then

             call saver2(lhed, ifmt_RecNum,l_RecNum,ln_RecNum, irec,
     1                   TRACEHEADER)
             call saver2(lhed, ifmt_TrcNum,l_TrcNum,ln_TrcNum, itrc,
     1                   TRACEHEADER)
             write(LERR,*)'LUIN= ',luin,' Rec= ',irec,' Trace= ',
     &                    itrc
           endif
c--------------------------------------------------------------------
c            adjust headers & write out data
c--------------------------------------------------------------------
c            call savew( itr, 'SGRNum',  1   , TRCHED)

             call wrtape(luout(iu),itr,nbytes)
  199    continue
  155 continue
  200 continue
c---------------------------------------------------------------------
c     output data set partitions
c---------------------------------------------------------------------
      ELSEIF (partition) THEN

            DO  iu = 1, nu

                do  jj = 1, nreco(iu)
                    do  kk = 1, ntrco(iu)

                    nbytes = 0
                    CALL RTAPE  ( LUIN , ITR, NBYTES         )
                        if(nbytes .eq. 0) then
                           write(LERR,*)'End of file on input:'
                           write(LERR,*)'  rec= ',jj,'  trace= ',kk,
     1                                  'component= ',iu
                           go to 999
                        endif
                    if(verbos) then
 
                      call saver2(lhed, ifmt_RecNum,l_RecNum,ln_RecNum,
     1                           irec, TRACEHEADER)
                      call saver2(lhed, ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1                            itrc, TRACEHEADER)
                      write(LERR,*)'LUIN= ',luin,' Rec= ',irec,
     &                             ' Trace= ',itrc
                    endif
c--------------------------------------------------------------------
c            adjust headers & write out data
c--------------------------------------------------------------------
                    call wrtape(luout(iu),itr,nbytes)

                    enddo
                enddo

                write(LERR,*)'splitr: closing output unit ',iu
                write(LER ,*)'splitr: closing output unit ',iu
                call lbclos(luout(iu))

            ENDDO
c---------------------------------------------------------------------
c     output rolling block of records (add-1-drop-1 operation)
c---------------------------------------------------------------------
      ELSEIF (roll) THEN

             itrc = 0
             do  j = 1, nrolls
                 irec = j - nrolls
                 do  k = 1, ntrc
                     itrc = itrc + 1
                     call savew2(lhed0, ifmt_RecNum,l_RecNum,ln_RecNum,
     1                           irec, TRACEHEADER)
                     call savew2(lhed0, ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1                           k   , TRACEHEADER)
                     iptr = (itrc-1) * (nsamp + ITRWRD)
                     do  ii = 1, nwd
                         hold (iptr + ii) = lhed0 (ii)
                     enddo
                 enddo
             enddo
                     

             iread = 0
             ir    = 0
             do  nr = nrolls+1, nroll
                 ir = ir + 1
                 iread = iread + 1
                 do  kk = 1, ntrc
                     nbytes = 0
                     CALL RTAPE  ( LUIN , ITR, NBYTES         )
                     if(nbytes .eq. 0) then
                        write(LERR,*)'End of file on input:'
                        write(LERR,*)'  rec= ',nr,'  trace= ',kk
                        go to 999
                     endif
                     itrc = itrc + 1
                     iptr = (itrc-1) * (nsamp + ITRWRD)
                     do  ii = 1, nwd
                         hold (iptr + ii) = lhed (ii)
                     enddo
                 enddo
             enddo

             iu = 1
             DO  JJ = 1, nrec-nrolle


c---------------
c write out curnt
c blk of itrc trcs
c to next pipe
c---------------
                     do  kk = 1, itrc
                         iptr = (kk-1) * (nsamp + ITRWRD)
                         do  ii = 1, nwd
                             lhed (ii) = hold (iptr + ii)
                         enddo
                         call wrtape (luout(iu), itr, nbytes)
                     enddo

                     iread = iread + 1
                     if (iread .gt. nrec) go to 500
c---------------
c drop first ntrc
c traces & shift
c remainder down
c---------------
                     ioff =  ntrc * (nsamp + ITRWRD)
                     do  kk = 1, itrc-ntrc
                         iptr = (kk-1) * (nsamp + ITRWRD)
                         do  ii = 1, nwd
                             hold (ii + iptr) = hold (ii + iptr + ioff)
                         enddo
                     enddo
c---------------
c read next rec
c of ntrc traces
c & put at end of
c new blk
c---------------
                     ir = ir + 1
                     iu = iu + 1
                     if (iu .gt. nu) iu = 1
                     do  kk = 1, ntrc
                         nbytes = 0
                         call rtape (luin, itr, nbytes)
                         if(nbytes .eq. 0) then
                            write(LERR,*)'End of file on input:'
                            write(LERR,*)'  rec= ',ir,'  trace= ',kk
                            go to 999
                         endif
                         iptr =  (itrc-ntrc+kk-1) * (nsamp + ITRWRD)
                         do  ii = 1, nwd
                             hold (iptr + ii) = lhed (ii)
                         enddo
                     enddo
                     
             ENDDO

500          CONTINUE

             ir = nrec
             DO  JJ = nrec-nrolle+1, nrec

                 iu = iu + 1
                 if (iu .gt. nu) iu = 1

c---------------
c drop first ntrc
c traces & shift
c remainder down
c---------------
                     ioff =  ntrc * (nsamp + ITRWRD)
                     do  kk = 1, itrc-ntrc
                         iptr = (kk-1) * (nsamp + ITRWRD)
                         do  ii = 1, nwd
                             hold (ii + iptr) = hold (ii + iptr + ioff)
                         enddo
                     enddo
                     
                     ioff = (itrc-ntrc) * (nsamp + ITRWRD)
                     ir = ir + 1
                     do  kk = 1, ntrc
                         iptr = (kk-1) * (nsamp + ITRWRD)
                         call savew2(lhed0, ifmt_RecNum,l_RecNum,
     1                               ln_RecNum,ir, TRACEHEADER)
                         call savew2(lhed0, ifmt_TrcNum,l_TrcNum,
     1                               ln_TrcNum,kk, TRACEHEADER)
                         do  ii = 1, nwd
                             hold (iptr + ioff + ii) = lhed0 (ii)
                         enddo
                     enddo
c---------------
c write out curnt
c blk of itrc trcs
c to next pipe
c---------------
                     do  kk = 1, itrc
                         iptr = (kk-1) * (nsamp + ITRWRD)
                         do  ii = 1, nwd
                             lhed (ii) = hold (iptr + ii)
                         enddo
                         call wrtape (luout(iu), itr, nbytes)
                     enddo

             ENDDO

c---------------------------------------------------------------------
c     IF we're doing a partitioned roll-on, roll-off trace set	 
c---------------------------------------------------------------------
      ELSE IF(troll) then

      iu=0
      DO 600 JJ = 1, nrec
       do 599 iu = 1,nu

         nbytes = 0
         CALL RTAPE  ( LUIN , ITR, NBYTES         )
         if(nbytes .eq. 0) then
           write(LERR,*)'End of file on input:'
           write(LERR,*)'  rec= ',jj,'  trace= ',kk
           go to 999
         endif

         if(verbos) then
           call saver2(lhed, ifmt_RecNum,l_RecNum,ln_RecNum, irec,
     1                   TRACEHEADER)
           call saver2(lhed, ifmt_TrcNum,l_TrcNum,ln_TrcNum, itrc,
     1                   TRACEHEADER)
           write(LERR,*)'LUIN= ',luin,' Rec= ',irec,' Trace= ',itrc
         endif

	 if (iu .eq. 1) then
	   liveknt = ntrco(iu) - mx
	   holdtrc = liveknt - 2*mx + 1
           DO 596 kk = 1, mx
	     call move(0,hold,0,nbytes)
	     call savew2(hold,ifmt_StaCor,l_StaCor,ln_StaCor,
     1			30000,TRACEHEADER)
	     call wrtape( luout,hold,nbytes )

             if(verbos) then
               call saver2(hold, ifmt_RecNum,l_RecNum,ln_RecNum, irec,
     1                   TRACEHEADER)
               call saver2(hold, ifmt_TrcNum,l_TrcNum,ln_TrcNum, itrc,
     1                   TRACEHEADER)
               write(LERR,*)'LUOUT= ',luout(iu),' Rec= ',irec,
     &                    ' Trace= ',itrc
             endif
  596      continue
	 else
	   if (iu .eq. nu) then
	     liveknt = ntrco(iu) - 2*mx - ntrcdo(iu)
	     holdtrc = liveknt + 1
	   else
	     liveknt = ntrco(iu) - 2*mx
	     holdtrc = liveknt - 2*mx + 1
	   endif
	   do kk = 1,2*mx
             iptr = (kk-1) * (nsamp + ITRWRD) + 1
             call wrtape(luout(iu),hold(iptr),nbytes)
             if(verbos) then
               call saver2(hold(iptr), ifmt_RecNum,l_RecNum,ln_RecNum,
     1			irec, TRACEHEADER)
               call saver2(hold(iptr), ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1			itrc, TRACEHEADER)
               write(LERR,*)'LUOUT= ',luout(iu),' Rec= ',irec,
     &                    ' Trace= ',itrc
             endif
	   enddo
	 endif

         DO 597 KK = 1, liveknt

             call wrtape(luout(iu),itr,nbytes)

             if(verbos) then
               call saver2(lhed, ifmt_RecNum,l_RecNum,ln_RecNum, irec,
     1                   TRACEHEADER)
               call saver2(lhed, ifmt_TrcNum,l_TrcNum,ln_TrcNum, itrc,
     1                   TRACEHEADER)
               write(LERR,*)'LUOUT= ',luout(iu),' Rec= ',irec,
     &                    ' Trace= ',itrc
             endif

	     if ( kk .ge. holdtrc ) then
               iptr = (kk-holdtrc) * (nsamp + ITRWRD) + 1
	       call move(1,hold(iptr),lhed,nbytes)
	     endif

	     if (kk .ne. liveknt) then
               nbytes = 0
               CALL RTAPE  ( LUIN , ITR, NBYTES         )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif

               if(verbos) then
                 call saver2(lhed, ifmt_RecNum,l_RecNum,ln_RecNum, irec,
     1                   TRACEHEADER)
                 call saver2(lhed, ifmt_TrcNum,l_TrcNum,ln_TrcNum, itrc,
     1                   TRACEHEADER)
                 write(LERR,*)'LUIN= ',luin,' Rec= ',irec,' Trace= ',
     1			itrc
             endif
	     endif
  597    continue
c
c - write dead traces to pad the last dataset if necessary
c
	 if (iu .eq. nu) then
	   call move(0,hold,0,nbytes)
           DO 598 kk = 1, ntrcdo(nu)
	     call savew2(hold,ifmt_StaCor,l_StaCor,ln_StaCor,
     1			30000,TRACEHEADER)
	     call wrtape(luout(iu),hold,nbytes )

             if(verbos) then
               call saver2(hold, ifmt_RecNum,l_RecNum,ln_RecNum, irec,
     1                   TRACEHEADER)
               call saver2(hold, ifmt_TrcNum,l_TrcNum,ln_TrcNum, itrc,
     1                   TRACEHEADER)
               write(LERR,*)'LUOUT= ',luout(iu),' Rec= ',irec,
     &                    ' Trace= ',itrc
             endif
  598      continue
	 endif

  599    continue
  600 continue
      ENDIF

  999 continue
c--------------------------------------------------------------------
c     close all open units if not -p [partition] option
c--------------------------------------------------------------------
      if (.not. partition) then
         do  i=1, nu
             call lbclos(luout(i))
         enddo
      endif
        call lbclos(luin)
      stop 0
      END

C**********************************************************************C
C     help panel
C**********************************************************************C
      subroutine help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for SPLITR: '
        write(LER,*)' re-distribute an input data stream'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]  -- input data set'
        write(LER,*)' '
        write(LER,*)'Direct cmd line input of file names...'
        write(LER,*)'-O[otap]  -- output data set'
        write(LER,*)'-O[otap]  -- output data set'
        write(LER,*)'  ...            ...'
        write(LER,*)'-O[otap]  -- output data set: max 1000 sets'
        write(LER,*)'... or'
        write(LER,*)'-F[ftap]   -- file of output file names, one per li
     1ne'
        write(LER,*)' '
        write(LER,*)'Output option 1:'
        write(LER,*)'-Y        -- duplicate input data on each output'
        write(LER,*)'-p        -- partition input data stream into as'
        write(LER,*)'             many output data files as -O[]'
        write(LER,*)'-R        -- send successive input records to'
        write(LER,*)'-rm       -- send successive input traces to'
        write(LER,*)'             available outputs'
        write(LER,*)'-T        -- split each input trc into successive'
        write(LER,*)'             time chunks'
        write(LER,*)'-P[num]   -- maximum number of output pipes'
        write(LER,*)' '
        write(LER,*)'Output option 2:'
        write(LER,*)'-ro       -- rolling add-1-drop-1 record operation'
        write(LER,*)' '
        write(LER,*)'For Output options 1 & 2:'
        write(LER,*)'-b[nroll] -- 1. send nroll records at a time to'
        write(LER,*)'                each output stream'
        write(LER,*)'-b[nroll] -- 2. number of recs in rolling block'
        write(LER,*)' '
        write(LER,*)'Output option 3:'
        write(LER,*)'-n[ntr]   -- split each ntap rec into ntr length'
        write(LER,*)'             chunks.  ntr must divide into ntap '
        write(LER,*)'             #tr/rec evenly'
        write(LER,*)' '
        write(LER,*)'-norig    -- do not store original number trc/rec'
        write(LER,*)'             or number of recs (of input)'
        write(LER,*)'-V        -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'   splitr [ -N[] -O[] -O[] ... -O[] ] [ -F[] ]'
        write(LER,*)'          [-p -R -Y -rm -T -P -n[] -b[] -norig -V]'
        write(LER,*)' '

      return
      end


      subroutine cmdln(ntap,otap,nu,ntr,nblk,oneblk,split,verbos,
     1                 wye,rotary,mpx,pmax,partition,nroll,roll,
     2		       troll,mx,trace,ftap,no_orig)
c-----
c     get command arguments 
c
c     ntap  - C*100     string defining input data set
c     otap  - C*100     vector of strings defining output data sets
c      ntr  - I*4       length of output records in traces
c       nu  - I*4       number of output data sets
c       mx  - I*4       number of traces at ends of rolling window
c  flags:
c     nblk  - L         input records are placed back-to-back on output
c   oneblk  - L         input records are combined into one output rec
c      mpx  - L         input traces are multiplexed on output
c    split  - L         input records are to split into ntr recs of ntr length
c      wye  - L         duplicate the input data on each output
c   rotary  - L         send successive input recs to outputs
c   verbos  - L         verbos output flag
c-----
#include <f77/iounit.h>
      character*256  ntap, otap(*), ftap
      integer        nu, ntr, argis, pmax
      logical        nblk, oneblk, mpx, split, verbos, wye, rotary
      logical        rottrc, partition, roll, troll, trace, no_orig

      no_orig   = (argis('-norig') .gt. 0)

c                        get output data set names
      nu=0

      call argstr('-F',ftap,' ',' ')
 
      IF (ftap(1:1) .eq. ' ') THEN
 
         nu=0
            do  i = 1, 1000
                call argstr('-O',otap(i),' ',' ')
                if(otap(i) .eq. ' ') go to 1
                nu=nu+1
            enddo
    1       continue
            if(nu .eq. 0) then
              write(LERR,*)'Since no input files are explicitly'
              write(LERR,*)'named it is assumed splitr is running'
              write(LERR,*)'inside the iconic processor - ikp'
            endif
 
      ELSE

            call alloclun (lufil)
            open (unit=lufil, file = ftap, status = 'old', iostat=ierr)
            if(ierr .ne. 0) then
            write(LERR,*)'FATAL ERROR in splitr:'
            write(LERR,*)'Could not open file of input names ',ftap
            write(LER ,*)'FATAL ERROR in splitr:'
            write(LER ,*)'Could not open file of input names ',ftap
            stop
            endif
            rewind lufil
            i = 1
            do while (1.eq.1)
 
               read (lufil,'(a80)',end=2,err=666) otap (i)
               i = i + 1
            enddo
2           continue
            nu = i - 1
            do  i = 1, nu
               if (otap(i) .eq. ' ') then
                   if (i .lt. nu) then
                      write(LERR,*)'FATAL ERROR in splitr:'
                      write(LERR,*)'Cannot have blank input name (line '
     1                ,i,' in file ',ftap,' )'
                      write(LER ,*)'FATAL ERROR in splitr:'
                      write(LER ,*)'Cannot have blank input name (line '
     1                ,i,' in file ',ftap,' )'
                      stop
                   endif
                   nu = nu - 1
                   go to 3
               endif
            enddo
3           continue
            if(nu .eq. 0) then
              write(LERR,*)'FATAL ERROR in splitr:'
              write(LERR,*)'No input file names read in file ',ftap
              write(LER ,*)'FATAL ERROR in splitr:'
              write(LER ,*)'No input file names read in file ',ftap
              stop
            endif
 
      ENDIF

c
c - Kurt wanted the option to be nxpad, mx is for bckwrd compatibility - jmw
c
              call argi4('-mx', mx, 0, 0)
              call argi4('-nxpad', mx, mx, mx)

c                       get input data set name and output trcs/rec
              call argstr('-N', ntap, ' ',' ')
              call argi4('-n', ntr, 0, 0)
              call argi4('-b', nroll, 0, 0)
              call argi4('-P', pmax, 1000, 1000)

              if (ntr .ne. 0 .AND. nroll .ne. 0) then
                 write(LER,*)' '
                 write(LER,*)'Cannot have -n[] & -b[] both nonzero'
                 write(LER,*)'-b[] is a rolling add-1-drop-1 record'
                 write(LER,*)'     operation (option 2)'
                 write(LER,*)'-n[] is a split of input records (option'
                 write(LER,*)'     3)'
                 write(LER,*)'Choose one or the other & rerun'
                 stop 100
              endif

c                       set flags
              nblk    = .false.
            oneblk    = .false.
               mpx    = .false.
             split    = .false.
            rotary    = .false.
            rottrc    = .false.
            partition = .false.
            roll      = .false.
            verbos    = .false.

c                       get flags
            wye       = (argis('-Y') .gt. 0)
            partition = (argis('-p') .gt. 0)
            rotary    = (argis('-R') .gt. 0)
            rottrc    = (argis('-rm') .gt. 0)
            roll      = (argis('-ro') .gt. 0)
            mpx       = (argis('-m') .gt. 0)
            trace     = (argis('-T') .gt. 0)

            if (trace) then
              rotary = .true.
               mpx   = .true.
            endif
            if (mpx) then
              rotary = .true.
            endif
            if (rottrc) then
               rotary = .true.
               mpx    = .true.
            endif

c           if (nroll .ne. 0) roll = .true.
            if(ntr .ne. 0) split = .true.
            if(mx .ne. 0) troll = .true.


            if (roll) then
c              if (mod(nroll,2) .eq. 0) then
c                 write(LERR,*)'splitr: FATAL ERROR...'
c                 write(LERR,*)'nroll partition must be odd number'
c                 write(LERR,*)'Rerun with proper -b[]'
c                 write(LER ,*)'splitr: FATAL ERROR...'
c                 write(LER ,*)'nroll partition must be odd number'
c                 write(LER ,*)'Rerun with proper -b[]'
c                 stop
c              endif
               partition = .false.
               rottrc    = .false.
               mpx       = .false.
               wye       = .false.
               rotary    = .false.
               split     = .false.
               troll     = .false.
               ntr       = 0
            endif
            if (troll) then
               partition = .false.
               rotary    = .false.
               rottrc    = .false.
               roll      = .false.
               mpx       = .false.
               wye       = .false.
               split     = .false.
            endif
            if (split) then
               partition = .false.
               rotary    = .false.
               rottrc    = .false.
               roll      = .false.
               mpx       = .false.
               wye       = .false.
               troll     = .false.
            endif
            if (partition) then
               rotary    = .false.
               rottrc    = .false.
               split     = .false.
               mpx       = .false.
               roll      = .false.
               wye       = .false.
               troll     = .false.
               ntr       = 0
            endif
            if (rotary) then
               partition = .false.
               wye       = .false.
               roll      = .false.
               split     = .false.
               ntr       = 0
               troll     = .false.
               if (nroll .eq. 0) nroll = 1
            endif
            if (rottrc) then
               partition = .false.
               wye       = .false.
               roll      = .false.
               split     = .false.
               ntr       = 0
               troll     = .false.
            endif
            verbos = (argis('-V') .gt. 0)


      return

666   continue
      write(LERR,*)'FATAL ERROR in splitr:'
      write(LERR,*)'Error in reading file of input names from file ',
     1              ftap
      write(LER ,*)'FATAL ERROR in splitr:'
      write(LER ,*)'Error in reading file of input names from file ',
     1              ftap
      stop 666

      end

