C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***************************************************************** C
C                                                                  C
C     PROGRAM - SQAVOU               ENTRY POINT - MAIN            C
C                                                                  C
C     LANGUAGE - FORTRAN                                           C
C     SYSTEM(S) - SUN, CRAY                                        C
C     AUTHOR - David Ford                                          C
C     DATE WRITTEN - January 2, 1994                               C
C     Modification History:                                        C
C                                                                  C
C                 AMOCO PRODUCTION CO. PROPRIETARY                 C
C                  TO BE MAINTAINED IN CONFIDENCE                  C
C                                                                  C
C     ABSTRACT - Perform Semi-Quantitative AVO on selected CDP's   C
C                                                                  C
C     USAGE                                                        C
C                                                                  C
C      ANGBEG   -   Begin angle.                                   C
C      ANGINC   -   Angle increment                                C
C      RECST    -   Start record                                   C
C      RECEND   -   End record                                     C
C      VCARD    -   TDFN card file                                 C
C      NTAP     -   Input data set                                 C
C      OTAP     -   Stack output data set                          C
C      ANGCRD   -   Optional angle data card file.                 C
C                                                                  C
C     ERROR FILE AND MNEUMONIC - NONE                              C
C                                                                  C
C     DATA DECLARATIONS                                            C
C                                                                  C
C***************************************************************** C
#include <localsys.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/pid.h>
#include <f77/iounit.h>

      INTEGER NPOL,nerrflg
      real dtor, rtod
      PARAMETER (dtor = .0174533)
      PARAMETER (rtod = 57.29578)
      PARAMETER (NPOL = 6)
      PARAMETER (nerrflg = 7)
      external fpoly
      REAL DX(250), C(63,70), TT(63,70)
      real data(1), angles(1), stack(1), sqavo(1)
      real VCOEF(NPOL),errparms(5)
      real sig(3000), vtrms(3000),vsrms(3000),vism(3000),vit(3000)
C     real tr2(3000),tr3(3000), etr(3000)
      real etr(3000)
      real timvec(3000),livebf(1)
      real angmn(1), angmx(1), tang, uang
      real Ritr(3000), work(3000), work1(3000)
      real langle(3000), hangle(3000)
      real min1, max1, min2, max2, min3, max3
      real ci(3000,9), f(3000,9), tci(9), tf(9)
C     real ci(9), f(9), tci(9), tf(9)
      real amp(500)
      real vscale
      real vpvs
C                                                      
      CHARACTER NAME*6,TITLE(17)*4
      character ntap*100,otap*100
      character vcard*100
C
      logical verbos, query, cdp
      logical fit,dead,disco
      logical errflg(nerrflg)
c
      INTEGER NC(70),JR(70),pol
      integer istrt
      integer argis,luv
      integer angbeg, angend, anginc, recbeg, recend
      integer winst, winend,emerg, inc
      integer dgofit, optype
      integer trhd(1)
      INTEGER linehead(3000)
      integer itr(6128)
      integer posneg(3000)
      integer*2 itr2(128)
      integer   itr4(64)
      integer start(500),end(500)


C
      POINTER (pdata, data), (pang, angles)
      POINTER (pst, stack), (ptrhd, trhd)
      POINTER (psq, sqavo)
      POINTER (plive, livebf)
C
      DATA NAME/'SQAVOU'/
      DATA LUIN/7/,luout/11/
      DATA IER/0/
      DATA TITLE/7*'    ','SEMI','-QUA','NTIT','ATIV',
     *             'E AV', 'O   ', 4*'    '/                   
      data luv/22/

      equivalence(itr(1),itr2(1),itr4(1))
      equivalence(itr(ITHWP1),Ritr(1))

      ival = 0
	  verbos=.false.
c +---------------------------------------------------------+
c |     check for help flag.  If found, print help and quit |
c +---------------------------------------------------------+
      query= ((argis ('-?').gt.0).or.(argis('-H').gt.0).or.
     *        (argis ('-h').gt.0))
      if (query) then
        call help(LER)
        stop
      endif
C               +------------------------------+
C               |       Begin Edit Phase       |
C               +------------------------------+
#include <f77/open.h>
      call gcmdln(ntap,otap,vcard,verbos,luv,angbeg, 
     *anginc, recbeg, recend, winst, winend, optype, dgofit,
     *emerg,pol,dead,disco,cdp, mode, vscale, vpvs)

      if(recend.eq.0)recend = 32767
C
      if(winst.lt.0)winend = 0
      if(winst.ne.0.and.winend.ne.0.and.winst.gt.winend)then
        write(LERR, *)' Window start time exceeds window',
     *' end time.'
        write(LERR, *)' Job abended'
        stop
      endif
      if(mode.eq.-1)then
       write(LER,*)' Solution mode must be specified. There is',
     :' no default for it.'
       stop
      endif
      if(dgofit.lt.2.or.dgofit.gt.3)then
       write(LER,*)' Degree of fit must be 2 or 3'
       stop
      endif
      if(optype.lt.1.or.optype.gt.2)then
       write(LER,*)' Output type must be 1 or 2'
       stop
      endif
      if(vpvs.lt.1.6)then
       write(LER,*)' Vp/Vs ratio (vpvs) must be greater than 1.6'
       stop
      endif
      if(vpvs.gt.5.0)then
       write(LER,*)' Vp/Vs ratio (vpvs) must be less than 5.0'
       stop
      endif
C                                                           
C     PRINT TORCH AND OVAL                                 
C                                                         
      CALL GAMOCO(TITLE,1,LERR) 
c  open the temp output file
C
C     READ LINE HEADER FROM INPUT TAPE  
C                                      
      if(ntap.ne.' ')then
        call lbopen(luin,ntap,'r')
        if(luin.lt.0)then
         write(LERR,*)'Unable to open ', ntap
         stop
        endif
      else
        luin = 0
      endif
      NBY = 0                        
      CALL RTAPE(LUIN,linehead,NBY)     
      IF (nby.EQ.0) then         
        write(LERR,9041)
 9041 format(8x,' ** m0133 ** Error Detected in Program SQAVOU:',
     */,19x,'EOF encountered trying to read line header from',
     *'input data set.',
     */,19x,'Job abended.')
        call lbclos(luin)
        stop
      endif
C   get processing constants from line header
      call saver(linehead, 'NumSmp', nsamps, LINHED)
      call saver(linehead, 'SmpInt', nsi  , LINHED)
      call saver(linehead, 'NumTrc', ntrc , LINHED)
      call saver(linehead, 'NumRec', nrec , LINHED)
      call saver(linehead, 'Format', iform, LINHED)
      call savelu('TrcNum',ifmt,l_TrcNum,length,TRACEHEADER)
      call savelu('RecNum',ifmt,l_RecNum,length,TRACEHEADER)
      call savelu('DstSgn',ifmt,l_DstSgn,length,TRACEHEADER)
      call savelu('DstUsg',ifmt,l_DstUsg,length,TRACEHEADER)
      call savelu('StaCor',ifmt,l_StaCor,length,TRACEHEADER)
      call savelu('DphInd',ifmt,l_DphInd,length,TRACEHEADER)
      if(winend.eq.0)winend = nsi*nsamps
      iws = winst/nsi+1
      iwe = winend/nsi
      if(iwe.gt.nsamps)iwe=nsamps
      lwin = iwe-iws + 1
      if(lwin.gt.nsamps)lwin = nsamps
C
      lx = nsamps
      delt = float(nsi)/1000.
      do 555 i = 1,  lx
       xj = i-1
       timvec(i) = xj * delt
  555 continue
      n4 = 4
      CALL HLHPRT (linehead,NBY,NAME,n4, LERR)
C                                         
C     GET THE NUMBER OF SAMPLES FROM LH
      IF (LX.LT.1.OR.LX.GT.3000) GO TO 9080
C                                         
C     CALCULATE NUMBER OF BYTES IN A OUTPUT TRACE
C                                               
       ntbyt = lx*iszbyt + sztrhd
       if(lwin.lt.nsamps)then
         if(iwe.lt.nsamps)ntbyt = iwe*iszbyt + sztrhd
       endif
       nasets = 1
       nvsets = 0
       nstak = dgofit
       lastang = nstak*anginc + angbeg
	  angend = lastang
       nang = nstak

C
C 2 parm fit
C
	 if(nstak .eq. 2) then

      	min1 = (angbeg)
      	max1 = (angbeg + anginc)
      	min2  = (max1)
      	max2 = (max1 + anginc)

      	min1 = min1 * dtor
      	max1 = max1 * dtor
      	min2 = min2 * dtor
      	max2 = max2 * dtor

	 else
C
C 3 parm fit
C
      	min1 = (angbeg)
      	max1 = (angbeg + anginc)
      	min2  = (max1)
      	max2 = (max1 + anginc)
      	min3 = (max2)
	 	max3 = (max2 + anginc)

      	min1 = min1 * dtor
      	max1 = max1 * dtor
      	min2 = min2 * dtor
      	max2 = max2 * dtor
      	min3 = min3 * dtor
      	max3 = max3 * dtor

	 endif

C
C     SET NUMBER OF TRACES PER RECORD FOR OUTPUT LH
C                                                 
C     SET UP CONSTANTS FOR ANGLE SOLUTION
C                                    
C     WRITE OUT LINE HEADER 
C                          
      if (otap.ne.' ')then
        call lbopen(luout,otap,'w')
        if(luout.lt.0)then
         write(LERR,*)'  Unable to open ',otap
         call lbclos(luin)
         stop
        endif
      else
        luout = 1
      endif
      if(recend.lt.32767.and.recbeg.gt.0)then
        jnrec=recend-recbeg+1
        call savew(linehead, 'NumRec', jnrec , LINHED)
      endif
      if(lwin.lt.nsamps)call savew(linehead,'NumSmp', iwe, LINHED)

      kstak = nang

      call savew(linehead,'NumTrc',  kstak+1, LINHED)
      call savhlh(linehead,nby,jtbyt)
      call wrtape(luout,linehead,jtbyt)
C +==================================+
C |   allocate the required memory   |
C +==================================+
      ierror = 0
      iabort = 0
      ner = 0
      do i=1,nerrflg
         errflg(i)=.false.
      end do
      iget =nsamps * ntrc * ISZBYT
      call galloc(pdata,iget,ierror,iabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      call galloc(pang, iget,ierror,iabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      iget = nsamps * nang * ISZBYT
      call galloc(pst  ,iget,ierror,iabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      call galloc(psq  ,iget,ierror,iabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      call galloc(plive,iget,ierror,iabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      iget = ITRWRD * ntrc * ISZBYT
      call galloc(ptrhd,iget,ierror,iabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      iget = nang*ISZBYT
      call galloc(pamx,iget,ierror,iabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      do i=1,nerrflg
      if(errflg(i))then
       write(LERR,*)' Memory allocation failed.  FATAL'
       call lbclos(luin)
       call lbclos(luout)
       stop
      endif
      end do
      lmove = nsamps
      if(lwin.lt.nsamps)lmove = lwin
      write(LERR,*)' SQAVOU Processing Parameters :'
      write(LERR,'(a,i5)')'Start Record ...............',recbeg
      write(LERR,'(a,i5)')'End Record .................',recend
      write(LERR,'(a,i5)')'Window Start................',winst
      write(LERR,'(a,i5)')'Window End..................',winend
      write(LERR,'(a,i5)')'Degree of Fit...............',dgofit
      write(LERR,'(a   )')'     2 = Two Parameter'
      write(LERR,'(a   )')'     3 = Three Parameter'
      write(LERR,'(a,i5)')'Mode........................',mode
      write(LERR,'(a   )')'     0 = Straight Ray'
      write(LERR,'(a   )')'     1 = Curved Ray'
      write(LERR,'(a   )')'     2 = Perturbed Curved Ray'
      write(LERR,'(a,i5)')'Output Type.................',optype
      write(LERR,'(a   )')'     1 = Delta Rock Properties'
      write(LERR,'(a   )')'     2 = Bortfeld Coeffcients'
      write(LERR,'(a,i5)')'Angles......................',emerg
      write(LERR,'(a   )')'     0 = Use incident angles'
      write(LERR,'(a   )')'     1 = Use emergent angles'
      write(LERR,'(a,i5)')'Number Stacked Traces.......',nstak
      write(LERR,'(a,i5)')'Start Angle.................',angbeg
      write(LERR,'(a,i5)')'Angle Increment.............',anginc
      write(LERR,'(a,i5)')'End Angle...................',angend
      write(LERR,'(a,f10.7)')'RMS Velocity Multiplier.....',vscale
      write(LERR,'(a,f10.7)')'Vp/Vs ratio ................',vpvs
C               +---------------------------------+
C               |       Begin Process Phase       |
C               +---------------------------------+
      ier = 0
      if(.not.disco)then
        call rdvels(c,tt,nc,jr,luv,LERR,ier)
      else
        call rdhvel(c,tt,nc,jr,luv,LERR,ier)
      endif
      if(ier.ne.0)then
       call lbclos(luin)
       call lbclos(luout)
       stop 100
      endif
C      
C      FIND RECORD TO DO ANALYSIS ON 
C 
  330 nby=0
      call rtape(luin,itr,nby)
      if(nby.eq.0)then
       call lbclos(luin)
       call lbclos(luout)
       stop
      endif
      irec = itr2(l_RecNum)
      if(irec.lt.recbeg)go to 330
      if(irec.gt.recend)then
       call lbclos(luin)
       call lbclos(luout)
       stop
      endif
       do k=1,nsamps
        data(k)=Ritr(k)
       end do
       do k=1,ITRWRD
        trhd(k)=itr(k)
       end do
       idist=itr2(l_DstUsg)
       if(idist.eq.0.0)then
        idist = itr2(l_DstSgn)
        idist = iabs(idist)
       endif
       dx(1) = idist

C
C      PROCESS DATA 
C                 
C     GET THE WHOLE RECORD
C                                           
  340 continue
      LJJ = 0
      DO 410 J=2,ntrc
       NBY = 0   
       CALL RTAPE (LUIN,ITR,NBY)
       IF (NBY.EQ.0) GO TO 870 
       irec = itr2(l_RecNum)
       if(irec.gt.recend)go to 870
       iaddr = (j-1)*nsamps
       do k=1,nsamps
        data(iaddr+k)=Ritr(k)
       end do
       idist=itr2(l_DstUsg)
       if(idist.eq.0.0)then
        idist = itr2(l_DstSgn)
        idist = iabs(idist)
       endif
       dx(j) = idist
       iaddr = (j-1)*ITRWRD
       do k=1,ITRWRD
        trhd(iaddr+k)=itr(k)
       end do
  410 CONTINUE
C   Get the local velocity function
      irec = itr2(l_RecNum)
      if(cdp)irec = itr2(l_DphInd)
      do i=1,lx
       sig(i)=1.0
      end do
      chisq = 0
      fit = .true.
      call getvel(irec, jr, tt, c, nc, lx, delt, vcoef,
     &  sig,chisq,vtrms,nvsets,vtmax,fit,pol,vsrms,vism,vit,vscale)
C
      bang = angbeg
      cang = anginc
      do 430 J = 1, nang
          angmn(j)= float((j-1))*cang + bang
          angmx(j) = angmn(j) + cang
          if(angmx(j).gt.angend)angmx(j)= angend
  430 continue
C                                         
C     Go compute the angles and do stacking
C                                       
      lclr = nsamps * nang
      do i=1,lclr
       stack(i)=0.
       livebf(i)=0.
	  sqavo(i) = 0.
      end do
      lclr = nsamps * ntrc
      do i=1,lclr
       angles(i)=0.
      end do

      call dostak(nsamps, vcoef, data, angles,stack, dx,trhd,
     *angmn, angmx, nang, ntrc, delt, livebf, iws, iwe,timvec, vtrms,
     *mode,emerg,vtmax,ierr,errparms,vsrms,vism,vit,langle,hangle)

      if(ierr.ne.0)then
       call lbclos(luin)
       call lbclos(luout)
       write(LERR,'(a,i5)')
     :' Fatal Error in Velocity Function for Record',irec
       write(LERR,'(a,f8.3,a)')
     :' Found imaginary interval velocity at ',errparms(5),' seconds.'
       write(LERR,'(a,f10.0,a,f8.3)')
     :' V2 = ',errparms(1),' T2 = ',errparms(3)
       write(LERR,'(a,f10.0,a,f8.3)')
     :' V1 = ',errparms(2),' T1 = ',errparms(4)
        write(LERR,*)' coeffs'
C        call writer(vcoef,npol,1,LERR)
        write(LERR,*)'vsrms '
C        call writer(vsrms,nsamps,1,LERR)
        write(LERR,*)'vism '
C        call writer(vsrms,nsamps,1,LERR)
        write(LERR,*)'vit '
C        call writer(vsrms,nsamps,1,LERR)
       stop
      endif
      kstak = nstak

      do 551 i = 1,kstak
        ist = (i-1)*nsamps
        do k=1,iwe
          work1(k)=stack(ist+k)
		if(stack(ist+k) .lt. 0.0) then
			posneg(k) = -1
		else
			posneg(k) = 1
		endif
        end do
C
C square wave trace
C
	   call sqrtrc(work1, posneg, work, nsamps,
     :              start, end, istrt,amp)
       do k=1,iwe
          stack(ist+k) = work(k)
	   end do
  551  continue

       do 821 i = 1,kstak
        ist = (i-1)*nsamps
       do k=1,iwe
          stack(ist+k) = stack(ist+k)
       end do
  821  continue

       do k=1,iwe
		if(dgofit.eq.3) then
		   if(langle(k).eq. -1.0) then
			tang = min1
		   else
               tang = langle(k)*dtor
		   endif
		   if(hangle(k).eq. -1.0) then
			uang = max3
		   else
               uang = hangle(k)*dtor
		   endif
             call calc3(tang,max1,min2,max2,min3,uang,tci,tf,vpvs)
		else
		   if(langle(k).eq. -1.0) then
			tang = min1
		   else
               tang = langle(k)*dtor
		   endif
		   if(hangle(k).eq. -1.0) then
			uang = max2
		   else
               uang = hangle(k)*dtor
		   endif
             call calc2(tang,max1,min2,uang,tci,tf)
		endif
	     do j=1,9
             ci(k,j) = tci(j)
             f(k,j) = tf(j)
		end do
       end do

	 if(dgofit.eq.3) then
	 	inc = 3
	 else
		inc = 2
	 endif

	 n=1
      do 552 i = 1,kstak
      	ist = (i-1)*nsamps
          do k=1,iwe
C
C rock properties
C
            if(optype.eq.1) then
              sqavo(k)=sqavo(k) +f(k,n)*stack(ist+k)
              sqavo(nsamps+k)=sqavo(nsamps+k)
     :                       +f(k,n+inc)*stack(ist+k)
              if(kstak .eq. 3) then
                sqavo(2*nsamps+k)=sqavo(2*nsamps+k)
     :                           +f(k,n+2*inc)*stack(ist+k)
              endif
            else
C
C bortfeld coeffcients
C
              sqavo(k)=sqavo(k) +ci(k,n)*stack(ist+k)
              sqavo(nsamps+k)=sqavo(nsamps+k)
     :                       +ci(k,n+inc)*stack(ist+k)
              if(kstak .eq. 3) then
                sqavo(2*nsamps+k)=sqavo(2*nsamps+k)
     :                           +ci(k,n+2*inc)*stack(ist+k)
              endif
            endif
          end do 
          n=n+1
  552 continue

      ioknt = 0
      do 550 i = 1,kstak+1
        ioknt = ioknt + 1
        if(ioknt.gt.ntrc)ioknt = 1
        ist = (i-1)*nsamps
        if(i .le. kstak) then
         do k=1,iwe
          Ritr(k)=sqavo(ist+k)
         end do
        else
          do k=1,iwe
               Ritr(k)=etr(k)
          end do
        endif
        do k=1,ITRWRD
          itr(k)=trhd(k)
        end do
        iang = angmn(i)
        itr2(l_DstSgn)=iang
        iang = angmx(i)
        itr2(l_DstUsg)=iang
        itr2(l_TrcNum)=i
        if(.not.dead)then
          sum = 0.
          do k=1,iwe
           sum = sum+abs(sqavo(ist+k))
          end do
          if(sum.ne.0.0)then
            itr2(l_StaCor)=0
          else
            itr2(l_StaCor)=30000
          endif
        else
          itr2(l_StaCor)=0
        endif
        call wrtape(luout,itr,ntbyt)
  550  continue
      if(irec.lt.recend)go to 330
  870 continue
      ic = 0
  900 continue
      CALL LBCLOS(luin)                   
      CALL lbclos(luout)                   
      stop
C
 9080 WRITE(LER,9081) LX
 9081 FORMAT(T8,' ** M0039 ** ERROR DETECTED IN PROGRAM SQAVOU',/,
     * T19,' THE NUMBER OF SAMPLES PER TRACE IS INVALID',/,
     * T19,' THE MINIMUM IS 1 AND THE MAXIMUM IS 3000',/,
     * T19,' CHANGE NUMBER OF SAMPLES ',I8,' TO WITHIN THE ',
     * 'RANGE - JOB ABORTS')
 9980 CALL LBCLOS(luin)
      call lbclos(luout)
      stop 100
      END                                                    
