C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c
c
      subroutine gcmdln ( ntap, otap, vcard, verbos,luv,
     *	angbeg, anginc, recbeg, recend, winst, winend, optype,
     *	dgofit,emerg,npol,dead,disco,cdp,mode,vscale,vpvs)

#include <f77/iounit.h>

      character ntap*100, otap*100, vcard*100
      character vtemp*100,mdc*2
      logical     verbos, dead,disco,cdp
      integer argis
      integer angbeg, anginc, recbeg, recend
      integer winst, winend,emerg
      integer optype, dgofit
      real vscale
      real vpvs
C                                                         
      verbos = .false.                                   
      verbos = (argis('-V') .gt. 0)                    
      call argstr ('-N',ntap,' ',' ')          
      call argstr ('-O',otap,' ',' ')            
C  Handle both the -DV and -v symbols for velocity file indicator
      vcard = ' '
      vtemp = ' '
      call argstr ('-DV',vcard,' ',' ')
      call argstr ('-v',vtemp,' ',' ')
      if(vcard(1:1).eq.' '.and.vtemp(1:1).ne.' ')then
        vcard = vtemp
      endif
      if(vcard(1:1) .ne. ' ') then
         call chkfle(vcard)
         open(unit=LUV, file=vcard, status='old',
     *       form='formatted',access='sequential')
         rewind (LUV)                           
       else                                      
          write(LER, *)
     :    ' Please enter a file name for velocity card images'
          call ccexit(100)
       endif                                                   
       call argi4('-as', angbeg, 0,0)
       if(angbeg.lt.0)angbeg = 0
       call argi4('-ai', anginc, 0,0)
       if(anginc.eq.0)anginc = 15
       if(anginc.lt.0)anginc = 15
       call argi4('-rs', recbeg, 0,0)
       call argi4('-re', recend, 0,0)
       call argi4('-ws', winst, 0,0)
       call argi4('-we', winend, 0,0)
       call argi4('-to', optype, 1,1)
       call argi4('-dof',dgofit, 3,3)
C       call argi4('-md', mode, 1,2)
       call argr4('-s', vscale, 1.0,1.0)
       call argr4('-vpvs', vpvs, 2.0,2.0)
       call argstr('-md',mdc,' ',' ')
       if(mdc.eq.'0'.or.mdc.eq.'1'.or.mdc.eq.'2')then
        read(mdc,'(I1)')mode
       else
        mode = -1
       endif
       call argi4('-em',emerg,0,0)
       if(mode.gt.2)mode = 0
       if(emerg.ne.1)emerg=0
       call argi4('-or',npol,0,0)
       if(npol.eq.0)npol=5
       npol = npol + 1
       if(npol.gt.6)npol=6
      dead = (argis('-dead').gt.0)
      disco = (argis('-disco').gt.0)
      cdp = (argis('-cdp').gt.0)
      return                                                  
      end
c
c**********************************************
c
      subroutine help(LER)
       write(LER,*)  
     :'***************************************************************'
       write(LER,*)' '
       write(LER,*)
     :'Program SQAVOU............................Semi-Quantitative AVO' 
       write(LER,*)' '                                             
       write(LER,*)                                               
     :' -N [ntap]    (default = stdin)  : Input data file name'   
       write(LER,*)                                             
     :' -O [otap]    (default = stdout) : Output data file name'
       write(LER,*)                                           
     :' -v[cardin]   (required)         : TDFN Card file name'
       write(LER,*)
     :'-as[angbeg]   (default = 0)      : Start Angle'
       write(LER,*)
     :'-ai[anginc]   (default =15)      : Angle Increment'
       write(LER,*)
     :'-rs[irs]      (default = first)  : Start Record Number'
       write(LER,*)
     :'-re[ire]      (default = last)   : Last Record Number'
       write(LER,*)
     :'NOTE: Both rs and re parameters should be supplied'
       write(LER,*)
     :'      when using spatial windowing.'
       write(LER,*)
     :' '
       write(LER,*)
     :'-ws[ws]       (default = 0)      : Window Start'
       write(LER,*)
     :'-we[we]   (default = trace end)  : Window End'
       write(LER,*)
     :'-to[to]       (default = 1 )     : Output Type'
       write(LER,*)
     :'                                   1 = Delta Rock Properties'
       write(LER,*)
     :'                                   2 = Bortfeld Coeffcients'
       write(LER,*)
     :'-dof[dof]     (default = 3 )     : Degree of Fit'
       write(LER,*)
     :'                                   2 = Two Parameter'
       write(LER,*)
     :'                                   3 = Three Parameter'
       write(LER,*)
     :'-md[mode]     (No Default -      : Solution Flag'
       write(LER,*)
     :'                 value required)   0 = Straight Ray'
       write(LER,*)
     :'                                   1 = Curved Ray'
       write(LER,*)
     :'                                   2 = Perturbed Curved Ray'
       write(LER,*)
     :'-em[angl]     (default = 0)      : Angles Flag'
       write(LER,*)
     :'                                   0 = incident angle'
       write(LER,*)
     :'                                   1 = emergent angle'
       write(LER,*)
     :'-s[vscale]    (default =1.0)     : If present, velocity are '
       write(LER,*)
     :'                                   mult by this constant '
       write(LER,*)
     :'-vpvs[vpvs]   (default =2.0)     : If present, this value for '
       write(LER,*)
     :'                                   Vp/Vs used in calculations '
       write(LER,*)
     :'-dead         (default = No)     : If present, zero-valued'
       write(LER,*)
     :'                                   stack traces not flagged'
       write(LER,*)
     :'                                   "dead"'
       write(LER,*)
     :'-disco        (default = No)     : If present, velocity'
       write(LER,*)
     :'                                   card images are in DISCO'
       write(LER,*)
     :'                                   HANDVEL format'
       write(LER,*)
     :'-cdp          (default = No)     : If present, velocity and '
       write(LER,*)
     :'                                   angle functions are '
       write(LER,*)
     :'                                   keyed to CDP, not RI #'
       write(LER,*)
     :'-h            (default = No)     : If present, online help '
       write(LER,*)
     :'                                   documentation is displayed '
       write(LER,*)' '
       write(LER,*)                                        
     :'Usage:  ',                                         
     :'sqavou -N[ntap] -O[otap] -DV[vcard] -as[as] -ai[ai] -to[to] ',
     :'-dof[dof] -rs[rs] -re[re] -ws[ws] -we[we]  -md[md] -em[em] ',
     :'-s[vscale] -vpvs[vpvs] -dead -disco -cdp -h'
       write(LER,*)' '
       write(LER,*)  
     :'***************************************************************'
      return                                                          
      end                                                            
c
c**********************************************
c
      subroutine chkfle(name,lu)

#include <f77/iounit.h>

      character*100 name
      integer lu
      logical there
C
      inquire(FILE=name, EXIST=there)
      if(.not.there)THEN
        write(LER, *)name, ' does not exist.'
        write(LER, *)' Program abended'
        call ccexit(100)
      endif
      return
      end
