C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C
      program STACK
c__________________________________________________________________________
c     STACK -- Stack/Add seismic traces using various weights.
c                                                            
c     Original Version by K. B. Taylor and R. B. Herrmann.
c
c     Additional options (Blackman, Hamming and Linear offset weights)
c     vectorization, restructuring and cleanup by K. J. Marfurt (11/2/92)
c
c     Mary Ann Thornton     August 28, 1995   
c     I changed stacksub.F to move DptInt into SrcPnt trace header for
c     plotting purposes.
C
c     Garossino    May 27, 1999
c      I removed reference to InTrCn in preparation for using that slot
c      for ProMax trace identifier.  This entry was not used for anything
c      but was written to indicating fold for that stacked trace.  Since
c      sample wise fold is ultimately more important better to use pstack -F
c
c     Garossino    Oct 2, 2001
c      added [ala windstat]: 
c
c     -LPV largest positive (> 0) value
c     -LNV largest negative (< 0) value 
c     -MAA maximum absolute value 
c     -MNZ minimum non-zero absolute value 
c     -MDA median of absolute values
c     -MED median
c     -SAV sum of absolute values
c     -STD standard deviation
c     -STP standard deviation of positive (> 0) values
c     -STN standard deviation of negative (< 0) values
c     -STA standard deviation of absolute values
c     -AVA average
c     -AAA average of absolute values
c     -APV average of positive values
c     -APN average of negative values
c 
c     default remains, sum divided by number of live samples
c     at a given sample position
c     removed mapmem logic to facilitate memory and access debugging
c     in workshop
c
c     Wade    Feb 13, 2002
c      Removed lntrhd, ITRWRD and SZLNHD from stacksub parameter list. 
c      These are defined via size_defs header file. Passing them confuses
c      the issue in the subroutine and screws up the workspace allocation.
c__________________________________________________________________________

      implicit none

#include <localsys.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>

c declare standard USP variables

      integer nbytes, lbytes, jerr
      integer ntr, nrec, ns, ne, irs, ire, luin
      integer luout, nsamp, nsi, iform, lbyout 
      integer argis

      character name * 5, ntap * 256, otap * 256

      logical verbos 

c variables used in dynamic memory allocation

      integer abort, errcd1, errcd2, errcd3, errcd4, errcd5, errcd6
      integer errcd7, errcd8
      integer icount

      real ugather, weight, usum, udenom, taper, xoff, theta

      pointer (mem_ugather, ugather(2) )
      pointer (mem_weight, weight(2) )
      pointer (mem_usum, usum(2) )
      pointer (mem_udenom, udenom(2) )
      pointer (mem_taper, taper(2) )
      pointer (mem_xoff, xoff(2) )
      pointer (mem_theta, theta(2) )
      pointer (mem_icount, icount(2) )

c local variables

      integer hbegin

      integer itr (SZLNHD)
      integer     holdi (SZLNHD)
      integer     holdo (SZLNHD)
      integer     bufin (SZLNHD)
      integer     bufout (SZLNHD)

      real        power

      logical semb, semwt, renum, dwgt, blackman, hamming, snorm, tnorm
      logical threed, BC
      logical LPV, LNV, MAA, MNZ, MDA, MED, SAV, STD, STP
      logical STN, STA, AVA, AAA, APV, APN, attribute

c declare variables picked up by implicit none

      integer ngath, ntpr, i
      integer lenhed, itot, meft, ntrout
      integer nreout, ireco, left, ipad, nd1, nd2, nl1, nl2, nd, nl
      integer ic, icc
      integer irec, l, nreco
      integer ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY
      integer ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX
      integer ifmt_SrRcMX, l_SrRcMX, ln_SrRcMX
      integer ifmt_SrRcMY, l_SrRcMY, ln_SrRcMY
      integer ifmt_FlReFn, l_FlReFn, ln_FlReFn
      integer ifmt_ToStUn, l_ToStUn, ln_ToStUn
      integer ifmt_ToTmAu, l_ToTmAu, ln_ToTmAu
      integer ifmt_RecNum, l_RecNum, ln_RecNum
      integer ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer ifmt_RecInd, l_RecInd, ln_RecInd
      integer ifmt_DphInd, l_DphInd, ln_DphInd
      integer ifmt_SrcLoc, l_SrcLoc, ln_SrcLoc
      integer ifmt_SrcPnt, l_SrcPnt, ln_SrcPnt
      integer ifmt_StaCor, l_StaCor, ln_StaCor
      integer ifmt_DstSgn, l_DstSgn, ln_DstSgn
      integer ifmt_LinInd, l_LinInd, ln_LinInd
      integer ifmt_SoPtNm, l_SoPtNm, ln_SoPtNm
      integer ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC
      integer ifmt_SrPtYC, l_SrPtYC, ln_SrPtYC
      integer ifmt_RcPtXC, l_RcPtXC, ln_RcPtXC
      integer ifmt_RcPtYC, l_RcPtYC, ln_RcPtYC
      integer ifmt_FoldNm, l_FoldNm, ln_FoldNm

      real d1pos, d2pos, d1neg, d2neg, xre, xreco

c initialize variables
 
      data name/'STACK'/
      data nbytes/0/
      data lbytes/0/
      data abort/0/

c-------------------------------------------------------------------
c     give command line help if requested and exit
c-------------------------------------------------------------------
      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 )then
         call help()
         stop
      endif
c-------------------------------------------------------------------
c     open printout file
c-------------------------------------------------------------------

#include <f77/open.h>

c---------------------------------------------------------------------------
c     Read program input parameters from command line argument flags
c---------------------------------------------------------------------------

      call cmdln(ntap, otap, d1pos, d2pos, d1neg, d2neg, ngath, ntpr, 
     1     power, ns, ne, irs, ire, semb, semwt, verbos, 
     2     renum, tnorm, snorm, dwgt, blackman, hamming, threed, BC,
     :     attribute, LPV, LNV, MAA, MNZ, MDA, MED, SAV, STD, STP,
     :     STN, STA, AVA, AAA, APV, APN )

c-------------------------------------------
c     Open input and output files
c-------------------------------------------

      call getln(luin,ntap,'r',0)
      call getln(luout,otap,'w',1)

c----------------------------------------------------
c     Read line header and save parameters
c----------------------------------------------------

      lbytes=0
      call rtape(luin,itr,lbytes)
      if(lbytes .eq. 0) then
         write(LERR,*)'STACK: no header read on unit ',luin
         write(LERR,*)'FATAL'
         stop
      endif

      call hlhprt(itr,lbytes,name,5,lerr)
      call saver(itr,'NumSmp',nsamp,LINEHEADER)
      call saver(itr,'SmpInt',nsi,LINEHEADER)
      call saver(itr,'NumTrc',ntr,LINEHEADER)
      call saver(itr,'NumRec',nrec,LINEHEADER)
      call saver(itr,'Format',iform,LINEHEADER)

      write(LERR,*) ' Values read from input data set lineheader'
      write(LERR,*) ' Number of Samples/Trace =  ', nsamp
      write(LERR,*) ' Sample Interval         =  ', nsi
      write(LERR,*) ' Traces per Record       =  ', ntr
      write(LERR,*) ' Records per Line        =  ', nrec
      write(LERR,*) ' Format of Data          =  ', iform

      lenhed=ITRWRD
      hbegin=1-lenhed

C check limits on traces

      if(ns .eq. 0) ns=1
      if(ne .eq. 0) ne=ntr
      ne=min(ne,ntr)

c check limits on records

      if(irs .eq. 0) irs=1 
      if(ire .eq. 0) ire=nrec
      ire=min(ire,nrec)

c---------------------------------------------------------------------------
c     print out parameters
c---------------------------------------------------------------------------
      write(LERR,*) ' Values read from command line'
      write(LERR,*) ' First record to process =  ', irs
      write(LERR,*) ' Last record to process  =  ', ire
      write(LERR,*) ' Starting trace number   =  ', ns
      write(LERR,*) ' Ending trace number     =  ', ne
      write(LERR,*) ' Output traces/rec       =  ', ntpr
      write(LERR,*) ' Force stacking gather   =  ', ngath
      write(LERR,*) ' Nth root power          =  ', power
      write(LERR,*) ' Positive spread: near dist = ',d1pos
      write(LERR,*) ' Positive spread: far  dist = ',d2pos
      write(LERR,*) ' Negative spread: near dist = ',d1neg
      write(LERR,*) ' Negative spread: far  dist = ',d2neg
      write(LERR,*) ' Change single trace records  '      
      write(LERR,*) '   single record multi trace=     ',renum    
      write(LERR,*) ' weight traces by distance?       ',dwgt     
      write(LERR,*) ' Apply Hamming weights?           ',hamming  
      write(LERR,*) ' Apply Blackman weights?          ',blackman 
      write(LERR,*) ' Apply equal, normalized weights? ',tnorm
      write(LERR,*) ' Normalize by nonzero samps?      ',snorm
      write(LERR,*) ' Apply semblance weights?         ',semwt
      write(LERR,*) ' Output semblance?                ',semb
      write(LERR,*) ' Input data 3D                    ', threed
      if (threed)
     1write(LERR,*) ' Compute bin center XYs from src/rcvr XYs',BC

      if (attribute)then

         write(LERR,*)' Stack attribute choosen '
         if ( LPV) 
     :write(LERR,*)'  largest positive (> 0) value'
         if ( LNV)
     :write(LERR,*)'  largest negative (< 0) value' 
         if ( MAA)
     :write(LERR,*)'  maximum absolute value' 
         if (  MNZ)
     :write(LERR,*)'  minimum non-zero absolute value' 
         if (  MDA)
     :write(LERR,*)'  median of absolute values'
         if (  MED)
     :write(LERR,*)'  median of values'
         if (  SAV)
     :write(LERR,*)'  sum of absolute values'
         if (  STD)
     :write(LERR,*)'  standard deviation of values'
         if (  STP)
     :write(LERR,*)'  standard deviation of positive (> 0) values'
         if (  STN)
     :write(LERR,*)'  standard deviation of negative (< 0) values'
         if (  STA)
     :write(LERR,*)'  standard deviation of absolute values'
         if (  AVA)
     :write(LERR,*)'  average of values'
         if (  AAA)
     :write(LERR,*)'  average of absolute values'
         if (  APV)
     :write(LERR,*)'  average of positive values'
         if (  APN)
     :write(LERR,*)'  average of negative values'
      endif

      write(LERR,*) ' Verbose output?                  ',verbos
c----------------------------------------------------
c     print out header parameters
c----------------------------------------------------
      if(ngath .eq. 0) ngath = ntr
      write(LERR,*) ' Traces/gather           =  ', ngath
c---------------------------------------------------------------------------
c     Check bounds of input parameters and set values to defaults
c---------------------------------------------------------------------------
      call cmdchk(ns,ne,irs,ire,ntr,nrec)
c-------------------------------------------------------------
c     reorganize output traces/rec based on new ngath
c     and ntpr (number traces/rec output) entry
c-------------------------------------------------------------
      if(ngath .ne. ntr) then
         if(irs.ne.1 .and. ire.ne. nrec .and. 
     &         ns.ne.1 .and. ne.ne.ntr) then
            write(LERR,*)'If ngath not = input gather size, start/end'
            write(LERR,*)'records & traces must be left to default'
            write(LERR,*)'Rerun with these defaults'
            stop
         endif
         itot = ntr*nrec
         xre = float(itot)/float(ngath)
         ire = xre
         meft = itot - ngath*ire
         ire = xre + .99
         write(LERR,*)'xre= ',xre,' ire= ',ire,' meft= ',meft
         irs = 1
         ns = 1
         ne = ngath
      endif
      ntrout = ire - irs + 1
      nreout = ne - ns + 1
      if(ntpr .gt. ntrout) ntpr = ntrout
c   number output records
      xreco = float(ntrout)/float(ntpr)
      nreco = xreco + 0.99
      ireco = xreco 
      left = ntrout - ireco*ntpr
      ipad = ntpr - left
      write(LERR,*)'left= ',left,' ntrout= ',ntrout,' ntpr= ',ntpr

c-------------------------------------------------------------
c        save key parameters in line header; save command
c        line in historical line header
c-------------------------------------------------------------
      call saver(itr, 'MnDpIn', nd1 , LINHED)
      call saver(itr, 'MxDpIn', nd2 , LINHED)
      call saver(itr, 'MnLnIn', nl1 , LINHED)
      call saver(itr, 'MxLnIn', nl2 , LINHED)

      if(renum) then
         if(ntpr .ne. 1) then
            write(LERR,*) 'ntpr = ',ntpr,' .ne. 1 !'
            write(LERR,*) 'cannot do a simple renumbering using -R'
     1               //' option'
            stop 666
         endif 
         call savew( itr, 'NumTrc', nreco, LINHED)
         call savew( itr, 'NumRec', ntpr , LINHED)
      else
         call savew( itr, 'NumTrc', ntpr , LINHED)
         call savew( itr, 'NumRec', nreco, LINHED)
         if (threed) then
            nd = nd2 - nd1 + 1
            nl = nl2 - nl1 + 1
            call savew( itr, 'NumTrc', nl , LINHED)
            call savew( itr, 'NumRec', nd , LINHED)
         endif

      endif

      call savhlh( itr, lbytes, lbyout)
      call WRTAPE (luout, itr, lbyout)

      call savelu('TrcNum',ifmt_TrcNum,l_trcnum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_recnum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_srcloc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_recind,ln_RecInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_dstsgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_stacor,ln_StaCor,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('FlReFN',ifmt_FlReFN,l_FlReFN,ln_FlReFN,TRACEHEADER)
      call savelu('ToStUn',ifmt_ToStUn,l_ToStUn,ln_ToStUn,TRACEHEADER)
      call savelu('ToTmAU',ifmt_ToTmAU,l_ToTmAU,ln_ToTmAU,TRACEHEADER)
      call savelu('SrcPnt',ifmt_SrcPnt,l_SrcPnt,ln_SrcPnt,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
      call savelu('FoldNm',ifmt_FoldNm,l_FoldNm,ln_FoldNm,TRACEHEADER)
      call savelu('SrRcMX',ifmt_SrRcMX,l_SrRcMX,ln_SrRcMX,TRACEHEADER)
      call savelu('SrRcMY',ifmt_SrRcMY,l_SrRcMY,ln_SrRcMY,TRACEHEADER)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('FoldNm',ifmt_FoldNm,l_FoldNm,ln_FoldNm,TRACEHEADER)

c dynamic memory allocation

      call galloc ( mem_ugather, nsamp*ngath*SZSMPD, errcd1, abort )
      call galloc ( mem_weight, nsamp*ngath*SZSMPD, errcd2, abort )
      call galloc ( mem_usum, nsamp*SZSMPD, errcd3, abort )
      call galloc ( mem_udenom, nsamp*SZSMPD, errcd4, abort )
      call galloc ( mem_icount, nsamp*SZSMPD, errcd5, abort )
      call galloc ( mem_taper, ngath**2*SZSMPD, errcd6, abort )
      call galloc ( mem_xoff, ngath*SZSMPD, errcd7, abort )
      call galloc ( mem_theta, ngath*SZSMPD, errcd8, abort )

      if ( errcd1 .ne. 0 .or. 
     :     errcd2 .ne. 0 .or. 
     :     errcd3 .ne. 0 .or. 
     :     errcd4 .ne. 0 .or. 
     :     errcd5 .ne. 0 .or. 
     :     errcd6 .ne. 0 .or. 
     :     errcd7 .ne. 0 .or. 
     :     errcd8 .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 2*nsamp*ngath*SZSMPD, '  bytes'
         write(LERR,*) 3*nsamp*SZSMPD, '  bytes'
         write(LERR,*) ngath**2*SZSMPD, '  bytes'
         write(LERR,*) 2*ngath*SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 2*nsamp*ngath*SZSMPD, '  bytes'
         write(LER,*) 3*nsamp*SZSMPD, '  bytes'
         write(LER,*) ngath**2*SZSMPD, '  bytes'
         write(LER,*) 2*ngath*SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 2*nsamp*ngath*SZSMPD, '  bytes'
         write(LERR,*) 3*nsamp*SZSMPD, '  bytes'
         write(LERR,*) ngath**2*SZSMPD, '  bytes'
         write(LERR,*) 2*ngath*SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory

      call vclr ( ugather, 1, nsamp*ngath )
      call vclr ( weight, 1, nsamp*ngath )
      call vclr ( usum, 1, nsamp )
      call vclr ( udenom, 1, nsamp )
      call vclr ( icount, 1, nsamp )
      call vclr ( taper, 1, ngath**2 )
      call vclr ( xoff, 1, ngath )
      call vclr ( theta, 1, ngath )

c---------------------------------------------------------------------
c     get weights for all possible combination of live samples.
c     for non unitary weights, the traces should be sorted by distance,
c     be equally spaced, and have dead traces interpolated.
c---------------------------------------------------------------------

      call getwgt ( taper, theta, xoff, ngath, lerr, hamming, blackman, 
     :     tnorm, snorm, verbos )

c---------------------------------------------------------------------
c     Skip unwanted records if necessary.  Skipping is done
c     in groups of ntr traces per record.
c---------------------------------------------------------------------

      call recskp(1,irs-1,luin,ntr,bufin)    
c
      ic=1
      icc = 0
      irec = 1
      do 10000 i=irs,ire
c-----------------------------------------------------------------------------
c      if no. traces in gather is not input no. traces/gath we may have some 
c      traces in input left over, i.e. partial gather
c-----------------------------------------------------------------------------
       if(ngath .ne. ntr .and. i .eq. ire .and. meft.ne.0)ngath = meft

       call stacksub(bufin,bufin,bufout,bufout,threed,BC,nsamp,
     1      nbytes,holdi,holdo,renum, attribute,ugather, usum, udenom, 
     2      weight,xoff,taper,icount,power,ic,icc,irs,ire,
     3      irec,ngath,ntpr,ifmt_CDPBCY,hbegin,luin,luout,lerr,verbos,
     4      ns,ne,ifmt_CDPBCX,semb,semwt,snorm,dwgt,l_CDPBCX,ln_CDPBCX,
     5      ln_CDPBCY,d1neg,d2neg,d1pos,d2pos,l_SrRcMX,l_SrRcMY,
     6      l_CDPBCY,l_FlReFN,l_ToStUn,l_ToTmAU,l_RecNum,l_TrcNum,
     7      l_RecInd,l_DphInd,l_SrcLoc,l_SrcPnt,l_StaCor,l_DstSgn,
     8      l_LinInd,l_SoPtNm,ln_SrRcMX,ln_FlReFN,ln_ToStUn,ln_ToTmAU,
     9      ln_RecNum,ln_TrcNum,ln_RecInd,ln_DphInd,ln_SrcLoc,ln_SrcPnt,
     a      ln_StaCor,ln_DstSgn,ln_LinInd,ln_SoPtNm,ln_SrRcMY,
     b      ifmt_FlReFN,ifmt_ToStUn,ifmt_ToTmAU,ifmt_RecNum,
     c      ifmt_TrcNum,ifmt_RecInd,ifmt_DphInd,ifmt_SrcLoc,
     d      ifmt_SrcPnt,ifmt_StaCor,ifmt_DstSgn,ifmt_LinInd,ifmt_SoPtNm,
     e      ifmt_SrRcMX,ifmt_SrRcMY,ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,
     f      ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,ifmt_RcPtXC,l_RcPtXC,
     g      ln_RcPtXC,ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,ifmt_FoldNm,
     h      l_FoldNm,ln_FoldNm, LPV, LNV, MAA, MNZ, MDA, MED, SAV, STD, 
     i      STP, STN, STA, AVA, AAA, APV, APN )

c 
c *** check if nbytes is zero, i.e., end of file reached on input
c *** if so, jump out of do loop
c *** message was written out in stacksub
c

      if (nbytes .eq. 0) go to 11000

10000 continue
11000 if(left .ne. 0) then
c_______________________________________________________________________
c        pad the last record.               
c_______________________________________________________________________
         do 20000 l = 1, ipad
          icc = icc + 1
          call savew2(bufout,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                irec  , TRACEHEADER)
          call savew2(bufout,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                icc   , TRACEHEADER)
          call savew2(bufout,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                30000 , TRACEHEADER)
          call wrtape(luout,bufout,nbytes)
20000    continue
      endif
c-------------------------------------------
c     Normal Termination; Close files and end program
c-------------------------------------------

      call lbclos(luin)
      call lbclos(luout)
      write(lerr,*)'Normal Termination'
      close(lerr)  
      write(ler,*)'stack: Normal Termination'

      stop

 999  continue

c-------------------------------------------
c     Abnormal Termination; Close files and end program
c-------------------------------------------

      call lbclos(luin)
      call lbclos(luout)
      
      write(lerr,*)'Abnormal Termination'
      close(lerr)  
      write(ler,*)'stack: Abnormal Termination'

      stop
      end


c -----------------  Subroutine -----------------------

      subroutine help

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for stack: stack gathers'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman or see the USP'
      write(LER,*)' intranet site '
      write(LER,*)' '
      write(LER,*)'Input......................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                     (stdin)'
      write(LER,*)'-O[]   -- output data set                   (stdout)'
      write(LER,*)'-rs[]  -- start record                           (1)'
      write(LER,*)'-re[]  -- end record                   (last record)'
      write(LER,*)'-ns[]  -- start trace number                     (1)'
      write(LER,*)'-ne[]  -- end trace number              (last trace)'
      write(LER,*)' '
      write(LER,*)' Distance Limiting Options'
      write(LER,*)' '
      write(LER,*)'-d2neg[] -- far negative distance (-ve #) (not used)'
      write(LER,*)'-d1neg[] -- near negative distance (-ve #)(not used)'
      write(LER,*)'-d1pos[] -- near positive distance        (not used)'
      write(LER,*)'-d2pos[] -- far positive distance         (not used)'
      write(LER,*)' '
      write(LER,*)' Weighting Options'
      write(LER,*)' '
      write(LER,*)' Choose 1 weighting option OR 1 Attribute'
      write(LER,*)' '
      write(LER,*)'-H -- if present, weight stack with hamming taper'         
      write(LER,*)'-B -- if present, weight stack with blackman taper'         
      write(LER,*)'-D -- if present, weight stack with offset'        
      write(LER,*)'-swt -- if present, weight stack with semblance'      
      write(LER,*)' '
      write(LER,*)' Attribute Options'
      write(LER,*)' '
      write(LER,*)' Choose 1 weighting option OR 1 Attribute'
      write(LER,*)' '
      write(LER,*)'-LPV -- largest positive (> 0) value '
      write(LER,*)'-LNV -- largest negative (< 0) value '
      write(LER,*)'-MAA -- maximum absolute value' 
      write(LER,*)'-MNZ -- minimum non-zero absolute value' 
      write(LER,*)'-MDA -- median of absolute values'
      write(LER,*)'-MED -- median'
      write(LER,*)'-SAV -- sum of absolute values'
      write(LER,*)'-STD -- standard deviation'
      write(LER,*)'-STP -- standard deviation of positive (> 0) values'
      write(LER,*)'-STN -- standard deviation of negative (< 0) values'
      write(LER,*)'-STA -- standard deviation of absolute values'
      write(LER,*)'-AVA -- average'
      write(LER,*)'-AAA -- average of absolute values'
      write(LER,*)'-APV -- average of positive values'
      write(LER,*)'-APN -- average of negative values'
      write(LER,*)'-sem -- semblance'
      write(LER,*)' '
      write(LER,*)' Miscellaneous Options'
      write(LER,*)' '
      write(LER,*)'-S -- if present, normalize by # of live traces' 
      write(LER,*)'      in the gather (same for all times)'
      write(LER,*)'-L -- if present, normalize by # of live samples'
      write(LER,*)'      at each time'
      write(LER,*)'-R -- if present, change line header to be one '
      write(LER,*)'      record, multiple traces (MBS model building)'
      write(LER,*)'-gath[] -- input traces/gather    (input lineheader)'
      write(LER,*)'-pw[] -- nth root power                        (1.0)'
      write(LER,*)'-tr[] -- output number traces/rec                (1)'
      write(LER,*)'-threed -- if present, output is assumed to be 3D '
      write(LER,*)'           from sr3d2, '
      write(LER,*)'           # trcs/rec set to be # of DIs'
      write(LER,*)'           # recs will be # LIs'
      write(LER,*)' '
      write(LER,*)'-BC -- if present, compute CDP XYs from S/R XYs'
      write(LER,*)'-V  -- verbose printout'
      write(LER,*)' '
      write(LER,*)'Usage:  ' 
      write(LER,*)'       stack -N[ntap] -O[otap] -rs[] -re[] -ns[]'
      write(LER,*)'             -ne[] -d2neg[] -d1neg[] -d1pos[] '
      write(LER,*)'             -d2pos[] [ -ngath[] -ntpr[] -pw[] '
      write(LER,*)'             -H -B -D -sem -swt -L  -R -threed -BC '
      write(LER,*)'             -LPV -LNV -MAA -MNZ -MDA -MED -SAV -STD'
      write(LER,*)'             -STP -STN -STA -AVA -AAA -APV -APN -V ]'
      write(LER,*)' '
      write(LER,*)'===================================================='

      return
      end

      subroutine cmdln ( ntap, otap, d1pos, d2pos, d1neg, d2neg, ngath, 
     1     ntpr, power, ns, ne, irs, ire, semb, semwt, 
     2     verbos, renum, tnorm, snorm, dwgt, blackman, hamming, threed,
     3     BC, attribute, LPV, LNV, MAA, MNZ, MDA, MED, SAV, STD, STP,
     :     STN, STA, AVA, AAA, APV, APN )
c-----
c     get command arguments
c
c      ns   - I      start trace
c      ne   - I      stop end trace
c     irs   - I      start record
c     ire   - I      stop end record
c    d1pos  - R      min distance to stack (positive side of spread)
c    d2pos  - R      max distance to stack (negative side of spread)
c    d1neg  - R      min distance to stack (positive side of spread)
c    d2neg  - R      max distance to stack (negative side of spread)
c    ntpr   - I      number traces per rec on output
c    ngath  - I      force number traces in gather to stack
c     ntpr  - I      output number traces/record
c     power  - R      take nth nth root, stack, then nth power
c   snorm   - L      normalize stacked trace by # live samples
c    semb   - L      output semblance
c    semwt  - L      output semblance weghted stack
c    verbos - L      verbose output or not
c    attribute - C   attribute to output rather than stacked amplitude
c-----

      implicit none

#include <f77/iounit.h>

      integer   ns,ne,irs,ire,ngath,ntpr, argis

      real      d1pos,d2pos,d1neg,d2neg,power

      character ntap*(*), otap*(*)

      logical   semb,semwt,verbos,renum
      logical   dwgt,blackman,hamming,snorm,tnorm,threed,BC
      logical   LPV, LNV, MAA, MNZ, MDA, MED, SAV, STD, STP
      logical   STN, STA, AVA, AAA, APV, APN, attribute

c declare local variables

      integer ierror, noption, nattribute
c----------------------------------------------------------------------------
c        ARGXXX has parameters
c             ( flag, variable name, default value, format error value )
c-----------------------------------------------------------------------------
      AAA = ( argis ('-AAA') .gt. 0 )
      APN = ( argis ('-APN') .gt. 0 )
      APV = ( argis ('-APV') .gt. 0 )
      AVA = ( argis ('-AVA') .gt. 0 )

      BC       =( argis ('-BC') .gt. 0 )
      blackman =( argis ('-B') .gt. 0 )

      call argr4  ('-d2neg', d2neg, -99999., -99999.)
      call argr4  ('-d1neg', d1neg, -00000., -00000.)
      call argr4  ('-d1pos', d1pos,  00000.,  00000.)
      call argr4  ('-d2pos', d2pos,  99999.,  99999.)
      dwgt  = ( argis ('-D') .gt. 0 )

      call argi4  ('-gath', ngath, 0, 0)
 
      hamming  =( argis ('-H') .gt. 0 )

      LNV = ( argis ('-LNV') .gt. 0 )
      LPV = ( argis ('-LPV') .gt. 0 )
      snorm = ( argis ('-L') .gt. 0 )

      MAA = ( argis ('-MAA') .gt. 0 )
      MDA = ( argis ('-MDA') .gt. 0 )
      MED = ( argis ('-MED') .gt. 0 )
      MNZ = ( argis ('-MNZ') .gt. 0 )

      call argi4  ('-ns', ns, 0, 0)
      call argi4  ('-ne', ne, 0, 0)
      call argstr('-N',ntap,' ',' ')

      call argstr('-O',otap,' ',' ' )

      call argr4  ('-pw', power, 1.0, 1.0)

      call argi4  ('-rs', irs, 0, 0)
      call argi4  ('-re', ire, 0, 0)
      renum = ( argis ('-R') .gt. 0 )

      SAV  = ( argis ('-SAV') .gt. 0 )
      STA  = ( argis ('-STA') .gt. 0 )
      STD  = ( argis ('-STD') .gt. 0 )
      STN  = ( argis ('-STN') .gt. 0 )
      STP  = ( argis ('-STP') .gt. 0 )
      semb  = ( argis ('-sem') .gt. 0 )
      semwt = ( argis ('-swt') .gt. 0 )
      tnorm = ( argis ('-S') .gt. 0 )

      threed   =( argis ('-threed') .gt. 0 )
      call argi4  ('-tr', ntpr, 1, 1)

      verbos = ( argis ('-V') .gt. 0 )

c policemen:

      ierror=0
      noption=0
      nattribute=0

c make sure only a single attribute is requested

      if ( LPV ) then
         attribute = .true.
         nattribute = nattribute + 1
      endif
      if ( LNV ) then
         attribute = .true.
         nattribute = nattribute + 1
      endif
      if ( MAA ) then
         attribute = .true.
         nattribute = nattribute + 1
      endif
      if ( MNZ ) then
         attribute = .true.
         nattribute = nattribute + 1
      endif
      if ( MDA ) then
         attribute = .true.
         nattribute = nattribute + 1
      endif
      if ( MED ) then
         attribute = .true.
         nattribute = nattribute + 1
      endif
      if ( SAV ) then
         attribute = .true.
         nattribute = nattribute + 1
      endif
      if ( STD ) then
         attribute = .true.
         nattribute = nattribute + 1
      endif
      if ( STP ) then
         attribute = .true.
         nattribute = nattribute + 1
      endif
      if ( STN ) then
         attribute = .true.
         nattribute = nattribute + 1
      endif
      if ( STA ) then
         attribute = .true.
         nattribute = nattribute + 1
      endif
      if ( AVA ) then
         attribute = .true.
         nattribute = nattribute + 1
      endif
      if ( AAA ) then
         attribute = .true.
         nattribute = nattribute + 1
      endif
      if ( APV ) then
         attribute = .true.
         nattribute = nattribute + 1
      endif
      if ( APN ) then
         attribute = .true.
         nattribute = nattribute + 1
      endif

      if ( attribute ) then
         if (nattribute .gt. 1 ) then
         write(lerr,*) 'command line error in routine STACK!'
         write(lerr,*) 'can only invoke one attribute at a time:'
         write(lerr,*) 'number of attributes chosen = ',nattribute
         ierror=ierror+1
         endif
      endif

c default stack power to unity

      if (power .eq. 0.0) power = 1.0

c support only one stack option at a time

      if(semb) noption=noption+1
      if(semwt) noption=noption+1
      if(power .ne. 1.) noption=noption+1
      if(blackman) noption=noption+1
      if(hamming) noption=noption+1
c
      if(noption .gt. 1) then
         write(lerr,*) 'command line error in routine STACK!'
         write(lerr,*) 'can only invoke one of the following options:'
         write(lerr,'(a10,l10)') '-sem',semb,'-swt',semwt,
     1                     '-B',blackman,'-H',hamming
         write(lerr,'(a10,f10.1)') '-pw',power           
         write(lerr,*) 'number of options chosen = ',noption
         ierror=ierror+1
      endif
 
c---------------------------------------------
c     check range limiting parameters
c---------------------------------------------
      if(d1neg .lt. d2neg) then
        write(LERR,*)'d1neg should be near range negative side of spread
     1(a -ve number)'
        write(LERR,*)'d2neg should be far range negative side of spread
     1(a -ve number)'
        write(LERR,*)'Check command line arguments & rerun'

        ierror=ierror+1

      endif

      if(d1pos .gt. d2pos) then
        write(LERR,*)'d1pos should be near range '
     1                //'positive side of spread'
        write(LERR,*)'d2pos should be far range '                       
     1                //'positive side of spread'
        write(LERR,*)'Check command line arguments & rerun'

        ierror=ierror+1

      endif
c
      if(ierror .ne. 0) then

         write(lerr,*) ' STACK aborted due to ', ierror
         write(lerr,*) ' errors on the command line'
         write(ler,*) ' '
         write(ler,*) 'STACK:'
         write(ler,*) ' errors on the command line'
         write(ler,*) ' check printout file for details'
         write(ler,*) 'FATAL'
         write(ler,*) ' '
         call exitfu(666)
      endif

      return
      end
