C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine GetVelDepths ( nseg, index, traces, times, luvel, 
     :     velocities, depths, ntrc, nrec, nsamp, nsi)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      integer nseg, index(2*SZSMPM,2), luvel, nsamp, nsi
      integer pickndx, nbytes
      integer itr(SZLNHD)

      real tri(SZLNHD)
      real traces(*), times(*), velocities(*), depths(*)

      pickndx = 0

      do i = 1, nseg
         
         do j = 1,index(i,1)

            pickndx = pickndx + 1

c determine record and trace from which to get the next velocity

            if ( ntrc .eq. 1 ) then
               irec = nint(traces(pickndx))
               call recskp(1,irec-1,luvel,ntrc,itr)
               call trcskp(1,1,0,luvel,ntrc,itr)
            else
               itrc = nint(traces(pickndx))
               call recskp(1,0,luvel,ntrc,itr)
               call trcskp(1,1,itrc-1,luvel,ntrc,itr)
            endif

c skip to correct location on velocity dataset and read velocity trace

            call rtape (luvel, itr, nbytes)
            if(nbytes.eq.0)then
               write(LERR,*)'STACKLAY: No Velocity Data At Record ',
     :              irec,' trace ',itrc
               write(LERR,*)'FATAL'
               stop
            endif

            call vmov (itr(ITHWP1),1,tri,1,nsamp)

c load the index of the appropriate velocity for the given pick

            ismp = nint(times(pickndx))

c calculate depth at pick using average velocity and two-way time

            velocities(pickndx) = tri(ismp)
            depths(pickndx) = times(pickndx) / 
     :           2000. * velocities(pickndx) * float(nsi)

         enddo
      enddo

      return
      end
            

            

      
