C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ReadPick ( lu, index, records, traces, times, count, 
     :     nseg, mul, spinit, spincr, PickType, mnemonic, ntrc, nsi, 
     :     verbos ) 

c I have changed this from the default ReadPick routine to put color
c in index(1,2) rather than record number

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c ----------------------------------------------------------------------
c	routine to read in mute control pick file from device lu 
c	correct for duplicate trace numbers 
c       correct for duplicate times
c	correct for first or last picks outside record boundaries
c       correct file for reverse pick order within record
c       correct record index as per command line input if required
c       output is time in samples
c ----------------------------------------------------------------------

      integer lu, index(2*SZSMPM,2), npicks, i, count, mul, nseg
      integer spinit, spincr, pointer, ntrc, nsi

      real   recnum, records(*), traces(*), times(*), oldrec, value

      character ajunk*1, key*10, name*20, PickType*(*), mnemonic*(*)
 
      logical verbos

c Variables passed from Main

c Integer
c
c     lu : logical unit connected to pick file
c     index : array to contain pick index information
c     nseg : number of segments in pick file
c     count : total number of picks in file (check this)
c     mul : time indices multiplier (to adjust for delta t on command line)
c     spinit : initial shot point from command line 
c     spincr : shot pint increment from command line
c     PickType : indicates file is pick format or header values at picks
c     mnemonic : if header values then this is the key to read as record number
c
c Real
c
c     records : array for record numbers
c     traces : array for segment trace values
c     times : array for segment time values
c
c Logical
c
c     verbos : verbose output flag

c Local Variables
c
c Integer
c
c     i : loop counter
c     npicks : number of picks in a given segment
c     pointer : pointer to traces and times arrays
c
c Real
c
c     recnum : record number of given segment
c     oldrec : record number of previously read segment element
c
c  Character
c
c     ajunk : used to find segment boundaries

c START

c determine type of pickfile in use
       
      IF ( PickType .ne. 'header' ) then

c using standard rec,trace,sample format pick file traces/record from pick file header 

         read(lu,'(51x,i5)')ntr

c initialize element and segmentcounters

         npicks = 0
         nseg = 1

c read segment header, need two reads to get past 1st header while still counting picks

         read(lu,'(a1)',end=20) ajunk

c for subsequent segments start at statement 1 

 1       read(lu,'(a1)',end=20) ajunk

c scan for next segment header while advancing counter
c record number of picks in segment in index(I,1)
c tag number of segments in variable nseg

         if(ajunk .ne. 'S') then
            npicks = npicks + 1
            goto 1
         else
            index(nseg,1) = npicks
            if (verbos) then
               write(LERR,*) ' segment number : ', nseg 
               write(LERR,*) ' number of picks : ', npicks 
            endif

c advance segment register and reset element counter 

            nseg = nseg + 1
            npicks = 0

c start next segment

            goto 1
         endif

c have reached end of pick file assign number of picks for last segment

 20      index(nseg,1) = npicks
      
         if (verbos) then
            write(LERR,*) ' segment number : ', nseg 
            write(LERR,*) ' number of picks : ', npicks 
         endif

c now know total number of segments and number of picks in each
	
         rewind lu

c read and quality control each segment

         read(lu,'(a1)') ajunk

c reset array total element counter

         count = 1

c SEGMENT LOOP 

         do 30 i = 1,nseg

c read segment header and get color to store in index(i,2)

            read(lu,'(51x,i5)')index(i,2)
 101        format(15x,26x,10x,i5)

c ELEMENT LOOP 

            do 40 j = 1,index(i,1)

               if ( ntr .eq. 1) then
                  read(lu,50)traces(count),recnum,times(count)
               
c handle renumbering of records if requested remember in this mode traces = recs 

                  if(spinit.ne.-9999)then
                    traces(count)=float(spinit)+float(j-1)*float(spincr)
                  endif

               else

                  read(lu,50)recnum, traces(count), times(count)
 50               format(f12.6,2f13.6)

               endif

c adjust times if requested

               if(mul.gt.-9999)times(count) = times(count) * float(mul)

c convert to samples

               times(count) = times(count) / float(nsi)

c QC TESTS

               if ( ntr .gt. 1 ) then


c FIRST digitized point out of record
                
                  if(j.eq.2.and.oldrec.ne.recnum)then

c renumber trace entry on first pick element accordingly

                     if(traces(count-1).gt.traces(count))then
                        traces(count-1) = 1
                     elseif(traces(count-1).lt.traces(count))then
                        traces(count-1) = ntr
                     else
                        write(LERR,*)' something weird in pick file '
                        stop
                     endif
                  endif

c LAST digitized point out of record 

                  if(j.eq.index(i,1).and.oldrec.ne.recnum)then
                     if(traces(count-1).gt.traces(count))then
                        traces(count) = ntr
                     elseif(traces(count-1).lt.traces(count))then
                        traces(count) = 1
                     else
                        write(LERR,*)' something weird in pick file '
                        stop
                     endif

c set recnum to oldrec

                     recnum = oldrec
                  endif

c increment indices

               endif

               oldrec = recnum
               count = count + 1

c ELEMENT LOOP END 

 40         continue

c determine trace order and sort if necessary 

            pointer = count-index(i,1)

            if(traces(pointer).gt.traces(pointer+1))then
               call hsort2(index(i,1),traces(pointer),times(pointer))
            endif

c handle duplicate picks in pick file 

            do j = pointer+1,pointer+index(i,1)-1
               if(traces(j).eq.traces(j-1).and.j.gt.pointer)then
                  traces(j) = traces(j-1) + 1.
               endif
            enddo

c use initial record number if requested 

            if(i.lt.2)then
               if(spinit.ne.-9999)recnum = float(spinit)
            endif

c SEGMENT LOOP END 

 30      continue

c decrement count as it was started at 1 

         count = count-1

c write out picks to printout file for QC

	if (verbos) then
        pointer = 0
        do i = 1,nseg
           if ( ntrc .eq. 1 ) then
              write(LERR,*)' Segment ',i
           endif
           write(LERR,*)' Offset           Time'
           do j = 1,index(i,1)
              pointer = pointer + 1
              write(LERR,*)traces(pointer),times(pointer)*float(nsi)
           enddo
        enddo
	endif

         return

      ELSE

c using new header key,value pickfile format 
c need to define count,nseg,traces,times,index
c index[a,b] where a is recnum b is npicks

         count = 0
         nseg = 0

         DO while(1.eq.1)
            
            read(lu,'(a10,1x,f17.6)',end=200)key,value

C Get sample units 
           if (key.EQ.'UnitSmp') then
              if(mul.eq.-9999)mul = nint(value)
           endif
        
C Get colour 
           if (key.EQ.'Color') then
              index(nseg,2) = nint(value)
           endif
        
C Increment counter for segment and reset pick counter.
C Get segment name.
           if (key.EQ.'Segment') then
              nseg=nseg+1
              read(lu,'(a10,1x,a20)',end=200)key,name
           endif

C Increment counter for pick.
           if (key.EQ.'Pick') then
              count=count+1
           endif

C Store the number of picks for that segment.
           if (key.EQ.'Picks') then
              index(nseg,1)=nint(value)
              if (verbos) then
                 write(LERR,*) ' segment number : ',nseg 
                 write(LERR,*) ' number of picks : ',index(nseg,1)
              endif
           endif
           
C Store the trace header record number for pick.
           if ( key .EQ. mnemonic ) then
              records(count) = value
           endif
           
C Store the trace identifier for trace.

           if ( ntrc .eq. 1 ) then
              
              if (key.EQ.'RecNum') then
                 traces(count)=value
              endif

           else
              
              if (key.EQ.'TrcNum') then
                 traces(count)=value
              endif

           endif
           
C Store the sample value for pick.
           if (key.EQ.'Sample') then
              times(count)=value
           endif

        ENDDO           

 200    continue

c go through digitization and qc for faults 

c initialize array pointer

        pointer = 0

c SEGMENT LOOP

        DO i = 1,nseg

c PICKS LOOP

           do j = 1,index(i,1)

c advance array pointer

              pointer = pointer + 1

c POLICEMEN

c FIRST digitized point outside record boundaries
                
              if ( j .eq. 2 .and. 
     :             records(pointer-1) .ne. records(pointer) .and. 
     :             ntrc .gt. 1 )then

c flag illegal pick offset as 999999

                 traces(pointer-1)=999999.
                 write(LERR,*)'PICKLAY: Picks digitized outside record'
                 write(LERR,*)'        boundaries at record ',
     :                records(pointer)
                 write(LERR,*)'        These picks will be ignored with'
                 write(LERR,*)'        yielding unpredictable results.'      
                 write(LERR,*)'        Fix Picks and re-run if desired'
                 write(LERR,*)'WARNING'      
              endif

c LAST digitized point out of record

              if( j .eq. index(i,1) .and. 
     :             records(pointer-1) .ne. records(pointer) .and. 
     :             ntrc .gt. 1 )then

c flag illegal pick offset as 999999

                 traces(pointer-1)=999999.

                 write(LERR,*)'PICKLAY: Picks digitized outside record'
                 write(LERR,*)'        boundaries at record ',
     :                records(pointer)
                 write(LERR,*)'        These picks will be ignored with'
                 write(LERR,*)'        yielding unpredictable results.'      
                 write(LERR,*)'        Fix Picks and re-run if desired'
                 write(LERR,*)'WARNING'      
              endif

c END PICKS LOOP

           enddo

c move pointer back to start of segment 

           pointer = pointer - index(i,1) + 1

c sort offsets into increasing order 

           call hsort2(index(i,1),traces(pointer),times(pointer))

c handle duplicate picks - since we are working with offsets 
c adding one foot or meter to the last value shouldn't cause
c any trouble with the resultant curve

           do j=pointer+1,pointer+index(i,1)-1
              if(traces(j).eq.traces(j-1).and.j.gt.pointer)then
                 traces(j)=traces(j-1)+1.
              endif
           enddo

c move pointer back to current position in arrays

           pointer = pointer + index(i,1) -1

c END SEGMENT LOOP

        ENDDO           
        
c now should have all pick segments in increasing offset order with flagged
c offsets at the max side (right side) and correct colors in index(i,2)slot
c also all times should be correct for any command line override dt and converted
c to samples

c output picks to printfile for QC

        pointer = 0
        do i = 1,nseg
           if ( ntrc .eq. 1 ) then
              write(LERR,*)' Segment ',i
           endif
           write(LERR,*)' Offset           Time'
           do j = 1,index(i,1)
              pointer = pointer + 1
              write(LERR,*)traces(pointer),times(pointer)*float(nsi)
           enddo
        enddo

        return

      ENDIF

      end
