C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine sample_sums(sums, u, isamp, im)
      implicit none

c Kelly D. Crawford	04/09/97
c
c Bertram Kaufhold	05/01/98	Modification
c
c Generates rolling sample sums.  Given a one-dimensional array,
c u(i), generate rolling i-dimension-sums (column) of length 2*iap+1. 
c For example, if iap = 2, sums(4) = u(2) + ... + u(6).
c This code also computes partial sums for sums(i) where i < im and
c i > isamp-im+1 (Note-> im = iap+1)

      integer isamp, im
      double precision sums(isamp)
      real u(isamp)

      integer i, iap

      iap = im - 1

c     Compute partial sums for sums(1)

      sums(1) = u(1)
      do i = 2, im
         sums(1) = sums(1) + u(i)
      enddo

c     Compute partial sums for i < im, and a full sum for i == im

      do i = 2, im
         sums(i) = sums(i-1) + u(i+iap)
      enddo

c     Compute full rolling window sums for im+1 <= i <= isamp-iap
c     by dropping the sample value immediately above the rolling window
c     and adding the sample value at the bottom of the rolling window.

      do i = im+1, isamp-iap
         sums(i) = sums(i-1) + (u(i+iap) - u(i-im))
      enddo

c     Compute partial sums for i >= isamp-im+2

      do i = isamp-im+2, isamp
         sums(i) = sums(i-1) - u(i-im)
      enddo

      end

      subroutine isample_sums(livesum, liverec, NumTrc, jm)
      implicit none

c Kelly D. Crawford	04/09/97
c
c Bertram Kaufhold	05/01/98	Modification
c

      integer NumTrc, jm
      integer livesum(NumTrc), liverec(NumTrc)

      integer i

c     Compute partial sums for livesum(1)

      livesum(1) = liverec(1)
      do i = 2, jm
         livesum(1) = livesum(1) + liverec(i)
      enddo

c     Compute partial sums for i < jm, and a full sum for i == jm

      do i = 2, jm
         livesum(i) = livesum(i-1) + liverec(i+jm-1)
      enddo

c     Compute full rolling window sums for jm+1 <= i <= NumTrc-jm+1
c     by dropping the sample value immediately above the rolling window
c     and adding the sample value at the bottom of the rolling window.

      do i = jm+1, NumTrc-jm+1
         livesum(i) = livesum(i-1) + (liverec(i+jm-1) - liverec(i-jm))
      enddo

c     Compute partial sums for i >= NumTrc-jm+2

      do i = NumTrc-jm+2, NumTrc
         livesum(i) = livesum(i-1) - liverec(i-jm)
      enddo

      end


