C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine trace_sums(sums, ssum, isamp, NumTrc, jm)
      implicit none

c Author: Kelly D. Crawford
c Date:   04/09/97
c
c Generates rolling trace sums.  Given a two-dimensional array,
c u(i,j), generate rolling j-dimension-sums (row) of length 2*jap+1. 
c This code also computes partial sums for sums(i,j) where j < jm and
c j > isamp-jm+1

      integer isamp, NumTrc, jm
      double precision sums(isamp, NumTrc), ssum(isamp, NumTrc)

      integer i, j, jap
      jap = jm - 1
      
c     Compute partial sums for sums(i,1)

      

      do i = 1, isamp
         sums(i,1) = ssum(i,1)
      enddo
      do j = 2, jm
         do i = 1, isamp
            sums(i,1) = sums(i,1) + ssum(i,j)
         enddo
      enddo

c     Compute partial sums for j < jm, and a full sum for j == jm

      do j = 2, jm
         do i = 1, isamp
            sums(i,j) = sums(i,j-1) + ssum(i,j+jap)
         enddo
      enddo

c     Compute full rolling window sums for jm+1 <= j <= NumTrc-jap
c     by dropping the sample value immediately above the rolling window
c     and adding the sample value at the bottom of the rolling window.

      do j = jm+1, NumTrc-jap
         do i = 1, isamp
            sums(i,j) = sums(i,j-1) + (ssum(i,j+jap) - ssum(i,j-jm))
         enddo
      enddo


c     Compute partial sums for j >= NumTrc-jm+2

      do j = NumTrc-jm+2, NumTrc
         do i = 1, isamp
            sums(i,j) = sums(i,j-1) - ssum(i,j-jm)
         enddo
      enddo

c      do i = 1, 55
c         write(*,10) sums(2,i), ssum(2,i)
c10    format(1x, 2f30.20)
c      enddo

      end
