C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c     Program Changes:

c Nov 2, 2000 : - corrected unpacking logic to put all frequency estimates in the
c Garossino       proper order for filtering.  The initial subband comes from
c                 the real part of the first estimate.  The last subband similarly
c                 from the real part of the last estimate.  We now have N/2+1 subbands
c                 instead of N/2.  The original code dropped the last estimate
c                 on inverse stft.  On forward the first estimate amplitude was 
c                 corrupted by inclusion of the last estimate real part.
c                
c awarded US Patent US05850622 Vassiliou/Garossino
c
c      - original written: November 13, 1995
c        [prototype program by Anthony Vassiliou]

c     Program Description:

c      - Short Time Fourier Transform to generate time - frequency version
c        of input data.  For a complete description see man stft

c get machine dependent parameters 
      implicit none

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer itr( 2*SZLNHD )
     
      integer nsamp, nsampo, nsi, ntrc, ntrco, nrec, nreco, iform
      integer luin , luout, lbytes, nbytes, lbyout, obytes
      integer ist, iend, irs, ire, ns, ne, argis, jerr, JJ, KK

      real        tri( 2*SZLNHD )

      character   ntap*255, otap*255, name*4

      logical     verbos

c Program Specific _ dynamic memory variables

      integer errcd1, errcd2, errcd3, errcd4, abort
      integer tfsize, ctrsize, hbufsize, tbufsize, header_buffer

      real    stft_Record, trace_buffer

      complex  ctr

      pointer (ptr_ctr, ctr(20000))
      pointer (ptr_record, stft_Record(200000))
      pointer (ptr_header, header_buffer(200000))
      pointer (ptr_trace, trace_buffer(200000))

c Program Specific _ static memory variables

      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor
      integer ifmt_RecNum,l_RecNum,ln_RecNum
      integer ifmt_TrcNum,l_TrcNum,ln_TrcNum
      integer nwin, nu, nwin2, nf2, nf, i, ia, ordfft
      integer lutmp, RecordCount, j
      integer tr_index, hdr_index, tr_outdex, hdr_outdex
      integer tbuf_index, tbuf_outdex, hbuf_outdex
      integer end_trace
      integer TempLineHeader(SZLNHD), length, lenth
      integer nf_unpack, hbuf_index, ll

      real  w( SZLNHD ), Workspace( 2*SZLNHD ) 
      real sigma, sigma2, pi, spi

      character temptap*255

      logical reverse, time_freq, ready

c Initialize variables

      data abort/0/
      data name/"STFT"/
      data RecordCount/0/

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, name, nwin, 
     :     reverse, time_freq, temptap, verbos )

c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'STFT: no line header on input dataset',ntap
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

c define pointers to header words required by your routine

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c update historical line header and print to printout file 

      call hlhprt (itr, lbytes, name, 4, LERR)

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec

      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 .or. ne .gt. ntrc ) ne = ntrc

      ist = nint ( float(ist) / float(nsi) )
      iend = nint ( float(iend) / float(nsi) )
      if ( ist .eq. 0 ) ist = 1

      if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp

c determine next power of 2 for window and number of frequencies to generate

      if ( nwin .lt. 32 ) nwin = 32

      nu = ordfft ( nwin )
      nwin2 = 2 ** nu
      nf = nwin2 / 2
      nf_unpack = nf + 1

c update line header entries

      if (reverse ) then

c whatever we put into the line header on the way forward is how
c we want the data on the way back.  Pick up nreco and ntrco
c specification from the line header

         call saver ( itr, 'DtInFl', nreco, LINHED )
         call saver ( itr, 'OrNTRC', ntrco, LINHED )

c restore the domain flag for polymute

         call savew ( itr, 'DgTrkS' ,'xt', LINHED )
         nsampo = nsamp / 2
         if ( iend .eq. nsamp ) iend = nsampo

      else
         call savew ( itr, 'DtInFl', nrec, LINHED )
         call savew ( itr, 'OrNTRC', ntrc, LINHED )

         if ( time_freq ) then
            nreco = ( ire - irs + 1 ) * ( ne - ns + 1 )
            ntrco = nf_unpack
         else
            nreco = ( ire - irs + 1 ) * nf_unpack
            ntrco = ntrc
         endif

c put in the domain flag for polymute so no phase muting
c will occur

         call savew ( itr, 'DgTrkS' ,'fk', LINHED )
         nsampo = 2 * nsamp
      endif

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco  , LINHED)
      call savew(itr, 'NumSmp', nsampo  , LINHED)

c save out hlh and line header

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c determine output trace length in bytes

      obytes = SZTRHD + SZSMPD * nsampo 

c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, nsamp, nsi, ntrc, nrec, iform, ist, 
     :     iend, irs, ire, ns, ne, ntrco, nreco, nsampo, nwin , reverse,
     :     time_freq, temptap, verbos)

c setup the Gaussian sampling window

      sigma = float(nwin) / ( 2. * 3. )
      sigma2 = 2. * sigma**2
      pi = acos(-1.)
      nf2 = nf + 1
      spi = 1. / ( sqrt(2. * pi) * sigma )

      do i = 1, nwin2
         ia = i - nf2
         w ( i ) = spi * exp ( - ( float(ia) )**2 / sigma2 )
      enddo
         
c dynamic memory allocation:  

      ctrsize= nf_unpack * 4 

      if ( reverse ) then
         tbufsize = 2 * nsamp * ntrc * nf_unpack
         hbufsize = 4 * ntrc * nf_unpack
         tfsize = 2 * nsamp * nf_unpack
      else
         tfsize = 2 * nsampo * nf_unpack
         tbufsize = 2 * nsampo * ntrco * nf_unpack
         hbufsize = 4 * ntrco * nf_unpack
      endif

      call galloc ( ptr_ctr , ctrsize * SZSMPD, errcd1, abort )
      call galloc ( ptr_record , tfsize * SZSMPD, errcd2 , abort )
    
      if ( errcd1 .ne. 0 .or. 
     :     errcd2. ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)' Unable to allocate workspace:'
         write(LERR,*) ctrsize * SZSMPD, ' bytes '
         write(LERR,*) tfsize * SZSMPD, ' bytes '
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)' STFT: Unable to allocate workspace:'
         write(LER,*) ctrsize * SZSMPD, ' bytes '
         write(LER,*) tfsize * SZSMPD, ' bytes '
         write(LER,*)' '
         goto 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) ctrsize * SZSMPD, ' bytes '
         write(LERR,*) tfsize * SZSMPD, ' bytes '
         write(LERR,*)' '
      endif

c if we are going to put out nf frequency band records per input record
c then we need enough memory to hold the output from an entire input 
c record.  If we can't get it then use temporary disk.  If no temporary
c disk file is referenced on the command line then request same from
c the user and run away.

      if ( .not. time_freq ) then

         call galloc ( ptr_header , hbufsize * SZSMPD, errcd3 , abort )
         call galloc ( ptr_trace , tbufsize * SZSMPD, errcd4 , abort )

         if ( errcd3 .ne. 0 .or.
     :        errcd4 .ne. 0 ) then

            write(LERR,*)' '
            write(LERR,*)' Unable to allocate workspace:'
            write(LERR,*) hbufsize * SZSMPD, ' bytes '
            write(LERR,*) tbufsize * SZSMPD, ' bytes '
            write(LERR,*)' '
            write(LER,*)' '
            write(LER,*)' STFT: Unable to allocate workspace:'
            write(LER,*) hbufsize * SZSMPD, ' bytes '
            write(LER,*) tbufsize * SZSMPD, ' bytes '
            write(LER,*)' '

            if ( temptap .ne. ' ' ) then

c open the unit to temp file space on stdout for reading and writing

               call getln ( lutmp, temptap, 'w', 1 )

c modify line header and output line header to temporary file if needed

               if ( reverse ) then
                  call savew ( itr, 'NumRec', nf, LINHED )
                  call savew ( itr, 'NumTrc', ntrco, LINHED )
                  call savew ( itr, 'NumSmp', nsamp, LINHED )
               else
                  call savew ( itr, 'NumRec', ntrc, LINHED )
                  call savew ( itr, 'NumTrc', nf, LINHED )
               endif
               call vmov ( itr, 1, TempLineHeader, 1, SZLNHD)
               call wrtape ( lutmp, TempLineHeader, lbyout )
               length = lenth(temptap)
               write(LERR,*)' Using temporary file ', temptap(1:length) 
               write(LERR,*)' as output buffer'
               write(LERR,*)' '
               write(LER,*)' Using temporary file ', temptap(1:length) 
               write(LER,*)' as output buffer'
               write(LER,*)' '
            else
               write(LERR,*)' You do not have enough RAM to run this'
               write(LERR,*)' routine.  Use the -Temp command line '
               write(LERR,*)' option to attach temporary disk space '
               write(LERR,*)' to use in lieu of RAM.  Of course you '
               write(LERR,*)' could run this step on a bigger machine.'
               write(LERR,*)' '
               write(LER,*)' You do not have enough RAM to run this'
               write(LER,*)' routine.  Use the -Temp command line '
               write(LER,*)' option to attach temporary disk space '
               write(LER,*)' to use in lieu of RAM.  Of course you '
               write(LER,*)' could run this step on a bigger machine.'
               write(LER,*)' '
               go to 999
            endif

         else

            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) hbufsize * SZSMPD, ' bytes '
            write(LERR,*) tbufsize * SZSMPD, ' bytes '
            write(LERR,*)' '
         endif
      endif
c BEGIN PROCESSING 

c initialize trace and header buffer indices

      hbuf_outdex = 1
      tbuf_outdex = 1
         
      tbuf_index = 1
                  
c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire
 
c skip to start trace

         call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )

c initialize input trace and header array indices

         tr_index = 1 - nsamp
         hdr_index = 1 - ITRWRD
         hdr_outdex = 1 - ITRWRD

         if ( .not. reverse ) then
            hbuf_outdex = 1
            tbuf_outdex = 1
         else
            if ( ready ) then

c reset all the indices after an output record has been completed.

               hbuf_index = 1
               tbuf_index = 1
               ready = .false.
            endif
         endif

         
         DO KK = ns, ne

c read a trace

            nbytes = 0
            call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c retrieve dead trace flag

            call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :           StaCor, TRACEHEADER )

            IF ( .not. reverse ) then

c FORWARD TRANSFORM
               
c initialize time - frequency spectrum and complex trace arrays
c in preparation for the t-f transform of this trace

               call vclr ( stft_Record, 1, tfsize )
               do i = 1, nf_unpack
                  ctr(i) = cmplx(0.0,0.0)
               enddo

               if ( StaCor .ne. 30000) then

c process only live traces, move time series into tri and leave a 
c half window length zone of zero pad at the top and bottom.  The
c top can be done by moving to tri(nf) the bottom is automatic as
c tri is dimensioned a lot bigger than the trace going in.

                  call vmov ( itr(ITHWP1), 1, tri(nf), 1, nsamp )

c generate forward t-f spectrum for this trace.  The input trace has
c nsamp samples.  The output spectrum has nf traces of nsampo samples.

                  call forward_stft ( tri, Workspace, nsamp, ist, iend, 
     :                 nf, nwin, stft_Record, ntrco, nsampo, 
     :                 w, ctr, verbos )
               endif

c initialize output trace and header indices

               tr_outdex = 1 - nsampo

               IF ( time_freq ) then

c output time-frequency record for this trace with current trace header 
c on all traces of output record. 

                  do LL = 1 , nf_unpack
                     tr_outdex = tr_outdex + nsampo
                     call vmov ( stft_Record(tr_outdex), 1, 
     :                    itr(ITHWP1), 1, nsampo )
                     call wrtape ( luout, itr, obytes )
                  enddo

               ELSE

c load this t-f spectra to memory so that after ntrc traces have been
c processed we can output the sub-band records for this input record

                  if ( errcd3 .ne. 0 .or. errcd4 .ne. 0 ) then

c no RAM available, use temporary disk, write out the whole t-f spectra
c for this trace using the current trace header contents of itr[] as they
c will be the same for all output traces of this t-f spectra
                        
                     do LL = 1 , nf_unpack
                        tr_outdex = tr_outdex + nsampo
                        call vmov ( stft_Record(tr_outdex), 
     :                       1, itr(ITHWP1), 1, nsampo )
                        call wrtape ( lutmp, itr, obytes )
                     enddo

                  else

c RAM available, load a single header out to the header_buffer to be 
c used for all traces of this trace spectrum on output

                     hdr_outdex = hdr_outdex + ITRWRD
                     call vmov ( itr, 1,  
     :                    header_buffer(hbuf_outdex + hdr_outdex - 1), 
     :                    1, ITRWRD )

c load the entire t-f spectrum for this trace to the trace_buffer
 
                     do LL = 1 , nf_unpack
                        tr_outdex = tr_outdex + nsampo
                        call vmov ( stft_Record(tr_outdex), 1, 
     :                       trace_buffer(tbuf_outdex + tr_outdex - 1) 
     :                       , 1, nsampo )
                     enddo
                  endif

               ENDIF

               tbuf_outdex = tbuf_outdex + tr_outdex + nsampo - 1

            ELSE

c INVERSE TRANSFORM

               tr_index = tr_index + nsamp

               if ( time_freq ) then

c must read in the entire record in order to output a single trace
c load up time-frequency record so read this trace and keep going

                  call vmov ( itr(ITHWP1), 1, stft_Record(tr_index), 
     :                 1, nsamp )

               else

c must read in nf_unpack entire records in order to output a single record
c load up time-frequency array in memory or to temp disk if attached

                  if ( errcd3 .ne. 0 .or. errcd4 .ne. 0 ) then

                     call wrtape ( lutmp, itr, nbytes )

                  else

                     if ( mod(JJ,nf_unpack) .eq. 1  ) then

c load the trace headers from the first record of each set as the rest are
c duplicates  anyway.
                        hdr_index = hdr_index + ITRWRD
                        call vmov ( itr, 1, 
     :                       header_buffer(hdr_index)
     :                       , 1, ITRWRD )
                     endif

c load all the trace data

                     call vmov ( itr(ITHWP1), 1, 
     :                    trace_buffer(tbuf_index + tr_index -1), 1, 
     :                    nsamp )
                  endif
               endif
            ENDIF
         ENDDO

c a record has now been read, keep track of number of records read.  
c if doing reverse and not time_freq then need to read in nf records
c prior to doing inverse
         
         hbuf_outdex = hbuf_outdex + hdr_outdex + ITRWRD -1


         IF ( reverse ) then

            RecordCount = RecordCount + 1
            if ( mod (RecordCount,nf_unpack) .eq. 0 ) ready = .true.

            if ( time_freq ) then

c do the inverse stft transform and output a single trace

               if ( StaCor .ne. 30000 ) then
               
                  call inverse_stft ( tri, Workspace, nsamp, ist, iend, 
     :                 nf, nwin, stft_Record, ntrco, nsampo, w, ctr, 
     :                 verbos)

               else

                  call vclr ( tri, 1, nsampo )

               endif

c output trace

               call vmov ( tri, 1, itr(ITHWP1), 1, nsampo )
               call wrtape ( luout, itr, obytes )

            elseif ( ready ) then

c now have nf records of ntrc traces and nsamp samples in memory or in temp 
c disk storage.  Construct tracewise tf records, do inverse and output xt 
c trace data

               if ( errcd3 .ne. 0 .or. errcd4 .ne. 0 ) then

c retrieve data from temporary disk file
c close the file for writing, open for reading
c position pointer at first trace

                  call lbclos ( lutmp)
                  call getln ( lutmp, temptap, 'r', 1 )

                  do i = 1, ntrco

c                     end_trace = (nf - 1 ) * ntrc + i
                     end_trace = (nf_unpack - 1 ) * ntrc + i
                     tr_index = 1 - nsamp

                     do j = i, end_trace, ntrc

c load t-f spectrum for this trace
                        
                        call sisseek(lutmp, j)

                        nbytes = 0
                        call rtape ( lutmp, itr, nbytes )
                        if ( nbytes .eq. 0 ) then
                           write(LERR,*)'premature EOF reading ',temptap
                           write(LERR,*)'FATAL'
                           write(LER,*)'STFT: premature EOF on ',temptap
                           write(LER,*)'FATAL'
                           goto 999
                        endif
                        tr_index = tr_index + nsamp
                        call vmov(itr(ITHWP1), 1, stft_Record(tr_index),
     :                       1, nsamp )
                     enddo

c do inverse stft and output trace

                     call inverse_stft(tri, Workspace, nsamp, ist, iend, 
     :                    nf, nwin, stft_Record, ntrco, nsampo, w, ctr, 
     :                    verbos)

                     call vmov(tri, 1, itr(ITHWP1), 1, nsampo )
                     call wrtape( luout, itr, obytes )

                  enddo

c close temporary file to reading and open for writing
c position pointer after line header

                  call lbclos ( lutmp )
                  call getln ( lutmp, temptap, 'w', 1 )
                  call wrtape(lutmp, TempLineHeader, lbyout)

               else

c retrieve data from RAM do inverse and output trace

                  hdr_index = 1 - ITRWRD

                  do i = 1, ntrco

                     tr_index = 1 - nsamp
                     call vclr ( stft_Record, 1, tfsize )
                     do j = 1, nf_unpack
                        ctr(j) = cmplx(0.0, 0.0)
                     enddo

                     hdr_index = hdr_index + ITRWRD
                     call vmov ( header_buffer(hdr_index), 1, itr, 1, 
     :                    ITRWRD )
                     call saver2 ( itr, ifmt_StaCor, l_StaCor, 
     :                    ln_StaCor, StaCor, TRACEHEADER )

                     if ( StaCor .ne. 30000 ) then
c                        end_trace = (nf - 1 ) * ntrc + i
                        end_trace = (nf_unpack - 1 ) * ntrc + i

c load the t-f spectrum for this trace 

                        do j = i, end_trace, ntrc
                           tr_index = tr_index + nsamp
                           tbuf_index = ( j - 1 ) * nsamp + 1
                           call vmov ( trace_buffer(tbuf_index), 1, 
     :                          stft_Record(tr_index), 1, nsamp )
                        enddo

c calculate the inverse stft for this trace
                        
                        call inverse_stft ( tri, Workspace, nsamp, ist, 
     :                       iend, nf, nwin, stft_Record, ntrco, nsampo,
     :                       w, ctr, verbos)
                        
                     else
                        call vclr ( tri, 1, nsampo )
                     endif

c output this trace
                     call vmov ( tri, 1, itr(ITHWP1), 1, nsampo )
                     call wrtape ( luout, itr, obytes )
               
                  enddo
               endif
            endif

         ELSEIF ( .not. time_freq) then

c output the frequency band sort of the input record worth of spectra either
c from memory or by grabbing the appropriate traces off the temporary disk
c file.  If -TF on the command line then skip this as all output has been
c done in the record loop above.

            if ( errcd3 .ne. 0 .or. errcd4 .ne. 0 ) then

c get output from temporary disk storage
c close file for write
c open file for read

               call lbclos ( lutmp )
               call getln ( lutmp, temptap, 'r', 1 )
                  
               do i = 1, nf_unpack

c                  end_trace = ( ntrc - 1 ) * nf + i
                  end_trace = ( ntrc - 1 ) * nf_unpack + i

                  do j = i, end_trace, nf_unpack
                     
                     call sisseek ( lutmp, j )
                     nbytes = 0
                     call rtape ( lutmp, itr, nbytes )
                     if ( nbytes .eq. 0 ) then
                        write(LERR,*)' premature EOF on ',temptap
                        write(LERR,*)'FATAL'
                        write(LER,*)'STFT: premature EOF on ',temptap
                        write(LER,*)'FATAL'
                        goto 999
                     endif
                     call wrtape ( luout, itr, nbytes )
                  enddo
               enddo

c close temp file for read and open for next write position
c pointer at first trace

               call lbclos ( lutmp )
               call getln ( lutmp, temptap, 'w', 1 )
               call wrtape ( lutmp, TempLineHeader, lbyout)

            else

c retrieve forward transform stuff from memory and output nf_unpack 
c narrow band records

               do i = 1, nf_unpack

c                  end_trace = ( ntrc - 1 ) * nf + i
                  end_trace = ( ntrc - 1 ) * nf_unpack + i
                  hdr_index = 1 - ITRWRD

c load and output subband record

                  do j = i, end_trace, nf_unpack
                     hdr_index = hdr_index + ITRWRD
                     tr_index = ( j - 1 ) * nsampo + 1
                     call vmov ( header_buffer(hdr_index), 1, itr, 1, 
     :                    ITRWRD )
                     call vmov ( trace_buffer(tr_index), 1, itr(ITHWP1),
     :                    1, nsampo )
                     call wrtape ( luout, itr, obytes )
                  enddo
               enddo

            endif

         ENDIF

c reset any indices, counters,  etc that may be required
c initialize any memory that may need initializing
c rewind any files that may need rewinding

         
c skip to end of record

         call trcskp ( JJ, ne+1, ntrc, luin, ntrc, itr )
         tbuf_index = tbuf_index + (ne - ns + 1 ) * nsamp

      ENDDO

c close data files 

      call lbclos ( luin )
      call lbclos ( luout )
      if ( (errcd3 .ne. 0 .or. errcd4 .ne. 0 ) .and. temptap .ne. ' ' )
     :     call lbclos ( lutmp )
      write(LERR,*)'stft: Normal Termination'
      write(LER,*)'stft: Normal Termination'
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      if ( (errcd3 .ne. 0 .or. errcd4 .ne. 0 ) .and. temptap .ne. ' ' )
     :     call lbclos ( lutmp )
      write(LERR,*)'stft: ABNORMAL Termination'
      write(LER,*)'stft: ABNORMAL Termination'
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for STFT: Short Time Fourier 
     :Transform'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input...................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[]    -- input data set                  (stdin)'
      write(LER,*)'-O[]    -- output data set                (stdout)'
      write(LER,*)'-Temp[] -- temporary disk memory file   (not used)'
      write(LER,*)'-s[]    -- process start time (ms)             (1)'
      write(LER,*)'-e[]    -- process end time (ms)     (last sample)'
      write(LER,*)'-ns[]   -- start trace number                  (1)'
      write(LER,*)'-ne[]   -- end trace number           (last trace)'
      write(LER,*)'-rs[]   -- start record                        (1)'
      write(LER,*)'-re[]   -- end record                (last record)'
      write(LER,*)'-nwin[] -- window size                        (32)'
      write(LER,*)'-R      -- Inverse t-f transform'
      write(LER,*)'-TF     -- output 1 time-frequency record for each'
      write(LER,*)'           input trace.  The default is to output'
      write(LER,*)'           N frequency band records for each input'
      write(LER,*)'           record where N is the number of '
      write(LER,*)'           frequency bands in the transform'
      write(LER,*)' '
      write(LER,*)'           If used with -R then each input record'
      write(LER,*)'           is assumed to be the time-frequency '
      write(LER,*)'           spectrum of a single input trace'
      write(LER,*)' '
      write(LER,*)'-V      -- verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'    STFT -N[] -O[] -s[] -e[] -ns[] -ne[] -rs[]'
      write(LER,*)'            -re[] -nwin[] [-Temp[] -TF -R -V]'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c -----------------  Subroutine -----------------------

c pick up command line arguments 

      subroutine cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     name, nwin, reverse, time_freq, temptap, verbos )

#include <f77/iounit.h>

      integer    ist, iend, ns, ne, irs, ire, argis, nwin

      character  ntap*(*), otap*(*), name*(*), temptap*(*)

      logical    verbos, reverse, time_freq

           call argi4 ( '-e', iend, 0, 0 )

           call argi4 ( '-ne', ne, 0, 0 )
           call argi4 ( '-ns', ns, 0, 0 )
           call argstr ( '-N', ntap, ' ', ' ' ) 

           call argstr ( '-O', otap, ' ', ' ' ) 

           call argi4 ( '-re', ire, 0, 0 )
           call argi4 ( '-rs', irs, 0, 0 )
           call argi4 ( '-nwin', nwin, 32, 32 )
           reverse = (argis('-R') . gt. 0)

           call argi4 ( '-s', ist, 1, 1 )

           call argstr ( '-Temp', temptap, ' ', ' ' ) 
           time_freq = (argis('-TF') .gt. 0)

           verbos = (argis('-V') .gt. 0)

c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

           
      return
      end

c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars


      subroutine verbal ( ntap, otap, nsamp, nsi, ntrc, nrec, iform, 
     :     ist, iend, irs, ire, ns, ne, ntrco, nreco, nsampo, nwin, 
     :     reverse, time_freq, temptap, verbos )

#include <f77/iounit.h>

      integer    nsamp, ntrc, iform, ist, iend, irs, ire, ns, ne, nsi

      character  ntap*(*), otap*(*), temptap*(*)

      logical    verbos, reverse, time_freq

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name  =  ', otap
      write(LERR,*) ' start record          =  ', irs 
      write(LERR,*) ' end record            =  ', irs 
      write(LERR,*) ' start trace           =  ', ns
      write(LERR,*) ' end trace             =  ', ne
      write(LERR,*) ' processing sample start = ', ist
      write(LERR,*) ' processing sample end   = ', iend
      write(LERR,*)' '
      write(LERR,*)' Transform Parameters '
      write(LERR,*)' '
      write(LERR,*) ' window size for STFT = ', nwin
      write(LERR,*) ' samples per trace     =  ', nsampo
      write(LERR,*) ' traces per record     =  ', ntrco
      write(LERR,*) ' number of records     =  ', nreco

      if ( reverse ) then
         write(LERR,*) ' Inverse t-f transform requested'
      else
         write(LERR,*) ' Forward t-f transform requested'
      endif

      if ( time_freq ) then
         write(LERR,*) ' Output t-f spectra records'
      else
         write(LERR,*) ' Output frequency band records'
      endif

      if ( temptap .ne. ' ' ) 
     :write(LERR,*)' Temporary disk file is: ', temptap

      if ( verbos )  write(LERR,*) ' verbose printout requested'

      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end





