C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c Store reads a list static values and writes them 
c to the trace header of an input file.
c Results are written to an output file.
c
c
c**********************************************************************c
c
c     declare variables
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
      integer * 2 itr ( SZLNHD )
      integer * 4 lhed( 1500 )
      integer * 4 nsamp, nsi, ntrc, nrec, iform
      integer * 4 luin , luout, lbytes, nbytes, lbyout,lbyte
      integer * 4 irs,ire,ns,ne
#include <f77/pid.h>
      integer * 4 recnum, trcnum, static, srcloc, recind
      real    * 4 tri ( SZSMPM )
      real    * 4 ss(10000), rs(10000)
      character   ntap * 100, otap * 100, name*4
      character   sfile * 100
      logical     verbos, query
      integer     argis
 
      equivalence ( itr(129), tri (1) )
      equivalence ( itr(  1), lhed(1) )
      data lbytes / 0 /, nbytes / 0 /, name/'STOR'/
      data rs /10000 * -30000./, ss /10000 * -30000./
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,lus,sfile,ns,ne,irs,ire,isb,irb,
     1            srcsft,recsft,verbos)
c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape4  ( luin, itr, lbyte, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'STORE: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

      call hlhprt (itr, lbyte, name, 4, LERR)
c-----
c     ensure that command line values are compatible with data set
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
c-----
c     modify line header to reflect actual number of traces output
c-----
      nrecc=ire - irs+1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr=ne-ns+1
      call savew(itr, 'NumTrc', jtr  , LINHED)
      call savhlh(itr,lbyte,lbyout)
      call wrtape ( luout, itr, lbyout                 )

c-----
c     output of all pertinent information before
c     processing begins
c-----
      call verbal(nsamp, nsi, ntrc, nrec, iform,
     1            recsft,srcsft,ntap,otap,sfile,isb,irb)
c--------------------------------------------------
c  figure out design window times

      dt = float(nsi)/1000.

c--------------------------------------------------
c     READ STATICS FILE
      call rfile (ss,rs,lus,mingi,maxgi)
      write (lerr,*) 'mingi =', mingi, 'maxgi =', maxgi
c
c     interpolate source statics
      igflag = 1
      igss = 1
c
      do 150 il = mingi + 1, maxgi
        if ( ss(il) .eq. -30000. ) then
          igflag = 0
        else
          if (igflag .eq. 0) then
            sl=(ss(il)-ss(igss))/(float(il-igss))
            do 250 jl = igss, il
              ss(jl) = sl * (jl - igss) + ss(igss)
250         continue
            igss = il
            igflag = 1
          else
            igss = il
          endif
        endif
150   continue
c
c
c     interpolate receiver statics
      igflag = 1
      igss = 1
c
      do 350 il = mingi + 1, maxgi
        if ( rs(il) .eq. -30000. ) then
          igflag = 0
        else
          if (igflag .eq. 0) then
            sl=(rs(il)-rs(igss))/(float(il-igss))
            do 450 jl = igss, il
              rs(jl) = sl * (jl - igss) + rs(igss)
450         continue
            igss = il
            igflag = 1
          else
            igss = il
          endif
        endif
350   continue
c
c     write (lerr,992) (ixx, ss(ixx), rs(ixx), ixx = mingi,maxgi)
992   format (i10,2f10.2)
c-----
c     process desired trace records
c-----
      do 1000 jj = 1, nrec
c 
            do 1001 kk = 1, ntrc
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  dist   = itr(117)
                  static = itr(125)
                  recnum = itr(106)
                  trcnum = itr(107)
                  srcloc = itr(109)
                  recind = itr(118)

                  IF(static .ne. 30000) then
                     isrc10=srcloc/10
                     if ( ss(isrc10) .eq. -30000.) ss(isrc10) = 0.
                     if ( rs(recind) .eq. -30000.) rs(recind) = 0.
                     itr(isb) = int( ss(isrc10) + srcsft + 0.5 )
                     itr(irb) = int( rs(recind) + recsft + 0.5 )
                  endif
c
c-----------------------
                  if(verbos)write(LERR,*)'ri ',recnum,' trace ',trcnum,
     1' srcloc ',srcloc,' init stat ',itr(isb), ' recind ',recind,
     1' rec stat ',itr(irb)
c
                  call wrtape( luout, itr, nbytes)
 1001             continue
 
c----------------------
 
 1000       continue
c-----
c     close data files
c-----
  999 continue

      call lbclos ( luin )
      call lbclos ( luout )

            write(LERR,*)'end of prgm, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
      WRITE(LER,*)
     :'***************************************************************'
      WRITE(LER,*)
     :'PROGRAM MODULE STORE  --  WRITE STATICS TO HEADER'
      WRITE(LER,*)
      WRITE(LER,*)
     :'Program STORE writes a list of static values to the trace header'
      WRITE(LER,*)
     :'half words of an input data set. A constant time shift can'
      WRITE(LER,*)
     :'also be added to each header word. Statics can then be applied'
      WRITE(LER,*)
     :'with program REST. Static values are supplied to the program'
      WRITE(LER,*)
     :'through a flat file list with each line having 3 values,'
      WRITE(LER,*)
     :'an index (usually the group location, RecInd = halfword 118),'
      WRITE(LER,*)
     :'receiver static (ms), and source static (ms). Missing static'
      WRITE(LER,*)
     :'values are linearly interpolated.'
      WRITE(LER,*)
      WRITE(LER,*)
     :'Execute STORE  by typing "store" followed by program parameters.'
      WRITE(LER,*)
     :'Note that each parameter is proceeded by -A where "A" is '
      WRITE(LER,*)
     :'a character(s) corresponding to some parameter.'	
      WRITE(LER,*)
     :'..............................................................'
      WRITE(LER,*)
      WRITE(LER,*)
     :'INPUT PARAMETERS and (DEFAULT VALUES)'
      WRITE(LER,*)
      WRITE(LER,*)
     :' -N [ntap]      (no default) : input data file name'
        WRITE(LER,*)
     :' -O [otap]      (no default) : output data file name'
        WRITE(LER,*)
     :' -S [sfile]     (no default) : statics file name '
        WRITE(LER,*) 
     :' -is [isb]      (8=InStUn)   : trace header half word to'
        WRITE(LER,*) 
     :'                               write initiation static value' 
        WRITE(LER,*) 
     :' -ir [isr]      (11=RcStUn)  : trace header half word to'
        WRITE(LER,*) 
     :'                               write reception static value' 
      WRITE(LER,*)
     :' -st [srcsft] (0)          : initiation static constant'
      WRITE(LER,*)
     :'                               time shift (ms)'
      WRITE(LER,*)
     :' -rt [recsft] (0)          : reception static constant'
      WRITE(LER,*)
     :'                               time shift (ms)'
      WRITE(LER,*)
     :' -V [verbos]  ( no )         : print additional info'
      WRITE(LER,*)
      WRITE(LER,*)
     :' EXAMPLE'
      WRITE(LER,*)
     :' store -N/home/data/ntap -O/home/data/otap -Sstat.file'
        WRITE(LER,*) 
     :'       -is8 -ir11 -st20 -rt45                                '
      WRITE(LER,*)
      WRITE(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,lus,sfile,ns,ne,irs,ire,isb,irb,
     1                  srcsft,recsft,verbos)
c-----
c     get command arguments
c
c     ntap  - c*100     input file name
c     otap  - c*100     output file name
c     vel   - r*4  design velocity
c     ns    - i*4 starting trace index
c     ne    - i*4 ending trace index
c     irs   - i*4 starting record index
c     ire   - i*4 ending record index
c     verbos      - l   verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*), sfile*(*)
      integer * 4 ns, ne, irs, ire
      real    * 4 vel
      logical     verbos
      integer     argis
 
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-S', sfile, ' ', ' ' )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argr4( '-st', srcsft, 0., 0. )
            call argr4( '-rt', recsft, 0., 0. )
            call argi4 ( '-is', isb ,   8  ,  8    )
            call argi4 ( '-ir', irb ,  11  , 11    )
            verbos = (argis('-V') .gt. 0)
c
      lus=LUN
      open (unit=LUN, file=sfile, status='old', iostat=ierr)
      if (ierr. ne. 0) then
          write (LERR,*) 'Could not open statics input file'
          write (LERR,*) 'Check Existence of this file'
          stop
      endif
      return
      end
c
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  recsft,srcsft,ntap,otap,sfile,isb,irb)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     vel   - r*4  design velocity
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ntap  - C*120     input file name
c     otap  - C*120     output file name
c-----
#include <f77/iounit.h>
      integer * 4 nsamp, nsi, ntrc, nrec
      character ntap*(*), otap*(*), sfile*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace    =  ', nsamp
            write(LERR,*) ' sample interval       =  ', nsi
            write(LERR,*) ' traces per record     =  ', ntrc
            write(LERR,*) ' records per line      =  ', nrec
            write(LERR,*) ' format of data        =  ', iform
            write(LERR,*) 
            write(LERR,*) ' input data set name   =  ', ntap
            write(LERR,*) ' output data set name  =  ', otap
            write(LERR,*) ' input statics file    =  ', sfile
            write(LERR,*) ' Init. statics word    =  ', isb
            write(LERR,*) ' Recp. statics word    =  ', irb
            write(LERR,*) ' job static shift source   (ms) =  ', srcsft
            write(LERR,*) ' job static shift receiver (ms) =  ', recsft
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
c
      subroutine rfile (ss,rs,lus,mingi,maxgi)
      real ir, is
      real * 4 ss(*), rs(*)
c
      mingi = 9999999
      maxgi = 0
10    continue
         read (lus, *, end=20, err=20) igi, ir, is
         rs(igi) = ir
         ss(igi) = is
         if ( igi .lt. mingi) mingi = igi
         if ( igi .gt. maxgi) maxgi = igi
      goto 10
20    continue
      return
      end
