C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c stretch reads seismic trace data from an input file,
c either interpolates or decimates the data to arbitrary sample interval
c writes the results to an output file
c**********************************************************************c
c
c   changes:
c
c          fixed stretch removal error by introducing line header entry
c          SmpFlt to carry dtau [see below] in floating point to provide
c          exactly the same sample interval in both the forward and reverse
c          cases ....... Garossino  April 1, 1997
c
c     declare variables
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
      integer     itr ( SZLNHD )
      integer     lhed( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform,obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     nsampo
      integer     recnum, trcnum, static, nso
      integer     iz(SZLNHD)
      integer     ntmin, m
      integer     argis

      real        sfact, pwr
      real        tri ( SZLNHD ), xtr ( SZLNHD )
      real        tabl1 (SZLNHD), tabl2(SZLNHD), zz(4*SZLNHD)
      real        wt (SZLNHD)
      real        em

      character   ntap * 256, otap * 256, name*7

      logical     verbos, revers
 
      equivalence ( itr(  1), lhed(1) )

      data lbytes / 0 /
      data nbytes / 0 /
      data name/'STRETCH'/
      data m/3/

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 )then
         call help()
         stop
      endif
 
c-----
c     open printout files
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,ntmin,ifunc,sfact,verbos,revers,pwr,em)
c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'STRETCH: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
c---------------------------------
c  save key header values
#include <f77/saveh.h>

c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c--------
c  get original sample interval
c  & original # samps

      write(LERR,*)'direction ',revers

      if (revers) then

         call saver( itr, 'SmpFlt', dtau , LINHED)

c if someone is unstretching an old dataset that did not use the floating
c point sample interval assignment then we had better back off to doing it
c the old way.....hopefully we can grandfather this out in a couple of 
c months / years  ..... april 1, 1997.....

         if ( abs(dtau) .lt. 1.e-32 ) then
            call saver( itr, 'SmpInt', nsi   , LINHED)
            dtau = nsi/1000000.
         endif

         call saver( itr, 'TmSlIn', nso   , LINHED)
         call savew( itr, 'SmpInt', nso   , LINHED)
         call saver( itr, 'TmMsSl', nsampo, LINHED)
         call saver( itr, 'NumSmp', ntaui , LINHED)
         call savew( itr, 'NumSmp', nsampo, LINHED)
         call saver(itr, 'UnitSc', unitsc, LINHED)
         if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
         endif
         nsamp = ntaui
         dt = float(nso) * unitsc
         ntau = ntaui
         if (ntmin .eq. 0) then
             call saver( itr, 'ReSpFm', ntmin , LINHED)
             if (ntmin .eq. 0) then
                write(LERR,*)'ntmin parameter is zero from line'
                write(LERR,*)'header.  Include original cmd'
                write(LERR,*)'argument -tmin[]'
                stop
             endif
         else
             ntmin = ntmin/nso
             if (ntmin .gt. 0.10 * nsampo) then
                write(LERR,*)' '
                write(LERR,*)'tmin[] too large: exceeds ',nsampo/10
                ntmin = 0.10 * nsampo
                write(LERR,*)'will reset to ',ntmin
                write(LERR,*)' '
             endif

         endif

      else

c--------
c  for forward stretch:
c  find pwr of 2 for test number samps in stretched trc
c  then save old samp interval

         call saver( itr, 'SmpInt', nsi   , LINHED)
         call saver( itr, 'NumSmp', nsamp , LINHED)
         call saver(itr, 'UnitSc', unitsc, LINHED)
         if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
         endif
         dt = float(nsi) * unitsc
         if (ntmin .eq. 0) then
             if (ifunc .eq. 0) then
                 ntmin = 0.10 * nsamp
             else
                 ntmin = 0.05 * nsamp
             endif
             
         else
             ntmin = ntmin/nsi
             if (ntmin .gt. 0.10 * nsamp) then
                write(LERR,*)' '
                write(LERR,*)'tmin[] too large: exceeds ',nsamp/10
                ntmin = 0.10 * nsamp
                write(LERR,*)'will reset to ',ntmin
                write(LERR,*)' '
             endif
         endif
         call savew( itr, 'ReSpFm', ntmin , LINHED)

         if     (ifunc .eq. 0) then
            ntautp = em * float(nsamp)
            if (ntautp .gt. SZLNHD) then
                write(LERR,*)'WARNING:'
                write(LERR,*)'data would have been stretched out to '
                write(LERR,*)ntautp,' samples.  This is too long.'
                write(LERR,*)'Will change the stretch factor from '
                write(LERR,*)em,' to '
                em = float(SZLNHD) / float(nsamp)
                ntautp = em * float(nsamp)
                write(LERR,*)em,' and the stretched # samps is now ',
     1                       ntautp
            endif
            ntau = ntautp
            if (ntau .gt. SZLNHD) then
               write(LERR,*)'WARNING:'
               write(LERR,*)'number output samples/trc exceeded ',
     1                       SZLNHD
               write(LERR,*)'which is the maximum allowable. Number'
               write(LERR,*)'output samps set to ',SZLNHD
               write(LERR,*)'Beware - if a reverse stretch is run on'
               write(LERR,*)'this output traces may be truncated in'
               write(LERR,*)'length'
               ntautp = SZLNHD
               ntau   = SZLNHD
            endif
            dtau = log( float(nsamp/ntmin) )/float(ntautp)
         elseif (ifunc .eq. 1) then
            dtau = dt
            if (pwr .ne. 0.0) then
                pwri = 1./pwr
            else
                pwri = 1.0
            endif
            ntau = float(nsamp) ** pwri
            if (ntau .gt. SZLNHD) then
               ntau = SZLNHD
               write(LERR,*)'WARNING:'
               write(LERR,*)'number output samples/trc exceeded ',
     1                       SZLNHD
               write(LERR,*)'which is the maximum allowable. Number'
               write(LERR,*)'output samps set to ',SZLNHD
               write(LERR,*)'Beware - if a reverse stretch is run on'
               write(LERR,*)'this output traces may be truncated in'
               write(LERR,*)'length'
               ntautp = SZLNHD
               ntau   = SZLNHD
            endif
         elseif (ifunc .eq. 2) then
            dtau = dt
            ntau = float(nsamp) * sfact
            dtau = dtau / sfact
            if (ntau .gt. SZLNHD) then
               ntau = SZLNHD
               write(LERR,*)'WARNING:'
               write(LERR,*)'number output samples/trc exceeded ',
     1                       SZLNHD
               write(LERR,*)'which is the maximum allowable. Number'
               write(LERR,*)'output samps set to ',SZLNHD
               write(LERR,*)'Beware - if a reverse stretch is run on'
               write(LERR,*)'this output traces may be truncated in'
               write(LERR,*)'length'
               ntautp = SZLNHD
               ntau   = SZLNHD
            endif
         elseif (ifunc .eq. 4) then
            dtau = dt
            ntau = float(nsamp)
         elseif (ifunc .eq. 3) then
            dtau = dt
            ntau = float(nsamp)
         endif

c the nso variable carries the nearest integer entry to dtau to be put
c into the output SmpInt.  This is NOT sufficient for removing the 
c stretch.  In addition the floating point value of dtau is stored in
c SmpFlt for use in stretch removal.  The difference between dtau and
c nso was causing a time variant stretch removal error.  The greater the
c diff between nso and dtau the greater the error.  Using the floating
c point header entry solved this problem.

         nso = nint ( dtau * 1000000. )
         write(LERR,*)'ntmin= ',ntmin,'  nso= ',nso
         nsampo = ntau

         call savew( itr, 'SmpFlt', dtau  , LINHED)
         call savew( itr, 'SmpInt', nso   , LINHED)
         call savew( itr, 'TmSlIn', nsi   , LINHED)
         call savew( itr, 'TmMsSl', nsamp , LINHED)
         
      endif

      call hlhprt (itr, lbytes, name, 7, LERR)

c-----
c     modify line header to reflect actual number of traces output
c-----
      call savew(itr, 'NumSmp',nsampo, LINHED)

      obytes = SZTRHD + nsampo * SZSMPD
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout                 )

c-----
c     build starting weights, i.e.
c     first ntmin of trace will be weighted down
c     for log stretch
c-----
          call weights (wt, ntmin, max(nsamp,nsampo))

c-----
c     build interpolation tables
c-----

      dtmin = ntmin * dt
      if (revers) then
         call table (tabl1,nsamp,tabl2,nsampo,dtau,dt,
     1               pwr,sfact,dtmin,ifunc,nsamp, revers)
      else
         call table (tabl1,nsamp,tabl2,nsampo,dt,dtau,
     1               pwr,sfact,dtmin,ifunc,nsamp, revers)
      endif


c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
      if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform, dt, dtau,ntmin,
     1                  pwr,ifunc,nsampo,sfact,nso,revers,ntap,otap)
      end if

c-----
c     BEGIN PROCESSING
c     read trace, interpolate or decimate, write to output file
c-----
                     icinit = 1
c-----
c     process desired trace records
c-----
      do 1000 jj = 1, nrec
 
         do 1001 kk = 1, ntrc
            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif
            call vmov (lhed(ITHWP1), 1, tri, 1, nsamp)
c------
c     use previously derived pointers to trace header values
            call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1           recnum , TRACEHEADER)
            call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1           trcnum , TRACEHEADER)
            call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1           static , TRACEHEADER)

            IF(static .ne. 30000)then


c---------------------
c  interpolate data
               if (.not.revers) then
                  call fcuint (tabl1, tri, nsamp, tabl2, xtr,
     1                 nsampo, iz, zz, icinit)
                  call vmov (xtr, 1, tri, 1, nsampo)
               else
                  call vmul (wt, 1, tri, 1, xtr, 1, nsamp)
                  call fcuint (tabl1, xtr, nsamp, tabl2, tri,
     1                 nsampo, iz, zz, icinit)
               endif
               icinit = 0
      
c-----------------------

            ELSE

               call vclr (tri,1,nsampo)

            ENDIF

c-----------------------
c  output data
            call vmov (tri, 1, lhed(ITHWP1),1, nsampo)
            call wrtape (luout, itr, obytes)


 1001    continue
 
         if(verbos)write(LERR,*)'ri ',recnum,'  processed'
 
 1000 continue
c-----
c     close data files
c-----
  999 continue

      call lbclos ( luin )
      call lbclos ( luout )

            write(LERR,*)'end of stretch, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'stretch either interpolates or decimates seismic data'
        write(LER,*)
     :'see manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute stretch by typing gentrp and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)      : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)      : output data file name'
        write(LER,*) ' '
        write(LER,*)
     :' -tmin[ntmin] (def = .1*nsamp)  : log stretch pivot'
        write(LER,*)
     :' -s[sfact]    (default = 1.0)   : linear stretch factor'
        write(LER,*)
     :' -exp[pwr]    (default = 1.0)   : power exponent'
        write(LER,*) ' '
        write(LER,*)
     :' -f[ifunc]     (def = 0)        : resampling function'
        write(LER,*)
     :'               ifunc = 0   log/exp stretch/squeeze'
        write(LER,*)
     :'               ifunc = 1   power (t ** exp) stretch/sqz'
        write(LER,*)
     :'               ifunc = 2   linear stretch/squeeze'
        write(LER,*)
     :'               ifunc = 3   sin(sfact*t) stretch/squeeze'
        write(LER,*)
     :'               ifunc = 4   cos(sfact*t) stretch/squeeze'
        write(LER,*)
        write(LER,*) ' '
        write(LER,*)
     :' -R  include on command line to do previous stretch'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*) ' '
        write(LER,*)
     :'usage:   stretch -N[ntap] -O[otap] [-R -V]'
        write(LER,*)
     :'                  [ -tmin[] -s[] -f[] -exp[] ]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,ntmin,ifunc,sfact,verbos,revers,pwr,
     1                  em)
c-----
c     get command arguments
c
c     ntap  - C*100     input file name
c     otap  - C*100     output file name
c     sfact - R*4       stretch factor
c     pwr   - R*4       stretch exponent
c     revers  L         reverse former stretch
c     verbos  L         verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      real        sfact, pwr, em
      integer     ntmin, ifunc
      logical     verbos, revers
      integer     argis
 
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argr4( '-s', sfact, 1., 1. )
            call argr4( '-exp', pwr, 1., 1. )
            call argr4( '-m', em, 3., 3. )
            call argi4('-tmin',ntmin,0,0)
            call argi4('-f',ifunc,0,0)

            if (ifunc .eq. 2 .AND. sfact .eq. 0.0) then
                write(LERR,*)'Fatal Heart Attack in stretch:'
                write(LERR,*)'stretch factor cannot be = 0.0'
                stop
            endif

            revers  = (argis('-R') .gt. 0)
            verbos  = (argis('-V') .gt. 0)
 
      return
      end
 
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,dti,dto,ntmin,
     1                  pwr,ifunc,nsampo,sfact,nso,revers,ntap,otap)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c    nsampo - I*4 output number of samples in trace
c     sfact - R*4 stretch factor
c     pwr   - R*4       stretch exponent
c     nso   - I*4       output sample interval header override
c     ifunc - I*4       function type
c     ntmin - I*4       log/exp pivot point or mute zone
c     revers  L         undo prior gstretch
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ntap  - C*120     input file name
c     otap  - C*120     output file name
c-----
#include <f77/iounit.h>
      integer     nsamp, nsi, ntrc, nrec, nso, ntmin, ifunc
      real        sfact,dti,dto,pwr
      character   ntap*(*), otap*(*)
      logical     revers
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace       =  ', nsamp
            write(LERR,*) ' output samples/trace     =  ', nsampo
            write(LERR,*) ' input sample interval    =  ', nsi
            write(LERR,*) ' input sample interval    =  ', dti,' sec'
            write(LERR,*) ' traces per record   =  ', ntrc
            write(LERR,*) ' records per line    =  ', nrec
            write(LERR,*) ' format of data      =  ', iform
            write(LERR,*)' '
            write(LERR,*) ' function type       =   ', ifunc
            if (ifunc .eq. 0) then
            write(LERR,*) ' log stretch pivot time=  ', ntmin
            elseif (ifunc .eq. 1) then
            write(LERR,*) ' exponent power str/sqz= ', pwr
            elseif (ifunc .eq. 2) then
            write(LERR,*) ' linear stretch factor       =  ', sfact
            elseif (ifunc .eq. 3) then
            write(LERR,*) ' sine(t) stretch factor      =  ', sfact
            elseif (ifunc .eq. 4) then
            write(LERR,*) ' cosine(t) stretch factor    =  ', sfact
            endif
            write(LERR,*)' '
            write(LERR,*) ' output sample int   =  ', nso
            write(LERR,*) ' output sample int   =  ', dto,' sec'
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            if (revers)
     1      write(LERR,*) ' undo prior gstretch'
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
 
