C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine process(uin,amp,
     1                   uexp,cspec,
     2                   tabledexp,wgt,live,
     3                   jf,ifl,ifh,nx,istart,iend,iskip,
     4                   lenw_inner,lenw_outer,
     5                   verbose,lerr)
c___________________________________________________________________
c     calculate the amplitude for each sample and trace
c     of a single seismic line for a fixed frequency, jf.
c___________________________________________________________________
c     input data.
c___________________________________________________________________
      real     uin(istart-lenw_outer:iend+lenw_outer,0:nx)   
      logical  live(0:nx)
c___________________________________________________________________
c     output data.
c___________________________________________________________________
      real     amp(istart:iend,0:nx)    
c___________________________________________________________________
c     intermediate arrays.
c___________________________________________________________________
      complex  cspec(istart:iend)    
      complex  uexp(istart-lenw_outer:iend+lenw_outer)
c___________________________________________________________________
c     tabled arrays and tapers.
c___________________________________________________________________
      complex  tabledexp(istart-lenw_outer:iend+lenw_outer,ifl:ifh)
      real     wgt(-lenw_outer:lenw_outer)
c___________________________________________________________________
c     control variables.
c___________________________________________________________________
      logical  verbose
c
c
c___________________________________________________________________
c     loop over all traces in x.
c___________________________________________________________________
      do 90000 jx=0,nx    
       if(.not. live(jx)) go to 90000
c___________________________________________________________________
c      precompute product of the seismic trace with the tabled 
c      exp function for frequency jf.
c___________________________________________________________________
       do 10000 kt=istart-lenw_inner,iend+lenw_inner
        uexp(kt)=uin(kt,jx)*tabledexp(kt,jf)   
10000  continue
c___________________________________________________________________
c      initialize the output.
c___________________________________________________________________
       do 20000 kt=istart,iend
        cspec(kt)=(0.,0.)
20000  continue
c___________________________________________________________________
c      calculate sum over initial window.
c___________________________________________________________________
       kt=istart
       do 30000 jt=-lenw_inner,+lenw_inner
        cspec(kt)=cspec(kt)+uexp(kt+jt)
30000  continue
c___________________________________________________________________
c      calculate running sums over equally weighted part of window
c      by dropping and adding terms.
c      if necessary, prescale data such that roundoff doesn't bite you!
c___________________________________________________________________
       call timstr(v1,w1)
       do 40000 kt=istart+1,iend
        cspec(kt)=cspec(kt-1)
     1                +(uexp(kt+lenw_inner)-uexp(kt-lenw_inner-1))
40000  continue
c___________________________________________________________________
c      add tapers to the outside of the inner window.
c___________________________________________________________________
       do 60000 kt=istart,iend,iskip
        do 50000 jt=lenw_inner+1,lenw_outer
         cspec(kt)=cspec(kt)
     1                +wgt(jt)*(uexp(kt+jt)+uexp(kt-jt))
50000   continue
c___________________________________________________________________
c      add exponential shift necessary to center sin and cos at the
c      center of the analysis window, tcenter=kt*dt.
c      note exp(-j*omega*tcenter)=conjg(exp(+j*omega*tcenter))
c___________________________________________________________________
c       cspec(kt)=conjg(tabledexp(kt,jf))*cspec(kt)
60000  continue
c___________________________________________________________________
c      calculate amplitude.
c___________________________________________________________________
       do 70000 kt=istart,iend,iskip
        amp(kt,jx)=abs(cspec(kt))
70000  continue
90000 continue
c
      return
      end


