      program swak  
c====================================================================
c     Statistical wavelet amplitude kalculation.
c     This program is the preprocessor for program tune3d.
c
c                   Kurt J. Marfurt
c                   Amoco EPTG, Tulsa, OK, USA
c                   6/10/97
c______________________________________________________________________
c
c     AUTHORIZATION FOR USE BY NON AMOCO EMPLOYEES
c
c     This Software is owend by AMOCO Production Company. Non-Amoco users
c     require from AMOCO a license to use this Software and any related
c     documentation. This license may be terminated by AMOCO. Upon termination,
c     the originals and all copies or reproductions of the Software, including
c     any instruction manuals or program docmentation relating thereto, must be
c     returned to AMOCO. You may \fInot\fR sub-license, rent, assign or
c     transfer any rights to use the Software. If any copy of the Software
c     or any documentation is made for backup purposes, it must be marked:
c
C |               copyright 2001, Amoco Production Company             |
C |                           All Rights Reserved                      |
C |                   an affiliate of BP America Inc.                  |
c 
c     AMOCO does not warrent, guarantee, or make any representations regarding
c     the use of, or results of the use of, the Software in terms of
c     correctness, accuracy, reliability, currentness, or otherwise. The
c     results and performance of the Software is assumed by you.
c
c     No oral or written information or advise given by AMOCO or its employees
c     shall create or in any way increase the scope of any warranty relating
c     to the use of, or results of using the Software and you may NOT rely on
c     any such information or advise.
c
c     Amoco will NOT be responsible or liable for any loss, destruction of
c     property, lost profits or other damages whatsoever, including any direct,
c     indirect, incidental, consequential or punitive damages of any nature
c     which may be caused by or result from your use of the Software, even if
c     AMOCO has been advised of the possibility of such damages.
c
c     All warrantees, including all implied warranties of merchantability and
c     fitness for a particular purpose, are disclaimed.
c
c______________________________________________________________________
c
c     declare variables
c
#include     <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#ifdef CRAYSYSTEM
      parameter (maxchar=14)
#else
      parameter (maxchar=32)
#endif
      parameter (maxs=0 000 002)
      dimension s(maxs)
      pointer   (pntrs,s)

      parameter   (pi=3.1415926,twopi=2.*pi)
c
      integer     sheader(SZLNHD)
      real        cputim(20),waltim(20)
#include <f77/pid.h>
      parameter (undefined=+99999.)
c
      character*256  file_in,file_out,file_w
      integer        startline,endline,skipline
      character*7    name
      logical        verbose,flowmaker,query,IKP,wrw
      logical        eof
      logical        frequencies
      character*9    host,blank9
      integer        pipe(11)
      integer        argis
      data           name/'SWAK'/
      data           host/'         '/
      data           blank9/'         '/
      data           pipe/1,2,3,4,5,6,7,8,9,10,11/

c_______________________________________________________________
c     check to see if we are running under IKP.
c_______________________________________________________________
      call ikpchk(host)
      if(host .ne. blank9) then
         IKP=.true.
      else
         IKP=.false.
      endif
c_______________________________________________________________
c     initialize timing arrays.
c_______________________________________________________________
      call vclr(cputim,1,20)
      call vclr(waltim,1,20)
      call timstr(vtot,wtot)
      call timstr(v1,w1)
c_______________________________________________________________
c     read program parameters from command line card image file
c_______________________________________________________________
      query=(argis( '-?' ) .gt. 0 )
      if(query) then
         call help(ler)
c        call exit(0)
	 stop 0
      endif
c_______________________________________________________________
c     open printout files
c_______________________________________________________________
#include <f77/open.h>
c_______________________________________________________________
c     get i/o data set names
c_______________________________________________________________
      call argstr('-N',file_in,' ',' ')
      call argstr('-O',file_out, ' ',' ')
      call argstr('-W',file_w,' ',' ')
      call argr4 ('-ptaper',ptaper,20.,20.)
      call argr4 ('-fmax',fmax,80.,80.)
      call argr4 ('-fmin',fmin,0.,0.)
      call argr4 ('-df',df,0.,0.)
      call argr4 ('-pc',pc,10.,10.)
      call argr4 ('-twindow',twindow,0.,0.)
      call argr4('-tstart',tstart_cmd,0.,0.)
      call argr4('-tend',tend_cmd,0.,0.)
      call argr4('-tskip',tskip,0.,0.)
      call argi4('-startline',startline,1,1)
      call argi4('-endline',endline,0,0)
      call argi4('-skipline',skipline,1,1)
      verbose=(argis('-V') .gt. 0)
      flowmaker=(argis('-flowmaker') .gt. 0)
c_______________________________________________________________
c     get logical unit numbers for input and output
c_______________________________________________________________
      call getln(luin,file_in,'r',0)
      call getln(luout,file_out,'w',1)
      if(file_w .ne. ' ') then
         wrw=.true. 
         call lbopen(luw,file_w,'w')
      else
         if (IKP) then
            wrw = (pipcnt(pipe(11),1) .gt. 0)
            if (wrw) call sisfdfit(luw,pipe(11))
         else
            wrw=.false.
         endif
      endif
c_______________________________________________________________________
c     read in the seismic line header.
c_______________________________________________________________________
      lbytes=0
      call rtape(luin,sheader,lbytes)
      if(lbytes .eq. 0) then
         write(lerr,*)'SWAK: no header read from unit ',luin
         write(ler,*)'SWAK: no header read from unit ',luin
         call exitfu(1666)
      endif
c_______________________________________________________________________
c     pull relevent values from line header.
c_______________________________________________________________________
      call saver(sheader,'NumSmp',nsamp_in,LINEHEADER)
      call saver(sheader,'SmpInt',nsi,LINEHEADER)
      call saver(sheader,'NumRec',nrec_in,LINEHEADER)
      call saver(sheader,'NumTrc',ntr,LINEHEADER)
      call saver(sheader,'TmMsFS',tstart_orig,LINEHEADER)
      call saver(sheader,'TmMsSl',jtstart_orig,LINEHEADER)
      call saver(sheader,'TmSlIn',jtslice_orig,LINEHEADER)
      call saver(sheader,'Dz1000',dzh,LINEHEADER)
      call saver(sheader,'T_Unit',junits,LINEHEADER)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      nx=ntr-1
      if(endline .eq. 0) endline=nrec_in
      endline=min(endline,nrec_in)
      if(junits .eq. 1) then
c_______________________________________________________________________
c        input data are in microseconds.
c_______________________________________________________________________
         dtmsec=.001*nsi
      else
c_______________________________________________________________________
c        input data are in milliseconds.
c_______________________________________________________________________
         dtmsec=nsi
      endif
      dt=.001*dtmsec
c
      if(tstart_cmd .eq. 0.) then
         tstart=tstart_orig
      else
         tstart=tstart_cmd
      endif
      tend_orig=tstart_orig+(nsamp_in-1)*dtmsec
      if(tend_cmd .eq. 0.) tend_cmd=tstart_orig+(nsamp_in-1)*dtmsec
      tend=min(tend_orig,tend_cmd)
      tskip=max(tskip,dtmsec)
      istart=nint((tstart-tstart_orig)/dtmsec)
      iend=nint((tend-tstart_orig)/dtmsec)
      istart=max(0,istart)
      iend=min(nsamp_in-1,iend)
      iskip=nint(tskip/dtmsec)
      iskip=max(iskip,1)
      nsamp_out=(iend-istart+1)/iskip
      if(twindow .le. 0.) then
         twindow=96.
      endif
c_______________________________________________________________
c     round input parameters to be integers
c     (so that we can pass them via trace headers)
c_______________________________________________________________
      nwindow=nint(twindow)
      twindow=nwindow
      nptaper=nint(ptaper)
      ptaper=nptaper
      if(tstart .gt. tend_orig .or. tend .gt. tend_orig .or.
     1   tstart .lt. tstart_orig .or. tend .lt. tstart_orig 
     2   .or. tend .lt. tstart) then
         write(lerr,*) 'error in command line calculation '
     1                 //'of the time window!'
         write(lerr,'(a20,f12.3)') 'tstart',tstart,'tend',
     1       tend,'tstart_orig',tstart_orig,'tend_orig',
     2       tend_orig
         call exit(666)
      endif
c_______________________________________________________________________
c     sample spectrum with equal frequencies.
c_______________________________________________________________________
      if(df .le. 0.) df=.5/(.001*twindow)
      if(fmin .le. 0.) fmin=1./(.001*twindow)
      if(fmax .le. 0.) fmax=1./(2.*dt)
      frequencies=.true.
      ifh=nint(fmax/df)
      ifl=nint(fmin/df)
      dfp=df
      hw_outer=twindow/2.
      ttaper=hw_outer*.01*ptaper
      hw_inner=hw_outer-ttaper
      lenw_outer=hw_outer/dtmsec
      lenw_inner=hw_inner/dtmsec+.9999
      write(0,*) 'lenw_outer = ',lenw_outer
      if(lenw_outer .lt. 1) then
         write(lerr,*) 'error in swak!'
         write(lerr,*) 'operator window is less than 3 samples!'
         write(lerr,*) 'entered after -twindow as ',twindow,' msec'
         write(lerr,*) 'dtmsec = ',dtmsec
         close(lerr)
         call exitfu(1666)
      endif
      ncomponent=ifh-ifl+1
      nbytes_in=(ITRWRD+nsamp_in)*szsmpd
      nbytes_out=(ITRWRD+nsamp_out)*szsmpd
      nsi_out=tskip
      nrec_out=nrec_in*ntr         
      call hlhprt (sheader,lbytes,name,len(name),lerr)
c
      write(lerr,*)
      write(lerr,'(//,a)') 'INPUT FILE DESCRIPTION'
      write(lerr,'(a,t40,a)') '3-D seismic cube',file_in
      write(lerr,'(//,a)') 'OUTPUT  DESCRIPTION'
      write(lerr,'(a,t40,a)') 'wavelet time/frequency amp spec',
     1                         file_out 
      if(wrw) write(lerr,'(a,t40,i5,a)') 'analysis wavelets',
     1                         luw,file_w
      write(lerr,'(a,t40,i5)') 'number of input samples',nsamp_in
      write(lerr,'(a,t40,i5)') 'number of input traces',ntr  
      write(lerr,'(a,t40,i5)') 'number of input records',nrec_in 
      write(lerr,'(a,t40,i5)') 'starting line to analyze',startline  
      write(lerr,'(a,t40,i5)') 'ending line to analyze',endline  
      write(lerr,'(a,t40,i5)') 'line skip increment',skipline  
      write(lerr,'(a,t40,f12.6)') 'sample interval (msec)',dtmsec
      write(lerr,'(a,t40,f12.6)') 'sample interval (sec)',dt
      write(lerr,'(a,t40,f12.6)') 'original start time (msec)',
     1                             tstart_orig
      write(lerr,'(a,t40,f12.6)') 'original end time (msec)',
     1                             tend_orig
      write(lerr,'(a,t40,f12.6)') 'output start time (msec)',
     1                             tstart
      write(lerr,'(a,t40,f12.6)') 'output end time (msec)',
     1                             tend
      write(lerr,'(a,t40,f12.6)') 'skip time (msec)',tskip   
      write(lerr,'(a,t40,f12.6)') 'operator window (msec)',twindow
      write(lerr,'(a,t40,f12.6)') 'window taper (%)', ptaper
      write(lerr,'(a,t40,f12.6)') 'window taper (msec)', ttaper
      write(lerr,'(a,t40,i5)') 'half inner window (samples)',
     1                          lenw_inner
      write(lerr,'(a,t40,i5)') 'half outer window (samples)',
     1                          lenw_outer
      write(lerr,'(a,t40,i5)') 'start time (samples)',istart
      write(lerr,'(a,t40,i5)') 'end time (samples)',iend  
      write(lerr,'(a,t40,i5)') 'skip time (samples)',iskip 
      write(lerr,'(a,t40,i5)') 'output samples per trace',nsamp_out
      write(lerr,'(a,t40,i5)') 'input bytes per trace',nbytes_in
      write(lerr,'(a,t40,i5)') 'output bytes per trace',nbytes_out
      write(lerr,*) ('_',i=1,80)
      write(lerr,*) 'Equal frequency increment mode'
      write(lerr,*) ('_',i=1,80)
      write(lerr,'(a,t40,f12.6)') 'minimum frequency (Hz)',fmin  
      write(lerr,'(a,t40,f12.6)') 'maximum frequency (Hz)',fmax  
      write(lerr,'(a,t40,f12.6)') 'frequency increment (Hz)',df
      write(lerr,'(a,t40,f12.6)') 'percent prewhitening',pc
      write(lerr,'(a,t40,i5)') 'ifl',ifl,'ifh',ifh
      write(lerr,'(a,t40,i5)') 
     1           'number of output spectral components',ncomponent
c
      write(lerr,'(a,t40,l5)') 'verbose output?',verbose     
      write(lerr,*)' '
      pc=.01*pc
      lenu=iend-istart+1+2*lenw_outer
      lenamp=(iend-istart+1)*(nx+1)
      lentable=2*(iend-istart+1+2*lenw_outer)*(ifh-ifl+1)
      lenbuf=ITRWRD+max(nsamp_in,nsamp_out,2*lenw_outer+1)
c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)
C
      l_free=1
c____________________________________________________________________
      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('uin',l_uin,l_free,lenu*(nx+1),lerr)
      call mapmem('live',l_live,l_free,nx+1,lerr)
      call mapmem('uexp',l_uexp,l_free,2*lenu,lerr)
      call mapmem('cspec',l_cspec,l_free,2*(iend-istart+1),lerr)
      call mapmem('amp',l_amp,l_free,lenamp,lerr)
      call mapmem('tabledexp',l_tabledexp,l_free,lentable,lerr)
      call mapmem('tracebuf',l_tracebuf,l_free,lenbuf,lerr)
      call mapmem('trheader',l_trheader,l_free,(nx+1)*ITRWRD,lerr)
      call mapmem('omega',l_omega,l_free,ifh-ifl+1,lerr)           
      call mapmem('wgt',l_wgt,l_free,2*lenw_outer+1,lerr)           
      call mapmem('ampmax',l_ampmax,l_free,
     1            (iend-istart+1)*(ifh-ifl+1),lerr)           
C_______________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      write(ler,'(a20,10x,i10)') 'allocate ',lens,' words of memory'
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(lerr,*)'memory can be decreased by using the -M option'
         write(lerr,*)
         write(lerr,*)'program SWAK aborted'
         close(lerr)
c        call exit(101)
	 stop 101
      endif
c_______________________________________________________________________
c     calculate decomposition frequencies.                          
c_______________________________________________________________________
      call getomega(s(l_omega),ifh,ifl,dp,df,
     1              frequencies,verbose,lerr)
c_______________________________________________________________________
c     calculate the taper weights.                                  
c_______________________________________________________________________
      call gttapr(s(l_wgt),-hw_outer,-hw_inner,+hw_inner,+hw_outer,
     1            dtmsec,-lenw_outer,+lenw_outer)
C_______________________________________________________________________
c     precompute exponential (sin/cos) tables.                      
C_______________________________________________________________________
      call gettable(s(l_tabledexp),s(l_omega),
     1              ifh,ifl,istart,iend,lenw_outer,dt,
     2              verbose,lerr)
c_______________________________________________________________________
c     modify line header to reflect actual number of traces output
c
c     store (ifl,ifh) in header words (MnGrEl,MxGrEl)
c     store (df) in header word MutVel           
c_______________________________________________________________________
      call savhlh(sheader,lbytes,lbyout)
      call savew(sheader,'OrNTRC',nptaper,LINEHEADER)
      call savew(sheader,'OrNREC',nwindow,LINEHEADER)
      call savew(sheader,'NumRec',2,LINEHEADER)
      call savew(sheader,'NumTrc',ifh-ifl+1,LINEHEADER)
      call savew(sheader,'NumSmp',nsamp_out,LINEHEADER)
      call savew(sheader,'SmpInt',nsi_out,LINEHEADER)
      call savew(sheader,'NumCmp',ncomponent,LINEHEADER)
      jtstart=nint(tstart)
      jtend=nint(tend)
      jtslice=nint(iskip*dtmsec)
      call savew(sheader,'TmMsFS',tstart,LINEHEADER)
      call savew(sheader,'TmMsSl',jtstart,LINEHEADER)
      call savew(sheader,'TmSlIn',jtslice,LINEHEADER)
      call savew(sheader,'MnGrEl',ifl,LINEHEADER)
      call savew(sheader,'MxGrEl',ifh,LINEHEADER)
      call savew(sheader,'MutVel',df,LINEHEADER)
      call wrtape(luout,sheader,lbyout)
c
      if(wrw) then
c_______________________________________________________________________
c        write out wavelets (including its line header).
c_______________________________________________________________________
         call savew(sheader,'NumRec',2,LINEHEADER)
         call savew(sheader,'NumTrc',ifh-ifl+1,LINEHEADER)
         call savew(sheader,'NumSmp',2*lenw_outer+1,LINEHEADER)
         call wrtape(luw,sheader,lbyout)
         call wrwavlet(s(l_tracebuf),s(l_wgt),s(l_tabledexp),
     1                 istart,iend,ifl,ifh,dfp,dt,
     2                 lenw_outer,ITRWRD,
     3                 luw,lerr,nbytes_in,verbose,
     4                 ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     5                 ifmt_RecNum,l_RecNum,ln_RecNum,
     6                 ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
         call lbclos(luw)
      endif
      call timend(cputim(1),v1,v2,waltim(1),w1,w2)
      minlive=.1*(nx+1)
c__________________________________________________________________
c     initialize output array.
c__________________________________________________________________
      call init(s(l_ampmax),istart,iend,ifl,ifh)   
c__________________________________________________________________
c     skip to the starting line to be analyzed.
c__________________________________________________________________
      call recskp(1,startline-1,luin,nx+1,s(l_tracebuf))
      call timstr(v0,w0)
      do 90000 jrec=startline,endline,skipline
       if(jrec .gt. startline) then
          write(ler,'(a,i5,a,i5,a,i5,a,i5,a,i5,a)')
     1    'swak: process record ',jrec,' of ',nrec_in,
     2    ' time to completion: ',nhour,' hr',
     3      nmin,' min',nsec,' sec'
       endif
c__________________________________________________________________
c       read in a gather.
c__________________________________________________________________
        call rdgather(s(l_uin),s(l_trheader),
     1                s(l_tracebuf),s(l_tracebuf),nx,nlive,    
     2                istart,iend,lenw_outer,nsamp_in,
     3                s(l_live),luin,eof,ITRWRD,TRACEHEADER,
     4                ifmt_StaCor,l_StaCor,ln_StaCor)
        if(eof) then
           write(lerr,*)'End of file on input:'
           write(lerr,*)'  rec= ',jrec
           go to 90001
        endif
        do 80000 jf=ifl,ifh  
c__________________________________________________________________
c        decompose the data for each frequency.
c__________________________________________________________________
         call process(s(l_uin),s(l_amp),
     1               s(l_uexp),s(l_cspec),
     2               s(l_tabledexp),s(l_wgt),s(l_live),
     3               jf,ifl,ifh,nx,istart,iend,iskip,
     4               lenw_inner,lenw_outer,
     5               verbose,lerr)
c__________________________________________________________________
c       calculate ampmax(jt,jf) up to and including the present
c       line.
c__________________________________________________________________
        call timstr(v1,w1)
        call  getmax(s(l_amp),s(l_ampmax),s(l_live),
     1               jf,istart,iend,ifl,ifh,nx,lerr)
        call timend(cputim(17),v1,v2,waltim(17),w1,w2)
80000  continue
c_____________________________________________________________
c      calculate average wall time for completely
c      filled lines.
c_____________________________________________________________
       call timstr(vcurr,wcurr)
       time_per_line=(wcurr-w0)/(jrec-startline+1)
c_____________________________________________________________
c      predict wall time to completion.
c_____________________________________________________________
       time_left=(endline-jrec)*time_per_line
       nhour=time_left/3600.
       nmin=(time_left-3600.*nhour)/60.
       nsec=time_left-3600.*nhour-60.*nmin
c_____________________________________________________________
c      skip over any records that will not be analyzed.
c_____________________________________________________________
       if(skipline .gt. 1) then
          write(ler,*) 'skip lines ',jrec+1,' through ',
     1                 jrec+skipline-1
          call recskp(jrec+1,jrec+skipline-1,luin,nx+1,
     1                s(l_tracebuf))
       endif
90000 continue
90001 continue
c_____________________________________________________________
c     write out the wavelet amplitude as a function of time and
c     frequency.
c_____________________________________________________________
      call wrgather(s(l_ampmax),s(l_tracebuf),s(l_tracebuf),
     1              luout,istart,iend,iskip,ifl,ifh,df,pc,
     2              ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     3              ifmt_RecNum,l_RecNum,ln_RecNum,
     4              ifmt_RecInd,l_RecInd,ln_RecInd,
     6              ifmt_StaCor,l_StaCor,ln_StaCor,
     7              ITRWRD,TRACEHEADER,nbytes_out)
c_____________________________________________________________   
c     write out timing statistics.
c_____________________________________________________________   
      call timend(cputim(20),vtot,v2,waltim(20),wtot,w2)
      write(lerr,'(A30,2A15,/)') 'routine','cpu time','wall time'
      write(lerr,'(A30,2f15.3)')
     1         'read input',cputim(1),waltim(1),
     2         'cross multiply',cputim(4),waltim(4),
     2         'initialize sum',cputim(5),waltim(5),
     2         'running sum',cputim(6),waltim(6),
     2         'taper windows',cputim(7),waltim(7),
     2         'calc amp',cputim(8),waltim(8),
     4         'getmax',cputim(17),waltim(17),
     c         'total',cputim(20),waltim(20)
c_____________________________________________________________   
c     close all open data files.
c_____________________________________________________________   
      call lbclos(luin)
      call lbclos(luout)
c
      write(ler,*)'normal completetion. routine SWAK'           
      write(lerr,*)'normal completetion. routine SWAK'           
      close(lerr)
c     call exit(0)
      stop 0
      end
      subroutine help(ler)

      write(ler,*)
     1'**************************************************************'
      write(ler,*)'3-D Seismic Tuning cube (D1 spectral decomp)'
      write(ler,*)'Non AMOCO users require a license from AMOCO'
      write(ler,*)'to use this software and any documentation' 
      write(ler,*)
     1'**************************************************************'
      write(ler,*)'execute swak by typing swak and list of'
     1                   //' program parameters.'
      write(ler,*)
     1'note that each parameter is proceeded by -a where "a" is '
      write(ler,*)
     1'a character(s) corresponding to some parameter.'
      write(ler,*)
     1'users enter the following parameters, or use the default values'
      write(ler,*)' '
      write(ler,*)
     1' -N [file_in]  (stdin)       : input seismic file name'          
      write(ler,*)
     1' -O [file_out]  (stdout)     : output estimate of the wavelet'
     2 //' amplitude spectrum as a function of time'
      write(ler,*)
     1' -W [file_wavelets] (Optional)      : output wavelet file name'          
      write(ler,*)' '
      write(LER,*)'--------------------------------------------------'
      write(LER,*)'Data analysis limits' 
      write(LER,*)'-tstart[tstart] -- start time in ms  (first samp)'
      write(LER,*)'-tend[tend]     -- end time in ms     (last samp)'
      write(LER,*)'-tskip[tskip]   -- output increment in ms    (dt)'
      write(LER,*)'-startline[startline] -first line to analyze (1)'        
      write(LER,*)'-endline[startline]   -last line to analyze (last)'
      write(LER,*)'-skipline             -line analysis increment (1)'
      write(LER,*)'--------------------------------------------------'
      write(LER,*)'Operator window design:'
      write(LER,*)'-twindow[twindow] -- Full window length   (96 ms)'
      write(LER,*)'-ptaper[ptaper] -- Percent cosine Taper    (20%)' 
      write(LER,*)'     (100% => full taper; 0% => no taper)'
      write(LER,*)
      write(LER,*)'--------------------------------------------------'
      write(LER,*)

      write(LER,*)'--------------------------------------------------'
      write(LER,*)'Spectral Analysis Parameters '
      write(LER,*)'-fmin[fmin]   -- min frequency in Hz '
     1                                  //'(1000/twindow)'
      write(LER,*)'-fmax[fmax]   -- max frequency in Hz   (80Hz)'
      write(LER,*)'-df[df]       -- frequency increment in Hz '
     1                  //'(.5*1000./twindow, or 2 Nyquist rate)'
      write(LER,*)'--------------------------------------------------'
      write(LER,*)'Scaling window design:'
      write(LER,*)'-pc[] -- Percent prewhitening (10%)'
      write(LER,*)
      write(LER,*)'------------------------------------------------'
      write(LER,*)'Other Program Options:'
      write(LER,*)'-V         -- verbose printout'
      write(LER,*)' '
      write(ler,*)
      write(LER,*)'=================================================='
      write(LER,*)'Usage:'
      write(ler,*)'swak -N[file_in] -O[file_out] -W[file_wavelets]'
      write(LER,*)'        -tstart[] -tend[] -tskip[] '
      write(LER,*)'        -startline[] -endline[] -skipline[]'
      write(LER,*)'        -twindow[] -ptaper[] -pc[]'
      write(LER,*)'        -fmin[] -fmax[] -df[]'
      write(LER,*)'        -V '
      write(LER,*)'=================================================='

      write(ler,*)' '
      write(ler,*)

      return
      end
