C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine wrgather(wamp,tracebuf,ibuffer,
     1                    luout,istart,iend,iskip,ifl,ifh,df,pc,
     2                    ifmt_TrcNum,l_TrcNum,ln_TrcNum,                   
     3                    ifmt_RecNum,l_RecNum,ln_RecNum,       
     4                    ifmt_RecInd,l_RecInd,ln_RecInd,       
     6                    ifmt_StaCor,l_StaCor,ln_StaCor,       
     7                    ITRWRD,TRACEHEADER,nbytes_out)
c
      real      wamp(istart:iend,ifl:ifh)
      real      tracebuf(-ITRWRD:*)
      integer   ibuffer(ITRWRD)         
c______________________________________________________________
c     initialize the trace header
c______________________________________________________________
      do 14000 jh=1,ITRWRD  
       ibuffer(jh)=0
14000 continue
      jrec=1
      call savew2(tracebuf,ifmt_RecNum,l_RecNum,ln_RecNum,
     1            jrec,TRACEHEADER)
      jsta=0
      call savew2(tracebuf,ifmt_StaCor,l_StaCor,ln_StaCor,
     1            jsta,TRACEHEADER)
c______________________________________________________________
c     write out the time variant wavelet, one frequency component
c     per trace.
c______________________________________________________________
      jtr=0
      do 20000 jf=ifl,ifh
       jtr=jtr+1
       call savew2(tracebuf,ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1             jtr,TRACEHEADER)
       jval=nint(jf*df)
       call savew2(tracebuf,ifmt_RecInd,l_RecInd,ln_RecInd,
     1             jval,TRACEHEADER)
       k=0
       do 15000 jt=istart,iend,iskip
        tracebuf(k)=wamp(jt,jf)
        k=k+1
15000  continue
       call wrtape(luout,tracebuf(-ITRWRD),nbytes_out)
20000 continue
c______________________________________________________________
c     calculate the  inverse of the wavelet spectrum.
c     stabalize this result by adding a percentage of the
c     peak amplitude before inverting.
c______________________________________________________________
      do 50000 jt=istart,iend,iskip
       do 30000 jf=ifl,ifh
        wmax=max(wmax,wamp(jt,jf))
30000  continue
       eps=pc*wmax
       do 40000 jf=ifl,ifh
        wamp(jt,jf)=255./(wamp(jt,jf)+eps)
40000  continue
50000 continue
      jrec=2
      call savew2(tracebuf,ifmt_RecNum,l_RecNum,ln_RecNum,
     1            jrec,TRACEHEADER)
c______________________________________________________________
c     write out the time variant scale factor, one frequency component
c     per trace.
c______________________________________________________________
      jtr=0
      do 70000 jf=ifl,ifh
       jtr=jtr+1
       call savew2(tracebuf,ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1             jtr,TRACEHEADER)
       jval=nint(jf*df)
       call savew2(tracebuf,ifmt_RecInd,l_RecInd,ln_RecInd,
     1             jval,TRACEHEADER)
       k=0
       do 60000 jt=istart,iend,iskip
        tracebuf(k)=wamp(jt,jf)
        k=k+1
60000  continue
       call wrtape(luout,tracebuf(-ITRWRD),nbytes_out)
70000 continue


      return
      end 
