C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine getdelay(jpdelay,jpadvance,locate,
     1                     p,q,npoint,dx,dy,dxi,dyi,
     2                     kximin,kximax,kyimin,kyimax,
     3                     jpqlive,npqlive,nangs,dfine,ntfine,
     4                     np,nq,jplive,jqlive,verbose,lerr)
c_________________________________________________________________
c     calculate delays of the form:
c
c     u{tau-(p*x+q*y)}
c
c     calculate advances of the form:
c
c     u{tau+(p*x+q*y)}
c
c     at a given (x,y) point.
c
c     locate(1,ipoint)..relative x position in units of dx of
c                       point ipoint in the computational stencil.
c     locate(2,ipoint)..relative y position in units of dy of
c                       point ipoint in the computational stencil.
c     dx................input x grid spacing in m (ft).
c     dy................input y grid spacing in m (ft).
c     dxi...............interpolated output x grid spacing in m (ft).
c     dyi...............interpolated output y grid spacing in m (ft).
c_________________________________________________________________
      real     p(np),q(nq)
      integer  jpdelay(npqlive,npoint,2)                   
      integer  jpadvance(npqlive,kximin:kximax,kyimin:kyimax,2)
      integer  locate(2,npoint)
      integer  jpqlive(npqlive),jplive(npqlive),jqlive(npqlive)
      logical  verbose
      parameter (pi=3.1415926)
      do 52000 jpq=1,npqlive     
       jang=jpqlive(jpq)
       jp=jplive(jpq)
       jq=jqlive(jpq)
c_________________________________________________________________
c      calculate delay times needed for forward (tau,p,q) transform
c      for each input point in the analysis window.
c_________________________________________________________________
       if(verbose) then
          write(lerr,'(9a10)') 'jpq','p','q','x','y','pdelay',
     1      'jpfine','jpdelay(1)','jpdelay(2)'
       endif 
       do 10000 ipoint=1,npoint
        x=locate(1,ipoint)*dx
        y=locate(2,ipoint)*dy
        pdelay=(p(jp)*x+q(jq)*y)
        jpfine=nint(pdelay/dfine)
        jsamp=jpfine/ntfine
        jint=mod(jpfine,ntfine)
        if(jint .lt. 0) then
           jsamp=jsamp-1
           jint=jint+ntfine
        endif
        jpdelay(jpq,ipoint,1)=jsamp          
        jpdelay(jpq,ipoint,2)=jint                             
        if(verbose) then
           write(lerr,'(i10,5f10.3,3i10)') jpq,p(jp),q(jq),x,y,
     1        pdelay,jpfine,jpdelay(jpq,ipoint,1),
     2        jpdelay(jpq,ipoint,2)
        endif
10000  continue
c_________________________________________________________________
c      calculate advance times needed for reverse (tau,p,q) transform
c      for each interpolated output point.    
c_________________________________________________________________
       if(verbose) then
          write(lerr,'(8a10)') 'p','q','x','y','padvance',
     1      'jpfine','jpadvance(1)','jpadvance(2)'
       endif 
       do 30000 ky=kyimin,kyimax
        y=ky*dyi
        do 20000 kx=kximin,kximax
         x=kx*dxi
         padvance=-(p(jp)*x+q(jq)*y)
         jpfine=nint(padvance/dfine)
         jsamp=jpfine/ntfine
         jint=mod(jpfine,ntfine)
         if(jint .lt. 0) then
            jsamp=jsamp-1
            jint=jint+ntfine
         endif
         jpadvance(jpq,kx,ky,1)=jsamp
         jpadvance(jpq,kx,ky,2)=jint
         if(verbose) then
           write(lerr,'(5f10.3,3i10)') p(jp),q(jq),x,y,
     1        padvance,jpfine,jpadvance(jpq,kx,ky,1),
     2        jpadvance(jpq,kx,ky,2)
         endif
20000   continue
30000  continue
52000 continue

c
      return
      end
