C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine process(utxfine,utxfine2,live,ntfine,
     1                   w,wsemb,uout, 
     2                   usemb,utaupq,utaupqfine,
     3                   unum,udenom,
     4                   unumsum,udenomsum,
     5                   jpdelay,jpadvance,npqlive,nangs,
     6                   lenhed,cputim,waltim,
     7                   iypointer,jy,ny,locate,nt,nx,npoint,
     8                   ltsemb,mx,my,nsamp_out,
     9                   lerr,jrec,kstart,kend,istart,iend,
     a                   kximin,kximax,kyimin,kyimax,interpolate,
     b                   eps2,sigma1,sigma2,wgtpq,
     c                   rho,cbuf,rbuf,nfft,ifl,ifh,
     d                   uomegaxy,uomegapq,rr,rho_filt,
     e                   starttrace,endtrace,startline,endline)
c___________________________________________________________________
c     input seismic records.                  
c___________________________________________________________________
      real      utxfine(0:nt,0:ntfine-1,-mx:nx+mx,-my:+my)   
      real      utxfine2(0:nt,0:ntfine-1,-mx:+mx,-my:+my)   
      integer   iypointer(-my:ny+my)
      logical   live(-mx:nx+mx,-my:+my)
c___________________________________________________________________
c     arrays for output interpolated traces.  
c___________________________________________________________________
      real      uout(istart:iend,0:nx,kximin:kximax,kyimin:kyimax)     
      complex   uomegaxy(0:nfft/2-1)
c___________________________________________________________________
c     arrays used in semblance calculation.
c___________________________________________________________________
      real      unum(0:nt,npqlive),udenom(0:nt,npqlive)
      real      unumsum(0:nt,npqlive),udenomsum(0:nt,npqlive)
      real      usemb(0:nt,npqlive)  
      real      wsemb(0:nt,npqlive)  
      real      w(-2:+3,0:ntfine)
c___________________________________________________________________
c     radon (tau,p,q) and (omega,p,q) transform variables.                    
c___________________________________________________________________
      real      utaupq(-2:nt+3,npqlive)
      real      utaupqfine(0:nt,0:ntfine-1,npqlive)
      complex   uomegapq(ifl:ifh)
      integer   jpdelay(npqlive,npoint,2)
      integer   jpadvance(npqlive,kximin:kximax,kyimin:kyimax,2)
      logical   interpolate
c___________________________________________________________________
c     reverse   (omega,p,q) transform matrix
c___________________________________________________________________
      complex   rr(ifl:ifh,npqlive,kximin:kximax,kyimin:kyimax)
c___________________________________________________________________
c     packed mute array
c___________________________________________________________________
      real      wgtpq(npqlive) 
c___________________________________________________________________
c     rho filter and fft arrays.
c___________________________________________________________________
      real      rbuf(0:nfft-1)
      real      rho(ifl:ifh)
      complex   cbuf(0:nfft/2-1)
c___________________________________________________________________
c     grid stencil for the transform and spatial weights.
c___________________________________________________________________
      integer   locate(2,npoint)
c___________________________________________________________________
c     timing arrays.
c___________________________________________________________________
      real     cputim(*),waltim(*)
c___________________________________________________________________
c     control parameters
c___________________________________________________________________
      integer   starttrace,endtrace,startline,endline
      logical   rho_filt
c___________________________________________________________________
c     loop over the inline (x) direction, taking the radon transform.
c     points lieing outside the computational window are 'dead' 
c     (i.e. live(jx,jy)=.false.)
c___________________________________________________________________
      dsigma=sigma2-sigma1
      if(dsigma .eq. 0.) then
         oodsigma=1.
      else
         oodsigma=1./dsigma
      endif
      do 90000 jx=0,nx             
       jrec=jrec+1
c___________________________________________________________________
c      calculate utxfine2 over the computation star.
c___________________________________________________________________
       call timstr(v1,w1)
       do 30000 jpoint=1,npoint
        kx=locate(1,jpoint)
        ix=jx+kx                  
        iy=iypointer(jy+locate(2,jpoint))
        if(live(ix,iy)) then
           do 46000 jtfine=0,ntfine-1
            do 45000 jt=kstart,kend
             utxfine2(jt,jtfine,kx,iy)=utxfine(jt,jtfine,ix,iy)**2
45000       continue
46000      continue
        endif
30000  continue
       call timend(cputim(9),v1,v2,waltim(9),w1,w2)
c___________________________________________________________________
c      calculate utaupq and usemb for each (tau,p) pair.
c___________________________________________________________________
       call taupsemb(utxfine,utxfine2,ntfine,
     1               usemb,utaupq,unum,udenom,
     2               unumsum,udenomsum,
     3               ltsemb,nt,jpdelay,
     4               iypointer,locate,live,
     5               npqlive,npoint,jx,nx,mx,jy,ny,my,
     6               anorm,nlive,lerr,cputim,waltim,
     7               istart,iend,eps2)
c___________________________________________________________________
c      calculate the semblance weights.
c      no phase advance needed for inverse (tau,p,q) transform,
c      since we are calculating the transform along (x=0,y=0).
c___________________________________________________________________
       call timstr(v1,w1)
       do 50000 jpq=1,npqlive
        awgt=wgtpq(jpq)
        do  49000 jt=istart,iend
         sigma=usemb(jt,jpq)*anorm 
         if(sigma .lt. sigma1) then
            wsemb(jt,jpq)=0.
         elseif(sigma .ge. sigma2) then
            wsemb(jt,jpq)=awgt           
         else
            wsemb(jt,jpq)=(sigma-sigma1)*oodsigma*awgt
         endif
49000   continue
50000  continue
       call timend(cputim(15),v1,v2,waltim(15),w1,w2)

       if(rho_filt) then
          afact=anorm/npoint
c___________________________________________________________________
c         conventional (tau,p,q) inverse transform using the rho filter.
c___________________________________________________________________
          call revtaup(utaupq,utaupqfine,wsemb,uout,w,jx,nx,
     1                 istart,iend,kstart,kend,nt,ntfine,
     2                 jpadvance,npqlive,kximin,kximax,kyimin,kyimax,
     3                 afact,interpolate,cputim,waltim,lerr,
     4                 rho,cbuf,rbuf,nfft,ifl,ifh)
       else 
c___________________________________________________________________
c         discrete Radon transform least squares inverse.
c___________________________________________________________________
          call timstr(v1,w1)
          call revdrt(utaupq,uomegapq,uout,uomegaxy,rr,rbuf,cbuf,
     1                wsemb,kximin,kximax,kyimin,kyimax,npqlive,
     2                anorm,nt,nfft,ifl,ifh,istart,iend,
     3               jx,nx,nlive)
          call timend(cputim(17),v1,v2,waltim(17),w1,w2)
       endif
90000 continue
c
      return
      end
