C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getwgt(wgt,s,e,ns,ne,linear,hamming,blackman,lerr,
     1                  verbose,up)         
c
      parameter  (pi=3.14159265,twopi=2.*pi)
c
      real wgt(ns:ne)    
c
      logical linear,hamming,blackman,up,verbose
c
      if(e .eq. s) then
         wgt(ns)=1.
      else
         do 10000 j=ns,ne
          if(up) then
             dist=(j-s)/(e-s)
          else
             dist=(e-j)/(e-s)
          endif
          if(linear) then
             wgt(j)=dist
          theta=twopi*(j-s)/(e-s)
          elseif(hamming) then
             wgt(j)=.54+.46*cos(twopi*theta)
          elseif(blackman) then
             wgt(j)=.42+.5*cos(twopi*theta)+.08*cos(2.*twopi*theta)
          endif
10000    continue
      endif
      if(verbose) then
         write(lerr,*) 'weights up = ',up                       
         write(lerr,'(3a12)') 'j','wgt(j)'
         write(lerr,'(i12,f12.6)') (j,wgt(j),j=ns,ne)       
      endif
c
      return
      end
