C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Main Routine -----------------------
c
c     Program Description:
c     program to read tdfn and convert to xsd
c     
c     James M. Gridley
c     August 1996

c
c get machine dependent parameters
 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>
 
c dimension standard USP variables
 
      integer     luin , luout
      integer     Xsd_Color, Xsd_Num
      integer     argis, Total_Traces
      integer     Total_Records,pass
 
      real        Record( SZLNHD ),Velocity(SZLNHD)
      real        Unit(SZLNHD)
      real        samp
 
      character   ntap*255, otap*255, name*12
      character   Xsd_Name*255
      logical     EndFile,Plot, Stck, PStck, flat
      real        maxvel, minvel
 
c Program Specific _ dynamic memory variables
 
c Initialize variables
 
      data abort/1/
      data name/"TDFNVIEW"/
      Plot=.false.
      Stck=.false.
      PStck=.false.
      flat=.false.
      pass = 0
c     give command line help if requested
 
      if ( argis ( '-?' ) .gt. 0 .or.
     :     argis ( '-h' ) .gt. 0 .or.
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif
 
c     open printout file
 
#include <f77/open.h>
 
c     get command line input parameters
    
      
      call cmdln ( ntap, otap, samp, Plot, Total_Traces, 
     :     Total_Records, Stck, PStck, flat )
      
    
c     open input and output files
      
      luin = 10
      luout = 11
      open(luin, file=ntap, status='unknown')
      open(luout, file=otap, status='unknown')
      
c     read input line header and save certain parameters
      
 
      
c     number output bytes
      
      do i = 1, 10000
         Velocity(i)=0.
         Record(i)=0.
         Unit(i)=0.
      enddo
      jcount=0
      MaxFunc=0
      nfunc=0
      nunits=0
      MaxNum=0
      maxvel=0.
      minvel=999999.
c      i=1
c      N=0

      if (.not. flat) then
 5       call TdfnReadCards (luin, Record, Velocity, Unit, N,
     :        NumEntries, EndFile )
         
         do i=1,N
            maxvel = max(Velocity(i),maxvel)  
            minvel = min(Velocity(i),minvel)
         enddo
         
         nfunc=nfunc+1
         MaxNum=max(N,MaxNum)
         MaxFunc=max(MaxFunc,NumEntries)
         
         if(EndFile) goto 800
         nunits=N+nunits
         go to 5
      endif 
c=================================================================
      if (flat) then
      
         i = 1
         N=0
 7       read(luin,*,end=700,err=999)
     :        Unit(i),Velocity(i),Record(i)

         pass=pass + 1
         if(Unit(i) .eq. -1 .and. Velocity(i) .eq. 0) then
            N = N + 1
            i=i-1
            pass = pass -1
            NumEntries =  i 
            MaxNum=max(N,MaxnNum)
            MaxFunc=max(MaxFunc,NumEntries)
c         i=0
         endif
      
         i = i + 1
     
         go to 7
      
 700    do i = 1, pass

            maxvel = max(Velocity(i),maxvel)  
            minvel = min(Velocity(i),minvel)
         enddo
         
      endif
c=================================================================
      
 800  rewind(unit=10)
      EndFile=.false.
      pass = 0

c     verbose output of all pertinent information before processing begins
      

      call verbal ( ntap, otap, samp, Plot, Total_Traces,
     :     Total_Records, Stck, PStck, flat)

c     BEGIN PROCESSING
      Vel_Range = maxvel - minvel
      icount = 0
      iunit = 0
      
      
 10   if(.not. flat) then
         call TdfnReadCards (luin, Record, Velocity, Unit, N,
     :        NumEntries, EndFile )
         if(EndFile) goto 900

     
         icount = icount + 1
       
         if(icount .eq. 1) then
            MaxNum = 1
            RecUnit=1.
            VelUnit=1.
            RecOffset=0.
            VelOffset=0.
            SmpOffset=1.
            nrec=0
            ntrc=0
            nsamp=0
         endif
      
      elseif (flat) then
 
         icount=1
 17      read(luin,*,end=900,err=999)
     :        Unit(icount),Velocity(icount),Record(icount)
         if(Unit(icount) .eq. -1 .and. Velocity(icount) .eq. 0) then
            go to 20
         else
            icount = icount + 1
            go to 17
         endif
      endif


 20   if (icount .eq. 1) then
         MaxNum = 1
         RecUnit=1.
         VelUnit=1.
         RecOffset=0.
         VelOffset=0.
         SmpOffset=1.
         nrec=0
         ntrc=0
         nsamp=0
      endif
    
      if(flat) N=icount-1
      pass = pass + 1

      if (Stck .and. Total_Records .gt. 0 .and. pass .eq. 1) then
            write ( luout, 11) RecUnit, VelUnit, samp, nrec,
     :           ntrc, nsamp, RecOffset, VelOffset, SmpOffset,
     :           nunits, MaxNum
         elseif (Stck .and. Total_Record .eq. 0 .and. pass .eq.
     :           1) then
            write ( luout, 11) RecUnit, VelUnit, samp, nrec,
     :           ntrc, nsamp, RecOffset, VelOffset, SmpOffset,
     :           nfunc-1, MaxFunc
         elseif(PStck .and. Total_Traces .gt. 0 .and. pass .eq.
     :           1) then
            write ( luout, 11) RecUnit, VelUnit, samp, nrec,
     :           ntrc, nsamp, RecOffset, VelOffset, SmpOffset,
     :           nunits, MaxNum
         elseif(PStck .and. Total_Traces .eq. 0 .and. pass .eq. 
     :           1) then
            write ( luout, 11) RecUnit, VelUnit, samp, nrec,
     :           ntrc, nsamp, RecOffset, VelOffset, SmpOffset,
     :           nfunc-1, MaxFunc
         endif
 11      format('Units ',f12.6,1x,f12.6,1x,f12.6,1x,i5,1x,i5,1x,i5,
     :        ' Offset ',f12.6,1x,f12.6,1x,f12.6,' Count ',i5,1x,i5)
         
      
      Xsd_Name = '   NO_PICK_NAME_HERE'
      Xsd_Num=icount
      Xsd_Color = 0
      
      tmp=1.
      M = 1
      
c     just make file for plotting locations of picks
      if (Total_Traces .eq. 0 .and.
     :     Total_Records .eq. 0) then
         
        
         
         Do j = 1, N
            iunit=iunit +1
            write(luout,12) iunit, Xsd_Name, Xsd_Color, M
 12         format('Segment = ',i5,' Name ',a20,
     :           '  color = ',i5,' picks = ',i5)
         
            if (Stck ) then           
               write(luout,'(f12.6,1x,f12.6,1x,f12.6)')
     :              Record(j), tmp, Unit(j)
            elseif (PStck ) then
               write(luout,'(f12.6,1x,f12.6,1x,f12.6)')
     :              tmp, Record(j), Unit(j)
            endif
         enddo
         
         
         
      endif
      
      
      if (Total_Traces .gt. 0 .or. 
     :     Total_Records .gt. 0) then
         
         jcount = jcount + 1
         
         if( PStck) then
            
            write(luout,13) icount, Xsd_Name, Xsd_Color, 2*N - 1
 13         format('Segment = ',i5,' Name ',a20,
     :           '  color = ',i5,' picks = ',i5)
            
            do j = 1, N  
               iunit=iunit +1

               tmpvel = nint (((Velocity(j) - minvel)/Vel_Range)
     :              *(Total_Traces-1))
              
               write(luout,'(f12.6,1x,f12.6,1x,f12.6)')
     :              Record(j), tmpvel+1, Unit(j)
               
            enddo
         endif
         
         
c     if (Plot .and. Total_Records .ne. 0) then

         if (Stck) then
            tmp=1.
            write(luout,14) jcount, Xsd_Name, Xsd_Color, 2*N - 1
 14         format('Segment = ',i5,' Name ',a20,
     :           '  color = ',i5,' picks = ',i5)
            do j = 1, N  
               iunit=iunit +1
               tmpvel = nint (((Velocity(j) - minvel)/Vel_Range)
     :              *(Total_Records-1))
               
               write(luout,'(f12.6,1x,f12.6,1x,f12.6)')
     :              tmpvel+Record(j),tmp, Unit(j)
               
            enddo
         endif    
      endif
c     enddo
      
      if (EndFile) then
         goto 900
      else
         go to 10
      endif
      
 900  continue
c     close data files
      
      close(unit=10)
      close(unit=11)
      
      write(LERR,*)'tdfnview: Normal Termination'
      write(LER,*)'tdfnview: Normal Termination'
      go to 777
      
 999  continue
      
      close(unit=10)
      close(unit=11)
      
      write(LERR,*)'tdfnview: ABNORMAL Termination'
      write(LER,*)'tdfnview: ABNORMAL Termination'
 777  stop
      end
 
c     -----------------  Subroutine -----------------------
 
      subroutine help()
 
c     provide terse online help [detailed help goes in man page]
 
#include <f77/iounit.h>
 
      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for tdfnview: USP template'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input...................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                  (stdin)'
      write(LER,*)'-O[]   -- output data set                (stdout)'
      write(LER,*)'-dt[]  -- input sample interval (ms)        (2.0)'
      write(LER,*)'-S     -- Input is Stacked data         (Default)'
      write(LER,*)'-P     -- Input is Prestack data'
      write(LER,*)'-flat  -- Input file is a flat file format '
      write(LER,*)'                           Default is TDFN fromat'
      write(LER,*)'-trace[] --  Number of Traces to use for'
      write(LER,*)'   plotting width of velocity function  (0)'
      write(LER,*)'-rec[] --  Number of Records to use for'
      write(LER,*)'   plotting width of velocity function  (0)'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'       tdfnview -N[] -O[] -dt[] -trace[]  -rec[] '
      write(LER,*)'                [-flat, -S, -P, -V]'
      write(LER,*)' '
      write(LER,*)'===================================================='
 
      return
      end

c     -----------------  Subroutine -----------------------
 
c     pick up command line arguments
 
      subroutine cmdln ( ntap, otap, samp, Plot, Total_Traces,
     :     Total_Records, Stck, PStck, flat )
 
#include <f77/iounit.h>
 
      character  ntap*(*), otap*(*)
      real       samp
      integer    Total_Traces, Total_Records, argis
      logical    Plot, Stck, PStck, flat
     
      call argr4 ( '-dt', samp ,   2.  ,  2.  )

      flat = (argis('-flat') .gt. 0)

      call argstr ( '-N', ntap, ' ', ' ' )

      call argstr ( '-O', otap, ' ', ' ' )

      PStck = (argis('-P') .gt. 0)
   

      call argi4 ( '-rec', Total_Records, 0, 0)
      if(Total_Records  .gt. 0) Plot=.true.
   

      Stck = (argis('-S') .gt. 0) 
      if (Total_Traces .gt. 0 ) Plot=.true.    
     

      call argi4 ( '-trace', Total_Traces, 0, 0)

      if (.not. PStck  .and. 
     :    .not.  Stck  ) then
         Stck =.true.
      endif

c     check for extraneous arguments and abort if found to
c     catch all manner of user typo's
 
      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

 
      return
      end
 
c     -----------------  Subroutine -----------------------
 
c     verbal printout of pertinent program particulars
 
 
      subroutine verbal ( ntap, otap, samp, Plot, Total_Traces,
     :     Total_Records, Stak, PStck, flat)

#include <f77/iounit.h>
 
 
      character  ntap*(*), otap*(*)
      real samp
      integer Total_Traces, Total_Records
      logical Stak, PStck, flat
 
      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*)' '
      write(LERR,*) ' output data set name  =  ', otap
      write(LERR,*)'  Sample Interval  =  ',samp
      write(LERR,*)' '
      if (Stak) then
         write(LERR,*)'Input Data is Stacked Data'
      endif
      if (PStck) then
         write(LERR,*)'Input Data is Pretacked Data'
      endif
      write(LERR,*)' '
      if (flat) then
         write(LERR,*)'Input File is Flat File format'
      endif
      if (.not. Flat) then
         write(LERR,*)'Input File is TDFN format'
      endif
      write(LERR,*)' '
      if (Total_Traces .gt. 0) then
         write(LERR,*)'Velocity Function is  scaled over a range'
         write(LERR,*)'of  ',Total_Traces,' Traces'
      endif
      if (Total_Records .gt. 0) then
         write(LERR,*)'Velocity Function is  scaled over a range'
         write(LERR,*)'of  ',Total_Records,' Traces'
      endif      
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '
      
      return
      end
