C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine forward_stft( Headers, Record, Amplitude, Phase, 
     :     tri, Workspace, nsamp, ist, iend, nf, 
     :     nwin_samp, w, ctri, ntrc, ns, ne, 
     :     ifmt_StaCor, l_StaCor, ln_StaCor, verbos )

      implicit none

#include <f77/lhdrsz.h>
#include <save_defs.h> 

c variables passed from calling routine

      integer nsamp, ist, iend, nf, nwin_samp, ntrc, KK
      integer ns, ne, ifmt_StaCor, l_StaCor, ln_StaCor
      integer Headers(ITRWRD,ntrc)

      real Record(nsamp,ntrc)
      real Amplitude(nsamp,nf+1,ntrc)
      real Phase(nsamp,nf+1,ntrc)
      real tri(nsamp+nwin_samp)
      real Workspace(nsamp+nwin_samp)
      real w(nwin_samp)

      complex ctri(nf+1)

      logical verbos

c local variables

      integer StaCor
      integer start, finish, nft, i, j, k, nf_unpack

      real sum

c initialize variables

      nft = 2 * nf 
      nf_unpack = nf + 1

c set up loop parameters so that half window of zero 
c pad is taken into consideration

      start = ist + nf
      finish = iend + nf - 1
      
c Do forward transform over zone of record requested

      DO KK = ns, ne

c check for dead trace

         call saver2 ( Headers(1,KK-ns+1), ifmt_StaCor, l_StaCor, 
     :        ln_StaCor, StaCor, TRACEHEADER )

         IF ( StaCor .ne. 30000 ) THEN

c make certain data is zero for half window length beyond last sample
c and before first sample

            call vclr( tri, 1, nf )
            call vclr( tri(nsamp+1), 1, nf )
         
c move trace into tri() buffer

            call vmov ( Record(1,KK-ns+1), 1, tri(nf), 1, nsamp )


c process only the samples requested by the user

            DO i = start, finish

               call vclr ( Workspace , 1, nsamp )

               do j = 1, nf+1
                  ctri(j) = cmplx(0.0, 0.0)
               enddo

               sum = 0.
         
c load up window worth of data into workspace so that samples
c are centered at i

               do k = i, i + nwin_samp - 1
                  Workspace(k - i + 1) =  tri(k - nf)  * w(k - i + 1)
                  sum = sum + abs (Workspace(k - i + 1))
               enddo

               if (sum .ne. 0.) then
 
c if something in the window do fft

                  call rfftb( Workspace, ctri , nft , 1)
c                  call rfftsc ( ctri, nft , 2, 1)
                  call rfftsc ( ctri, nft , 3, 1)

c here we need to unpack the packed complex format comming from rfftb
c the output from that routine contains the real part of the first and
c nft/2+1 component in the first complex value.  The real part of the 
c nft/2+1 component occupies the complex slot of the first complex value.
c To unpack simply add the additional value to the end and supply a zero
c valued imaginary component to both locations.  Of course all logic from 
c here on must run for nf+1

c We want the first real samples to land on the first real data position.  
c This means subtract the half window size [nf] from the index
            
                  do k = 1, nf_unpack

c                     if ( k .eq. 1 ) then
c                        
c                        Amplitude ( i - nf + 1, k, KK ) = real(ctri(1))
c                        Phase ( i - nf + 1, k, KK ) = 0.0
c
c                     elseif ( k .eq. (nf_unpack) ) then
c          
c                        Amplitude ( i - nf + 1, k, KK ) = aimag(ctri(1))
c                        Phase ( i - nf + 1, k, KK ) = 0.0
c
c                     else
               
                     Amplitude ( i - nf + 1, k, KK ) = 
     :                    cabs ( ctri ( k ) )

                     Phase ( i - nf + 1, k, KK ) = 
     :                    atan2 ( aimag( ctri(k) ), real( ctri(k) ) )

c                     endif

                  enddo

               else

c trace was dead even if StaCor was not 30000, do not waste time doing
c a zero transform just load a zero phase dead spectra

                  do k = 1, nf_unpack
                     
                     Amplitude ( i - nf + 1, k, KK ) = 0.0
                     Phase ( i - nf + 1, k, KK ) = 0.0 

                  enddo

               endif

            ENDDO

         ELSE

c have a dead trace so load a zero phase dead spectra

            DO i = start, finish
               do k = 1, nf_unpack

                  Amplitude ( i - nf + 1, k, KK ) = 0.0
                  Phase ( i - nf + 1, k, KK ) = 0.0 
                  
               enddo
            ENDDO

         ENDIF
         
      ENDDO

      return
      end
