C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Subroutine -----------------------

c pick up command line arguments 

      subroutine cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, name, 
     :     nwin, statstap, functap, use_ratio, use_range, c_RecWrd, 
     :     c_TrcWrd, killtap, qc, velocity, step_size, xsdtap, 
     :     picktap, user_multiplier, zone, DesiredRunningCount, 
     :     DesiredStdDevMultiplier, globaltap, verbos )

#include <f77/iounit.h>

      integer    ist, iend, ns, ne, irs, ire, argis, nwin
      integer    step_size, DesiredRunningCount

      real velocity, user_multiplier, DesiredStdDevMultiplier

      character  ntap*(*), otap*(*), name*(*), statstap*(*)
      character  functap*(*), c_RecWrd*6, c_TrcWrd*6, killtap*(*)
      character  xsdtap*(*), picktap*(*), globaltap*(*)

      logical use_ratio, use_range, qc, zone, verbos

      call argi4 ( '-e', iend, 0, 0 )

      call argstr ( '-F', functap, ' ',' ' )
 
      call argstr ( '-G', globaltap, ' ',' ' ) 

      call argstr ( '-K', killtap, ' ',' ' ) 

      call argstr ( '-hw1', c_RecWrd, 'LinInd','LinInd' ) 
      call argstr ( '-hw2', c_TrcWrd, 'DphInd','DphInd' ) 

      call argr4 ( '-mult',user_multiplier, 1.0, 1.0 )

      call argi4 ( '-ntraces', DesiredRunningCount, 5, 5 )
      call argr4 ( '-nsigma', DesiredStdDevMultiplier, 4.0, 4.0 )
      call argi4 ( '-nwin', nwin, 32, 32 )
      call argi4 ( '-ne', ne, 0, 0 )
      call argi4 ( '-ns', ns, 0, 0 )
      call argstr ( '-N', ntap, ' ', ' ' ) 

      call argstr ( '-O', otap, ' ', ' ' )

      call argstr ( '-P', picktap, ' ', ' ' )

      use_range = (argis('-range') .gt. 0)
      use_ratio = (argis('-ratio') .gt. 0)

      qc = (argis('-qc') .gt. 0)

      call argi4 ( '-re', ire, 0, 0 )
      call argi4 ( '-rs', irs, 0, 0 )
      
      call argstr ( '-S', statstap, ' ',' ' ) 
      call argi4 ( '-s', ist, 1, 1 )
      
      call argi4 ( '-tstep', step_size, 1, 1 )

      call argr4 ( '-v', velocity, 10000000., 10000000. )

      verbos = (argis('-V') .gt. 0)

      call argstr ( '-X', xsdtap, ' ', ' ' )

      zone = (argis('-zone') .gt. 0)

c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

      return
      end

