C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine forward_stft( tri, Workspace, nsamp, ist, iend, nf,  
     :     nwin, stft_Record, nsampo, w, ctr, step_size, verbos )

c variables passed from calling routine

      integer nsamp, ist, iend, nf, nwin, nsampo
      integer step_size

      real tri(nsamp+nwin), Workspace(nsampo)
      real stft_Record( nsampo, nf) 
      real w(nwin)

      complex ctr(nf)

      logical verbos

c local variables

      integer start, finish

c initialize variables

      nft = 2 * nf 

c set up loop parameters so that first and last half window 
c are taken into consideration

      start = ist + nf
      finish = iend + nf - 1
      
      DO i = start, finish, step_size

         call vclr ( Workspace , 1, nsampo )

         do j = 1, nf
            ctr(j) = cmplx(0.0, 0.0)
         enddo

         sum = 0.
         
c load up window worth of data into workspace so that samples
c are centered at i

         do k = i, i + nwin -1
            Workspace(k - i + 1) =  tri(k - nf)  * w(k - i + 1)
            sum = sum + abs (Workspace(k - i + 1))
         enddo

         IF (sum .ne. 0.) then
 
c if something in the window do fft

            call rfftb( Workspace, ctr , nft , 1)
            call rfftsc ( ctr, nft , 2, 1)

c need to put amp spectrum components into output trace.  take the 
c effect of the half window pad out when loading the output data.  We want the
c first real samples to land on the first real data position.  This means 
c subtract the half window size [nf] from the index
            
            do k = 1, nf
               stft_record( i - nf + 1, k ) = cabs ( ctr ( k ) )
            enddo

         ELSE

            do k = 1, nf
               stft_record( i - nf + 1, k ) = 0.0
            enddo

         ENDIF
         
      ENDDO

      return
      end
