C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rpunch ( rdata, nsamp, ntrc, nt, nt2, nx, cdata, nkx, 
     :     nky, square, hole, zero )

c  pick the noise threads from kk data, calculate an average abs amp value in
c   square-hole and apply in hole.

c  input

c      rdata  -  matrix of real input data
c      nsamp  -  # samps in rdata
c       ntrc  -  # traces in rdata
c         nt  -  power of 2 time samples
c         nx  -  power of 2 # traces
c        nkx  -  base position of thread in x
c        nky  -  base position of thread in y
c     square  -  linear dimension of a square around punch out aone
c       hole  - linear dimension of a square punch out zone inside square


c output

c      cdata  -  matrix of complex transformed values (x,iy)
c      rdata  -  split matrix of complex transformed values (r,theta)

c declare variables passed from calling routine

      integer nsamp, ntrc, nt, nt2, nx, nkx, nky, square, hole

      real rdata( nt2, nx )

      complex  cdata( nt, nx )

      logical zero

c declare local variables

      integer i, j, kx, ix, kxout, kt, iamp, ktout, iphase, count
      integer ii, jj, tstep, xstep
       
      real out

c form amplitude and phase components

      do  kx = 1, nx
          
         if (kx .gt. nx/2) then
            kxout = kx - nx/2
         else
            kxout = nx/2 + kx
         endif
          
         ix = kxout
 
         do  kt = 1, nt
 
            if (kt .gt. nt/2) then
               ktout = kt - nt/2
            else
               ktout = nt/2 + kt
            endif
 
            iamp   = nt  - ktout + 1
            iphase = nt2 - ktout + 1
 
            rdata(iamp, ix  ) = cabs ( cdata(kt,kx) )
 
            if (rdata(iamp, ix  ) .eq. 0.) then
               rdata(iphase, ix  ) = 0.
            else
               rdata(iphase, ix  ) =
     1              atan2 ( aimag(cdata(kt,kx)),
     2              real(cdata(kt,kx))  )
            endif
         enddo
      enddo

      tstep=nt/(2*nkx)
      xstep=nx/(2*nky)

c clean up noise threads at all hole/square locations

      DO kt= nt/2+1-tstep*nkx,nt,nkx

         DO kx= nx/2+1-xstep*nky,nx,nky

            if ((kt.ne.nt/2+1).or.(kx.ne.nx/2+1)) then
               out = 0.0
               count = 0

               IF ( .not. zero ) THEN

                  do i= kt-(square+1)/2,kt+(square+1)/2

                     do j= kx-(square+1)/2,kx+(square+1)/2

                        if ((j .lt. kx-(hole-1)/2) .or. 
     :                       (j.gt.kx+(hole-1)/2)) then

                           if ((i .lt. kt-(hole-1)/2).or.
     :                          (i.gt.kt+(hole-1)/2)) then

                              ii = i
                              jj = j
                              if (i .le.0 ) ii=nt+i
                              if (i .gt.nt ) ii=i-nt
                              if (j .le.0 ) jj=nx+j
                              if (j .gt.nx ) jj=j-nx
                              out= out + abs(rdata(ii,jj))
                              count =count +1
                           endif
                        endif
                     enddo
                  enddo

c form the average spectral amplitude in the area of the square that
c is outside the area of the circle

                  out= out/count

c fill in the circle area with this average

                  do i= kt-(hole-1)/2,kt+(hole-1)/2
                      
                     do j= kx-(hole-1)/2,kx+(hole-1)/2

                        ii = i
                        jj=j
                        if (i .le.0 ) ii=nt+i
                        if (i .gt.nt ) ii=i-nt
                        if (j .le.0 ) jj=nx+j
                        if (j .gt.nx ) jj=j-nx
                        rdata(ii,jj) = out
                     enddo
                  enddo

               ELSE

c user has asked to just zero out the hole

                  do i= kt-(hole-1)/2,kt+(hole-1)/2
                      
                     do j= kx-(hole-1)/2,kx+(hole-1)/2

                        ii = i
                        jj=j
                        if (i .le.0 ) ii=nt+i
                        if (i .gt.nt ) ii=i-nt
                        if (j .le.0 ) jj=nx+j
                        if (j .gt.nx ) jj=j-nx
                        rdata(ii,jj) = 0.0
                        
                     enddo
                  enddo

               ENDIF

            endif
         ENDDO
      ENDDO

      return
      end
