C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c tpstackr reads seismic trace data from an input file,
c performs reverse t-p stacking a` ls` de Belazaire (geoph, feb, 1989)
c writes the results to an output file
c
c
c**********************************************************************c
c
c     declare variables
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer     NPMAX, NWMAX
      parameter   (NPMAX = 550, NWMAX = 8192)
 
      integer     itr ( SZLNHD )
      integer     lhed( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     ltaper,nw,nspad,istpr,nwt1,nwt2
      integer     irs,ire,ns,ne
      real        vel,fmax,tp1,tp2,ftaper,domega,delf,deltp
#include <f77/pid.h>
      integer     recnum, trcnum, static
      real        xoff(SZLNHD ),weight(SZLNHD ),taper(SZLNHD )
      real        dist(SZLNHD )
c     real        data ( SZSMPM ), datarr ( SZSMPM,SZSPRD )
c------
c  dynamic memory allocation
      integer     itrhdr
      real        data ( SZSMPM ), datarr
      complex     data2d
      pointer     (wkadri, itrhdr(1))
      pointer     (wkadr1, datarr(1))
      pointer     (wkadr2, data2d(1))
c------

      character   ntap * 256, otap * 256, name*8
      logical     verbos, query, orig, heap1, heap2, heapi
      integer     argis
      integer     errcd1,errcd2,abort
 
c     equivalence ( itr(129), data (1) )
      equivalence ( itr(  1), lhed(1) )
      data lbytes / 0 /, nbytes / 0 /, name/'TPSTACKR'/
      data abort / 0 /
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,ns,ne,irs,ire,
     1             fmax,vel,numtp,tp1,tp2,nwt1,nwt2,
     2             ftaper,verbos)
c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'TPSTACK: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'DptInt', dpint, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)

      call hlhprt (itr, lbytes, name, 8, LERR)
c-----
c     ensure that command line values are compatible with data set
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
      if (ntrc .le. 1) then
         write(LERR,*)'Input data must have more than 1 trc/rec'
         write(LERR,*)'Try reorganizing the line header with utop'
         stop
      endif
      if (numtp .eq. 0) numtp = ntrc

c-----
c     initialize tp parameters
c-----
      call tpinit (nsamp,nspad,nw,ncmplx,nsi,si,fnyq,tp1,tp2,
     1             numtp,fmax,ltaper,ftaper,domega,nwt1,nwt2,
     2             delf,deltp,xoff,weight,taper,istpr,ntrc,
     3             unitsc)

c---------------------------------------------------
c  malloc only space we're going to use
      heapi = .true.
      heap1 = .true.
      heap2 = .true.

      itemi = max(ntrc,numtp) * ITRWRD  * SZSMPD
      itemr = max(ntrc,numtp) * (nspad) * SZSMPD
      itemc = max(ntrc,numtp) * (nspad) * SZSMPD * 2

      call galloc (wkadri, itemi, errcdi, abori)
      call galloc (wkadr1, itemr, errcd1, abort)
      call galloc (wkadr2, itemc, errcd2, abort)
      if (errcdi .ne. 0.) heapi = .false.
      if (errcd1 .ne. 0.) heap1 = .false.
      if (errcd2 .ne. 0.) heap2 = .false.
      if (.not. heap1 .or. .not. heap2) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) itemr,'  bytes'
         write(LERR,*) itemc,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) itemr,'  bytes'
         write(LERR,*) itemc,'  bytes'
         write(LERR,*)' '
      endif

      maxtrc = max(ntrc,numtp)
      call vclr (itrhdr, 1, maxtrc * ITRWRD)



c-----------
c     if no output dists given
c     use original tr dists
c-----------
      if (tp1 .eq. 0.0 .and. tp2 .eq. 0.0) then
         orig = .true.
      else
         orig = .false.
      endif

c-----
c     modify line header to reflect actual number of traces output
c-----
      obytes = SZTRHD + SZSMPD * nsamp
      nsamp4 = SZSMPD * nsamp
      nrecc=ire - irs+1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr=ne-ns+1
      call savew(itr, 'NumTrc', numtp, LINHED)
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout                 )

c-----
c     output of all pertinent information before
c     processing begins
c-----
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  vel,numtp,tp1,tp2,delf,deltp,
     2                  nw,ltaper,ftaper,fmax,xoff,weight,nwt1,nwt2,
     3                  istpr,ntap,otap) 

c-----
c     BEGIN PROCESSING
c     read trace, do tpstackr, write to output file
c-----
c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)
c-----
c     process desired trace records
c-----
      DO 1000 jj = irs, ire
 
c----------------------
c  skip to start trace
            call trcskp(jj,1,ns-1,luin,ntrc,itr)
c----------------------
 
               ic = 0
               nlive = 0
               do 1001  kk = ns, ne
                  ic = ic+1
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif

c                 static = itr(125)
c                 recnum = itr(106)
c                 trcnum = itr(107)
                  call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                        idist , TRACEHEADER)
                  dist (kk) = idist
                  call saver2(itr,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1                        idista, TRACEHEADER)
                  call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        static, TRACEHEADER)
                  call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum, TRACEHEADER)
                  call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum, TRACEHEADER)


c                 call move (1,itrhdr(1,ic),itr(1),SZTRHD )
                  ishdr = (kk-1) * ITRWRD
                  call vmov (itr, 1, itrhdr(ishdr+1), 1, ITRWRD)

                  IF(static .eq. 30000) THEN
                    call vclr (data,1,nsamp)
                  ELSE
                    nlive = nlive + 1
                  ENDIF
c                 call move (1,datarr(1,ic),data(1),nsamp4)
                  istrc = (kk-1) * nsamp
                  call vmov (itr(ITHWP1),1,datarr(istrc+1),1,nsamp)

                  if (orig) then
                     xoff(kk) = idista
                  endif

1001           continue
 
c----------------------
c  skip to end of record
            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
c----------------------

c----------------------
c  do tp processing
c----------------------

               call vestba (nsamp,ntrc,nspad,nw,nlive,ncmplx,domega,
     1                     numtp,istpr,vel,xoff,weight,taper,datarr,
     2                     dist,data2d)
 
c-------------------
c  fill in headers
c  write out data
c  save signed tr dists
c  save tp values
c-------------------
               do 1002  kk = 1, numtp

c                  call move (1,itr(1),itrhdr(1,kk),SZTRHD )
                   ishdr = (kk-1) * ITRWRD
                   call vmov (itrhdr(ishdr+1), 1, itr, 1, ITRWRD)
                   call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                         idist , TRACEHEADER)
c                  itr(107) = kk
c                  itr(119) = xoff(kk)
c                  itr(117) = itr(119)
                   ival = xoff(kk)
                   call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                         kk    , TRACEHEADER)
                   call savew2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                         ival  , TRACEHEADER)
                   call savew2(itr,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1                         ival  , TRACEHEADER)
c                  call move (1,data(1),datarr(1,kk),nsamp4)
                   istrc = (kk-1) * nsamp
                   call vmov (datarr(istrc+1),1,data,1,nsamp)
                   call vmov (datarr(istrc+1),1,itr(ITHWP1),1,nsamp)
                   call wrtape (luout, itr, obytes)

1002           continue

1000        CONTINUE
c-----
c     close data files
c-----
  999 continue

      call lbclos ( luin )
      call lbclos ( luout )

            write(LERR,*)'end of tpstackr, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'program to do t-p stacking (de Belazaire, Geoph, Feb 1989):'
        write(LER,*)
     :'see manual pages for details ( online by typing uman tpstackr )'
        write(LER,*)
     :'execute tpstackr by typing tpstack and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*) ' '
        write(LER,*)
     :' -N [ntap]    (no default)      : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)      : output data file name'
        write(LER,*)
     :' -ns[ns]      (default = first)         : start trace number'
        write(LER,*)
     :' -ne[ne]      (default = last)         : end trace number'
        write(LER,*)
     :' -rs[irs]      (default = first)         : start record number'
        write(LER,*)
     :' -ne[ire]      (default = last)         : end record number'
        write(LER,*) ' '
        write(LER,*)
     :' -v[vel] (default = flat) :  velocity of shot medium (ft,m/s)'
        write(LER,*)
     :' -tps [tp1] (def=none): start tp value (ms)'
        write(LER,*)
     :' -tpe [tp2] (def=none): end tp value (ms)'
        write(LER,*)
     :' -ntp [numtp] (def= # trcs/rec):  number tp values'
        write(LER,*)
     :' -it [nwt2] (def= 0):  number inside trace to taper'
        write(LER,*)
     :' -ot [nwt1] (def= 0):  number outside trace to taper'
        write(LER,*)
     :' -f [fmax] (def= nyquist/2):  max frequency to use'
        write(LER,*)
     :' -Ft [ftaper] (def= none):  frequency to start tapering'
        write(LER,*) ' '
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*) ' '
        write(LER,*)
     :'usage:   tpstackr -N[ntap] -O[otap] -ns[ns] -ne[ne] -rs[irs] '
        write(LER,*)
     :'                 -re[ire] -v[vel] -tps[tp1] -tpe[tp2] '
        write(LER,*)
     :'                 -ntp[numtp] -it[nwt1] -ot[nwt2] -f[fmax]'
        write(LER,*)
     :'                 -Ft[ftaper] -V'
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,ns,ne,irs,ire,
     1                  fmax,vel,numtp,tp1,tp2,nwt1,nwt2,
     2                  ftaper,verbos)
c-----
c     get command arguments
c
c     ntap   - C*100     input file name
c     otap   - C*100     output file name
c     vel    - R*4  shot velocity
c     ns     - I*4  starting trace index
c     ne     - I*4  ending trace index
c     irs    - I*4  starting record index
c     ire    - I*4  ending record index
c      tp1   - R*4  start range value
c      tp2   - R*4  end range value
c    numtp   - I*4  number range values
c     nwt1   - I*4  number inside traces to taper
c     nwt2   - I*4  number outside traces to taper
c     fmax   - R*4  max frequency to use
c   ftaper   - R*4  frequency to start tapering
c     verbos - L    verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      integer     ns, ne, irs, ire, numtp, nwt1, nwt2
      real        vel, tp1, tp2, fmax, ftaper
      logical     verbos
      integer     argis
 
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argr4( '-v', vel, 0., 0. )
            call argr4( '-tps',tp1, 0., 0.)
            call argr4( '-tpe',tp2, 0., 0.)
            call argi4( '-ntp',numtp,0,0)
            call argi4( '-it',nwt2,0,0)
            call argi4( '-ot',nwt1,0,0)
            call argr4( '-f',fmax,0.,0.)
            call argr4( '-Ft',ftaper,0.,0.)
            verbos = (argis('-V') .gt. 0)
 
            if (vel .eq. 0.) then
               write(LERR,*)'Must enter velocity value on command line'
               stop
            endif

      return
      end
 
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  vel,numtp,tp1,tp2,delf,deltp,
     2                  nw,ltaper,ftaper,fmax,p,weight,nwt1,nwt2,
     3                  istpr, ntap,otap)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     vel   - R*4 shot velocity
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c      tp1  - R*4 start range value
c      tp2  - R*4 end range value
c    numtp  - I*4 number range values
c   ftaper  - R*4 start frequency taper
c     delf  - R*4 delta freq
c    deltp  - R*4 delta tp
c     ntap  - C*120     input file name
c     otap  - C*120     output file name
c-----
#include <f77/iounit.h>
      real        p(*), weight(*)
      integer     nsamp, nsi, ntrc, nrec
      integer     numtp
      real        vel,tp1,tp2,delf,deltp
      character ntap*(*), otap*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' shot medium velocity =  ', vel
            write(LERR,*) ' start range value     =  ', tp1
            write(LERR,*) ' end range value       =  ', tp2
            write(LERR,*) ' number range values   =  ', numtp
            write(LERR,*) ' range increment       =  ', deltp
            write(LERR,*) ' frequency increment=  ', delf
            write(LERR,*) ' max freq to use    =  ',fmax
            write(LERR,*) ' number freqs in x-form= ',nw
            write(LERR,*) ' start frequency taper = ',ftaper
            write(LERR,*) ' number freqs to taper = ',ltaper
            write(LERR,*) ' start taper at freq indx= ',istpr
            write(LERR,*) ' number inside traces taper = ',nwt2
            write(LERR,*) ' number outside traces taper = ',nwt1
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            if (nwt1 .gt. 0 .or. nwt2 .gt. 1) then
               write(LERR,*) ' '
               write(LERR,*) ' '
               write(LERR,*) ' weights:'
               write(LERR,*) ' '
               write(LERR,*) ' '
               write(LERR,1000) (weight(j),j=1,ntrc)
1000           format(10(1x,f7.3))
            endif
            if (tp1 .ne. 0.0 .or. tp2 .ne. 0.0) then
               write(LERR,*) ' '
               write(LERR,*) ' '
               write(LERR,*) ' range values used:'
               write(LERR,*) ' '
               write(LERR,*) ' '
               write(LERR,1001) (p(j),j=1,numtp)
1001           format(8(1x,f10.3))
            endif
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
 
