C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C
C	Name:		CHKFLG
C
C	Purpose:	To check arguments
C				 separated by a comma or
C				other delimiter.
C
C	Usage:		INPUTS:
C				ISTART	-	starting index
C				DELIM	-	delimiter
C				TEXTIN	-	input text
C				FLGTXT	-	flag to search for
C
C			Outputs:
C				IVAL	-	value following FLGTXT if present
C
C	Notes:		Logical function
C                       ISTART,IVAL are altered on a match
C
C	Author:		Chester A. Jacewicz
C
C	Revised:	17Aug89 ... initial release ... Cray
C			24Oct89	... check if out of text 
C                       06Nov90 ... replaced CALL EXIT with STOP ... caj
C                                   added error differences
C
C...............................................................
C				
        LOGICAL FUNCTION CHKFLG(ISTART,DELIM,TEXTIN,FLGTXT,IVAL)
C
c       IMPLICIT NONE
C
        PARAMETER (LENTXT=10)
C
        CHARACTER * 1        DELIM
        CHARACTER * (*)      FLGTXT,TEXTIN
        CHARACTER*(LENTXT)        TEXT
C
        EXTERNAL BLANK,NEXT
C
        INTEGER        ISTART,ITEMP,IVAL
C
#include <f77/iounit.h>
C
        ITEMP=ISTART
        CALL NEXT(ITEMP,DELIM,TEXTIN,TEXT)
C
        IF(TEXT.EQ.FLGTXT) THEN
                CHKFLG=.TRUE.
C
C	Now to get value
C
                CALL BLANK(TEXT)
                CALL NEXT(ITEMP,DELIM,TEXTIN,TEXT)
C
                IF(ITEMP.EQ.0) THEN
                        WRITE(LER,*)'CHKFLG error ... no value found:'
                        GOTO 900
                        ENDIF
C
                READ(TEXT,1000,ERR=902)IVAL
C
                ISTART=ITEMP
1000    FORMAT(I10)
                ELSE
                CHKFLG=.FALSE.
                ENDIF
C
        RETURN
C
902     CONTINUE

        WRITE(LER,*)'CHKFLG error ... BAD value '

900     CONTINUE
C
        WRITE(LER,*)'CHKFLG error ... flag is:',FLGTXT
        WRITE(LER,*)'CHKFLG error ... text is:',TEXT
        WRITE(LER,*)'CHKFLG error ... pointer is:',ITEMP
        WRITE(LER,*)'CHKFLG error ... input text length is:',LEN(TEXTIN)
C
        STOP
C
        END
