C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c----------------------------------------------------------------- 
c   main command line arguments 
        subroutine cmdln (nmtrin,nmrcin,lunout,nskip,ns,ne,nrs,endrec,
     1                    nri,hdcoda,hdcodb,hdcodc,hdcodd,hdcode,hdcodm, 
     2                    endsam,numsmp,text,delime,pgmnme,keep,moder)
 
c-----------------------------------------------------------------
c   nmtrin  I*4   number input traces
c   nmrcin  I*4   number output traces
c   lunout  I*4   printer unit number
c    nskip  I*4   printout every so-many traces
c   ns, ne  I*4   start, end traces
c   nrs,end I*4   start, end records
c      nri  I*4   do every nri records
c   hdcoda  C*120 control strings for calculator functions
c   hdcodb  C*120 control strings for calculator functions
c   hdcodc  C*120 control strings for calculator functions
c   hdcodd  C*120 control strings for calculator functions
c   hdcode  C*150 control strings for calculator functions
c   hdcodm  C*120 control strings for calculator functions
c     text  C*120 string
c   delime  C*1   delimiter
c   endsmp  I*4   end time of trace
c   numsmp  I*4   number samples/trace

C           06Nov90 ... replaced CALL EXIT with STOP for SUN.
C                       hdcode length input

#include <f77/iounit.h>

      character * 120  hdcoda,hdcodb,hdcodc,hdcodd,hdcodm
      character * (*)  hdcode
      character * 120  text
      character *  11  pgmnme
      character * 1    delime
      integer          nskip,ns,ne,nrs,nri,nmtrin,nmrcin,numsmp
      integer          endsam
      integer          endrec
      integer          argis
      logical          keep

        CALL ARGI4('-log',NSKIP,-1,-1)
                WRITE(LUNOUT,*)PGMNME//
     *          'Number of traces to skip between logging:',NSKIP

        CALL ARGI4('-ns',NS,1,1)
        WRITE(LUNOUT,*)PGMNME//'NS:',NS
 
        CALL ARGI4('-ne',NE,0,0)
        WRITE(LUNOUT,*)PGMNME//'ne:',NE
 
        CALL ARGI4('-ri',NRI,1,1)
        WRITE(LUNOUT,*)PGMNME//'ri:',NRI
        IF(NRI.LE.0) THEN
                WRITE(LUNOUT,*)PGMNME//'**** BAD -ri'
                STOP
                ENDIF
 
        CALL ARGSTR('-a:',HDCODA,' ',' ')
        IF(HDCODA.NE.' ') THEN
                WRITE(LUNOUT,*)PGMNME//'Header code(s) a:',HDCODA
                ENDIF
 
        CALL ARGSTR('-b:',HDCODB,' ',' ')
        IF(HDCODB.NE.' ') THEN
                WRITE(LUNOUT,*)PGMNME//'Header code(s) b:',HDCODB
                ENDIF
 
        CALL ARGSTR('-c:',HDCODC,' ',' ')
        IF(HDCODC.NE.' ') THEN
                WRITE(LUNOUT,*)PGMNME//'Header code(s) c:',HDCODC
                ENDIF
 
 
        CALL ARGSTR('-d:',HDCODD,' ',' ')
        IF(HDCODD.NE.' ') THEN
                NSKIP=-1
                WRITE(LUNOUT,*)PGMNME//'Header code(s) d:',HDCODD
        ENDIF

C        **** NEED to check which are acceptable for DELIME
 
                CALL ARGSTR('-s',TEXT,delime,DELIME)
                IF(DELIME(1:1).NE.TEXT(1:1)) THEN
                        DELIME(1:1)=TEXT(1:1)
                        CALL BLANK(TEXT)
                        IF(DELIME(1:1).EQ.' ') TEXT=' ... blank'
                        WRITE(LUNOUT,*)PGMNME//
     *                'New separator:'//DELIME(1:1)//TEXT(1:10)
                ENDIF
 
        CALL ARGSTR('-e:',HDCODE,' ',' ')
        IF(HDCODE.NE.' ') THEN
                WRITE(LUNOUT,*)PGMNME//'Header code(s) e:',HDCODE
 
                IF(HDCODE(LEN(HDCODE):LEN(HDCODE)).NE.' ') THEN
                        WRITE(LUNOUT,*)PGMNME//
     *                        '**** e: option text buffer overflow ****'
                        WRITE(LUNOUT,*)PGMNME//'last of buffer: '
     *                        ,HDCODE(MAX(1,LEN(HDCODE)-10):LEN(HDCODE))
                        STOP
                ENDIF
                IF(HDCODE(1:1).EQ.DELIME) THEN
                        WRITE(LUNOUT,*)PGMNME//
     *                        '**** do not start with delimitor ****'
                        STOP
                ENDIF

 
        ENDIF
 
        CALL ARGSTR('-mw:',HDCODM,' ',' ')
        IF(HDCODM.NE.' ') THEN
                WRITE(LUNOUT,*)PGMNME//'Header code(s) mw:',HDCODM
                CALL ARGI4('-mc',MODER,0,0)
                WRITE(LUNOUT,*)PGMNME//'Modulo:',MODER
                ENDIF
 
C
C	Check the first record the user wants
 
        CALL ARGI4('-rs',NRS,1,1)
        WRITE(LUNOUT,*)PGMNME//'-rs:',NRS
        IF(NRS.LE.0) THEN
                WRITE(LUNOUT,*)PGMNME//'**** BAD -rs',NRS
                STOP
                ENDIF
 
C	Check the last record the user wants
 
        CALL ARGI4('-re',ENDREC,-1,NMRCIN)
        WRITE(LUNOUT,*)PGMNME//'-re:',ENDREC
        IF(ENDREC.LE.0) THEN
                WRITE(LUNout,*)PGMNME//'....defaulted -re'
                ENDREC=9999
                ENDIF

        CALL ARGI4('-e',ENDSAM,-1,NUMSMP)
        IF(ENDSAM.LE.0) THEN
                WRITE(LUNout,*)PGMNME//'....defaulted -e'
                ENDSAM=9999
        ENDIF
 
        keep  =  (argis('-K') .gt. 0)
 
      return
      end
c--------------------------------------
