C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine GetDecay( tri, nsampo, decay, MemoryInSamples, 
     :     DenomTest, counter )

c variables passed from calling routine

      integer nsampo, MemoryInSamples, counter

      real tri(nsampo), decay(MemoryInSamples), DenomTest

c local variables

      integer HalfWindow, WindowCenterSample 

      real AvgAbsAmp1, AvgAbsAmp2

c initialize variables

      HalfWindow = nsampo / 2
                 
c AvgAbsAmp over First Half-window

      call svemg ( tri, 1, AvgAbsAmp1, HalfWindow )
      AvgAbsAmp1 = AvgAbsAmp1 / DenomTest
 
c AvgAbsAmp over Last Half-window

      WindowCenterSample = 1 + HalfWindow
      call svemg   (tri(WindowCenterSample), 1, AvgAbsAmp2, 
     :     HalfWindow)
      AvgAbsAmp2   = AvgAbsAmp2 / DenomTest

c calculate decay parameter

      if ( abs(AvgAbsAmp1) .gt. 1.e-30) then
         decay(counter) = 20.0 * alog10 ( AvgAbsAmp2 / AvgAbsAmp1 )
      else
         decay(counter) = 0.0
      endif

      return
      end

